DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -1.34963085984344E-11   0.00000000000000E+00   1.31938183510284E-10   1.64411234925083E-22
      1.33643758479058E-08   1.34963140314162E-08  -7.90356667088165E-19  -2.50371042858463E-01  -2.50371042857039E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42386139855645E-09   0.00000000000000E+00  -1.42386139855645E-09
      3.70001668496812E-18  -2.50371042858463E-01  -2.46567585215325E-01   0.00000000000000E+00  -4.28244497674604E-12
     -9.83405481597020E-23  -1.20681701878839E-08  -1.20724526328607E-08  -2.90966001787995E-18
      1.17500000000000E-12
      0.00000000000000E+00  -1.34927266536833E-11   0.00000000000000E+00   8.88167128837214E-12   1.65785630605307E-22
      1.34838990896304E-08   1.34927807609189E-08  -7.89530143318327E-19  -2.50727023102222E-01  -2.50727023100882E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33966529010784E-09   0.00000000000000E+00  -1.33966529010784E-09
      3.69911241089730E-18  -2.50727023102219E-01  -2.46898160230401E-01   0.00000000000000E+00  -5.90624900861224E-12
     -9.83451993306664E-23  -1.21472092218041E-08  -1.21531154708128E-08  -2.90958226757897E-18
      2.08625000000000E-12
      0.00000000000000E+00  -1.34885936405090E-11   0.00000000000000E+00   2.89542678819180E-13   1.68053894679820E-22
      1.34883042186274E-08   1.34885937613064E-08  -7.88547512361122E-19  -2.51140737930659E-01  -2.51140737929450E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20884850237770E-09   0.00000000000000E+00  -1.20884850237770E-09
      3.69801084769950E-18  -2.51140737930657E-01  -2.47271964092225E-01   0.00000000000000E+00  -6.68041321626258E-12
     -9.83514500034801E-23  -1.22730648457118E-08  -1.22797452589282E-08  -2.90946333533838E-18
      2.24002343750000E-12
      0.00000000000000E+00  -1.34879507273485E-11   0.00000000000000E+00  -6.06630482794065E-14   1.68445245519110E-22
      1.34879716867899E-08   1.34879110237418E-08  -7.88385412305805E-19  -2.51208897626917E-01  -2.51208897625730E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18639459359921E-09   0.00000000000000E+00  -1.18639459359921E-09
      3.69782841172462E-18  -2.51208897626914E-01  -2.47333264338897E-01   0.00000000000000E+00  -6.78363043305509E-12
     -9.83524989823913E-23  -1.22947327997102E-08  -1.23015164301434E-08  -2.90944299941881E-18
      2.34382050781250E-12
      0.00000000000000E+00  -1.34874915036625E-11   0.00000000000000E+00  -1.35309094295784E-13   1.68712344248271E-22
      1.34875934050409E-08   1.34874580959467E-08  -7.88277660858135E-19  -2.51254190404011E-01  -2.51254190402840E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17110270113730E-09   0.00000000000000E+00  -1.17110270113730E-09
      3.69770685469520E-18  -2.51254190404009E-01  -2.47373882048186E-01   0.00000000000000E+00  -6.83801241039970E-12
     -9.83532030308946E-23  -1.23095173824257E-08  -1.23163553948362E-08  -2.90942919383707E-18
      2.48394655273438E-12
      0.00000000000000E+00  -1.34868485905021E-11   0.00000000000000E+00  -1.59238899481912E-13   1.69076028044693E-22
      1.34870184417754E-08   1.34868592028761E-08  -7.88135167692087E-19  -2.51314079711674E-01  -2.51314079710524E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15030364376729E-09   0.00000000000000E+00  -1.15030364376729E-09
      3.69754566719514E-18  -2.51314079711672E-01  -2.47427407227715E-01   0.00000000000000E+00  -6.88278514463501E-12
     -9.83541408683468E-23  -1.23296727739743E-08  -1.23365555591190E-08  -2.90941049950306E-18
      2.67311671337891E-12
      0.00000000000000E+00  -1.34860219878672E-11   0.00000000000000E+00  -1.62344963673351E-13   1.69568035689023E-22
      1.34862352680709E-08   1.34860729231074E-08  -7.87948069701079E-19  -2.51392713007248E-01  -2.51392713006126E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12214698945620E-09   0.00000000000000E+00  -1.12214698945620E-09
      3.69733339046888E-18  -2.51392713007248E-01  -2.47497417427964E-01   0.00000000000000E+00  -6.89484549353093E-12
     -9.83553873517926E-23  -1.23570310881500E-08  -1.23639259336436E-08  -2.90938532076780E-18
      2.92849643024902E-12
      0.00000000000000E+00  -1.34850116957579E-11   0.00000000000000E+00  -1.57962477182399E-13   1.70225981028963E-22
      1.34852084109282E-08   1.34850504484512E-08  -7.87704747234817E-19  -2.51494971481783E-01  -2.51494971480699E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08438999355834E-09   0.00000000000000E+00  -1.08438999355834E-09
      3.69705645925935E-18  -2.51494971481779E-01  -2.47588102642139E-01   0.00000000000000E+00  -6.84274112714875E-12
     -9.83570195156958E-23  -1.23938177137629E-08  -1.24006604548901E-08  -2.90935171202453E-18
      3.27325904802368E-12
      0.00000000000000E+00  -1.34837258694370E-11   0.00000000000000E+00  -1.50204804160374E-13   1.71090763735398E-22
      1.34838882140132E-08   1.34837380092092E-08  -7.87392345403306E-19  -2.51626248116230E-01  -2.51626248115195E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03452921943542E-09   0.00000000000000E+00  -1.03452921943542E-09
      3.69669979225749E-18  -2.51626248116220E-01  -2.47704084135619E-01   0.00000000000000E+00  -6.68932715446614E-12
     -9.83591270748589E-23  -1.24425194626208E-08  -1.24492087897754E-08  -2.90930744685419E-18
      3.73868858201947E-12
      0.00000000000000E+00  -1.34820726641673E-11   0.00000000000000E+00  -1.39507836904373E-13   1.72201601825593E-22
      1.34822220116668E-08   1.34820825038301E-08  -7.86998084914816E-19  -2.51791892979950E-01  -2.51791892978980E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70090135365718E-10   0.00000000000000E+00  -9.70090135365718E-10
      3.69624828365786E-18  -2.51791892979962E-01  -2.47849949232116E-01   0.00000000000000E+00  -6.40206250913094E-12
     -9.83618014438495E-23  -1.25055903059545E-08  -1.25119923684637E-08  -2.90925019874304E-18
      4.36701845291379E-12
      0.00000000000000E+00  -1.34800520799487E-11   0.00000000000000E+00  -1.28633741413203E-13   1.73588219313202E-22
      1.34801672377329E-08   1.34800386039916E-08  -7.86511767429393E-19  -2.51996156322872E-01  -2.51996156321983E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.89102657088160E-10   0.00000000000000E+00  -8.89102657088160E-10
      3.69568963390012E-18  -2.51996156322879E-01  -2.48029340899474E-01   0.00000000000000E+00  -5.95824355299162E-12
     -9.83651217191454E-23  -1.25849777033525E-08  -1.25909359469056E-08  -2.90917786647072E-18
      4.79114111576745E-12
      0.00000000000000E+00  -1.34787662536278E-11   0.00000000000000E+00  -1.22214781444342E-13   1.74472459881264E-22
      1.34788643003313E-08   1.34787420855500E-08  -7.86203247698967E-19  -2.52125706352040E-01  -2.52125706351203E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.37237409252270E-10   0.00000000000000E+00  -8.37237409252270E-10
      3.69533454254066E-18  -2.52125706457580E-01  -2.48142958868521E-01   0.00000000000000E+00  -5.65185635920660E-12
     -9.83672891190111E-23  -1.26358528199362E-08  -1.26415046762955E-08  -2.90913129484170E-18
      4.93428251448056E-12
      0.00000000000000E+00  -1.34783070299418E-11   0.00000000000000E+00  -1.18542859052111E-13   1.74765015702591E-22
      1.34784336994166E-08   1.34783151565577E-08  -7.86101328619945E-19  -2.52168497555399E-01  -2.52168497554579E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.20052406253896E-10   0.00000000000000E+00  -8.20052406253896E-10
      3.69521715909221E-18  -2.52168497602867E-01  -2.48180470735958E-01   0.00000000000000E+00  -5.54992516707222E-12
     -9.83679766422613E-23  -1.26527128251300E-08  -1.26582627502972E-08  -2.90911583047227E-18
      5.12752340274326E-12
      0.00000000000000E+00  -1.34777559615185E-11   0.00000000000000E+00  -1.16176326601855E-13   1.75149492805655E-22
      1.34778700454299E-08   1.34777538691035E-08  -7.85967646953479E-19  -2.52224618208887E-01  -2.52224618208090E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.97432422875953E-10   0.00000000000000E+00  -7.97432422875953E-10
      3.69506306254249E-18  -2.52224618254929E-01  -2.48229641370479E-01   0.00000000000000E+00  -5.41049678838918E-12
     -9.83687369805109E-23  -1.26749109494456E-08  -1.26803214462340E-08  -2.90909541558901E-18
      5.38839860189791E-12
      0.00000000000000E+00  -1.34770212036209E-11   0.00000000000000E+00  -1.10708823728737E-13   1.75649750077928E-22
      1.34771367906246E-08   1.34770260818011E-08  -7.85794035964058E-19  -2.52297492091941E-01  -2.52297492091173E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.67939472624583E-10   0.00000000000000E+00  -7.67939472624583E-10
      3.69486272617963E-18  -2.52297492116003E-01  -2.48293453162378E-01   0.00000000000000E+00  -5.22713182679993E-12
     -9.83714936438246E-23  -1.27038594773421E-08  -1.27090866091690E-08  -2.90906869021557E-18
      5.74058012075668E-12
      0.00000000000000E+00  -1.34761027562488E-11   0.00000000000000E+00  -1.04945167182812E-13   1.76291932366382E-22
      1.34761970565716E-08   1.34760921114046E-08  -7.85571546859805E-19  -2.52390867335625E-01  -2.52390867334895E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29981093082143E-10   0.00000000000000E+00  -7.29981093082143E-10
      3.69460564032953E-18  -2.52390867328759E-01  -2.48375163851043E-01   0.00000000000000E+00  -4.98446194323379E-12
     -9.83722350646025E-23  -1.27411265563835E-08  -1.27461110183268E-08  -2.90903409346972E-18
      6.21602517121602E-12
      0.00000000000000E+00  -1.34749087746651E-11   0.00000000000000E+00  -9.73344195450445E-14   1.77101329459471E-22
      1.34750143218304E-08   1.34749169874110E-08  -7.85291428349944E-19  -2.52508403101084E-01  -2.52508403100402E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.81977129417908E-10   0.00000000000000E+00  -6.81977129417908E-10
      3.69428139767882E-18  -2.52508403060243E-01  -2.48477946268229E-01   0.00000000000000E+00  -4.67142508827031E-12
     -9.83737290038750E-23  -1.27882684329033E-08  -1.27929398579916E-08  -2.90898996932888E-18
      6.85787598933613E-12
      0.00000000000000E+00  -1.34734392588698E-11   0.00000000000000E+00  -8.92813786473863E-14   1.78097097693140E-22
      1.34735604416873E-08   1.34734711603088E-08  -7.84946953794158E-19  -2.52652900576064E-01  -2.52652900575441E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.22673633063618E-10   0.00000000000000E+00  -6.22673633063618E-10
      3.69388173409802E-18  -2.52652900516761E-01  -2.48604215386079E-01   0.00000000000000E+00  -4.27660988731318E-12
     -9.83760085501408E-23  -1.28465209173570E-08  -1.28507975272444E-08  -2.90893478030386E-18
      7.29112529156720E-12
      0.00000000000000E+00  -1.34725208114977E-11   0.00000000000000E+00  -7.97775063697254E-14   1.78727643801411E-22
      1.34726405519915E-08   1.34725607744853E-08  -7.84728864199522E-19  -2.52744361105558E-01  -2.52744361104973E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.85019107424291E-10   0.00000000000000E+00  -5.85019107424291E-10
      3.69362827497793E-18  -2.52744360988434E-01  -2.48684100814379E-01   0.00000000000000E+00  -4.02842019670411E-12
     -9.83782747664094E-23  -1.28835132468642E-08  -1.28875416670610E-08  -2.90889941077841E-18
      7.36423611131870E-12
      0.00000000000000E+00  -1.34724289667605E-11   0.00000000000000E+00  -8.28240122598365E-14   1.78832872701433E-22
      1.34724871046761E-08   1.34724042806640E-08  -7.84692468923772E-19  -2.52759623261031E-01  -2.52759623260452E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.78731888313349E-10   0.00000000000000E+00  -5.78731888313349E-10
      3.69358596341516E-18  -2.52759623140849E-01  -2.48697430210935E-01   0.00000000000000E+00  -3.98231887781660E-12
     -9.83783937435565E-23  -1.28896900734723E-08  -1.28936723923502E-08  -2.90889349449139E-18
      7.46293571798321E-12
      0.00000000000000E+00  -1.34722452772861E-11   0.00000000000000E+00  -8.16129806995073E-14   1.78972824818848E-22
      1.34722830058264E-08   1.34722013928459E-08  -7.84644066016593E-19  -2.52779919389124E-01  -2.52779919388553E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.70364499924359E-10   0.00000000000000E+00  -5.70364499924359E-10
      3.69352966866336E-18  -2.52779919259851E-01  -2.48715154095674E-01   0.00000000000000E+00  -3.92620939484767E-12
     -9.83785043668054E-23  -1.28979106835274E-08  -1.29018368929223E-08  -2.90888560264677E-18
      7.59618018698031E-12
      0.00000000000000E+00  -1.34719697430744E-11   0.00000000000000E+00  -7.98316911124841E-14   1.79157994635416E-22
      1.34720128521354E-08   1.34719330204444E-08  -7.84580027501835E-19  -2.52806769923065E-01  -2.52806769922506E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.59283978033025E-10   0.00000000000000E+00  -5.59283978033025E-10
      3.69345514716669E-18  -2.52806769783942E-01  -2.48738598306197E-01   0.00000000000000E+00  -3.85200921919705E-12
     -9.83787547677350E-23  -1.29087970331967E-08  -1.29126490424160E-08  -2.90887511966485E-18
      7.77606022012639E-12
      0.00000000000000E+00  -1.34716023641256E-11   0.00000000000000E+00  -7.79096120034103E-14   1.79401274477218E-22
      1.34716578656549E-08   1.34715799560431E-08  -7.84495891880222E-19  -2.52842044063413E-01  -2.52842044062868E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44708826572481E-10   0.00000000000000E+00  -5.44708826572481E-10
      3.69335716492491E-18  -2.52842043915435E-01  -2.48769391692714E-01   0.00000000000000E+00  -3.75376459533783E-12
     -9.83792331004766E-23  -1.29231173648761E-08  -1.29268711294716E-08  -2.90886127304469E-18
      8.01889826487360E-12
      0.00000000000000E+00  -1.34711431404396E-11   0.00000000000000E+00  -7.51027723566889E-14   1.79717878609689E-22
      1.34711958451423E-08   1.34711207423701E-08  -7.84386381410904E-19  -2.52887951917192E-01  -2.52887951916667E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.25710259955402E-10   0.00000000000000E+00  -5.25710259955402E-10
      3.69322950247328E-18  -2.52887951761615E-01  -2.48809458703754E-01   0.00000000000000E+00  -3.62547943195627E-12
     -9.83799614210186E-23  -1.29417850029783E-08  -1.29454104824103E-08  -2.90884312106238E-18
      8.34672962528234E-12
      0.00000000000000E+00  -1.34705002272791E-11   0.00000000000000E+00  -7.14407530114536E-14   1.80124677079266E-22
      1.34706020966713E-08   1.34705306559184E-08  -7.84245615123725E-19  -2.52946954380033E-01  -2.52946954379531E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.01247500241760E-10   0.00000000000000E+00  -5.01247500241760E-10
      3.69306517782338E-18  -2.52946954221274E-01  -2.48860940073964E-01   0.00000000000000E+00  -3.45941322750873E-12
     -9.83809527064211E-23  -1.29658237424500E-08  -1.29692831556776E-08  -2.90881956269965E-18
      8.78930196183413E-12
      0.00000000000000E+00  -1.34698573141187E-11   0.00000000000000E+00  -6.67053573841981E-14   1.80638488933793E-22
      1.34698517222583E-08   1.34697850169011E-08  -7.84067663089472E-19  -2.53021529605123E-01  -2.53021529604653E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.70263012430698E-10   0.00000000000000E+00  -4.70263012430698E-10
      3.69285705242317E-18  -2.53021529446728E-01  -2.48925988578162E-01   0.00000000000000E+00  -3.24782507180007E-12
     -9.83822290388584E-23  -1.29962741794021E-08  -1.29995220044739E-08  -2.90878938933370E-18
      9.38677461617904E-12
      0.00000000000000E+00  -1.34688470220094E-11   0.00000000000000E+00  -6.05755659161100E-14   1.81272798442813E-22
      1.34689241446721E-08   1.34688635691064E-08  -7.83847619980329E-19  -2.53113721570357E-01  -2.53113721569925E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.31869668436225E-10   0.00000000000000E+00  -4.31869668436225E-10
      3.69259902210604E-18  -2.53113721414230E-01  -2.49006375146625E-01   0.00000000000000E+00  -2.98421590203276E-12
     -9.83838211604125E-23  -1.30340096847645E-08  -1.30369939006667E-08  -2.90875140212571E-18
      1.01933626995447E-11
      0.00000000000000E+00  -1.34677448851629E-11   0.00000000000000E+00  -5.45057972615260E-14   1.82032489270135E-22
      1.34678104741082E-08   1.34677559683111E-08  -7.83583340695551E-19  -2.53224411147267E-01  -2.53224411146882E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.85657207622731E-10   0.00000000000000E+00  -3.85657207622731E-10
      3.69228795559811E-18  -2.53224410994417E-01  -2.49102854179216E-01   0.00000000000000E+00  -2.66364762694055E-12
     -9.83857513118036E-23  -1.30794351130613E-08  -1.30820987606883E-08  -2.90870461490256E-18
      1.07378096558165E-11
      0.00000000000000E+00  -1.34671019720024E-11   0.00000000000000E+00  -4.49505314364151E-14   1.82504400294501E-22
      1.34671218977944E-08   1.34670769472632E-08  -7.83418748588077E-19  -2.53293330446205E-01  -2.53293330445848E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.56833512622253E-10   0.00000000000000E+00  -3.56833512622253E-10
      3.69209367867826E-18  -2.53293333940299E-01  -2.49162911669010E-01   0.00000000000000E+00  -2.46918758820251E-12
     -9.83869289759049E-23  -1.31077742470535E-08  -1.31102434346418E-08  -2.90867493009019E-18
      1.09215605035582E-11
      0.00000000000000E+00  -1.34668264377908E-11   0.00000000000000E+00  -5.21806497151712E-14   1.82659173904949E-22
      1.34668932808081E-08   1.34668411001585E-08  -7.83364729195212E-19  -2.53315947350350E-01  -2.53315947350002E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.47368947430909E-10   0.00000000000000E+00  -3.47368947430909E-10
      3.69202984933969E-18  -2.53315949993303E-01  -2.49182617711401E-01   0.00000000000000E+00  -2.39471306627091E-12
     -9.83915199211180E-23  -1.31170774396639E-08  -1.31194721527303E-08  -2.90866512014448E-18
      1.11696241480096E-11
      0.00000000000000E+00  -1.34665509035792E-11   0.00000000000000E+00  -4.76387431775030E-14   1.82860388708537E-22
      1.34665951988421E-08   1.34665475600991E-08  -7.83294487901207E-19  -2.53345352509561E-01  -2.53345352509226E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.35054202709976E-10   0.00000000000000E+00  -3.35054202709976E-10
      3.69194673457308E-18  -2.53345354215001E-01  -2.49208235555750E-01   0.00000000000000E+00  -2.31179630958932E-12
     -9.83909821589117E-23  -1.31291815610792E-08  -1.31314933573888E-08  -2.90865224667188E-18
      1.15045100680189E-11
      0.00000000000000E+00  -1.34661835246304E-11   0.00000000000000E+00  -4.51782242223565E-14   1.83118378906118E-22
      1.34662155902192E-08   1.34661704119951E-08  -7.83204315825785E-19  -2.53383096201150E-01  -2.53383096200831E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.19231905352299E-10   0.00000000000000E+00  -3.19231905352299E-10
      3.69183982830276E-18  -2.53383098490743E-01  -2.49241113724036E-01   0.00000000000000E+00  -2.20192325752931E-12
     -9.83896538973575E-23  -1.31447365833869E-08  -1.31469385066445E-08  -2.90863551247698E-18
      1.19566060600314E-11
      0.00000000000000E+00  -1.34656324562071E-11   0.00000000000000E+00  -4.19775790587106E-14   1.83443089898982E-22
      1.34657352146256E-08   1.34656932370468E-08  -7.83090513954871E-19  -2.53430721659239E-01  -2.53430721658939E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.99247507464792E-10   0.00000000000000E+00  -2.99247507464792E-10
      3.69170453970402E-18  -2.53430723491579E-01  -2.49282593092125E-01   0.00000000000000E+00  -2.06252063679536E-12
     -9.83896739966699E-23  -1.31643832089403E-08  -1.31664457295772E-08  -2.90861402574915E-18
      1.25669356492484E-11
      0.00000000000000E+00  -1.34651732325211E-11   0.00000000000000E+00  -3.80851763725676E-14   1.83842131043930E-22
      1.34651434291419E-08   1.34651053439657E-08  -7.82950091331059E-19  -2.53489472767428E-01  -2.53489472767154E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74571193537049E-10   0.00000000000000E+00  -2.74571193537049E-10
      3.69153696078025E-18  -2.53489474188918E-01  -2.49333754777764E-01   0.00000000000000E+00  -1.88963301280761E-12
     -9.83905048000538E-23  -1.31886445174164E-08  -1.31905341504293E-08  -2.90858686944920E-18
      1.33908805946913E-11
      0.00000000000000E+00  -1.34644384746234E-11   0.00000000000000E+00  -3.31800076130238E-14   1.84317435976541E-22
      1.34644354849510E-08   1.34644023049435E-08  -7.82781876553181E-19  -2.53559827144426E-01  -2.53559827144181E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.44999609357303E-10   0.00000000000000E+00  -2.44999609357303E-10
      3.69133509459049E-18  -2.53559828358277E-01  -2.49395014056688E-01   0.00000000000000E+00  -1.68182765189062E-12
     -9.83917465813329E-23  -1.32177208679330E-08  -1.32194026955850E-08  -2.90855321803731E-18
      1.45032062710393E-11
      0.00000000000000E+00  -1.34636118719886E-11   0.00000000000000E+00  -2.89849826545474E-14   1.84860691338096E-22
      1.34636200752743E-08   1.34635910902918E-08  -7.82587986535470E-19  -2.53640880514865E-01  -2.53640880514654E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10922295513676E-10   0.00000000000000E+00  -2.10922295513676E-10
      3.69110048030547E-18  -2.53640881627562E-01  -2.49465586565339E-01   0.00000000000000E+00  -1.43994319475568E-12
     -9.83932463019600E-23  -1.32512288515844E-08  -1.32526687947792E-08  -2.90851249377001E-18
      1.60048459341090E-11
      0.00000000000000E+00  -1.34626934246165E-11   0.00000000000000E+00  -2.31363920844734E-14   1.85449074013170E-22
      1.34627292388458E-08   1.34627061024539E-08  -7.82375287963218E-19  -2.53729735976287E-01  -2.53729735976113E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.73596573352915E-10   0.00000000000000E+00  -1.73596573352915E-10
      3.69083980080556E-18  -2.53729738231615E-01  -2.49542962585270E-01   0.00000000000000E+00  -1.17515537774145E-12
     -9.83947522431133E-23  -1.32879343737225E-08  -1.32891095291003E-08  -2.90846451284234E-18
      1.62582476272520E-11
      0.00000000000000E+00  -1.34626015798793E-11   0.00000000000000E+00  -2.29114896982865E-14   1.85544381199434E-22
      1.34625833396039E-08   1.34625604281144E-08  -7.82340740850823E-19  -2.53744165480606E-01  -2.53744165480439E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.67535151718814E-10   0.00000000000000E+00  -1.67535151718814E-10
      3.69079734711445E-18  -2.53744167460500E-01  -2.49555527918737E-01   0.00000000000000E+00  -1.13150439765138E-12
     -9.83948313222689E-23  -1.32938937719930E-08  -1.32950252763908E-08  -2.90845660626363E-18
      1.66003399129950E-11
      0.00000000000000E+00  -1.34623260456676E-11   0.00000000000000E+00  -2.18235510976176E-14   1.85666128311331E-22
      1.34623958182652E-08   1.34623739947142E-08  -7.82296429817359E-19  -2.53762669521095E-01  -2.53762669520935E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59762878828842E-10   0.00000000000000E+00  -1.59762878828842E-10
      3.69074269346605E-18  -2.53762671192156E-01  -2.49571641728172E-01   0.00000000000000E+00  -1.07636601788716E-12
     -9.83953996646039E-23  -1.33015347498702E-08  -1.33026111158882E-08  -2.90844626364869E-18
      1.70621644987482E-11
      0.00000000000000E+00  -1.34621423561932E-11   0.00000000000000E+00  -2.03146619905110E-14   1.85818781168106E-22
      1.34621599466267E-08   1.34621396319649E-08  -7.82240565943601E-19  -2.53785992082206E-01  -2.53785992082056E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49970886569877E-10   0.00000000000000E+00  -1.49970886569877E-10
      3.69067343322349E-18  -2.53785993593658E-01  -2.49591952996234E-01   0.00000000000000E+00  -1.00684519781745E-12
     -9.83959716389106E-23  -1.33111619001961E-08  -1.33121687453940E-08  -2.90843286727989E-18
      1.76856276895149E-11
      0.00000000000000E+00  -1.34618668219816E-11   0.00000000000000E+00  -1.84369386131154E-14   1.86005478811518E-22
      1.34618701187681E-08   1.34618516818297E-08  -7.82171718708703E-19  -2.53814725036243E-01  -2.53814725036105E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37919859099304E-10   0.00000000000000E+00  -1.37919859099304E-10
      3.69058744526806E-18  -2.53814726563708E-01  -2.49616980015231E-01   0.00000000000000E+00  -9.21000188566089E-13
     -9.83965765642342E-23  -1.33230108225423E-08  -1.33239318227310E-08  -2.90841572655936E-18
      1.85273029970500E-11
      0.00000000000000E+00  -1.34614994430328E-11   0.00000000000000E+00  -1.63868554752692E-14   1.86226339307199E-22
      1.34615241669154E-08   1.34615077800601E-08  -7.82089353249581E-19  -2.53849082820952E-01  -2.53849082820829E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23538218869993E-10   0.00000000000000E+00  -1.23538218869993E-10
      3.69048346619970E-18  -2.53849084492433E-01  -2.49646915316031E-01   0.00000000000000E+00  -8.18072371711106E-13
     -9.83972755276413E-23  -1.33371514888209E-08  -1.33379695611927E-08  -2.90839411295012E-18
      1.96635646622224E-11
      0.00000000000000E+00  -1.34611320640840E-11   0.00000000000000E+00  -1.39718314999641E-14   1.86476330088878E-22
      1.34611265258956E-08   1.34611125540643E-08  -7.81994525247715E-19  -2.53888611403463E-01  -2.53888611403356E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07050085694768E-10   0.00000000000000E+00  -1.07050085694768E-10
      3.69036182929108E-18  -2.53888613275786E-01  -2.49681374015401E-01   0.00000000000000E+00  -6.99878901427982E-13
     -9.83980926231387E-23  -1.33533625894676E-08  -1.33540624683692E-08  -2.90836730404336E-18
      2.04305412862137E-11
      0.00000000000000E+00  -1.34608565298723E-11   0.00000000000000E+00  -1.25224517447448E-14   1.86625515117354E-22
      1.34608862492411E-08   1.34608737267895E-08  -7.81937173590068E-19  -2.53912505190283E-01  -2.53912505190185E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.71122285508080E-11   0.00000000000000E+00  -9.71122285508080E-11
      3.69028734648187E-18  -2.53912507178924E-01  -2.49702212231127E-01   0.00000000000000E+00  -6.28582082826286E-13
     -9.83985960389543E-23  -1.33631329161547E-08  -1.33637614982376E-08  -2.90835017289181E-18
      2.14659597286021E-11
      0.00000000000000E+00  -1.34605809956607E-11   0.00000000000000E+00  -1.06320021894906E-14   1.86796322498448E-22
      1.34606058858999E-08   1.34605952538979E-08  -7.81870184690876E-19  -2.53940392979914E-01  -2.53940392979828E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.55674599666495E-11   0.00000000000000E+00  -8.55674599666495E-11
      3.69019874835576E-18  -2.53940395075332E-01  -2.49726550738417E-01   0.00000000000000E+00  -5.45846735708437E-13
     -9.83992010095456E-23  -1.33744819471965E-08  -1.33750277939323E-08  -2.90832856366488E-18
      2.28637746258263E-11
      0.00000000000000E+00  -1.34603054614491E-11   0.00000000000000E+00  -8.51474797384931E-15   1.86981354884162E-22
      1.34602930862647E-08   1.34602845715169E-08  -7.81795344327115E-19  -2.53971515371767E-01  -2.53971515371694E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.27831543098311E-11   0.00000000000000E+00  -7.27831543098311E-11
      3.69009701097840E-18  -2.53971517513165E-01  -2.49753743433453E-01   0.00000000000000E+00  -4.54121094750045E-13
     -9.83999057889898E-23  -1.33870472961110E-08  -1.33875014172058E-08  -2.90830166665128E-18
      2.47508247370791E-11
      0.00000000000000E+00  -1.34599380825003E-11   0.00000000000000E+00  -6.12264254906526E-15   1.87167448943586E-22
      1.34599630715267E-08   1.34599569488844E-08  -7.81716228978926E-19  -2.54004362625174E-01  -2.54004362625115E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.94666507808894E-11   0.00000000000000E+00  -5.94666507808894E-11
      3.68998479442842E-18  -2.54004364654209E-01  -2.49782498562697E-01   0.00000000000000E+00  -3.58655474187701E-13
     -9.84006987612385E-23  -1.34001316426288E-08  -1.34004902981030E-08  -2.90826856544950E-18
      2.72983423872703E-11
      0.00000000000000E+00  -1.34595707035514E-11   0.00000000000000E+00  -3.61712465214399E-15   1.87336389771618E-22
      1.34596374958853E-08   1.34596338787609E-08  -7.81637946200483E-19  -2.54036786098977E-01  -2.54036786098931E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.66232668649226E-11   0.00000000000000E+00  -4.66232668649226E-11
      3.68986602083317E-18  -2.54036787681606E-01  -2.49810977259652E-01   0.00000000000000E+00  -2.66718445188357E-13
     -9.84015610236547E-23  -1.34127438934511E-08  -1.34130106118964E-08  -2.90822807463269E-18
      3.07374912150284E-11
      0.00000000000000E+00  -1.34592951693398E-11   0.00000000000000E+00  -3.43959404946408E-15   1.87468086443998E-22
      1.34593396691902E-08   1.34593362295963E-08  -7.81566013453345E-19  -2.54066472602994E-01  -2.54066472602958E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.53571973643040E-11   0.00000000000000E+00  -3.53571973643040E-11
      3.68974442216930E-18  -2.54066473115343E-01  -2.49837206629039E-01   0.00000000000000E+00  -1.84069728461157E-13
     -9.84024755331439E-23  -1.34237949625033E-08  -1.34239790322319E-08  -2.90817840871596E-18
      3.30589166737651E-11
      0.00000000000000E+00  -1.34592033246026E-11   0.00000000000000E+00  -2.75354970302748E-15   1.87525061967017E-22
      1.34591858852734E-08   1.34591831317239E-08  -7.81528729240355E-19  -2.54081813638282E-01  -2.54081813638253E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.97789586565730E-11   0.00000000000000E+00  -2.97789586565730E-11
      3.68967529253655E-18  -2.54081813227093E-01  -2.49850837510236E-01   0.00000000000000E+00  -1.43771402482529E-13
     -9.84030092312352E-23  -1.34292604016645E-08  -1.34294041730671E-08  -2.90814656329619E-18
      3.38423977660888E-11
      0.00000000000000E+00  -1.34591114798654E-11   0.00000000000000E+00  -3.45560335124934E-15   1.87541065044227E-22
      1.34591386644622E-08   1.34591352088591E-08  -7.81517289103003E-19  -2.54086515014488E-01  -2.54086515014460E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81017568236728E-11   0.00000000000000E+00  -2.81017568236728E-11
      3.68965327534141E-18  -2.54086514262039E-01  -2.49855024944317E-01   0.00000000000000E+00  -1.30754554758851E-13
     -9.84031917206622E-23  -1.34309026974813E-08  -1.34310334520362E-08  -2.90813598623841E-18
      3.49000972407257E-11
      0.00000000000000E+00  -1.34591114798654E-11   0.00000000000000E+00  -2.22308905285805E-15   1.87557648966449E-22
      1.34590825431734E-08   1.34590803200846E-08  -7.81503632145849E-19  -2.54092118074593E-01  -2.54092118074567E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.61585275720116E-11   0.00000000000000E+00  -2.61585275720116E-11
      3.68962560748054E-18  -2.54092116823895E-01  -2.49860032882669E-01   0.00000000000000E+00  -1.17720622385595E-13
     -9.84033989195749E-23  -1.34328040718898E-08  -1.34329217925122E-08  -2.90812197533469E-18
      3.63279915314855E-11
      0.00000000000000E+00  -1.34590196351282E-11   0.00000000000000E+00  -1.90380022848394E-15   1.87572613164770E-22
      1.34590179820322E-08   1.34590160782321E-08  -7.81487857536186E-19  -2.54098575777740E-01  -2.54098575777716E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40126703249147E-11   0.00000000000000E+00  -2.40126703249147E-11
      3.68959131992568E-18  -2.54098573813049E-01  -2.49865834061222E-01   0.00000000000000E+00  -1.02306016073287E-13
     -9.84036717347444E-23  -1.34349011018921E-08  -1.34350034079082E-08  -2.90810346238950E-18
      3.82556488240113E-11
      0.00000000000000E+00  -1.34589277903910E-11   0.00000000000000E+00  -1.57242399038882E-15   1.87582516833600E-22
      1.34589462953509E-08   1.34589447229271E-08  -7.81470291644277E-19  -2.54105746830094E-01  -2.54105746830072E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.17829783023639E-11   0.00000000000000E+00  -2.17829783023639E-11
      3.68954932980870E-18  -2.54105743816642E-01  -2.49872324085493E-01   0.00000000000000E+00  -8.63268946933322E-14
     -9.84040127173112E-23  -1.34370754177287E-08  -1.34371617446235E-08  -2.90807903816442E-18
      4.08579861689211E-11
      0.00000000000000E+00  -1.34588359456538E-11   0.00000000000000E+00  -1.24821058345533E-15   1.87582713669090E-22
      1.34588695724860E-08   1.34588683242756E-08  -7.81451419067926E-19  -2.54113427064564E-01  -2.54113427064545E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.96346651723420E-11   0.00000000000000E+00  -1.96346651723420E-11
      3.68949823378627E-18  -2.54113422498422E-01  -2.49879350017766E-01   0.00000000000000E+00  -7.10033493498579E-14
     -9.84044354148205E-23  -1.34391626557539E-08  -1.34392336591033E-08  -2.90804681471834E-18
      4.43711415845494E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -1.02134743246457E-15   1.87567746292854E-22
      1.34587895807663E-08   1.34587885594190E-08  -7.81431668963540E-19  -2.54121443405261E-01  -2.54121443405243E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77445667765758E-11   0.00000000000000E+00  -1.77445667765758E-11
      3.68943589436540E-18  -2.54121436559932E-01  -2.49886793723799E-01   0.00000000000000E+00  -5.75760838633857E-14
     -9.84049606204418E-23  -1.34409864165591E-08  -1.34410439926431E-08  -2.90800422540186E-18
      4.55568315373239E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.48312292164237E-16   1.87561245157600E-22
      1.34587648497310E-08   1.34587639014189E-08  -7.81425555509884E-19  -2.54123922912653E-01  -2.54123922912636E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.72035742307502E-11   0.00000000000000E+00  -1.72035742307502E-11
      3.68941549626028E-18  -2.54123915279843E-01  -2.49889109772553E-01   0.00000000000000E+00  -5.37577552947936E-14
     -9.84051331007732E-23  -1.34415065694313E-08  -1.34415603271867E-08  -2.90798994075040E-18
      4.57569167168546E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.36113129604660E-16   1.87560107941261E-22
      1.34587607377084E-08   1.34587598015955E-08  -7.81424539122944E-19  -2.54124335088512E-01  -2.54124335088495E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.71149574967593E-11   0.00000000000000E+00  -1.71149574967593E-11
      3.68941207181094E-18  -2.54124327321459E-01  -2.49889495187306E-01   0.00000000000000E+00  -5.31329933801094E-14
     -9.84051620057523E-23  -1.34415917111022E-08  -1.34416448440957E-08  -2.90798753268800E-18
      4.60270317092211E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.19589164641459E-16   1.87558502312316E-22
      1.34587552978215E-08   1.34587543782325E-08  -7.81423193706092E-19  -2.54124880612907E-01  -2.54124880612890E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.70000004907862E-11   0.00000000000000E+00  -1.70000004907862E-11
      3.68940747985594E-18  -2.54124872664924E-01  -2.49890006022447E-01   0.00000000000000E+00  -5.23244203340475E-14
     -9.84052010869819E-23  -1.34417020533321E-08  -1.34417543777525E-08  -2.90798428614985E-18
      4.63916869489158E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.98860163835879E-16   1.87556213953631E-22
      1.34587481428238E-08   1.34587472439638E-08  -7.81421423500393E-19  -2.54125598252985E-01  -2.54125598252968E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.68528669261652E-11   0.00000000000000E+00  -1.68528669261652E-11
      3.68940133436971E-18  -2.54125590059371E-01  -2.49890679310472E-01   0.00000000000000E+00  -5.12907225800785E-14
     -9.84052535591795E-23  -1.34418430863117E-08  -1.34418943770344E-08  -2.90797991086932E-18
      4.68839715225036E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.72980092607502E-16   1.87552922069994E-22
      1.34587388021683E-08   1.34587379291884E-08  -7.81419111900194E-19  -2.54126535216673E-01  -2.54126535216657E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66678651375339E-11   0.00000000000000E+00  -1.66678651375339E-11
      3.68939312903683E-18  -2.54126526688648E-01  -2.49891560590043E-01   0.00000000000000E+00  -4.99938119083692E-14
     -9.84053236336180E-23  -1.34420200702390E-08  -1.34420700640510E-08  -2.90797401713664E-18
      4.75485556968472E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.41240679161827E-16   1.87548146066744E-22
      1.34587267187055E-08   1.34587258774651E-08  -7.81416120685540E-19  -2.54127747514140E-01  -2.54127747514123E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.64405935699529E-11   0.00000000000000E+00  -1.64405935699529E-11
      3.68938220287852E-18  -2.54127738530063E-01  -2.49892704627130E-01   0.00000000000000E+00  -4.84059633192282E-14
     -9.84054170494760E-23  -1.34422368779307E-08  -1.34422852838942E-08  -2.90796608219298E-18
      4.84457443322111E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.03560654442672E-16   1.87541171785191E-22
      1.34587112480826E-08   1.34587104445221E-08  -7.81412290370726E-19  -2.54129299975135E-01  -2.54129299975119E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61696679452142E-11   0.00000000000000E+00  -1.61696679452142E-11
      3.68936769563621E-18  -2.54129290368230E-01  -2.49894175973286E-01   0.00000000000000E+00  -4.65226025226439E-14
     -9.84055413975956E-23  -1.34424942539751E-08  -1.34425407765777E-08  -2.90795540526548E-18
      4.96569489899523E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -7.60614732490599E-16   1.87530957357128E-22
      1.34586916540342E-08   1.34586908934196E-08  -7.81407440179053E-19  -2.54131266670194E-01  -2.54131266670178E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.58588386615302E-11   0.00000000000000E+00  -1.58588386615302E-11
      3.68934848733695E-18  -2.54131256211891E-01  -2.49896050051110E-01   0.00000000000000E+00  -4.43782393057984E-14
     -9.84057065962745E-23  -1.34427876765192E-08  -1.34428320547587E-08  -2.90794104715790E-18
      5.12920752779030E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -7.14520202929810E-16   1.87516024670536E-22
      1.34586670793276E-08   1.34586663648075E-08  -7.81401363434436E-19  -2.54133733720941E-01  -2.54133733720925E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55188034838911E-11   0.00000000000000E+00  -1.55188034838911E-11
      3.68932311213342E-18  -2.54133722099332E-01  -2.49898416539999E-01   0.00000000000000E+00  -4.20597834323513E-14
     -9.84059256612378E-23  -1.34431055015403E-08  -1.34431475613238E-08  -2.90792174869898E-18
      5.18439304000863E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -8.26787764204308E-14   1.87511471084938E-22
      1.34586543800756E-08   1.34585717012994E-08  -7.81399366274006E-19  -2.54134546191546E-01  -2.54134546191530E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54120700324912E-11   0.00000000000000E+00  -1.54120700324912E-11
      3.68931460690363E-18  -2.54134535283359E-01  -2.49899200213299E-01   0.00000000000000E+00   4.05898431856670E-14
     -9.83979925841502E-23  -1.34432002211087E-08  -1.34431596312656E-08  -2.90791524062962E-18
      5.19370559519547E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -2.48456870135988E-15   1.87510150568662E-22
      1.34586496414030E-08   1.34586471568345E-08  -7.81399025807880E-19  -2.54134683141178E-01  -2.54134683141162E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53934741232837E-11   0.00000000000000E+00  -1.53934741232837E-11
      3.68931317337785E-18  -2.54134672309657E-01  -2.49899333317877E-01   0.00000000000000E+00  -3.99035103164325E-14
     -9.84018770333711E-23  -1.34432137791906E-08  -1.34432536827011E-08  -2.90791414756997E-18
      5.20627754469771E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -1.63106978014186E-15   1.87508993385433E-22
      1.34586454292400E-08   1.34586437981704E-08  -7.81398572334022E-19  -2.54134866794497E-01  -2.54134866794482E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53696530807243E-11   0.00000000000000E+00  -1.53696530807243E-11
      3.68931124111283E-18  -2.54134856135238E-01  -2.49899510696693E-01   0.00000000000000E+00  -4.05610087500609E-14
     -9.84042696546201E-23  -1.34432335840911E-08  -1.34432741450999E-08  -2.90791266877881E-18
      5.22324967652574E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -4.12429589371274E-16   1.87507515838230E-22
      1.34586439408769E-08   1.34586435284475E-08  -7.81397966928096E-19  -2.54135112790695E-01  -2.54135112790680E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53387481477712E-11   0.00000000000000E+00  -1.53387481477712E-11
      3.68930863780028E-18  -2.54135102190528E-01  -2.49899747100324E-01   0.00000000000000E+00  -4.13113357220329E-14
     -9.84054585542258E-23  -1.34432634689702E-08  -1.34433047803060E-08  -2.90791067087218E-18
      5.24616205449357E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00   1.56546108289769E-17   1.87505380681087E-22
      1.34586439207875E-08   1.34586439364423E-08  -7.81397158261376E-19  -2.54135441707402E-01  -2.54135441707387E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52985092711020E-11   0.00000000000000E+00  -1.52985092711020E-11
      3.68930513254801E-18  -2.54135430956407E-01  -2.49900063060632E-01   0.00000000000000E+00  -4.12290226994715E-14
     -9.84059319216175E-23  -1.34433041981453E-08  -1.34433454271681E-08  -2.90790797428663E-18
      5.27709376475014E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -1.65202115936221E-16   1.87502331829374E-22
      1.34586427657288E-08   1.34586426005269E-08  -7.81396080098337E-19  -2.54135880313464E-01  -2.54135880313449E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52464452394416E-11   0.00000000000000E+00  -1.52464452394416E-11
      3.68930041656174E-18  -2.54135869252017E-01  -2.49900485374776E-01   0.00000000000000E+00  -4.06121748659558E-14
     -9.84060969752015E-23  -1.34433555431144E-08  -1.34433961552893E-08  -2.90790433646341E-18
      5.31885157359651E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -4.36713768016265E-16   1.87498118547220E-22
      1.34586389246153E-08   1.34586384879017E-08  -7.81394647681676E-19  -2.54136463166184E-01  -2.54136463166169E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51798952587195E-11   0.00000000000000E+00  -1.51798952587195E-11
      3.68929407777010E-18  -2.54136451701737E-01  -2.49901048154154E-01   0.00000000000000E+00  -3.99144832959641E-14
     -9.84061753782587E-23  -1.34434186781591E-08  -1.34434585926425E-08  -2.90789943008842E-18
      5.37522461553911E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -5.83003224697661E-16   1.87492387526760E-22
      1.34586320962654E-08   1.34586315132623E-08  -7.81392753218244E-19  -2.54137234497682E-01  -2.54137234497667E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50963200720643E-11   0.00000000000000E+00  -1.50963200720643E-11
      3.68928556751525E-18  -2.54137222540530E-01  -2.49901794860633E-01   0.00000000000000E+00  -3.92468994633579E-14
     -9.84062513214800E-23  -1.34434959462905E-08  -1.34435351931901E-08  -2.90789281429701E-18
      5.45132822216163E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.25964717564609E-16   1.87484583697583E-22
      1.34586222604926E-08   1.34586216345280E-08  -7.81390260659401E-19  -2.54138250455980E-01  -2.54138250455965E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49938433047758E-11   0.00000000000000E+00  -1.49938433047758E-11
      3.68927415665972E-18  -2.54138237868876E-01  -2.49902781016879E-01   0.00000000000000E+00  -3.85424568867504E-14
     -9.84063501494528E-23  -1.34435892487644E-08  -1.34436277912214E-08  -2.90788389600032E-18
      5.55406809110202E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.25017519829168E-16   1.87473885144496E-22
      1.34586090708237E-08   1.34586084458064E-08  -7.81386999430703E-19  -2.54139582011504E-01  -2.54139582011489E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48719402422962E-11   0.00000000000000E+00  -1.48719402422962E-11
      3.68925887724781E-18  -2.54139568591018E-01  -2.49904077489805E-01   0.00000000000000E+00  -3.77464594960455E-14
     -9.84064828773439E-23  -1.34436987591049E-08  -1.34437365055645E-08  -2.90787187781711E-18
      5.69276691417155E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -6.10467741674070E-16   1.87459144328137E-22
      1.34585917743507E-08   1.34585911638832E-08  -7.81382755826432E-19  -2.54141319221088E-01  -2.54141319221074E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47321354857799E-11   0.00000000000000E+00  -1.47321354857799E-11
      3.68923844394928E-18  -2.54141304688399E-01  -2.49905774988060E-01   0.00000000000000E+00  -3.68567081528144E-14
     -9.84066608064087E-23  -1.34438221716888E-08  -1.34438590283971E-08  -2.90785568812284E-18
      5.88001032531541E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -5.92255788219520E-16   1.87438805711251E-22
      1.34585692522495E-08   1.34585686599939E-08  -7.81377259639343E-19  -2.54143578119590E-01  -2.54143578119576E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45783884009786E-11   0.00000000000000E+00  -1.45783884009786E-11
      3.68921114687755E-18  -2.54143562108844E-01  -2.49907991062648E-01   0.00000000000000E+00  -3.59082429917211E-14
     -9.84068989486421E-23  -1.34439543633496E-08  -1.34439902715927E-08  -2.90783388723820E-18
      6.13278893035963E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -5.73586274085881E-16   1.87410795822805E-22
      1.34585399733407E-08   1.34585393997546E-08  -7.81370162833961E-19  -2.54146512054365E-01  -2.54146512054351E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44166078518754E-11   0.00000000000000E+00  -1.44166078518754E-11
      3.68917470477732E-18  -2.54146494101970E-01  -2.49910881308403E-01   0.00000000000000E+00  -3.49575616563670E-14
     -9.84072174780507E-23  -1.34440878343410E-08  -1.34441227919028E-08  -2.90780454194336E-18
      6.47404004716933E-11
      0.00000000000000E+00  -1.34584685667049E-11   0.00000000000000E+00  -5.56076641315074E-16   1.87372391907705E-22
      1.34585018416198E-08   1.34585012855433E-08  -7.81361008260709E-19  -2.54150329137858E-01  -2.54150329137844E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42528033703499E-11   0.00000000000000E+00  -1.42528033703499E-11
      3.68912606692665E-18  -2.54150308684042E-01  -2.49914656296034E-01   0.00000000000000E+00  -3.40663965987934E-14
     -9.84076434880787E-23  -1.34442144157763E-08  -1.34442484821730E-08  -2.90776505866593E-18
      6.93472905486242E-11
      0.00000000000000E+00  -1.34584685667049E-11   0.00000000000000E+00  -5.40712266925950E-16   1.87320063349119E-22
      1.34584519604869E-08   1.34584514197748E-08  -7.81349191401101E-19  -2.54155315962730E-01  -2.54155315962716E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40900497867610E-11   0.00000000000000E+00  -1.40900497867610E-11
      3.68906115561610E-18  -2.54155292386141E-01  -2.49919604438603E-01   0.00000000000000E+00  -3.32802213408262E-14
     -9.84082133948885E-23  -1.34443280897667E-08  -1.34443613699881E-08  -2.90771196421500E-18
      7.55665921524809E-11
      0.00000000000000E+00  -1.34583767219677E-11   0.00000000000000E+00  -5.27829829431692E-16   1.87249260414970E-22
      1.34583863383047E-08   1.34583858104751E-08  -7.81333926486333E-19  -2.54161865091339E-01  -2.54161865091325E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39255318356344E-11   0.00000000000000E+00  -1.39255318356344E-11
      3.68897454853362E-18  -2.54161837835310E-01  -2.49926118734359E-01   0.00000000000000E+00  -3.26081545021026E-14
     -9.84089760697183E-23  -1.34444276704848E-08  -1.34444602786394E-08  -2.90764062204729E-18
      8.39626493176874E-11
      0.00000000000000E+00  -1.34582848772305E-11   0.00000000000000E+00  -5.17313677206275E-16   1.87154118101631E-22
      1.34582995147414E-08   1.34582989974279E-08  -7.81314235344576E-19  -2.54170502123053E-01  -2.54170502123039E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37494636854354E-11   0.00000000000000E+00  -1.37494636854354E-11
      3.68885910725053E-18  -2.54170471183269E-01  -2.49934723972865E-01   0.00000000000000E+00  -3.20172748817277E-14
     -9.84099967892365E-23  -1.34445175164675E-08  -1.34445495337424E-08  -2.90754487190595E-18
      9.52973264907162E-11
      0.00000000000000E+00  -1.34581930324933E-11   0.00000000000000E+00  -5.09594625678715E-16   1.87027063158054E-22
      1.34581839202613E-08   1.34581834106669E-08  -7.81288977808161E-19  -2.54181909376458E-01  -2.54181909376444E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35466347679061E-11   0.00000000000000E+00  -1.35466347679061E-11
      3.68870556051865E-18  -2.54181877444057E-01  -2.49946102761785E-01   0.00000000000000E+00  -3.14477834290592E-14
     -9.84113621995190E-23  -1.34446053281154E-08  -1.34446367758989E-08  -2.90741658271049E-18
      1.10599140674305E-10
      0.00000000000000E+00  -1.34580093430189E-11   0.00000000000000E+00  -5.06762249927286E-16   1.86858349369718E-22
      1.34580285584456E-08   1.34580280516835E-08  -7.81256938124633E-19  -2.54196945975991E-01  -2.54196945975977E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.32993884674566E-11   0.00000000000000E+00  -1.32993884674566E-11
      3.68850205574757E-18  -2.54196927089931E-01  -2.49961123476699E-01   0.00000000000000E+00  -3.08411343893338E-14
     -9.84131867913406E-23  -1.34446978220817E-08  -1.34447286632162E-08  -2.90724511762293E-18
      1.30599140674305E-10
      0.00000000000000E+00  -1.34578256535445E-11   0.00000000000000E+00  -5.07788441616945E-16   1.86642538830698E-22
      1.34578251477937E-08   1.34578246400055E-08  -7.81218149841929E-19  -2.54216057289230E-01  -2.54216057289217E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30004816262741E-11   0.00000000000000E+00  -1.30004816262741E-11
      3.68824204611504E-18  -2.54216095064996E-01  -2.49980261389015E-01   0.00000000000000E+00  -3.01771866963748E-14
     -9.84155445138771E-23  -1.34447939811924E-08  -1.34448241583792E-08  -2.90702389627311E-18
      1.50599140674305E-10
      0.00000000000000E+00  -1.34576419640701E-11   0.00000000000000E+00  -4.95458691130922E-16   1.86431271627932E-22
      1.34576257051615E-08   1.34576252097030E-08  -7.81182112052773E-19  -2.54234680765273E-01  -2.54234680765261E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27225214724380E-11   0.00000000000000E+00  -1.27225214724380E-11
      3.68798759568559E-18  -2.54234809142503E-01  -2.49998950749208E-01   0.00000000000000E+00  -2.95819495644334E-14
     -9.84178765336570E-23  -1.34448731062809E-08  -1.34449026882306E-08  -2.90680548363282E-18
      1.70599140674305E-10
      0.00000000000000E+00  -1.34574582745956E-11   0.00000000000000E+00  -4.54236413126670E-16   1.86224475241437E-22
      1.34574420293424E-08   1.34574415751062E-08  -7.81148490629245E-19  -2.54252880463419E-01  -2.54252880463406E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24689713822673E-11   0.00000000000000E+00  -1.24689713822673E-11
      3.68773821625795E-18  -2.54253084782530E-01  -2.50017204385462E-01   0.00000000000000E+00  -2.89893920033245E-14
     -9.84201793112606E-23  -1.34449436143317E-08  -1.34449726037238E-08  -2.90658972562870E-18
      1.90599140674305E-10
      0.00000000000000E+00  -1.34572745851212E-11   0.00000000000000E+00  -3.73417508913069E-16   1.86022172394494E-22
      1.34572901943132E-08   1.34572898208959E-08  -7.81116946064229E-19  -2.54270732839901E-01  -2.54270732839889E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.22444328721023E-11   0.00000000000000E+00  -1.22444328721023E-11
      3.68749332760050E-18  -2.54270901069462E-01  -2.50034997764380E-01   0.00000000000000E+00  -2.83355564875127E-14
     -9.84224440264564E-23  -1.34450170524673E-08  -1.34450453880238E-08  -2.90637638153627E-18
      2.10599140674305E-10
      0.00000000000000E+00  -1.34571827403840E-11   0.00000000000000E+00  -2.88432792419615E-16   1.85824336947204E-22
      1.34571790449625E-08   1.34571787565299E-08  -7.81087187661691E-19  -2.54288301066803E-01  -2.54288301066791E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20473294445653E-11   0.00000000000000E+00  -1.20473294445653E-11
      3.68725238101161E-18  -2.54288212266298E-01  -2.50052281871233E-01   0.00000000000000E+00  -2.75794225994270E-14
     -9.84246604228112E-23  -1.34451038476627E-08  -1.34451314270854E-08  -2.90616519334992E-18
      2.30599140674305E-10
      0.00000000000000E+00  -1.34570908956468E-11   0.00000000000000E+00  -2.13242869034214E-16   1.85630616993720E-22
      1.34570912882946E-08   1.34570910750519E-08  -7.81059085557730E-19  -2.54305582775725E-01  -2.54305582775713E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18613305972445E-11   0.00000000000000E+00  -1.18613305972445E-11
      3.68701515439967E-18  -2.54304993310541E-01  -2.50069031967041E-01   0.00000000000000E+00  -2.68551752401222E-14
     -9.84268267898391E-23  -1.34452028892793E-08  -1.34452297444547E-08  -2.90595606884194E-18
      2.50599140674305E-10
      0.00000000000000E+00  -1.34569990509096E-11   0.00000000000000E+00  -3.22802993683544E-16   1.85440051712476E-22
      1.34569669918243E-08   1.34569666690214E-08  -7.81032789952493E-19  -2.54322453725569E-01  -2.54322453725558E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16514244006145E-11   0.00000000000000E+00  -1.16514244006145E-11
      3.68678212591166E-18  -2.54321319619642E-01  -2.50085331353767E-01   0.00000000000000E+00  -2.63311918783932E-14
     -9.84289640131561E-23  -1.34452889134289E-08  -1.34453152446208E-08  -2.90574933595916E-18
      2.70599140674305E-10
      0.00000000000000E+00  -1.34566316719608E-11   0.00000000000000E+00  -6.27324315936737E-16   1.85251067103467E-22
      1.34567096539058E-08   1.34567090265817E-08  -7.81008738885728E-19  -2.54338661350198E-01  -2.54338661350187E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13744532220753E-11   0.00000000000000E+00  -1.13744532220753E-11
      3.68655463684722E-18  -2.54337444523348E-01  -2.50101450196055E-01   0.00000000000000E+00  -2.64285177318556E-14
     -9.84311243658451E-23  -1.34453081448418E-08  -1.34453345733596E-08  -2.90554589796149E-18
      2.90599140674305E-10
      0.00000000000000E+00  -1.34561724482747E-11   0.00000000000000E+00  -1.14636815149050E-15   1.85062117126117E-22
      1.34562380704239E-08   1.34562369240559E-08  -7.80987398569732E-19  -2.54353940405174E-01  -2.54353940405163E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10119693691187E-11   0.00000000000000E+00  -1.10119693691187E-11
      3.68633439745983E-18  -2.54353791497863E-01  -2.50117831730291E-01   0.00000000000000E+00  -2.73129288346909E-14
     -9.84333793481660E-23  -1.34451976417578E-08  -1.34452249546868E-08  -2.90534699889010E-18
      3.10599140674305E-10
      0.00000000000000E+00  -1.34556213798515E-11   0.00000000000000E+00  -1.58727434718763E-15   1.84873144782558E-22
      1.34555901386686E-08   1.34555885513944E-08  -7.80968653046532E-19  -2.54368290853094E-01  -2.54368290853084E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06205936777257E-11   0.00000000000000E+00  -1.06205936777257E-11
      3.68612198558628E-18  -2.54370758237253E-01  -2.50134879457350E-01   0.00000000000000E+00  -2.86975045984246E-14
     -9.84357715310166E-23  -1.34449392602120E-08  -1.34449679577167E-08  -2.90515333253975E-18
      3.30599140674305E-10
      0.00000000000000E+00  -1.34550703114283E-11   0.00000000000000E+00  -1.32781241419310E-15   1.84687428782583E-22
      1.34550390170000E-08   1.34550376891878E-08  -7.80951014837210E-19  -2.54382342696989E-01  -2.54382342696979E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03705645970553E-11   0.00000000000000E+00  -1.03705645970553E-11
      3.68591457429434E-18  -2.54388289869743E-01  -2.50152505897329E-01   0.00000000000000E+00  -2.94580478316296E-14
     -9.84382335013582E-23  -1.34446376665428E-08  -1.34446671245908E-08  -2.90496355945713E-18
      3.50599140674305E-10
      0.00000000000000E+00  -1.34550703114283E-11   0.00000000000000E+00   2.21070851126938E-16   1.84512392210420E-22
      1.34551176205490E-08   1.34551178416200E-08  -7.80931238555078E-19  -2.54397543685930E-01  -2.54397543685920E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05171634392346E-11   0.00000000000000E+00  -1.05171634392346E-11
      3.68570423102555E-18  -2.54405361100733E-01  -2.50169598083250E-01   0.00000000000000E+00  -2.75486652509346E-14
     -9.84405145233007E-23  -1.34445731295155E-08  -1.34446006781808E-08  -2.90477299247048E-18
      3.70599140674305E-10
      0.00000000000000E+00  -1.34564479824864E-11   0.00000000000000E+00   3.50074532634347E-15   1.84357207724262E-22
      1.34564062397433E-08   1.34564097404888E-08  -7.80905261518660E-19  -2.54415744715170E-01  -2.54415744715159E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12468371304180E-11   0.00000000000000E+00  -1.12468371304180E-11
      3.68547929428295E-18  -2.54419785501013E-01  -2.50183845464863E-01   0.00000000000000E+00  -2.14563062073412E-14
     -9.84422012707951E-23  -1.34451414470520E-08  -1.34451629033583E-08  -2.90457403276428E-18
      3.90599140674305E-10
      0.00000000000000E+00  -1.34590196351282E-11   0.00000000000000E+00   6.68432695643140E-15   1.84225479624528E-22
      1.34589936920392E-08   1.34590003763663E-08  -7.80871234698468E-19  -2.54437823298249E-01  -2.54437823298236E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23935103453854E-11   0.00000000000000E+00  -1.23935103453854E-11
      3.68523142407604E-18  -2.54428974454335E-01  -2.50192579500575E-01   0.00000000000000E+00  -1.09843698624999E-14
     -9.84429337891492E-23  -1.34465958816511E-08  -1.34466068660210E-08  -2.90436018937757E-18
      4.10599140674305E-10
      0.00000000000000E+00  -1.34617749772444E-11   0.00000000000000E+00   8.15891242546621E-15   1.84104131547338E-22
      1.34617434102837E-08   1.34617515691963E-08  -7.80834221039510E-19  -2.54461520581688E-01  -2.54461520581674E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.31499805798254E-11   0.00000000000000E+00  -1.31499805798254E-11
      3.68496842446444E-18  -2.54432105935885E-01  -2.50195082883627E-01   0.00000000000000E+00  -2.74832680229547E-15
     -9.84428480266491E-23  -1.34485988402895E-08  -1.34486015886164E-08  -2.90413420342493E-18
      4.30599140674305E-10
      0.00000000000000E+00  -1.34618668219816E-11   0.00000000000000E+00   5.38104478852291E-16   1.83955117115623E-22
      1.34618688337067E-08   1.34618693718114E-08  -7.80809903297490E-19  -2.54479690107496E-01  -2.54479690107484E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20648376251146E-11   0.00000000000000E+00  -1.20648376251146E-11
      3.68472712771194E-18  -2.54433289612985E-01  -2.50195887212619E-01   0.00000000000000E+00  -4.18121657642988E-15
     -9.84430835622078E-23  -1.34498003529696E-08  -1.34498045341863E-08  -2.90391722441445E-18
      4.50599140674305E-10
      0.00000000000000E+00  -1.34556213798515E-11   0.00000000000000E+00  -1.50219079196192E-14   1.83722010626930E-22
      1.34556597361397E-08   1.34556447142320E-08  -7.80822141964824E-19  -2.54481321838692E-01  -2.54481321838684E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.70077157111396E-12   0.00000000000000E+00  -7.70077157111396E-12
      3.68457311228052E-18  -2.54443782929025E-01  -2.50206966748807E-01   0.00000000000000E+00  -3.14066018669673E-14
     -9.84459168669332E-23  -1.34479125360589E-08  -1.34479439426609E-08  -2.90375097031569E-18
      4.70599140674305E-10
      0.00000000000000E+00  -1.34411099113727E-11   0.00000000000000E+00  -3.54849191863361E-14   1.83364448284642E-22
      1.34411227909576E-08   1.34410873060386E-08  -7.80888907000383E-19  -2.54457891941348E-01  -2.54457891941348E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44228308490605E-13   0.00000000000000E+00  -1.44228308490605E-13
      3.68457022771434E-18  -2.54479660260451E-01  -2.50245049791812E-01   0.00000000000000E+00  -8.69055382538950E-14
     -9.84538879396258E-23  -1.34408561721918E-08  -1.34409430777302E-08  -2.90368132071396E-18
      4.90599140674305E-10
      0.00000000000000E+00  -1.34221898955080E-11   0.00000000000000E+00  -4.32496109436355E-14   1.82920651667859E-22
      1.34222876160258E-08   1.34222443664150E-08  -7.80995881551751E-19  -2.54415459375621E-01  -2.54415459375628E-01
      0.00000000000000E+00   0.00000000000000E+00   7.09198963325440E-12   0.00000000000000E+00   7.09198963325440E-12
      3.68471206750701E-18  -2.54551465158722E-01  -2.50320512399604E-01   0.00000000000000E+00  -1.52731846952411E-13
     -9.84675169064884E-23  -1.34291836242012E-08  -1.34293363560482E-08  -2.90371618595526E-18
      5.00599140674305E-10
      0.00000000000000E+00  -1.34128217323128E-11   0.00000000000000E+00  -9.50037919090197E-14   1.82689801487307E-22
      1.34128737187187E-08   1.34127787149270E-08  -7.81054533144454E-19  -2.54391655263761E-01  -2.54391655263771E-01
      0.00000000000000E+00   0.00000000000000E+00   9.92608061667876E-12   0.00000000000000E+00   9.92608061667876E-12
      3.68481132831318E-18  -2.54597026352840E-01  -2.50368146644893E-01   0.00000000000000E+00  -1.29895630002926E-13
     -9.84769725123309E-23  -1.34225748999136E-08  -1.34227047955437E-08  -2.90375679516872E-18
      5.03974140674305E-10
      0.00000000000000E+00  -1.34096071665105E-11   0.00000000000000E+00  -4.69634339015033E-14   1.82611091647622E-22
      1.34096791483615E-08   1.34096321849278E-08  -7.81074774990474E-19  -2.54383388576368E-01  -2.54383388576379E-01
      0.00000000000000E+00   0.00000000000000E+00   1.07514801082473E-11   0.00000000000000E+00   1.07514801082473E-11
      3.68484761455854E-18  -2.54613357856830E-01  -2.50385224648480E-01   0.00000000000000E+00  -1.86151071600550E-13
     -9.84792407908811E-23  -1.34201975139641E-08  -1.34203836650358E-08  -2.90377283956807E-18
      5.08530390674305E-10
      0.00000000000000E+00  -1.34055659980734E-11   0.00000000000000E+00  -4.39592867704944E-14   1.82505499322449E-22
      1.34056434823815E-08   1.34055995230949E-08  -7.81102042359188E-19  -2.54372202140083E-01  -2.54372202140094E-01
      0.00000000000000E+00   0.00000000000000E+00   1.15651632986676E-11   0.00000000000000E+00   1.15651632986676E-11
      3.68490030833382E-18  -2.54637397764644E-01  -2.50410278734222E-01   0.00000000000000E+00  -1.97841174230960E-13
     -9.84825528545752E-23  -1.34169668452196E-08  -1.34171646863939E-08  -2.90379826597463E-18
      5.14681328174305E-10
      0.00000000000000E+00  -1.34009737612130E-11   0.00000000000000E+00  -3.70818089575199E-14   1.82370492219429E-22
      1.34010488563478E-08   1.34010117745390E-08  -7.81136346726418E-19  -2.54358123795976E-01  -2.54358123795988E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18387849042238E-11   0.00000000000000E+00   1.18387849042238E-11
      3.68497312795984E-18  -2.54673075341466E-01  -2.50447315541019E-01   0.00000000000000E+00  -2.07883925751134E-13
     -9.84882495459499E-23  -1.34126426755173E-08  -1.34128505594431E-08  -2.90383678123343E-18
      5.22985093799305E-10
      0.00000000000000E+00  -1.33979428848852E-11   0.00000000000000E+00  -1.82628491551901E-14   1.82222179437977E-22
      1.33979492853884E-08   1.33979310225395E-08  -7.81169536427650E-19  -2.54344860904335E-01  -2.54344860904345E-01
      0.00000000000000E+00   0.00000000000000E+00   9.85728784024112E-12   0.00000000000000E+00   9.85728784024112E-12
      3.68505498056777E-18  -2.54725161509778E-01  -2.50500996766996E-01   0.00000000000000E+00  -2.06928698533452E-13
     -9.84958252681951E-23  -1.34075813816812E-08  -1.34077883103798E-08  -2.90388544414012E-18
      5.34195177393055E-10
      0.00000000000000E+00  -1.34047393954385E-11   0.00000000000000E+00   2.97348258985100E-14   1.82157482283390E-22
      1.34046931019491E-08   1.34047228367751E-08  -7.81159371825214E-19  -2.54351593543068E-01  -2.54351593543068E-01
      0.00000000000000E+00   0.00000000000000E+00   3.45174454344946E-13   0.00000000000000E+00   3.45174454344946E-13
      3.68505885000226E-18  -2.54792517302861E-01  -2.50569209647553E-01   0.00000000000000E+00  -1.58260766003649E-13
     -9.85033050657956E-23  -1.34049097504633E-08  -1.34050680112294E-08  -2.90389947817704E-18
      5.49328790244618E-10
      0.00000000000000E+00  -1.34498351614074E-11   0.00000000000000E+00   1.47432788813563E-13   1.82559171779528E-22
      1.34497244208599E-08   1.34498718536489E-08  -7.80942208831189E-19  -2.54453129160515E-01  -2.54453129160484E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.11627161929819E-11   0.00000000000000E+00  -3.11627161929819E-11
      3.68458724551999E-18  -2.54829933682101E-01  -2.50602328579452E-01   0.00000000000000E+00   4.64400920874370E-14
     -9.84986153198050E-23  -1.34187555775478E-08  -1.34187091374558E-08  -2.90364503668880E-18
      5.69328790244618E-10
      0.00000000000000E+00  -1.35925618830279E-11   0.00000000000000E+00   3.82720084465119E-13   1.84352387826966E-22
      1.35922755953109E-08   1.35926583153955E-08  -7.80120754765811E-19  -2.54833501698480E-01  -2.54833501698375E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04651749875476E-10   0.00000000000000E+00  -1.04651749875476E-10
      3.68249421052248E-18  -2.54625691650285E-01  -2.50376263544466E-01   0.00000000000000E+00   5.67175986054038E-13
     -9.84413129613219E-23  -1.34885737415061E-08  -1.34880065655201E-08  -2.90237345575667E-18
      5.79328790244618E-10
      0.00000000000000E+00  -1.36851413781331E-11   0.00000000000000E+00   4.58581416032595E-13   1.85592819931025E-22
      1.36847670295713E-08   1.36852256109875E-08  -7.79565215283483E-19  -2.55090837880152E-01  -2.55090837880004E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47711151715673E-10   0.00000000000000E+00  -1.47711151715673E-10
      3.68101709900532E-18  -2.54438217578714E-01  -2.50173182585438E-01   0.00000000000000E+00   9.34241278322123E-13
     -9.83970378536727E-23  -1.35384487005499E-08  -1.35375144592717E-08  -2.90145188372183E-18
      5.92828790244618E-10
      0.00000000000000E+00  -1.38353993682046E-11   0.00000000000000E+00   5.56263352025497E-13   1.87771476506478E-22
      1.38348089554717E-08   1.38353652188240E-08  -7.78598168337778E-19  -2.55540941869418E-01  -2.55540941869213E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.05323852088431E-10   0.00000000000000E+00  -2.05323852088431E-10
      3.67824522700213E-18  -2.53988140791430E-01  -2.49693956184512E-01   0.00000000000000E+00   1.43158320080840E-12
     -9.83063688155985E-23  -1.36314729499363E-08  -1.36300413667356E-08  -2.89964705866435E-18
      6.11053790244618E-10
      0.00000000000000E+00  -1.39713295792718E-11   0.00000000000000E+00   3.77453764403404E-13   1.90194132779302E-22
      1.39709695411897E-08   1.39713469949543E-08  -7.77479046253794E-19  -2.56073959675872E-01  -2.56073959675655E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.16591244027839E-10   0.00000000000000E+00  -2.16591244027839E-10
      3.67429785157972E-18  -2.53093039161309E-01  -2.48759562208767E-01   0.00000000000000E+00   1.73808330997955E-12
     -9.81610432815513E-23  -1.37564938342364E-08  -1.37547557509265E-08  -2.89681880532592E-18
      6.31053790244618E-10
      0.00000000000000E+00  -1.37779045627127E-11   0.00000000000000E+00  -1.43744648271040E-13   1.88466013933027E-22
      1.37784105588642E-08   1.37782668142161E-08  -7.78016528925641E-19  -2.55864191838943E-01  -2.55864191838913E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.00252674058531E-11   0.00000000000000E+00  -3.00252674058531E-11
      3.67369734623161E-18  -2.52350827569489E-01  -2.48019503702162E-01   0.00000000000000E+00   3.75335410219856E-13
     -9.81051799992091E-23  -1.37486168822204E-08  -1.37482415468103E-08  -2.89568081730596E-18
      6.51053790244618E-10
      0.00000000000000E+00  -1.29929075938000E-11   0.00000000000000E+00  -6.46174809063755E-13   1.78307259633981E-22
      1.29948080751153E-08   1.29941619003064E-08  -7.82126428937756E-19  -2.54018959089771E-01  -2.54018959090199E-01
      0.00000000000000E+00   0.00000000000000E+00   4.28485433336400E-10   0.00000000000000E+00   4.28485433336400E-10
      3.68226705489833E-18  -2.52948023594680E-01  -2.48719580405188E-01   0.00000000000000E+00  -3.78816850612914E-12
     -9.83514265079146E-23  -1.34188591651365E-08  -1.34226473336428E-08  -2.90014062596057E-18
      6.71053790244618E-10
      0.00000000000000E+00  -1.16764051306673E-11   0.00000000000000E+00  -3.26106462105786E-12   1.59507846123705E-22
      1.16796877484602E-08   1.16764266838393E-08  -7.90409053021486E-19  -2.50231283978486E-01  -2.50231283979523E-01
      0.00000000000000E+00   0.00000000000000E+00   1.03699909143745E-09   0.00000000000000E+00   1.03699909143745E-09
      3.70300703672708E-18  -2.55925483358038E-01  -2.51920075233564E-01   0.00000000000000E+00  -7.50222513111469E-12
     -9.90438213932512E-23  -1.27059235501455E-08  -1.27134257752768E-08  -2.91259798370559E-18
      6.91053790244618E-10
      0.00000000000000E+00  -1.05136507576200E-11   0.00000000000000E+00  -2.88834141868677E-12   1.40269550470332E-22
      1.05165362295005E-08   1.05136478880819E-08  -7.99732521096689E-19  -2.45899577606757E-01  -2.45899577608093E-01
      0.00000000000000E+00   0.00000000000000E+00   1.33600952593760E-09   0.00000000000000E+00   1.33600952593760E-09
      3.72972722724583E-18  -2.61136707894646E-01  -2.57403436691688E-01   0.00000000000000E+00  -1.13603348273325E-11
     -1.00034687754015E-22  -1.18382970791922E-08  -1.18496574140196E-08  -2.92999470614914E-18
      7.11053790244618E-10
      0.00000000000000E+00  -1.07854193350171E-11   0.00000000000000E+00   6.57932978383039E-13   1.37498200779739E-22
      1.07847954001412E-08   1.07854533331197E-08  -8.01471414824587E-19  -2.44975979887542E-01  -2.44975979888180E-01
      0.00000000000000E+00   0.00000000000000E+00   6.37656080669896E-10   0.00000000000000E+00   6.37656080669896E-10
      3.74248034885923E-18  -2.66331026644737E-01  -2.62732150887981E-01   0.00000000000000E+00  -7.94065840864242E-12
     -1.00684521911989E-22  -1.14151687553807E-08  -1.14231094137895E-08  -2.94100893403464E-18
      7.31053790244618E-10
      0.00000000000000E+00  -1.37800169916685E-11   0.00000000000000E+00   7.40863254997030E-12   1.72105627149555E-22
      1.37725936243269E-08   1.37800022568771E-08  -7.85848058721552E-19  -2.51976224599558E-01  -2.51976224598180E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37848701853939E-09   0.00000000000000E+00  -1.37848701853939E-09
      3.71491060848844E-18  -2.66912668800242E-01  -2.63005559794264E-01   0.00000000000000E+00   6.81781047796302E-12
     -1.00040115814095E-22  -1.24083330488156E-08  -1.24015152383377E-08  -2.92906254976689E-18
      7.51053790244618E-10
      0.00000000000000E+00  -1.97484553943624E-11   0.00000000000000E+00   1.47768734731845E-11   2.57746251003997E-22
      1.97337164866666E-08   1.97484933601401E-08  -7.53576308294751E-19  -2.66644841705929E-01  -2.66644841701909E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.01953253745806E-09   0.00000000000000E+00  -4.01953253745806E-09
      3.63451995773928E-18  -2.56276853112031E-01  -2.51321419354273E-01   0.00000000000000E+00   2.64778404067708E-11
     -9.74808423360396E-23  -1.57554386630887E-08  -1.57289608226820E-08  -2.88094364944453E-18
      7.71053790244618E-10
      0.00000000000000E+00  -2.69784731073389E-11   0.00000000000000E+00   1.79173579547553E-11   3.77587413156046E-22
      2.69605729661447E-08   2.69784903240999E-08  -7.17025329506127E-19  -2.83630934863580E-01  -2.83630934857294E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.28653987976512E-09   0.00000000000000E+00  -6.28653987976512E-09
      3.50878916014398E-18  -2.28272748815107E-01  -2.21753659014545E-01   0.00000000000000E+00   4.10901053091244E-11
     -9.29602033957506E-23  -2.07330405496437E-08  -2.06919504443347E-08  -2.79176383063785E-18
      7.91053790244618E-10
      0.00000000000000E+00  -3.25095468714506E-11   0.00000000000000E+00   1.37350101446807E-11   4.81606176509121E-22
      3.24957816430574E-08   3.25095166532025E-08  -6.86869778477219E-19  -2.98449609898376E-01  -2.98449609890498E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.87811041068340E-09   0.00000000000000E+00  -7.87811041068340E-09
      3.35122695193031E-18  -1.82172419573923E-01  -1.74412097134820E-01   0.00000000000000E+00   4.70043372072388E-11
     -8.69213282855411E-23  -2.46784105797263E-08  -2.46314062425191E-08  -2.66435717345309E-18
      8.11053790244618E-10
      0.00000000000000E+00  -3.28264112148166E-11   0.00000000000000E+00   8.39131304844130E-13   5.04554758575986E-22
      3.28255927754893E-08   3.28264319067946E-08  -6.71754457906680E-19  -3.07114695681390E-01  -3.07114695673842E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.54813163616412E-09   0.00000000000000E+00  -7.54813163616412E-09
      3.20026431920703E-18  -1.30436053509893E-01  -1.22471844111923E-01   0.00000000000000E+00   4.02536714875831E-11
     -7.78022478380637E-23  -2.53185539421180E-08  -2.52783002706305E-08  -2.52850986130035E-18
      8.31053790244618E-10
      0.00000000000000E+00  -2.58765199503230E-11   0.00000000000000E+00  -1.71536591048864E-11   4.11058581353461E-22
      2.58936239990950E-08   2.58764703399905E-08  -6.81897245706195E-19  -3.04413509434393E-01  -3.04413509430864E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.52950524168440E-09   0.00000000000000E+00  -3.52950524168440E-09
      3.12967421437334E-18  -9.43455997951743E-02  -8.73048985148288E-02   0.00000000000000E+00   2.50300393956032E-11
     -5.56966686391433E-23  -2.23719951377017E-08  -2.23469650983062E-08  -2.44777696866715E-18
      8.51053790244618E-10
      0.00000000000000E+00  -1.46877185294905E-11   0.00000000000000E+00  -2.76485063966824E-11   2.48841668768466E-22
      1.47154085319581E-08   1.46877600255616E-08  -7.23771441363442E-19  -2.86766890260176E-01  -2.86766890263329E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15279765930426E-09   0.00000000000000E+00   3.15279765930426E-09
      3.19273016755942E-18  -8.51722990665649E-02  -7.95513924832233E-02   0.00000000000000E+00   5.74656612305741E-12
     -6.31426409393797E-23  -1.78463042509889E-08  -1.78405576848659E-08  -2.46895872619598E-18
      8.71053790244618E-10
      0.00000000000000E+00  -3.29639946311534E-12   0.00000000000000E+00  -2.82252261274023E-11   8.41966859604909E-23
      3.32462976863244E-09   3.29640454250512E-09  -8.03494605020956E-19  -2.50736325008538E-01  -2.50736325018678E-01
      0.00000000000000E+00   0.00000000000000E+00   1.01398539413891E-08   0.00000000000000E+00   1.01398539413891E-08
      3.39552724638721E-18  -1.03012282862269E-01  -9.87790019808507E-02   0.00000000000000E+00  -2.31300081863697E-11
     -8.34187059860551E-23  -1.34131284757078E-08  -1.34362584838942E-08  -2.59203264136625E-18
      8.91053790244618E-10
      0.00000000000000E+00   4.45841907826497E-12   0.00000000000000E+00  -1.94480593791041E-11  -2.01701120387029E-23
     -4.43898863088709E-09  -4.45843669026622E-09  -9.25229746752688E-19  -1.92726098017933E-01  -1.92726098033152E-01
      0.00000000000000E+00   0.00000000000000E+00   1.52188195058901E-08   0.00000000000000E+00   1.52188195058901E-08
      3.69990363650501E-18  -1.37075949287509E-01  -1.33685718435966E-01   0.00000000000000E+00  -7.42702816092576E-11
     -9.22029283153525E-23  -1.06861125340145E-08  -1.07603828156238E-08  -2.77467388975232E-18
      9.11053790244618E-10
      0.00000000000000E+00   6.67334676076169E-12   0.00000000000000E+00  -6.01689930667898E-12  -4.37736317285102E-23
     -6.66731085408814E-09  -6.67332775339486E-09  -1.06250163502906E-18  -1.22420124569398E-01  -1.22420124585546E-01
      0.00000000000000E+00   0.00000000000000E+00   1.61488377793565E-08   0.00000000000000E+00   1.61488377793565E-08
      4.02288039209214E-18  -1.74890755824355E-01  -1.71905329930248E-01   0.00000000000000E+00  -1.42724459220099E-10
     -1.04265037410707E-22  -9.33278556674140E-09  -9.47551002596161E-09  -2.96037875706308E-18
      9.31053790244618E-10
      0.00000000000000E+00   5.39367403724922E-12   0.00000000000000E+00   2.54135017548473E-12  -4.65415517098835E-23
     -5.39618400081890E-09  -5.39364265064346E-09  -1.17027741976814E-18  -6.26111736583686E-02  -6.26111736715220E-02
      0.00000000000000E+00   0.00000000000000E+00   1.31534741593637E-08   0.00000000000000E+00   1.31534741593637E-08
      4.28594987527941E-18  -2.14371999636991E-01  -2.11927118527217E-01   0.00000000000000E+00  -1.96116221111914E-10
     -1.16551533675994E-22  -7.56371528760818E-09  -7.75983150872021E-09  -3.11567245551127E-18
      9.51053790244618E-10
      0.00000000000000E+00   2.60361461035897E-12   0.00000000000000E+00   6.51407828401859E-12  -4.71673325128476E-23
     -2.61005386988777E-09  -2.60353979160380E-09  -1.22176791181249E-18  -3.22148750342204E-02  -3.22148750419988E-02
      0.00000000000000E+00   0.00000000000000E+00   7.77839582644906E-09   0.00000000000000E+00   7.77839582644906E-09
      4.44151779180839E-18  -2.53422670403996E-01  -2.51792223872827E-01   0.00000000000000E+00  -1.86565963540003E-10
     -1.26095124322229E-22  -4.98829007130516E-09  -5.17485603484529E-09  -3.21974987999590E-18
      9.71053790244618E-10
      0.00000000000000E+00   9.79983346004310E-13   0.00000000000000E+00   3.88054819606698E-12  -4.73592474856383E-23
     -9.83837681684238E-10  -9.79957133488218E-10  -1.24070652226492E-18  -2.05953927805713E-02  -2.05953927846481E-02
      0.00000000000000E+00   0.00000000000000E+00   4.07679167677939E-09   0.00000000000000E+00   4.07679167677939E-09
      4.52305362534398E-18  -2.84118618616567E-01  -2.83142892545168E-01   0.00000000000000E+00  -1.39019595068740E-10
     -1.32340011004818E-22  -2.95781494822233E-09  -3.09683454329120E-09  -3.28234710307906E-18
      9.91053790244618E-10
      0.00000000000000E+00   4.26710649066169E-13   0.00000000000000E+00   1.31836511205517E-12  -4.74419085407982E-23
     -4.28019459824832E-10  -4.26701094712825E-10  -1.24856396561417E-18  -1.57385472811474E-02  -1.57385472834153E-02
      0.00000000000000E+00   0.00000000000000E+00   2.26786306234378E-09   0.00000000000000E+00   2.26786306234378E-09
      4.56841088659086E-18  -3.04315435926922E-01  -3.03735334404061E-01   0.00000000000000E+00  -9.17371976978659E-11
     -1.36152021445286E-22  -1.74942476993301E-09  -1.84116196763101E-09  -3.31984692097669E-18
      1.01105379024462E-09
      0.00000000000000E+00   2.39347385162815E-13   0.00000000000000E+00   4.42558927877346E-13  -4.74864601571632E-23
     -2.39793487903993E-10  -2.39350928976163E-10  -1.25267299883039E-18  -1.32776530904452E-02  -1.32776530918630E-02
      0.00000000000000E+00   0.00000000000000E+00   1.41785032476075E-09   0.00000000000000E+00   1.41785032476075E-09
      4.59676789308607E-18  -3.17549754852325E-01  -3.17178442204037E-01   0.00000000000000E+00  -6.04280616047039E-11
     -1.38555663468952E-22  -1.11807133417967E-09  -1.17849939578451E-09  -3.34409489425569E-18
      1.02105379024462E-09
      0.00000000000000E+00   1.82128113882526E-13   0.00000000000000E+00   2.70209260974696E-13  -4.75014208539438E-23
     -1.82430048083852E-10  -1.82159838822925E-10  -1.25415611173477E-18  -1.24240575804487E-02  -1.24240575815538E-02
      0.00000000000000E+00   0.00000000000000E+00   1.10510622090688E-09   0.00000000000000E+00   1.10510622090688E-09
      4.60781895529514E-18  -3.22702058598542E-01  -3.22411264662864E-01   0.00000000000000E+00  -4.70088234205369E-11
     -1.39473402854981E-22  -8.75937558663388E-10  -9.22946382084065E-10  -3.35366284356037E-18
      1.03455379024462E-09
      0.00000000000000E+00   1.35746521592725E-13   0.00000000000000E+00   1.64751314330249E-13  -4.75131638193035E-23
     -1.35847858751640E-10  -1.35683107437358E-10  -1.25553388314652E-18  -1.16397247735391E-02  -1.16397247745472E-02
      0.00000000000000E+00   0.00000000000000E+00   1.00806786700040E-09   0.00000000000000E+00   1.00806786700040E-09
      4.62142787149965E-18  -3.29636020822012E-01  -3.29361157332915E-01   0.00000000000000E+00  -4.60941486043362E-11
     -1.40630333151187E-22  -8.26290610958486E-10  -8.72384759562963E-10  -3.36589398835312E-18
      1.05277879024462E-09
      0.00000000000000E+00   8.71606556099429E-14   0.00000000000000E+00   1.33391610030995E-13  -4.75150556473219E-23
     -8.73042563006246E-11  -8.71708646906411E-11  -1.25652233928161E-18  -1.09747642734574E-02  -1.09747642746896E-02
      0.00000000000000E+00   0.00000000000000E+00   1.23222188916977E-09   0.00000000000000E+00   1.23222188916977E-09
      4.64388511542976E-18  -3.43314356227429E-01  -3.42953580125937E-01   0.00000000000000E+00  -6.78776939112882E-11
     -1.42922490612941E-22  -1.07717333056781E-09  -1.14505102447924E-09  -3.38736277614815E-18
      1.07277879024462E-09
      0.00000000000000E+00   6.87917081684375E-14   0.00000000000000E+00   4.98467337224367E-14  -4.75132363300156E-23
     -6.88686065128630E-11  -6.88187597791880E-11  -1.25726145743092E-18  -1.02779152851710E-02  -1.02779152867641E-02
      0.00000000000000E+00   0.00000000000000E+00   1.59310310447981E-09   0.00000000000000E+00   1.59310310447981E-09
      4.67574717751936E-18  -3.64335038814655E-01  -3.63854772436043E-01   0.00000000000000E+00  -1.00711769453618E-10
     -1.46464678005352E-22  -1.42357257524686E-09  -1.52428434470062E-09  -3.41848572008844E-18
      1.09277879024462E-09
      0.00000000000000E+00   1.03692708307298E-13   0.00000000000000E+00  -8.74485989400555E-14  -4.75266399552471E-23
     -1.03579671209890E-10  -1.03667119808878E-10  -1.25871544649304E-18  -9.10691583507327E-03  -9.10691583681213E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73886812441837E-09   0.00000000000000E+00   1.73886812441837E-09
      4.71052454000773E-18  -3.86791407651797E-01  -3.86276192150137E-01   0.00000000000000E+00  -1.17395145390136E-10
     -1.50421155267269E-22  -1.51780585921924E-09  -1.63520100460953E-09  -3.45180909351469E-18
      1.11277879024462E-09
      0.00000000000000E+00   1.14163008348956E-13   0.00000000000000E+00  -3.02380325862944E-14  -4.75418510817350E-23
     -1.14167089996233E-10  -1.14197328028866E-10  -1.26039561697344E-18  -7.81220421614498E-03  -7.81220421785578E-03
      0.00000000000000E+00   0.00000000000000E+00   1.71080210765371E-09   0.00000000000000E+00   1.71080210765371E-09
      4.74474058216080E-18  -4.08754653289042E-01  -4.08251597310129E-01   0.00000000000000E+00  -1.23597448686193E-10
     -1.54417912060098E-22  -1.47300733093848E-09  -1.59660477962482E-09  -3.48434496518736E-18
      1.13277879024462E-09
      0.00000000000000E+00  -2.34204079879193E-14   0.00000000000000E+00   3.55920100267409E-13  -4.75008748879088E-23
      2.30374949759886E-11   2.33934150762085E-11  -1.25935568904043E-18  -8.15354755639986E-03  -8.15354755782822E-03
      0.00000000000000E+00   0.00000000000000E+00   1.42835852583219E-09   0.00000000000000E+00   1.42835852583219E-09
      4.77330775267745E-18  -4.30191290387146E-01  -4.29733874172774E-01   0.00000000000000E+00  -1.19176977866501E-10
     -1.58134245580276E-22  -1.33257496304177E-09  -1.45175194090843E-09  -3.51395206363702E-18
      1.15277879024462E-09
      0.00000000000000E+00  -1.07798168060474E-12   0.00000000000000E+00   2.77385017153630E-12  -4.70535262831220E-23
      1.07519354595526E-09   1.07796739612675E-09  -1.23743261007011E-18  -2.08020303657683E-02  -2.08020303654623E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.05949672727224E-10   0.00000000000000E+00  -3.05949672727224E-10
      4.76718875922290E-18  -4.52420634324389E-01  -4.52177395456559E-01   0.00000000000000E+00  -5.52555967900983E-11
     -1.59817543572859E-22  -7.16762126609269E-10  -7.72017723399527E-10  -3.52975614915280E-18
      1.17277879024462E-09
      0.00000000000000E+00  -2.69095895544333E-12   0.00000000000000E+00   4.35414102725900E-12  -4.60811065453873E-23
      2.68664248678496E-09   2.69099662781218E-09  -1.18418408203512E-18  -5.09940492785374E-02  -5.09940492756900E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.84746467549573E-09   0.00000000000000E+00  -2.84746467549573E-09
      4.71023946571299E-18  -4.75855561408248E-01  -4.75904886309091E-01   0.00000000000000E+00   4.25566159721159E-11
     -1.58519548085340E-22   1.13911431711605E-10   1.56468047683562E-10  -3.52605538367786E-18
      1.18277879024462E-09
      0.00000000000000E+00  -3.69371979627510E-12   0.00000000000000E+00   5.37890269985662E-12  -4.53589440487506E-23
      3.68831626010469E-09   3.69369516280450E-09  -1.14817476613312E-18  -7.07908915919037E-02  -7.07908915875710E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.33268070330064E-09   0.00000000000000E+00  -4.33268070330064E-09
      4.66691265867998E-18  -4.87742619131392E-01  -4.87943985318620E-01   0.00000000000000E+00   9.45753517286085E-11
     -1.57070635127993E-22   5.44410188767763E-10   6.38985540496214E-10  -3.51873789254686E-18
      1.19627879024462E-09
      0.00000000000000E+00  -4.93950181175800E-12   0.00000000000000E+00   5.03193321900706E-12  -4.31529373259484E-23
      4.93449877894962E-09   4.93953071216858E-09  -1.08597939812601E-18  -1.03775809243549E-01  -1.03775809237634E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.91517150624579E-09   0.00000000000000E+00  -5.91517150624579E-09
      4.58705784334566E-18  -5.03861958306045E-01  -5.04169422136962E-01   0.00000000000000E+00   1.42034492132851E-10
     -1.54088272461564E-22   8.33606301944467E-10   9.75640794077164E-10  -3.50107844521965E-18
      1.21450379024462E-09
      0.00000000000000E+00  -7.38817435044787E-12   0.00000000000000E+00   7.07919394319081E-12  -2.49279413955978E-23
      7.38118425990813E-09   7.38826345385129E-09  -9.82331374101273E-19  -1.55686482419993E-01  -1.55686482412280E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.71343616626013E-09   0.00000000000000E+00  -7.71343616626013E-09
      4.44648046921557E-18  -5.23616735285316E-01  -5.23719356891103E-01   0.00000000000000E+00   1.83400872518756E-10
     -1.48700328625324E-22   1.41771839890287E-10   3.25172712408894E-10  -3.46414909511430E-18
      1.23450379024462E-09
      0.00000000000000E+00  -1.39433169344235E-11   0.00000000000000E+00   1.64888114321226E-11   8.13112149901397E-23
      1.39267850032496E-08   1.39432738146818E-08  -8.63865001211915E-19  -2.11128284477183E-01  -2.11128284468270E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.91321366247751E-09   0.00000000000000E+00  -8.91321366247751E-09
      4.26821619596602E-18  -5.33916889975669E-01  -5.32332597453690E-01   0.00000000000000E+00   2.00389366215623E-10
     -1.41630758814186E-22  -5.23044951841993E-09  -5.03006015220445E-09  -3.40435119475411E-18
      1.25450379024462E-09
      0.00000000000000E+00  -2.86699776324899E-11   0.00000000000000E+00   3.65295865364711E-11   3.38878550472636E-22
      2.86334052209087E-08   2.86699348074455E-08  -7.63762383760162E-19  -2.55958283792021E-01  -2.55958283782198E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.82323954032122E-09   0.00000000000000E+00  -9.82323954032122E-09
      4.07175140515960E-18  -5.16879292800493E-01  -5.10942424318649E-01   0.00000000000000E+00   2.16711577836806E-10
     -1.32465733968005E-22  -1.90634068449609E-08  -1.88466952671242E-08  -3.30798902139944E-18
      1.27450379024462E-09
      0.00000000000000E+00  -4.67730345597795E-11   0.00000000000000E+00   4.49249229892735E-11   6.68130889302899E-22
      4.67281629414060E-08   4.67730878643959E-08  -6.94298127447173E-19  -2.87361704822044E-01  -2.87361704811389E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06555966519443E-08   0.00000000000000E+00  -1.06555966519443E-08
      3.85863947212071E-18  -4.62853713080789E-01  -4.51475671191389E-01   0.00000000000000E+00   2.24455629528074E-10
     -1.20321619819926E-22  -3.63419468419795E-08  -3.61174912124515E-08  -3.16434134467354E-18
      1.29450379024462E-09
      0.00000000000000E+00  -5.74714769286610E-11   0.00000000000000E+00   2.66477748444411E-11   8.73026225663978E-22
      5.74447912100525E-08   5.74714389848978E-08  -6.54586309849330E-19  -3.06869863707892E-01  -3.06869863696536E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13560315280923E-08   0.00000000000000E+00  -1.13560315280923E-08
      3.63151884155887E-18  -3.73423277304446E-01  -3.58894929135739E-01   0.00000000000000E+00   2.09869258610194E-10
     -1.06422652160620E-22  -4.63252767154157E-08  -4.61154074568056E-08  -2.97693253170954E-18
      1.31450379024462E-09
      0.00000000000000E+00  -5.60774575073252E-11   0.00000000000000E+00  -3.36569297682677E-12   8.75010982533402E-22
      5.60807806536925E-08   5.60774149607165E-08  -6.37913755964110E-19  -3.17402469631182E-01  -3.17402469619288E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18942752040426E-08   0.00000000000000E+00  -1.18942752040426E-08
      3.39363333747801E-18  -2.61873285522309E-01  -2.47953235015939E-01   0.00000000000000E+00   1.69750360488657E-10
     -9.24492343731582E-23  -4.43528901171623E-08  -4.41831397566738E-08  -2.75571958151390E-18
      1.33450379024462E-09
      0.00000000000000E+00  -5.05931327144521E-11   0.00000000000000E+00  -1.35692127834558E-11   7.92530265090578E-22
      5.06067010800655E-08   5.05931318672829E-08  -6.28166631400769E-19  -3.25300972934616E-01  -3.25300972922584E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20324331379408E-08   0.00000000000000E+00  -1.20324331379408E-08
      3.15298467471920E-18  -1.58381392457003E-01  -1.46232458059237E-01   0.00000000000000E+00   1.03380761586483E-10
     -7.87367659728616E-23  -3.86640794909286E-08  -3.85606987293422E-08  -2.52481804331843E-18
      1.35450379024462E-09
      0.00000000000000E+00  -4.49995126843021E-11   0.00000000000000E+00  -1.38528766367648E-11   6.88251825803333E-22
      4.50133746004907E-08   4.49995217238546E-08  -6.15390009343485E-19  -3.34359650821165E-01  -3.34359650809273E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18917393527135E-08   0.00000000000000E+00  -1.18917393527135E-08
      2.91514988766493E-18  -7.89846492904900E-02  -6.85535876184268E-02   0.00000000000000E+00   5.69762475779699E-11
      4.71753051354425E-23  -3.31647586187191E-08  -3.31077823711411E-08  -2.29975987832144E-18
      1.35575379024462E-09
      0.00000000000000E+00  -4.40693091858643E-11   0.00000000000000E+00  -3.59908229652805E-11   6.80009496955761E-22
      4.41052633647947E-08   4.40692725418301E-08  -6.14757717536961E-19  -3.34838041931769E-01  -3.34838041919822E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19470845859293E-08   0.00000000000000E+00  -1.19470845859293E-08
      2.90021603193252E-18  -7.41683101314031E-02  -6.40477702659098E-02   0.00000000000000E+00   7.07873160024795E-11
      6.63319830975764E-23  -3.21929752719040E-08  -3.21221879559015E-08  -2.28545831439556E-18
      1.35744129024462E-09
      0.00000000000000E+00  -4.30349537554332E-11   0.00000000000000E+00  -3.05214085915539E-11   6.68289484643371E-22
      4.30654626466626E-08   4.30349412380717E-08  -6.13694287346435E-19  -3.35572643955407E-01  -3.35572643943490E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19175037998678E-08   0.00000000000000E+00  -1.19175037998678E-08
      2.88010524427024E-18  -6.81866088138584E-02  -5.83826195340499E-02   0.00000000000000E+00   5.87902560106454E-11
      9.75449311587689E-23  -3.11762276942149E-08  -3.11174374382042E-08  -2.26641095692381E-18
      1.35971941524462E-09
      0.00000000000000E+00  -4.17566587029788E-11   0.00000000000000E+00  -2.74622825876087E-11   6.54093036751743E-22
      4.17845595879975E-08   4.17570973054105E-08  -6.11667666170609E-19  -3.36779688392964E-01  -3.36779688381152E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18126382632347E-08   0.00000000000000E+00  -1.18126382632347E-08
      2.85319457772681E-18  -6.10108506462942E-02  -5.15765349915944E-02   0.00000000000000E+00   5.08025717407412E-11
      1.43067684843457E-22  -2.99952616139163E-08  -2.99444590421754E-08  -2.24152691155620E-18
      1.36279488399462E-09
      0.00000000000000E+00  -4.01422119123449E-11   0.00000000000000E+00  -2.48175596352851E-11   6.37161529272752E-22
      4.01682603855117E-08   4.01434428258771E-08  -6.07828703496373E-19  -3.38798574946294E-01  -3.38798574934653E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16414759677887E-08   0.00000000000000E+00  -1.16414759677887E-08
      2.81739158218400E-18  -5.28504043181811E-02  -4.38708150760216E-02   0.00000000000000E+00   4.36091914331133E-11
      2.05689933923809E-22  -2.85455760495217E-08  -2.85019668580883E-08  -2.20956287868763E-18
      1.36694676680712E-09
      0.00000000000000E+00  -3.82046553362149E-11   0.00000000000000E+00  -2.31050995064226E-11   6.31961169879823E-22
      3.82277894321670E-08   3.82046843326612E-08  -6.00828477425458E-19  -3.42162395062225E-01  -3.42162395050814E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14104641933621E-08   0.00000000000000E+00  -1.14104641933621E-08
      2.77001667201693E-18  -4.42790912954066E-02  -3.58371643876989E-02   0.00000000000000E+00   3.75413327256244E-11
      2.99278855593350E-22  -2.68317614720252E-08  -2.67942201392992E-08  -2.16918819459147E-18
      1.37255180860399E-09
      0.00000000000000E+00  -3.61261170884714E-11   0.00000000000000E+00  -1.83509866985237E-11   6.32117901447279E-22
      3.61444599413733E-08   3.61261089546754E-08  -5.88852392393083E-19  -3.47591374120030E-01  -3.47591374108886E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11440427088968E-08   0.00000000000000E+00  -1.11440427088968E-08
      2.70755384684741E-18  -3.61663665053065E-02  -2.82953755757204E-02   0.00000000000000E+00   2.90384259316350E-11
      4.14677307211422E-22  -2.50111046717106E-08  -2.49820662457786E-08  -2.11870145445432E-18
      1.38011861502977E-09
      0.00000000000000E+00  -3.42196958782547E-11   0.00000000000000E+00  -1.24511962264641E-11   6.40576151087952E-22
      3.42321204356738E-08   3.42196692394480E-08  -5.70036975327230E-19  -3.55853530367391E-01  -3.55853530356501E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08894810320822E-08   0.00000000000000E+00  -1.08894810320822E-08
      2.62515525180042E-18  -2.92767148848180E-02  -2.19261637753939E-02   0.00000000000000E+00   2.04360198548416E-11
      5.45138379374784E-22  -2.33506242272211E-08  -2.33301882073657E-08  -2.05511827647319E-18
      1.39033380370458E-09
      0.00000000000000E+00  -3.26871745932099E-11   0.00000000000000E+00  -7.38947986875331E-12   6.49190954679881E-22
      3.26945945168337E-08   3.26872050369656E-08  -5.42925637178941E-19  -3.67613411246428E-01  -3.67613411235745E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06828151994240E-08   0.00000000000000E+00  -1.06828151994240E-08
      2.51602827896024E-18  -2.38479783199596E-02  -1.69151321703881E-02   0.00000000000000E+00   1.36315336734796E-11
      6.72662623489650E-22  -2.20180213712157E-08  -2.20043898375416E-08  -1.97310264178130E-18
      1.40412430841556E-09
      0.00000000000000E+00  -3.14178803250019E-11   0.00000000000000E+00  -4.50971434301684E-12   6.36931334795193E-22
      3.14223969446547E-08   3.14178872303123E-08  -5.06466500807010E-19  -3.83455098579726E-01  -3.83455098569212E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05141020670672E-08   0.00000000000000E+00  -1.05141020670672E-08
      2.37103350487255E-18  -1.96194839553027E-02  -1.30333935242657E-02   0.00000000000000E+00   9.56549800754780E-12
      7.61345491120955E-22  -2.09133506612534E-08  -2.09037851632451E-08  -1.86456700406554E-18
      1.42274148977540E-09
      0.00000000000000E+00  -3.00826415354789E-11   0.00000000000000E+00  -3.50250749039740E-12   5.72094558269306E-22
      3.00861346073227E-08   3.00826320998329E-08  -4.59489450563923E-19  -4.04082407366485E-01  -4.04082407356145E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03400298598338E-08   0.00000000000000E+00  -1.03400298598338E-08
      2.17853129370596E-18  -1.61848509990906E-02  -9.96460377204413E-03   0.00000000000000E+00   7.66809708897708E-12
      7.59250331831530E-22  -1.97502703370889E-08  -1.97426022399992E-08  -1.71904184314203E-18
      1.44274148977540E-09
      0.00000000000000E+00  -2.87921311329759E-11   0.00000000000000E+00  -3.15006541808273E-12   4.64631205216216E-22
      2.87952999139322E-08   2.87921498485146E-08  -4.11467346946562E-19  -4.25362953296373E-01  -4.25362953286198E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01740366079418E-08   0.00000000000000E+00  -1.01740366079418E-08
      1.97505056154712E-18  -1.37751836661442E-02  -7.90922039339137E-03   0.00000000000000E+00   6.72922863294461E-12
      6.56143233811719E-22  -1.86248424692064E-08  -1.86181132405728E-08  -1.56358321460056E-18
      1.46274148977540E-09
      0.00000000000000E+00  -2.77433560788032E-11   0.00000000000000E+00  -2.55708843344490E-12   3.46197631906222E-22
      2.77459271681064E-08   2.77433700796733E-08  -3.65019935884680E-19  -4.46008663723045E-01  -4.46008663713019E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00264675169799E-08   0.00000000000000E+00  -1.00264675169799E-08
      1.77452121120752E-18  -1.21341626386009E-02  -6.55213679250218E-03   0.00000000000000E+00   5.78533473791962E-12
      5.05045694218331E-22  -1.77226878974319E-08  -1.77169025626934E-08  -1.40950127532284E-18
      1.48274148977540E-09
      0.00000000000000E+00  -2.70074041995593E-11   0.00000000000000E+00  -1.78711146903928E-12   2.35523583000328E-22
      2.70092037154130E-08   2.70074166039442E-08  -3.19099983189393E-19  -4.66378305493564E-01  -4.66378305483586E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.97803126806300E-09   0.00000000000000E+00  -9.97803126806300E-09
      1.57496058584626E-18  -1.09772055293353E-02  -5.61179005302634E-03   0.00000000000000E+00   5.00054638189270E-12
      3.47858990672331E-22  -1.70343858822633E-08  -1.70293853358811E-08  -1.25586060265687E-18
      1.50274148977539E-09
      0.00000000000000E+00  -2.74770981856386E-11   0.00000000000000E+00   1.18693415704664E-12   1.45119409923998E-22
      2.74758886074248E-08   2.74770755415820E-08  -2.69641563352610E-19  -4.88290536717412E-01  -4.88290536706656E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07559972374585E-08   0.00000000000000E+00  -1.07559972374585E-08
      1.35984064109709E-18  -1.03042228231747E-02  -5.03594105250607E-03   0.00000000000000E+00   4.07598142687978E-12
      2.12245537550189E-22  -1.67251542855506E-08  -1.67210783041235E-08  -1.09019907774448E-18
      1.52274148977539E-09
      0.00000000000000E+00  -2.82005591806223E-11   0.00000000000000E+00   1.81911263301689E-12   7.91065784033169E-23
      2.81987663766877E-08   2.82005854893208E-08  -2.18264185237606E-19  -5.11215960129595E-01  -5.11215960118132E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14623512703772E-08   0.00000000000000E+00  -1.14623512703772E-08
      1.13059361568955E-18  -9.91464622237930E-03  -4.64095521872941E-03   0.00000000000000E+00   3.16768378959688E-12
      1.11017634093499E-22  -1.67414019027334E-08  -1.67382342189437E-08  -9.12329430451944E-19
      1.52774148977539E-09
      0.00000000000000E+00  -2.85496610267481E-11   0.00000000000000E+00   3.46585073238417E-12   6.34305844461631E-23
      2.85461711764570E-08   2.85496370271894E-08  -2.05446987650017E-19  -5.17015905483705E-01  -5.17015905471905E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18006289557678E-08   0.00000000000000E+00  -1.18006289557678E-08
      1.07159047091071E-18  -9.85546493469261E-03  -4.57837843199775E-03   0.00000000000000E+00   2.95787885442415E-12
      8.64698845277372E-23  -1.67519659502760E-08  -1.67490080714215E-08  -8.66143483260693E-19
      1.53449148977539E-09
      0.00000000000000E+00  -2.90638078656358E-11   0.00000000000000E+00   3.79441954532117E-12   4.68127775231578E-23
      2.90600169038096E-08   2.90638113233550E-08  -1.87899203654203E-19  -5.24987346806500E-01  -5.24987346794419E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20809561163214E-08   0.00000000000000E+00  -1.20809561163214E-08
      9.90044017125540E-19  -9.87334487118306E-03  -4.52257871885922E-03   0.00000000000000E+00   1.34194636272319E-12
      6.07549810620072E-23  -1.69841971533963E-08  -1.69828552070335E-08  -8.02144813471337E-19
      1.53904773977540E-09
      0.00000000000000E+00  -2.94236555460149E-11   0.00000000000000E+00   3.93341872341478E-12   3.74316480709325E-23
      2.94197003026569E-08   2.94236337213803E-08  -1.76063519536244E-19  -5.30395484953739E-01  -5.30395484941501E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.22383664996972E-08   0.00000000000000E+00  -1.22383664996972E-08
      9.34282959761294E-19  -9.90839707357181E-03  -4.49385621924246E-03   0.00000000000000E+00   7.98138566478243E-13
      4.62195011939199E-23  -1.71860653602496E-08  -1.71852672216831E-08  -7.58219440225050E-19
      1.54519867727539E-09
      0.00000000000000E+00  -2.96989142234259E-11   0.00000000000000E+00   2.25624305231380E-12   2.78196772310585E-23
      2.96966941079636E-08   2.96989503510160E-08  -1.60260484819888E-19  -5.37644802014257E-01  -5.37644802001982E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.22748515380042E-08   0.00000000000000E+00  -1.22748515380042E-08
      8.58781115129252E-19  -9.92590604201906E-03  -4.43611593049548E-03   0.00000000000000E+00   9.93116942173632E-13
      3.14795854858013E-23  -1.74250919299540E-08  -1.74240988130118E-08  -6.98520630309363E-19
      1.55350244290040E-09
      0.00000000000000E+00  -2.95728113992399E-11   0.00000000000000E+00  -7.05830342797640E-13   1.89800612843742E-23
      2.95734780608818E-08   2.95727722305390E-08  -1.39890297857263E-19  -5.47042321945737E-01  -5.47042321933768E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19696001539698E-08   0.00000000000000E+00  -1.19696001539698E-08
      7.59388360825723E-19  -9.85715132596196E-03  -4.31093996027439E-03   0.00000000000000E+00   1.66581985304063E-12
      1.81772692675419E-23  -1.76048378964224E-08  -1.76031720765693E-08  -6.19498062968460E-19
      1.56471252649415E-09
      0.00000000000000E+00  -2.83626651417935E-11   0.00000000000000E+00  -5.29297596478670E-12   1.19038121249932E-23
      2.83679349268435E-08   2.83626419508787E-08  -1.16027036129583E-19  -5.58121413117853E-01  -5.58121413107168E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06859234608112E-08   0.00000000000000E+00  -1.06859234608112E-08
      6.39598265553615E-19  -9.63233269821207E-03  -4.06294780671450E-03   0.00000000000000E+00   2.00327941195822E-12
      7.98892002709738E-24  -1.76787217694796E-08  -1.76767184900676E-08  -5.23571229424032E-19
      1.57984613934571E-09
      0.00000000000000E+00  -2.37206484338507E-11   0.00000000000000E+00  -1.51131596861262E-11   6.82061542944642E-24
      2.37357321273231E-08   2.37206189676370E-08  -9.85037239995866E-20  -5.66145383814134E-01  -5.66145383808092E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.04245726905046E-09   0.00000000000000E+00  -6.04245726905046E-09
      5.48154056571696E-19  -9.09407836285918E-03  -3.52423682377535E-03   0.00000000000000E+00   1.26477303727674E-12
      1.63369679276444E-24  -1.76794264716237E-08  -1.76781616985864E-08  -4.49650332572109E-19
      1.59984613934571E-09
      0.00000000000000E+00  -1.00061167398112E-11   0.00000000000000E+00  -3.37916818280311E-11   2.35997613981731E-24
      1.00399233147379E-08   1.00061316329098E-08  -1.29818944315344E-19  -5.50683224785669E-01  -5.50683224793338E-01
      0.00000000000000E+00   0.00000000000000E+00   7.66911546091222E-09   0.00000000000000E+00   7.66911546091222E-09
      7.01536365789940E-19  -7.85588069391305E-03  -2.28696297135375E-03   0.00000000000000E+00  -1.59505128443069E-12
     -2.19293254242166E-24  -1.76736520425377E-08  -1.76752470938221E-08  -5.71717421474597E-19
      1.61984613934571E-09
      0.00000000000000E+00   8.08885785060409E-12   0.00000000000000E+00  -4.46285781138596E-11  -3.78503590545137E-24
     -8.04420471272174E-09  -8.08883329083560E-09  -2.44259576791905E-19  -4.98338138427265E-01  -4.98338138453022E-01
      0.00000000000000E+00   0.00000000000000E+00   2.57561384674048E-08   0.00000000000000E+00   2.57561384674048E-08
      1.21665913513804E-18  -6.21224598196404E-03  -6.45824098449719E-04   0.00000000000000E+00  -6.38721969235106E-12
     -8.26486360420828E-24  -1.76609179568769E-08  -1.76673051765692E-08  -9.72399558346131E-19
      1.63984613934571E-09
      0.00000000000000E+00   1.97616810365203E-11   0.00000000000000E+00  -2.89948920806686E-11  -2.08573042575787E-23
     -1.97326961870990E-08  -1.97616910791797E-08  -4.57741704212477E-19  -4.09923253282927E-01  -4.09923253320304E-01
      0.00000000000000E+00   0.00000000000000E+00   3.73767204882779E-08   0.00000000000000E+00   3.73767204882779E-08
      1.96419354490359E-18  -4.62008273479101E-03   9.29862303490733E-04   0.00000000000000E+00  -1.50703336220577E-11
     -3.64944604897053E-23  -1.75999590754761E-08  -1.76150294090982E-08  -1.50645184069112E-18
      1.65984613934571E-09
      0.00000000000000E+00   1.78829050922031E-11   0.00000000000000E+00   4.17014449680728E-12  -4.00833032389134E-23
     -1.78870629359982E-08  -1.78828927915014E-08  -7.44415678951720E-19  -2.93757509639169E-01  -2.93757509674447E-01
      0.00000000000000E+00   0.00000000000000E+00   3.52783166409489E-08   0.00000000000000E+00   3.52783166409489E-08
      2.66975987772257E-18  -4.30466275146744E-03   1.17607756934142E-03   0.00000000000000E+00  -3.55285484030257E-11
     -7.39782315973571E-23  -1.73598953010443E-08  -1.73954238494474E-08  -1.92534419877085E-18
      1.67984613934571E-09
      0.00000000000000E+00   1.22435463829238E-11   0.00000000000000E+00   1.32261032833347E-11  -4.40583643519245E-23
     -1.22567651719077E-08  -1.22435390686244E-08  -9.86296960266291E-19  -1.80297393860358E-01  -1.80297393887298E-01
      0.00000000000000E+00   0.00000000000000E+00   2.69393593123611E-08   0.00000000000000E+00   2.69393593123611E-08
      3.20854706396979E-18  -2.24334289833922E-02  -1.78032578247989E-02   0.00000000000000E+00  -7.18625892743548E-11
     -8.64016945776965E-23  -1.46239576544622E-08  -1.46958202437366E-08  -2.22225010370350E-18
      1.69984613934571E-09
      0.00000000000000E+00   8.47010535475253E-12   0.00000000000000E+00   8.48388780145614E-12  -4.65947532859703E-23
     -8.47854046336298E-09  -8.47005657556157E-09  -1.15438889325535E-18  -8.93502131580151E-02  -8.93502131781529E-02
      0.00000000000000E+00   0.00000000000000E+00   2.01379215358694E-08   0.00000000000000E+00   2.01379215358694E-08
      3.61130549468718E-18  -5.89897554508186E-02  -5.53135936021092E-02   0.00000000000000E+00  -1.30931452967384E-10
     -9.95528042905342E-23  -1.15369335073405E-08  -1.16678649603079E-08  -2.45691660143183E-18
      1.70984613934571E-09
      0.00000000000000E+00   5.75563414658408E-12   0.00000000000000E+00   1.25818171133845E-11  -4.74076518898942E-23
     -5.76820265120526E-09  -5.75562083409192E-09  -1.21124380103719E-18  -5.59799325483809E-02  -5.59799325637039E-02
      0.00000000000000E+00   0.00000000000000E+00   1.53230771084708E-08   0.00000000000000E+00   1.53230771084708E-08
      3.76453626577189E-18  -8.32118241074802E-02  -8.01974107490194E-02   0.00000000000000E+00  -1.72486665903808E-10
     -1.05995304278977E-22  -9.39496960847504E-09  -9.56745627437896E-09  -2.55329246473470E-18
      1.71659613934571E-09
      0.00000000000000E+00   3.76196043602030E-12   0.00000000000000E+00   1.39802704711160E-11  -4.77189618438625E-23
     -3.77592655763889E-09  -3.76194628716782E-09  -1.23614895338362E-18  -4.08017660592807E-02  -4.08017660711571E-02
      0.00000000000000E+00   0.00000000000000E+00   1.18764249065545E-08   0.00000000000000E+00   1.18764249065545E-08
      3.84470213389113E-18  -1.02103215865004E-01  -9.95465824600617E-02   0.00000000000000E+00  -1.81559096582398E-10
     -1.10051921677778E-22  -7.93291952280395E-09  -8.11447861938646E-09  -2.60855318050751E-18
      1.72115238934571E-09
      0.00000000000000E+00   2.58001051289663E-12   0.00000000000000E+00   1.23992698159622E-11  -4.78445889982138E-23
     -2.59244785476637E-09  -2.58004858495045E-09  -1.24757294342028E-18  -3.36511140770004E-02  -3.36511140868034E-02
      0.00000000000000E+00   0.00000000000000E+00   9.80304261471261E-09   0.00000000000000E+00   9.80304261471261E-09
      3.88936724680442E-18  -1.15770385259543E-01  -1.13494626847561E-01   0.00000000000000E+00  -1.83826311856372E-10
     -1.12637107762487E-22  -7.03916771790542E-09  -7.22299402976190E-09  -2.64179430338414E-18
      1.72730332684571E-09
      0.00000000000000E+00   1.59019978001112E-12   0.00000000000000E+00   7.72353378749596E-12  -4.79418299105389E-23
     -1.59790041195994E-09  -1.59017687817249E-09  -1.25690812557932E-18  -2.75737653077322E-02  -2.75737653157376E-02
      0.00000000000000E+00   0.00000000000000E+00   8.00542844382048E-09   0.00000000000000E+00   8.00542844382048E-09
      3.93860813682308E-18  -1.35050761512696E-01  -1.33029497571521E-01   0.00000000000000E+00  -1.83900288780409E-10
     -1.15905119718889E-22  -6.23135127686747E-09  -6.41525156564799E-09  -2.68170001124376E-18
      1.73560709247071E-09
      0.00000000000000E+00   9.06874935187119E-13   0.00000000000000E+00   3.94665851658216E-12  -4.80106843672731E-23
     -9.10835329936424E-10  -9.06888671419890E-10  -1.26384489392898E-18  -2.27503961417133E-02  -2.27503961483406E-02
      0.00000000000000E+00   0.00000000000000E+00   6.62723773492518E-09   0.00000000000000E+00   6.62723773492518E-09
      3.99363916571505E-18  -1.61335470198642E-01  -1.59533148075621E-01   0.00000000000000E+00  -1.87945485846242E-10
     -1.20091676310454E-22  -5.53240357765888E-09  -5.72034906350525E-09  -2.72979427178608E-18
      1.74681717606446E-09
      0.00000000000000E+00   5.04686830955360E-13   0.00000000000000E+00   1.71617886690830E-12  -4.80561850056635E-23
     -5.06365311964682E-10  -5.04649133097822E-10  -1.26871915413880E-18  -1.89867957604245E-02  -1.89867957660115E-02
      0.00000000000000E+00   0.00000000000000E+00   5.58699344065415E-09   0.00000000000000E+00   5.58699344065415E-09
      4.05626982922252E-18  -1.95733425547195E-01  -1.94132118009750E-01   0.00000000000000E+00  -1.95512493404455E-10
     -1.25487576920707E-22  -4.88683181415179E-09  -5.08234430755637E-09  -2.78755067508372E-18
      1.76195078891602E-09
      0.00000000000000E+00   2.93535780115255E-13   0.00000000000000E+00   6.65571187792435E-13  -4.80840522821304E-23
     -2.94166583307177E-10  -2.93501012119432E-10  -1.27213637269838E-18  -1.59716553501415E-02  -1.59716553547736E-02
      0.00000000000000E+00   0.00000000000000E+00   4.63209610097207E-09   0.00000000000000E+00   4.63209610097207E-09
      4.12637017830586E-18  -2.37789338337911E-01  -2.36422362119109E-01   0.00000000000000E+00  -1.99303136519980E-10
     -1.32209926443842E-22  -4.13929195233251E-09  -4.33859508885262E-09  -2.85423380560748E-18
      1.78195078891602E-09
      0.00000000000000E+00   1.97006961310145E-13   0.00000000000000E+00   2.29572441925071E-13  -4.81009104136722E-23
     -1.97285538400644E-10  -1.97055965958767E-10  -1.27476712078722E-18  -1.34905752367100E-02  -1.34905752402174E-02
      0.00000000000000E+00   0.00000000000000E+00   3.50738703599651E-09   0.00000000000000E+00   3.50738703599651E-09
      4.19651791902579E-18  -2.81624375577490E-01  -2.80581374528779E-01   0.00000000000000E+00  -1.80968547147838E-10
     -1.39482787431662E-22  -3.12936252288983E-09  -3.31033107003781E-09  -2.92175079823857E-18
      1.80195078891602E-09
      0.00000000000000E+00   1.58340326945776E-13   0.00000000000000E+00   9.27354632889492E-14  -4.81090865116732E-23
     -1.58439967936135E-10  -1.58347232472894E-10  -1.27665406967874E-18  -1.18358434521867E-02  -1.18358434546520E-02
      0.00000000000000E+00   0.00000000000000E+00   2.46528073200916E-09   0.00000000000000E+00   2.46528073200916E-09
      4.24582353366598E-18  -3.12296483848088E-01  -3.11569625826260E-01   0.00000000000000E+00  -1.42178055104744E-10
     -1.44746987733185E-22  -2.16475544443135E-09  -2.30693349953624E-09  -2.96916946398724E-18
      1.82195078891602E-09
      0.00000000000000E+00   1.38869242657780E-13   0.00000000000000E+00   4.78596677751737E-14  -4.81123758777794E-23
     -1.38954242492442E-10  -1.38906382824715E-10  -1.27817264137970E-18  -1.07073239683961E-02  -1.07073239700392E-02
      0.00000000000000E+00   0.00000000000000E+00   1.64305723249342E-09   0.00000000000000E+00   1.64305723249342E-09
      4.27868467831584E-18  -3.31698381430124E-01  -3.31224462680285E-01   0.00000000000000E+00  -9.58585783565301E-11
     -1.48121511713775E-22  -1.40829227131200E-09  -1.50415084966868E-09  -3.00051203693615E-18
      1.84195078891602E-09
      0.00000000000000E+00   1.31337974206763E-13   0.00000000000000E+00   1.92829669958601E-14  -4.81142853060561E-23
     -1.31383695947971E-10  -1.31364412981023E-10  -1.27955312916793E-18  -9.90347015586820E-03  -9.90347015686585E-03
      0.00000000000000E+00   0.00000000000000E+00   9.97645968925400E-10   0.00000000000000E+00   9.97645968925400E-10
      4.29863759769435E-18  -3.41733142596854E-01  -3.41460205360274E-01   0.00000000000000E+00  -4.98578319399482E-11
     -1.49836504509739E-22  -8.16423724004293E-10  -8.66281555944391E-10  -3.01908446852643E-18
      1.86195078891602E-09
      0.00000000000000E+00   1.04519310942165E-13   0.00000000000000E+00   7.08983230802665E-14  -4.81058910214236E-23
     -1.04594839472566E-10  -1.04523941149534E-10  -1.28040763955396E-18  -9.49812387948807E-03  -9.49812388021423E-03
      0.00000000000000E+00   0.00000000000000E+00   7.26157989162178E-10   0.00000000000000E+00   7.26157989162178E-10
      4.31316075747759E-18  -3.48518345614822E-01  -3.48322492717514E-01   0.00000000000000E+00  -3.19669744145056E-11
     -1.50915065551559E-22  -5.89667073598023E-10  -6.21634048012679E-10  -3.03275311792364E-18
      1.88195078891602E-09
      0.00000000000000E+00   8.04559897937934E-14   0.00000000000000E+00   6.78859626092252E-14  -4.80896831176271E-23
     -8.05304542676819E-11  -8.04625683051208E-11  -1.28079366630094E-18  -9.32297175041815E-03  -9.32297175120611E-03
      0.00000000000000E+00   0.00000000000000E+00   7.87960060271275E-10   0.00000000000000E+00   7.87960060271275E-10
      4.32891995868302E-18  -3.57014751530400E-01  -3.56791843842754E-01   0.00000000000000E+00  -4.11854191091609E-11
     -1.52265715527460E-22  -6.66312072856848E-10  -7.07497491966162E-10  -3.04812629238208E-18
      1.89195078891602E-09
      0.00000000000000E+00   5.25351896827053E-14   0.00000000000000E+00   1.50321711056290E-13  -4.80757586658232E-23
     -5.27098539190593E-11  -5.25595322080511E-11  -1.28071180860417E-18  -9.34906754670461E-03  -9.34906754769642E-03
      0.00000000000000E+00   0.00000000000000E+00   9.91805810349950E-10   0.00000000000000E+00   9.91805810349950E-10
      4.33883801678652E-18  -3.63275043426375E-01  -3.62979114028786E-01   0.00000000000000E+00  -6.36724331049576E-11
     -1.53287680578989E-22  -8.75573845036668E-10  -9.39246278141779E-10  -3.05812620818236E-18
      1.89532578891602E-09
      0.00000000000000E+00   2.78289553738806E-14   0.00000000000000E+00   3.75676429130295E-13  -4.80685954877184E-23
     -2.81782033824057E-11  -2.78025269533235E-11  -1.28060118806297E-18  -9.39629883469497E-03  -9.39629883582601E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13104475104934E-09   0.00000000000000E+00   1.13104475104934E-09
      4.34265529282131E-18  -3.65894658255143E-01  -3.65547054868899E-01   0.00000000000000E+00  -8.05692979889261E-11
     -1.53718737717481E-22  -1.02267292610757E-09  -1.10324222409665E-09  -3.06205410475834E-18
      1.89988203891602E-09
      0.00000000000000E+00   1.43277790043742E-14   0.00000000000000E+00   1.68103495677932E-13  -4.80592220360464E-23
     -1.44595184192573E-11  -1.42914149236274E-11  -1.28039149125208E-18  -9.47128549392341E-03  -9.47128549528751E-03
      0.00000000000000E+00   0.00000000000000E+00   1.36409775194941E-09   0.00000000000000E+00   1.36409775194941E-09
      4.34887046320363E-18  -3.70343865590947E-01  -3.69918572555808E-01   0.00000000000000E+00  -1.04202292462866E-10
     -1.54468038869143E-22  -1.24560404456278E-09  -1.34980633702580E-09  -3.06847897195155E-18
      1.90603297641602E-09
      0.00000000000000E+00   2.09406000833161E-14   0.00000000000000E+00  -3.36846204711206E-14  -4.80489136157981E-23
     -2.09394901185013E-11  -2.09731747390205E-11  -1.28015190086914E-18  -9.51610484875307E-03  -9.51610485034869E-03
      0.00000000000000E+00   0.00000000000000E+00   1.59561682030197E-09   0.00000000000000E+00   1.59561682030197E-09
      4.35868500253926E-18  -3.77370725024189E-01  -3.76874588559191E-01   0.00000000000000E+00  -1.26090221761098E-10
     -1.55685163325440E-22  -1.44855342380163E-09  -1.57464364556288E-09  -3.07853310167012E-18
      1.91433674204102E-09
      0.00000000000000E+00   3.62786711969731E-14   0.00000000000000E+00  -7.56805847219049E-14  -4.80378060195614E-23
     -3.62391605336759E-11  -3.63148411184458E-11  -1.27996035787180E-18  -9.47331977066796E-03  -9.47331977241400E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74603798292526E-09   0.00000000000000E+00   1.74603798292526E-09
      4.37318369272182E-18  -3.87629566331082E-01  -3.87090867952866E-01   0.00000000000000E+00  -1.41535958733850E-10
     -1.57508476413950E-22  -1.56818718307298E-09  -1.70972314180699E-09  -3.09322333485002E-18
      1.92554682563477E-09
      0.00000000000000E+00   5.40047054780257E-14   0.00000000000000E+00  -6.63595530284438E-14  -4.80264715003222E-23
     -5.39593441785465E-11  -5.40257037316230E-11  -1.27990834098418E-18  -9.28273756656270E-03  -9.28273756835840E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79570299760216E-09   0.00000000000000E+00   1.79570299760216E-09
      4.39331367343449E-18  -4.01661090491871E-01  -4.01112323456281E-01   0.00000000000000E+00  -1.49786654048581E-10
     -1.60067563061857E-22  -1.59189063982168E-09  -1.74167729387042E-09  -3.11340533245031E-18
      1.94068043848633E-09
      0.00000000000000E+00   8.15581266402838E-14   0.00000000000000E+00  -8.35117860206746E-14  -4.80192782914416E-23
     -8.15022250617264E-11  -8.15857368477951E-11  -1.28026862785776E-18  -8.77714831361518E-03  -8.77714831539993E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78475444330899E-09   0.00000000000000E+00   1.78475444330899E-09
      4.42032345621463E-18  -4.20000109928058E-01  -4.19463475880100E-01   0.00000000000000E+00  -1.53700723762886E-10
     -1.63529744819426E-22  -1.54946798269825E-09  -1.70316870646130E-09  -3.14005482835687E-18
      1.96068043848633E-09
      0.00000000000000E+00   1.30052147885858E-13   0.00000000000000E+00  -1.22199667665736E-13  -4.80282527073633E-23
     -1.29926214777966E-10  -1.30048414445680E-10  -1.28173368925700E-18  -7.54398644996490E-03  -7.54398645173200E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76710028852765E-09   0.00000000000000E+00   1.76710028852765E-09
      4.45566546198518E-18  -4.42826967387638E-01  -4.42311165000455E-01   0.00000000000000E+00  -1.57157693214444E-10
     -1.68073268808110E-22  -1.47989418086736E-09  -1.63705187408197E-09  -3.17393177272819E-18
      1.98068043848633E-09
      0.00000000000000E+00   1.68902471724642E-13   0.00000000000000E+00  -1.05688254903789E-13  -4.80507124690804E-23
     -1.68710682661053E-10  -1.68816370916005E-10  -1.28399034380106E-18  -5.86694406603276E-03  -5.86694406776877E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73600736088880E-09   0.00000000000000E+00   1.73600736088880E-09
      4.49038560920296E-18  -4.64301703246101E-01  -4.63807911361401E-01   0.00000000000000E+00  -1.60889103153546E-10
     -1.72584420752611E-22  -1.40630188681901E-09  -1.56719098997272E-09  -3.20639526540190E-18
      2.00068043848633E-09
      0.00000000000000E+00   1.71657813840867E-13   0.00000000000000E+00  -1.83021871760380E-14  -4.80722852261352E-23
     -1.71691648040676E-10  -1.71709950227900E-10  -1.28631966562268E-18  -4.17513917282037E-03  -4.17513917448340E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66302632865294E-09   0.00000000000000E+00   1.66302632865294E-09
      4.52364613577602E-18  -4.84702731640731E-01  -4.84232845274222E-01   0.00000000000000E+00  -1.62802396126164E-10
     -1.77020565021469E-22  -1.32851398229874E-09  -1.49131637842508E-09  -3.23732647015333E-18
      2.02068043848633E-09
      0.00000000000000E+00   2.18314940342291E-13   0.00000000000000E+00  -1.34150407581631E-13  -4.81133912354376E-23
     -2.18196305475639E-10  -2.18330455883269E-10  -1.28959277391816E-18  -1.93512904728719E-03  -1.93512904895743E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67023970225716E-09   0.00000000000000E+00   1.67023970225716E-09
      4.55705092982116E-18  -5.04113349533266E-01  -5.03655877859912E-01   0.00000000000000E+00  -1.68888068076747E-10
     -1.81498454307126E-22  -1.28302117829704E-09  -1.45190924637397E-09  -3.26745815590300E-18
      2.04068043848633E-09
      0.00000000000000E+00  -9.43796519544545E-13   0.00000000000000E+00   3.03689280324831E-12  -4.76708306332870E-23
      9.40727375225316E-10   9.43764268028516E-10  -1.26970780853872E-18  -1.36625966318872E-02  -1.36625966316434E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.43768630640254E-10   0.00000000000000E+00  -2.43768630640254E-10
      4.55217555720836E-18  -5.24107035337630E-01  -5.23886493511292E-01   0.00000000000000E+00  -6.35102075378481E-11
     -1.83148090028966E-22  -6.36485429850130E-10  -6.99995637388162E-10  -3.28246774866963E-18
      2.06068043848633E-09
      0.00000000000000E+00  -2.78923282425538E-12   0.00000000000000E+00   4.98287526544522E-12  -4.65558461555061E-23
      2.78424740316483E-09   2.78923027843023E-09  -1.21336630769461E-18  -4.63426681025166E-02  -4.63426680993288E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.18786423074651E-09   0.00000000000000E+00  -3.18786423074651E-09
      4.48841827259342E-18  -5.45233144829938E-01  -5.45358790555974E-01   0.00000000000000E+00   1.01734053096168E-10
     -1.80455245768738E-22   2.96899899220290E-10   3.98633952316277E-10  -3.27505196489882E-18
      2.07068043848633E-09
      0.00000000000000E+00  -4.01802356335488E-12   0.00000000000000E+00   6.59295873690096E-12  -4.57793689943259E-23
      4.01147428522260E-09   4.01806724395945E-09  -1.17327480306687E-18  -6.88476277548955E-02  -6.88476277498410E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.05443173249451E-09   0.00000000000000E+00  -5.05443173249451E-09
      4.43787395526848E-18  -5.56058439487598E-01  -5.56385043153123E-01   0.00000000000000E+00   1.92903196463475E-10
     -1.77866417348436E-22   8.43461292071699E-10   1.03636448853500E-09  -3.26459915220162E-18
      2.07743043848633E-09
      0.00000000000000E+00  -4.92939889066517E-12   0.00000000000000E+00   7.22724932494768E-12  -4.51573507650423E-23
      4.92216129745654E-09   4.92938854678145E-09  -1.14042585925123E-18  -8.68110096131487E-02  -8.68110096067785E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.37020860403153E-09   0.00000000000000E+00  -6.37020860403153E-09
      4.39487504719127E-18  -5.63492317336544E-01  -5.63946367303559E-01   0.00000000000000E+00   2.47418168008964E-10
     -1.75592107700902E-22   1.19340188924130E-09   1.44082005725009E-09  -3.25444918794003E-18
      2.08198668848633E-09
      0.00000000000000E+00  -5.55183067472058E-12   0.00000000000000E+00   7.32015423901178E-12  -4.46976155953554E-23
      5.54451906012096E-09   5.55183921435993E-09  -1.11570461013734E-18  -1.00050003250547E-01  -1.00050003243331E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.21645048839702E-09   0.00000000000000E+00  -7.21645048839702E-09
      4.36199509465351E-18  -5.68541152349369E-01  -5.69065724019785E-01   0.00000000000000E+00   2.76396852679081E-10
     -1.73856239692336E-22   1.38821442135844E-09   1.66461127403734E-09  -3.24629048451616E-18
      2.08813762598633E-09
      0.00000000000000E+00  -6.18932499567802E-12   0.00000000000000E+00   5.70197262658155E-12  -4.40346432837332E-23
      6.18357629494209E-09   6.18927826756862E-09  -1.07931307361629E-18  -1.19094853693773E-01  -1.19094853685810E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.96351813556625E-09   0.00000000000000E+00  -7.96351813556625E-09
      4.31301199232152E-18  -5.75307052185457E-01  -5.75866182809241E-01   0.00000000000000E+00   2.96817933894783E-10
     -1.71304227770565E-22   1.47742193410315E-09   1.77423986799776E-09  -3.23369891870523E-18
      2.09644139161133E-09
      0.00000000000000E+00  -6.94796252501219E-12   0.00000000000000E+00   5.04468261661482E-12  -4.29491750555268E-23
      6.94294294550082E-09   6.94798762811739E-09  -1.02721199495305E-18  -1.45504056322321E-01  -1.45504056313806E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.51564867896505E-09   0.00000000000000E+00  -8.51564867896505E-09
      4.24230004154655E-18  -5.84087262851862E-01  -5.84581344182604E-01   0.00000000000000E+00   3.00707315811661E-10
     -1.67747680728622E-22   1.26695373503624E-09   1.56766105084774E-09  -3.21508804659351E-18
      2.10765147520508E-09
      0.00000000000000E+00  -8.42161133350696E-12   0.00000000000000E+00   6.93012542938095E-12  -3.98351630640982E-23
      8.41467574656393E-09   8.42160587199327E-09  -9.55033852701982E-19  -1.80582840108104E-01  -1.80582840099234E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.86950099634435E-09   0.00000000000000E+00  -8.86950099634435E-09
      4.14287219394269E-18  -5.94497295350086E-01  -5.94638683545674E-01   0.00000000000000E+00   2.90325156396079E-10
     -1.62994079597314E-22   1.57569967955134E-10   4.47895124351049E-10  -3.18783834124071E-18
      2.12278508805664E-09
      0.00000000000000E+00  -1.31064276889885E-11   0.00000000000000E+00   1.55904186560401E-11  -2.35117323745411E-23
      1.30908712542730E-08   1.31064616729290E-08  -8.60214046786330E-19  -2.24379801548365E-01  -2.24379801539191E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.17398755536860E-09   0.00000000000000E+00  -9.17398755536860E-09
      4.00403661797469E-18  -6.02208236335143E-01  -6.00969876075457E-01   0.00000000000000E+00   2.81527267744622E-10
     -1.56514690048374E-22  -4.21400138530480E-09  -3.93247411756034E-09  -3.14382257118836E-18
      2.14278508805664E-09
      0.00000000000000E+00  -2.74151029880235E-11   0.00000000000000E+00   3.55053358096875E-11   4.36816517298937E-23
      2.73795764269306E-08   2.74150817627404E-08  -7.53430544420767E-19  -2.71524869513983E-01  -2.71524869504274E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70837479448054E-09   0.00000000000000E+00  -9.70837479448054E-09
      3.80986912208508E-18  -5.87616140241090E-01  -5.82038827607970E-01   0.00000000000000E+00   3.02227627268275E-10
     -1.46472374755845E-22  -1.80089345955279E-08  -1.77067069682598E-08  -3.05643857766431E-18
      2.16278508805664E-09
      0.00000000000000E+00  -4.75831051419499E-11   0.00000000000000E+00   5.00128887106782E-11   1.39457887006418E-22
      4.75330918760537E-08   4.75831047647645E-08  -6.76218203773522E-19  -3.05415639354240E-01  -3.05415639343835E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04051938350350E-08   0.00000000000000E+00  -1.04051938350350E-08
      3.60176524538438E-18  -5.36852370016049E-01  -5.25140892097470E-01   0.00000000000000E+00   3.15974602442522E-10
     -1.33587410145055E-22  -3.74938855321719E-08  -3.71779109297295E-08  -2.92554704161085E-18
      2.18278508805664E-09
      0.00000000000000E+00  -6.28459554158339E-11   0.00000000000000E+00   3.79855738054711E-11   2.10775520909618E-22
      6.28079562811040E-08   6.28459418549097E-08  -6.28096009937673E-19  -3.27660115130396E-01  -3.27660115119372E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10245449920274E-08   0.00000000000000E+00  -1.10245449920274E-08
      3.38127434554383E-18  -4.50702618450551E-01  -4.34377194828266E-01   0.00000000000000E+00   2.90288721704954E-10
     -1.17696586451781E-22  -5.21116855845871E-08  -5.18213968628823E-08  -2.75317833560615E-18
      2.20278508805664E-09
      0.00000000000000E+00  -6.46929530810772E-11   0.00000000000000E+00   4.70219705184038E-12   2.20291345574326E-22
      6.46882588077464E-08   6.46929610047985E-08  -6.05510148561905E-19  -3.39999983412086E-01  -3.39999983400506E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15798980544920E-08   0.00000000000000E+00  -1.15798980544920E-08
      3.14967638445399E-18  -3.34712594353537E-01  -3.17979492380560E-01   0.00000000000000E+00   2.41838842424570E-10
     -1.01409533447371E-22  -5.33549017927309E-08  -5.31130629503064E-08  -2.54416623589208E-18
      2.22278508805664E-09
      0.00000000000000E+00  -5.62515032843335E-11   0.00000000000000E+00  -2.09035819122417E-11   1.81976879527484E-22
      5.62723470207176E-08   5.62514434388056E-08  -5.98088581257662E-19  -3.46537491020815E-01  -3.46537491008897E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19176515653287E-08   0.00000000000000E+00  -1.19176515653287E-08
      2.91132335314741E-18  -2.12321477029362E-01  -1.98353844088317E-01   0.00000000000000E+00   1.66846584640167E-10
     -8.49985157142502E-23  -4.45006384581168E-08  -4.43337918734767E-08  -2.31323477188975E-18
      2.24278508805664E-09
      0.00000000000000E+00  -4.90909201926858E-11   0.00000000000000E+00  -1.77659426278692E-11   1.42673799949605E-22
      4.91087150214998E-08   4.90909490788721E-08  -5.88859512772855E-19  -3.53834631364433E-01  -3.53834631352606E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18270755727682E-08   0.00000000000000E+00  -1.18270755727682E-08
      2.67478184169205E-18  -1.11875551042883E-01  -1.00135128034677E-01   0.00000000000000E+00   8.87444054559106E-11
     -7.28728719925961E-23  -3.73526179115597E-08  -3.72638735061039E-08  -2.08592232891919E-18
      2.25278508805664E-09
      0.00000000000000E+00  -4.46944044672987E-11   0.00000000000000E+00  -2.17625919548912E-11   1.25091903757966E-22
      4.47161552464767E-08   4.46943926545219E-08  -5.81606941903973E-19  -3.58385290414801E-01  -3.58385290403121E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16806360706933E-08   0.00000000000000E+00  -1.16806360706933E-08
      2.55797548098512E-18  -7.16118196943904E-02  -6.12103835562181E-02   0.00000000000000E+00   6.17819367451209E-11
     -5.09557510499215E-23  -3.30755385205735E-08  -3.30137565838285E-08  -1.97636853908114E-18
      2.25953508805664E-09
      0.00000000000000E+00  -4.10997851424706E-11   0.00000000000000E+00  -2.63232129141698E-11   1.18042237062356E-22
      4.11260793822375E-08   4.10997561693235E-08  -5.72365140724000E-19  -3.62912891755475E-01  -3.62912891744086E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13884850353177E-08   0.00000000000000E+00  -1.13884850353177E-08
      2.48110320699672E-18  -5.14427257399147E-02  -4.20817564171579E-02   0.00000000000000E+00   5.15672606915965E-11
     -1.68550977765514E-23  -2.97628383946978E-08  -2.97112711340062E-08  -1.90873806627272E-18
      2.26409133805664E-09
      0.00000000000000E+00  -3.85289591032947E-11   0.00000000000000E+00  -2.78840448601780E-11   1.16429353268021E-22
      3.85568674863024E-08   3.85289834414423E-08  -5.63443286305395E-19  -3.66860137497515E-01  -3.66860137486398E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11168939423351E-08   0.00000000000000E+00  -1.11168939423351E-08
      2.43045185897196E-18  -4.13585462432606E-02  -3.27219545462077E-02   0.00000000000000E+00   4.53820121674800E-11
      1.33018887102101E-23  -2.74574715112745E-08  -2.74120894991070E-08  -1.86700857266656E-18
      2.27024227555664E-09
      0.00000000000000E+00  -3.59380190666704E-11   0.00000000000000E+00  -2.08551412339152E-11   1.19465452007165E-22
      3.59589084816010E-08   3.59380533403672E-08  -5.47746889461466E-19  -3.73441751726723E-01  -3.73441751715936E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07874171018016E-08   0.00000000000000E+00  -1.07874171018016E-08
      2.36409913059234E-18  -3.25098258076676E-02  -2.45857250333311E-02   0.00000000000000E+00   3.34301594317586E-11
      5.21635641176704E-23  -2.51840663979975E-08  -2.51506362385657E-08  -1.81635224113088E-18
      2.27854604118164E-09
      0.00000000000000E+00  -3.37814127923004E-11   0.00000000000000E+00  -1.28397122606930E-11   1.28038217821430E-22
      3.37942796432161E-08   3.37814399309556E-08  -5.23238978138216E-19  -3.83459370149934E-01  -3.83459370139436E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04979516144978E-08   0.00000000000000E+00  -1.04979516144978E-08
      2.27692660084296E-18  -2.56227808181078E-02  -1.82869411158653E-02   0.00000000000000E+00   2.23671241096972E-11
      9.63867061582508E-23  -2.33058554405675E-08  -2.32834883164577E-08  -1.75368762270475E-18
      2.28975612477539E-09
      0.00000000000000E+00  -3.22233586703119E-11   0.00000000000000E+00  -6.84278552580744E-12   1.53351131980252E-22
      3.22302278680951E-08   3.22233850825694E-08  -4.88646503938672E-19  -3.97482861428944E-01  -3.97482861418656E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02881926472917E-08   0.00000000000000E+00  -1.02881926472917E-08
      2.16159510123822E-18  -2.06040699504335E-02  -1.36930211784090E-02   0.00000000000000E+00   1.44083124653520E-11
      1.21755576590999E-22  -2.19496007477430E-08  -2.19351924352775E-08  -1.67294859729955E-18
      2.30488973762696E-09
      0.00000000000000E+00  -3.10144982391865E-11   0.00000000000000E+00  -3.90704014610958E-12   1.48684832118057E-22
      3.10183626537318E-08   3.10144556135858E-08  -4.43173343277178E-19  -4.15985323188397E-01  -4.15985323178269E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01282029447548E-08   0.00000000000000E+00  -1.01282029447548E-08
      2.00831879899025E-18  -1.69185094153183E-02  -1.03379367094451E-02   0.00000000000000E+00   9.93169911270523E-12
      1.78227153494914E-22  -2.08961843679440E-08  -2.08862526688311E-08  -1.56514545571307E-18
      2.32488973762696E-09
      0.00000000000000E+00  -2.97350092051484E-11   0.00000000000000E+00  -3.11996773175011E-12   1.31285273067115E-22
      2.97380888547194E-08   2.97349688869878E-08  -3.87192688484552E-19  -4.39059398349333E-01  -4.39059398339371E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.96288062977363E-09   0.00000000000000E+00  -9.96288062977363E-09
      1.80906118639477E-18  -1.40889268408009E-02  -7.85938228328764E-03   0.00000000000000E+00   7.81539269010065E-12
      1.73230792699957E-22  -1.97799036499045E-08  -1.97720882572142E-08  -1.42186849791022E-18
      2.34488973762696E-09
      0.00000000000000E+00  -2.85035549686699E-11   0.00000000000000E+00  -3.00592477362396E-12   1.01795997002197E-22
      2.85065654511266E-08   2.85035595263531E-08  -3.35473916896198E-19  -4.60735415124416E-01  -4.60735415114602E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.81378665335456E-09   0.00000000000000E+00  -9.81378665335456E-09
      1.61278545332768E-18  -1.22403436107104E-02  -6.35179551683967E-03   0.00000000000000E+00   6.75402438716155E-12
      1.38592276077172E-22  -1.86965268973858E-08  -1.86897728729985E-08  -1.27731153643149E-18
      2.36488973762696E-09
      0.00000000000000E+00  -2.74970284936126E-11   0.00000000000000E+00  -2.45588039812055E-12   6.92793761785031E-23
      2.74994833555908E-08   2.74970274751928E-08  -2.87237274108554E-19  -4.81303560892416E-01  -4.81303560882732E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.68362573941556E-09   0.00000000000000E+00  -9.68362573941556E-09
      1.41911293853937E-18  -1.09926124417538E-02  -5.38017599585133E-03   0.00000000000000E+00   5.59812183074779E-12
      9.33258731186003E-23  -1.78189998576081E-08  -1.78134017357772E-08  -1.13187566443082E-18
      2.38488973762696E-09
      0.00000000000000E+00  -2.66512303086685E-11   0.00000000000000E+00  -2.06207973896304E-12   4.21074782037355E-23
      2.66532774795742E-08   2.66512153998353E-08  -2.42156535383216E-19  -5.00869104130215E-01  -5.00869104120683E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.53132220175621E-09   0.00000000000000E+00  -9.53132220175621E-09
      1.22848649450425E-18  -1.01078047083374E-02  -4.71386687513959E-03   0.00000000000000E+00   4.66823330371255E-12
      5.33285101278117E-23  -1.71245614313829E-08  -1.71198931980791E-08  -9.86329959121031E-19
      2.40488973762696E-09
      0.00000000000000E+00  -2.64755313263905E-11   0.00000000000000E+00  -4.09755143516840E-13   2.36779767353291E-23
      2.64759855561133E-08   2.64755758009698E-08  -1.97973892936240E-19  -5.20453626936487E-01  -5.20453626926670E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.81684646201466E-09   0.00000000000000E+00  -9.81684646201466E-09
      1.03214956526395E-18  -9.53702847024663E-03  -4.28838591580474E-03   0.00000000000000E+00   3.83455274305153E-12
      2.55630037011420E-23  -1.66625638916983E-08  -1.66587293389552E-08  -8.34175672327714E-19
      2.42488973762696E-09
      0.00000000000000E+00  -2.73866311194892E-11   0.00000000000000E+00   2.27141418583355E-12   1.33309140908654E-23
      2.73843538746409E-08   2.73866252888267E-08  -1.52007227867991E-19  -5.41364836002926E-01  -5.41364835992156E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07705961792689E-08   0.00000000000000E+00  -1.07705961792689E-08
      8.16737641678575E-19  -9.31803744461685E-03  -4.08284503142425E-03   0.00000000000000E+00   2.73738288566616E-12
      1.01107314019713E-23  -1.66187664924435E-08  -1.66160291095578E-08  -6.64730413810585E-19
      2.44488973762696E-09
      0.00000000000000E+00  -2.83540317364960E-11   0.00000000000000E+00   2.41612206691411E-12   8.20386672799590E-24
      2.83515807122269E-08   2.83539968342938E-08  -1.05818427698611E-19  -5.62943126958150E-01  -5.62943126946675E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14751025365414E-08   0.00000000000000E+00  -1.14751025365414E-08
      5.87235590947747E-19  -9.27184578385079E-03  -3.95383021110699E-03   0.00000000000000E+00   1.85793372114532E-12
      2.64255067481393E-24  -1.68807522314734E-08  -1.68788942977523E-08  -4.81417163249135E-19
      2.44738973762696E-09
      0.00000000000000E+00  -2.86328723586581E-11   0.00000000000000E+00   5.47916611095071E-12   7.61415453376588E-24
      2.86274342049912E-08   2.86329133711022E-08  -1.00111527135947E-19  -5.65659709210239E-01  -5.65659709198542E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16978731557186E-08   0.00000000000000E+00  -1.16978731557186E-08
      5.57990908058451E-19  -9.29289671282527E-03  -3.95719077908760E-03   0.00000000000000E+00   1.30870901382804E-12
      1.72188490113539E-24  -1.69363489243972E-08  -1.69350402153834E-08  -4.57879380922503E-19
      2.45076473762696E-09
      0.00000000000000E+00  -2.90154056891274E-11   0.00000000000000E+00   5.62582122675254E-12   6.98218219801985E-24
      2.90098111299924E-08   2.90154369512192E-08  -9.23411773388242E-20  -5.69373313722592E-01  -5.69373313710699E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18930893263976E-08   0.00000000000000E+00  -1.18930893263976E-08
      5.17851731581859E-19  -9.36536117219935E-03  -3.97063950442585E-03   0.00000000000000E+00  -3.10810246713774E-13
      7.54326077745550E-25  -1.71220368145743E-08  -1.71223476248211E-08  -4.25510554243034E-19
      2.45532098762696E-09
      0.00000000000000E+00  -2.93617521931370E-11   0.00000000000000E+00   3.80209789831054E-12   6.35428929998980E-24
      2.93579376259076E-08   2.93617397238060E-08  -8.18840653780224E-20  -5.74388173673317E-01  -5.74388173661318E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19990707271521E-08   0.00000000000000E+00  -1.19990707271521E-08
      4.63180965581272E-19  -9.44317420923989E-03  -3.97273421753866E-03   0.00000000000000E+00  -2.22949814687286E-13
     -1.56141859717896E-25  -1.73624460468392E-08  -1.73626689966539E-08  -3.81296900203249E-19
      2.46147192512696E-09
      0.00000000000000E+00  -2.94728843251581E-11   0.00000000000000E+00   9.40209351094960E-13   5.74571879674603E-24
      2.94719488371193E-08   2.94728890464704E-08  -6.80994314652722E-20  -5.81026931324971E-01  -5.81026931313063E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19084138521077E-08   0.00000000000000E+00  -1.19084138521077E-08
      3.89933056252823E-19  -9.47061397047792E-03  -3.93659070125720E-03   0.00000000000000E+00   6.80815018892686E-13
     -9.25984064077005E-25  -1.75651560093815E-08  -1.75644751943626E-08  -3.21833624787550E-19
      2.46977569075196E-09
      0.00000000000000E+00  -2.90515006708500E-11   0.00000000000000E+00  -2.46689575763335E-12   5.14234667213860E-24
      2.90539255664837E-08   2.90514586707261E-08  -5.06814556094802E-20  -5.89461349078658E-01  -5.89461349067283E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13752298823782E-08   0.00000000000000E+00  -1.13752298823782E-08
      2.95475813379057E-19  -9.40197237669050E-03  -3.83273834879617E-03   0.00000000000000E+00   1.46873136167716E-12
     -1.50770424721438E-24  -1.76776975197093E-08  -1.76762287883476E-08  -2.44794357769576E-19
      2.48098577434571E-09
      0.00000000000000E+00  -2.73017665823094E-11   0.00000000000000E+00  -7.67443840128148E-12   4.44817359444876E-24
      2.73094706300267E-08   2.73017961916255E-08  -3.13212854490317E-20  -5.98864777225396E-01  -5.98864777215797E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.59856003773665E-09   0.00000000000000E+00  -9.59856003773665E-09
      1.87875152976401E-19  -9.17821879591261E-03  -3.60047454469617E-03   0.00000000000000E+00   1.62253651690908E-12
     -1.91341500393241E-24  -1.77048586904057E-08  -1.77032361538888E-08  -1.56553867527369E-19
      2.49611938719727E-09
      0.00000000000000E+00  -2.14141515483581E-11   0.00000000000000E+00  -1.91763378138435E-11   3.30138407823382E-24
      2.14333052225860E-08   2.14141288847721E-08  -2.16136420556829E-20  -6.03336318193432E-01  -6.03336318189711E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.72125524614714E-09   0.00000000000000E+00  -3.72125524614714E-09
      1.31559116759365E-19  -8.60794835321478E-03  -3.03346747848479E-03   0.00000000000000E+00   7.03411035026632E-13
     -2.23961455367590E-24  -1.76935770496601E-08  -1.76928736386250E-08  -1.09945474703681E-19
      2.51611938719727E-09
      0.00000000000000E+00  -5.80513845993894E-12   0.00000000000000E+00  -3.84801756384013E-11   8.08232536352509E-25
      5.84357918258391E-09   5.80509900694551E-09  -6.56725902275565E-20  -5.80875393336541E-01  -5.80875393348426E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18844629797142E-08   0.00000000000000E+00   1.18844629797142E-08
      3.69248376353648E-19  -7.28413401956873E-03  -1.71069446865100E-03   0.00000000000000E+00  -2.10991865933859E-12
     -2.93497375264104E-24  -1.76874520680003E-08  -1.76895619866597E-08  -3.03575786126092E-19
      2.53611938719727E-09
      0.00000000000000E+00   1.29961221596022E-11   0.00000000000000E+00  -4.60403195325069E-11  -3.82726117881138E-24
     -1.29497374446627E-08  -1.29957777641953E-08  -1.90969535209225E-19  -5.21527131612815E-01  -5.21527131643480E-01
      0.00000000000000E+00   0.00000000000000E+00   3.06651204678328E-08   0.00000000000000E+00   3.06651204678328E-08
      9.82550785710304E-19  -5.58596273666949E-03  -1.90024116225459E-05   0.00000000000000E+00  -6.88288610614713E-12
     -6.41872362338017E-24  -1.76624598175315E-08  -1.76693427036376E-08  -7.91581250501080E-19
      2.55611938719727E-09
      0.00000000000000E+00   2.43135980572625E-11   0.00000000000000E+00  -2.81146500283039E-11  -1.80008273416877E-23
     -2.42854195027183E-08  -2.43135341527466E-08  -4.11987985954635E-19  -4.27917560752147E-01  -4.27917560794075E-01
      0.00000000000000E+00   0.00000000000000E+00   4.19285743725135E-08   0.00000000000000E+00   4.19285743725135E-08
      1.82112227316057E-18  -3.87433537912965E-03   1.67561028073553E-03   0.00000000000000E+00  -1.43620297729530E-11
     -2.90705351834959E-23  -1.76006781899938E-08  -1.76150402197668E-08  -1.40913428720594E-18
      2.57611938719727E-09
      0.00000000000000E+00   2.10319855968376E-11   0.00000000000000E+00   7.64566550995603E-12  -3.94339661053085E-23
     -2.10396534946816E-08  -2.10320078291717E-08  -7.13358005853113E-19  -3.06977943880825E-01  -3.06977943919500E-01
      0.00000000000000E+00   0.00000000000000E+00   3.86746777534667E-08   0.00000000000000E+00   3.86746777534667E-08
      2.59461582822991E-18  -1.63948508308123E-03   3.91915852749651E-03   0.00000000000000E+00  -3.35651685247142E-11
     -7.17066198577577E-23  -1.76091047557702E-08  -1.76426699242950E-08  -1.88125782237679E-18
      2.59611938719727E-09
      0.00000000000000E+00   1.31968947551379E-11   0.00000000000000E+00   1.86430985399205E-11  -4.39003833662763E-23
     -1.32155005350508E-08  -1.31968574365109E-08  -9.71200571427415E-19  -1.88111866575613E-01  -1.88111866604062E-01
      0.00000000000000E+00   0.00000000000000E+00   2.84485605954846E-08   0.00000000000000E+00   2.84485605954846E-08
      3.16358704013960E-18  -1.58850693452845E-02  -1.10797568881570E-02   0.00000000000000E+00  -6.78136190911288E-11
     -8.49899203632013E-23  -1.51838895398825E-08  -1.52517031589737E-08  -2.19238646871218E-18
      2.61611938719727E-09
      0.00000000000000E+00   8.85447557996603E-12   0.00000000000000E+00   9.88739162492077E-12  -4.64956312579217E-23
     -8.86438633603121E-09  -8.85449894440634E-09  -1.14694567096594E-18  -9.38215880642284E-02  -9.38215880850947E-02
      0.00000000000000E+00   0.00000000000000E+00   2.08662550856313E-08   0.00000000000000E+00   2.08662550856313E-08
      3.58091214185223E-18  -5.05497105380608E-02  -4.67652006580956E-02   0.00000000000000E+00  -1.23846730725984E-10
     -9.81538440291176E-23  -1.18879094104988E-08  -1.20117561412249E-08  -2.43396647088628E-18
      2.62611938719727E-09
      0.00000000000000E+00   6.07626412417555E-12   0.00000000000000E+00   1.28718441951868E-11  -4.73571710153132E-23
     -6.08911871632283E-09  -6.07624687212769E-09  -1.20700829263328E-18  -5.87361288792913E-02  -5.87361288952285E-02
      0.00000000000000E+00   0.00000000000000E+00   1.59371326307497E-08   0.00000000000000E+00   1.59371326307497E-08
      3.74028346815972E-18  -7.41446200651766E-02  -7.10377574043336E-02   0.00000000000000E+00  -1.66758053372948E-10
     -1.04622984569933E-22  -9.69412770524908E-09  -9.86088575862214E-09  -2.53327517552644E-18
      2.62949438719727E-09
      0.00000000000000E+00   4.81486850336738E-12   0.00000000000000E+00   1.76389231248050E-11  -4.75583996110412E-23
     -4.83248912480270E-09  -4.81485020167794E-09  -1.22301709699985E-18  -4.91141606109515E-02  -4.91141606246976E-02
      0.00000000000000E+00   0.00000000000000E+00   1.37460994439937E-08   0.00000000000000E+00   1.37460994439937E-08
      3.78667655378320E-18  -8.29805725608574E-02  -8.01665974824448E-02   0.00000000000000E+00  -1.79296881508475E-10
     -1.06755964393756E-22  -8.75195236080679E-09  -8.93124924231537E-09  -2.56365945678335E-18
      2.63405063719727E-09
      0.00000000000000E+00   3.45152522425886E-12   0.00000000000000E+00   1.42541278476506E-11  -4.77440463324256E-23
     -3.46577154818449E-09  -3.45151742033689E-09  -1.23841171371573E-18  -3.96561829693746E-02  -3.96561829807831E-02
      0.00000000000000E+00   0.00000000000000E+00   1.14085824237434E-08   0.00000000000000E+00   1.14085824237434E-08
      3.83865690745138E-18  -9.60649334364092E-02  -9.35578933430860E-02   0.00000000000000E+00  -1.78797547083154E-10
     -1.09445843511163E-22  -7.77826745632332E-09  -7.95706500340658E-09  -2.60024519373565E-18
      2.64020157469727E-09
      0.00000000000000E+00   2.18259833499967E-12   0.00000000000000E+00   9.86310083523686E-12  -4.78891883726893E-23
     -2.19243409860181E-09  -2.18257099776663E-09  -1.25138713826780E-18  -3.14232154062257E-02  -3.14232154153948E-02
      0.00000000000000E+00   0.00000000000000E+00   9.16904137362005E-09   0.00000000000000E+00   9.16904137362005E-09
      3.89505510787544E-18  -1.14992690238100E-01  -1.12791454746093E-01   0.00000000000000E+00  -1.77963586370160E-10
     -1.12814286900799E-22  -6.80850678948309E-09  -6.98647037585336E-09  -2.64366796960763E-18
      2.64850534032227E-09
      0.00000000000000E+00   1.22603539698327E-12   0.00000000000000E+00   5.51842518885061E-12  -4.79883842436367E-23
     -1.23149843779434E-09  -1.22598001260553E-09  -1.26096582101687E-18  -2.50043014993555E-02  -2.50043015067103E-02
      0.00000000000000E+00   0.00000000000000E+00   7.35476663108268E-09   0.00000000000000E+00   7.35476663108268E-09
      3.95612736620652E-18  -1.41387373712182E-01  -1.39456367615067E-01   0.00000000000000E+00  -1.80864681110556E-10
     -1.17080855195315E-22  -5.94792193736654E-09  -6.12878661847721E-09  -2.69516154518964E-18
      2.65971542391602E-09
      0.00000000000000E+00   6.44015297299178E-13   0.00000000000000E+00   2.48572522257737E-12  -4.80500150752816E-23
     -6.46503179246502E-10  -6.44017454023973E-10  -1.26739075264526E-18  -2.02688759594461E-02  -2.02688759654865E-02
      0.00000000000000E+00   0.00000000000000E+00   6.04041414231457E-09   0.00000000000000E+00   6.04041414231457E-09
      4.02384091368273E-18  -1.76607605744148E-01  -1.74907352185701E-01   0.00000000000000E+00  -1.88755256188076E-10
     -1.22566770044013E-22  -5.20764143210250E-09  -5.39639668829070E-09  -2.75645016103747E-18
      2.67484903676758E-09
      0.00000000000000E+00   3.43131938207320E-13   0.00000000000000E+00   9.50990955702740E-13  -4.80847125550521E-23
     -3.44035845174279E-10  -3.43084854218624E-10  -1.27154437438017E-18  -1.67321132539065E-02  -1.67321132588974E-02
      0.00000000000000E+00   0.00000000000000E+00   4.99091279105988E-09   0.00000000000000E+00   4.99091279105988E-09
      4.09937145563854E-18  -2.20818624348396E-01  -2.19354220213567E-01   0.00000000000000E+00  -1.97140937813128E-10
     -1.29522633352917E-22  -4.45068699902807E-09  -4.64782793684133E-09  -2.82782708125837E-18
      2.69484903676758E-09
      0.00000000000000E+00   2.09865224519199E-13   0.00000000000000E+00   3.18565213827095E-13  -4.81030211737537E-23
     -2.10207593029547E-10  -2.09889027815768E-10  -1.27441812577485E-18  -1.39774468276008E-02  -1.39774468314578E-02
      0.00000000000000E+00   0.00000000000000E+00   3.85702058534241E-09   0.00000000000000E+00   3.85702058534241E-09
      4.17651186734539E-18  -2.68807479254800E-01  -2.67658363075393E-01   0.00000000000000E+00  -1.88397255800410E-10
     -1.37358414100757E-22  -3.45873430172609E-09  -3.64713155752664E-09  -2.90209374157054E-18
      2.71484903676758E-09
      0.00000000000000E+00   1.62289650645700E-13   0.00000000000000E+00   1.14374308673101E-13  -4.81115521381456E-23
     -1.62380425138463E-10  -1.62266050829838E-10  -1.27637379433648E-18  -1.21669609805782E-02  -1.21669609833436E-02
      0.00000000000000E+00   0.00000000000000E+00   2.76539309555070E-09   0.00000000000000E+00   2.76539309555070E-09
      4.23181972925640E-18  -3.03539613348648E-01  -3.02719432271472E-01   0.00000000000000E+00  -1.55688339046872E-10
     -1.43254667986565E-22  -2.44743870567384E-09  -2.60312704472086E-09  -2.95544593491992E-18
      2.73484903676758E-09
      0.00000000000000E+00   1.39328466343818E-13   0.00000000000000E+00   5.65795327566326E-14  -4.81144734220709E-23
     -1.39395915951990E-10  -1.39339336419282E-10  -1.27789450521813E-18  -1.09425830415548E-02  -1.09425830434424E-02
      0.00000000000000E+00   0.00000000000000E+00   1.88760764063060E-09   0.00000000000000E+00   1.88760764063060E-09
      4.26957188206902E-18  -3.26490411294284E-01  -3.25939575997403E-01   0.00000000000000E+00  -1.11490909656713E-10
     -1.47230683561945E-22  -1.63677739455450E-09  -1.74826830421136E-09  -2.99167737685089E-18
      2.75484903676758E-09
      0.00000000000000E+00   1.30878750520726E-13   0.00000000000000E+00   2.16962111182310E-14  -4.81159574570262E-23
     -1.30938223790780E-10  -1.30916527579710E-10  -1.27926192996164E-18  -1.00712319893212E-02  -1.00712319905134E-02
      0.00000000000000E+00   0.00000000000000E+00   1.19223145192249E-09   0.00000000000000E+00   1.19223145192249E-09
      4.29341651110746E-18  -3.39445390461856E-01  -3.39111001364403E-01   0.00000000000000E+00  -6.47188953894455E-11
     -1.49465644360725E-22  -9.96596028953103E-10  -1.06131492434270E-09  -3.01415458114583E-18
      2.77484903676758E-09
      0.00000000000000E+00   1.17102039939597E-13   0.00000000000000E+00   3.67519670154428E-14  -4.81126838690424E-23
     -1.17155541407478E-10  -1.17118789440510E-10  -1.28036379760444E-18  -9.51986695922967E-03  -9.51986695997326E-03
      0.00000000000000E+00   0.00000000000000E+00   7.43587574377940E-10   0.00000000000000E+00   7.43587574377940E-10
      4.30828826259502E-18  -3.46090629150139E-01  -3.45893253108398E-01   0.00000000000000E+00  -3.15854604363540E-11
     -1.50542735124702E-22  -5.94883324500925E-10  -6.26468784937429E-10  -3.02792446499058E-18
      2.79484903676758E-09
      0.00000000000000E+00   8.67932766611128E-14   0.00000000000000E+00   8.22390256773975E-14  -4.80981059344464E-23
     -8.68841759315408E-11  -8.68019369059115E-11  -1.28087087756161E-18  -9.30969397089409E-03  -9.30969397160644E-03
      0.00000000000000E+00   0.00000000000000E+00   7.12350897795100E-10   0.00000000000000E+00   7.12350897795100E-10
      4.32253528055093E-18  -3.53228117600956E-01  -3.53031030870263E-01   0.00000000000000E+00  -3.35277554049368E-11
     -1.51653679531505E-22  -5.92021205484156E-10  -6.25548960889244E-10  -3.04166440298932E-18
      2.79984903676758E-09
      0.00000000000000E+00   8.50482266541698E-14   0.00000000000000E+00   2.60261577733731E-14  -4.80947018997779E-23
     -8.50371832798504E-11  -8.50111571221251E-11  -1.28098939084553E-18  -9.26470967189584E-03  -9.26470967256850E-03
      0.00000000000000E+00   0.00000000000000E+00   6.72664079046953E-10   0.00000000000000E+00   6.72664079046953E-10
      4.32589860094616E-18  -3.54862390139987E-01  -3.54677243924987E-01   0.00000000000000E+00  -3.03800420183734E-11
     -1.51903833841924E-22  -5.57272879906639E-10  -5.87652921925164E-10  -3.04490921010063E-18
      2.80659903676758E-09
      0.00000000000000E+00   5.81377186523644E-14   0.00000000000000E+00   2.07554160185127E-13  -4.80853631745404E-23
     -5.83067437048423E-11  -5.80991895447053E-11  -1.28096936673297E-18  -9.28645370672739E-03  -9.28645370755010E-03
      0.00000000000000E+00   0.00000000000000E+00   8.22706164719477E-10   0.00000000000000E+00   8.22706164719477E-10
      4.33145186755802E-18  -3.58166438166160E-01  -3.57925535282286E-01   0.00000000000000E+00  -4.78190875176634E-11
     -1.52424236220186E-22  -7.16787887656572E-10  -7.64606975174388E-10  -3.05048250082505E-18
      2.81571153676758E-09
      0.00000000000000E+00   3.44417764528225E-14   0.00000000000000E+00   1.44407021715618E-13  -4.80699437160396E-23
     -3.46133267209103E-11  -3.44689196992427E-11  -1.28073105413150E-18  -9.37228721046799E-03  -9.37228721162160E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15360627691949E-09   0.00000000000000E+00   1.15360627691949E-09
      4.34196410475645E-18  -3.65275381176890E-01  -3.64922769946591E-01   0.00000000000000E+00  -8.08095387693843E-11
     -1.53600085898212E-22  -1.03832781845099E-09  -1.11913735722053E-09  -3.06123305062495E-18
      2.81878700551758E-09
      0.00000000000000E+00   2.05732211344860E-14   0.00000000000000E+00   2.40028461071690E-13  -4.80636038256477E-23
     -2.07941167979372E-11  -2.05540883369136E-11  -1.28060834788465E-18  -9.41689621471150E-03  -9.41689621600198E-03
      0.00000000000000E+00   0.00000000000000E+00   1.29047980215167E-09   0.00000000000000E+00   1.29047980215167E-09
      4.34593293506047E-18  -3.68071741140074E-01  -3.67671617614363E-01   0.00000000000000E+00  -9.62181053903693E-11
     -1.54068302636828E-22  -1.17370760842324E-09  -1.26992571381376E-09  -3.06532458717582E-18
      2.82293888833008E-09
      0.00000000000000E+00   1.54299158508645E-14   0.00000000000000E+00   8.21633253169369E-14  -4.80556155159909E-23
     -1.55011888835382E-11  -1.54190255582693E-11  -1.28042242573157E-18  -9.47142345751482E-03  -9.47142345899498E-03
      0.00000000000000E+00   0.00000000000000E+00   1.48016849458784E-09   0.00000000000000E+00   1.48016849458784E-09
      4.35207842119275E-18  -3.72484419314542E-01  -3.72022909016905E-01   0.00000000000000E+00  -1.15089049170914E-10
     -1.54821039850034E-22  -1.34966041985819E-09  -1.46474946902926E-09  -3.07165599546119E-18
      2.82854393012695E-09
      0.00000000000000E+00   2.44307000972021E-14   0.00000000000000E+00  -6.03914676028066E-14  -4.80467833132056E-23
     -2.43566436486644E-11  -2.44170351163152E-11  -1.28022389645616E-18  -9.49315236541645E-03  -9.49315236707222E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65576567914081E-09   0.00000000000000E+00   1.65576567914081E-09
      4.36135905703017E-18  -3.79114344790771E-01  -3.78600341167313E-01   0.00000000000000E+00  -1.31826444640211E-10
     -1.55977820379817E-22  -1.49952219938404E-09  -1.63134864402441E-09  -3.08113516057401E-18
      2.83611073655274E-09
      0.00000000000000E+00   3.84829448899537E-14   0.00000000000000E+00  -7.71206553701917E-14  -4.80370028998775E-23
     -3.84429503107583E-11  -3.85200709661766E-11  -1.28006635302409E-18  -9.44061291430999E-03  -9.44061291607538E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76538626615703E-09   0.00000000000000E+00   1.76538626615703E-09
      4.37471739317291E-18  -3.88549649421667E-01  -3.88005549321702E-01   0.00000000000000E+00  -1.43606619960394E-10
     -1.57660326710908E-22  -1.58325957523030E-09  -1.72686619519085E-09  -3.09465104014882E-18
      2.84632592522754E-09
      0.00000000000000E+00   5.40965502152333E-14   0.00000000000000E+00  -6.35493238097081E-14  -4.80266778731259E-23
     -5.39941494452750E-11  -5.40576987691327E-11  -1.28001905995891E-18  -9.26548926654386E-03  -9.26548926834246E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79860722185811E-09   0.00000000000000E+00   1.79860722185811E-09
      4.39309050529606E-18  -4.01356337028177E-01  -4.00806664830065E-01   0.00000000000000E+00  -1.50156661670054E-10
     -1.59996748983870E-22  -1.59439286141884E-09  -1.74454952308905E-09  -3.11307144533715E-18
      2.86011642993853E-09
      0.00000000000000E+00   7.82517161008128E-14   0.00000000000000E+00  -7.94812810110603E-14  -4.80192419951255E-23
     -7.81268982039281E-11  -7.82063794849871E-11  -1.28029949821090E-18  -8.83140388171890E-03  -8.83140388350392E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78501416706732E-09   0.00000000000000E+00   1.78501416706732E-09
      4.41770675157618E-18  -4.18125530353772E-01  -4.17587749568647E-01   0.00000000000000E+00  -1.53498833430059E-10
     -1.63152181967161E-22  -1.55330895415214E-09  -1.70680778758236E-09  -3.13740725336528E-18
      2.87873361129836E-09
      0.00000000000000E+00   1.23071947858086E-13   0.00000000000000E+00  -1.20409606571207E-13  -4.80252889746856E-23
     -1.22991892265891E-10  -1.23112301872510E-10  -1.28153160400242E-18  -7.75779656452868E-03  -7.75779656629642E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76774093769999E-09   0.00000000000000E+00   1.76774093769999E-09
      4.45061710521054E-18  -4.39536096097853E-01  -4.39017906387753E-01   0.00000000000000E+00  -1.56616310972556E-10
     -1.67382130833604E-22  -1.48801232485466E-09  -1.64462863582738E-09  -3.16908550120812E-18
      2.89873361129836E-09
      0.00000000000000E+00   1.65596061185171E-13   0.00000000000000E+00  -1.14179764424881E-13  -4.80468326484516E-23
     -1.65456206812822E-10  -1.65570386577295E-10  -1.28372098511097E-18  -6.11548354971536E-03  -6.11548355145837E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74300515265210E-09   0.00000000000000E+00   1.74300515265210E-09
      4.48547720826358E-18  -4.61182148168546E-01  -4.60685128854249E-01   0.00000000000000E+00  -1.60356159700904E-10
     -1.71898155186302E-22  -1.41707860637376E-09  -1.57743476607483E-09  -3.20175622315261E-18
      2.91873361129836E-09
      0.00000000000000E+00   1.71474124366452E-13   0.00000000000000E+00  -2.56098282109681E-14  -4.80684953541771E-23
     -1.71421619821686E-10  -1.71447229649945E-10  -1.28604288423456E-18  -4.42313510870931E-03  -4.42313511038238E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67306363744664E-09   0.00000000000000E+00   1.67306363744664E-09
      4.51893848101251E-18  -4.81725479282060E-01  -4.81252347746612E-01   0.00000000000000E+00  -1.62428635858470E-10
     -1.76342698376786E-22  -1.33918777193796E-09  -1.50161640779661E-09  -3.23289559677796E-18
      2.93873361129836E-09
      0.00000000000000E+00   2.17672027181838E-13   0.00000000000000E+00  -1.33047839451247E-13  -4.81093255699061E-23
     -2.17529771573250E-10  -2.17662819412749E-10  -1.28930065551149E-18  -2.18812126269262E-03  -2.18812126437120E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67858225663413E-09   0.00000000000000E+00   1.67858225663413E-09
      4.55251012614520E-18  -5.01265198881376E-01  -5.00804888463459E-01   0.00000000000000E+00  -1.68446628202736E-10
     -1.80826938601198E-22  -1.29247280901851E-09  -1.46091943722142E-09  -3.26320947063370E-18
      2.95873361129836E-09
      0.00000000000000E+00  -5.18096162587658E-13   0.00000000000000E+00   1.91739156074269E-12  -4.78427511452597E-23
      5.16204640349949E-10   5.18122031910643E-10  -1.27789536802810E-18  -8.82926268516656E-03  -8.82926268560899E-03
      0.00000000000000E+00   0.00000000000000E+00   4.42425611859394E-10   0.00000000000000E+00   4.42425611859394E-10
      4.56135863838238E-18  -5.20866363288534E-01  -5.20563720159660E-01   0.00000000000000E+00  -1.02595445429958E-10
     -1.83498108346210E-22  -8.57952198339857E-10  -9.60547643769998E-10  -3.28346327035428E-18
      2.96873361129836E-09
      0.00000000000000E+00  -1.83101668096925E-12   0.00000000000000E+00   6.76969511498154E-12  -4.74194038465967E-23
      1.82428510689471E-09   1.83105480200965E-09  -1.25910862754368E-18  -1.99490408856371E-02  -1.99490408839633E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.67379808193754E-09   0.00000000000000E+00  -1.67379808193754E-09
      4.54462065756301E-18  -5.31174115486385E-01  -5.31124595154011E-01   0.00000000000000E+00   1.94851677411148E-11
     -1.83249146945086E-22  -1.76741887813215E-10  -1.57256720072283E-10  -3.28551203001933E-18
      2.97548361129836E-09
      0.00000000000000E+00  -2.61371753145180E-12   0.00000000000000E+00   6.14741815266481E-12  -4.70501183666270E-23
      2.60764762235219E-09   2.61379504050480E-09  -1.24118476910396E-18  -3.04286704005525E-02  -3.04286703976262E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.92636746875232E-09   0.00000000000000E+00  -2.92636746875232E-09
      4.52486767714893E-18  -5.38301335412322E-01  -5.38399861680729E-01   0.00000000000000E+00   8.96312312799608E-11
     -1.82460459930565E-22   2.22941196967908E-10   3.12572428247687E-10  -3.28368290804497E-18
      2.98003986129836E-09
      0.00000000000000E+00  -3.11574086502814E-12   0.00000000000000E+00   5.91282593335766E-12  -4.67638031191411E-23
      3.10984725806963E-09   3.11576008400295E-09  -1.22682862116368E-18  -3.87282594698265E-02  -3.87282594661105E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.71608003405871E-09   0.00000000000000E+00  -3.71608003405871E-09
      4.50793628749375E-18  -5.43171868798180E-01  -5.43361066151520E-01   0.00000000000000E+00   1.31510490126013E-10
     -1.81673652218786E-22   4.68809459929976E-10   6.00319950055808E-10  -3.28110766633007E-18
      2.98619079879836E-09
      0.00000000000000E+00  -3.68508639097760E-12   0.00000000000000E+00   5.09932911877293E-12  -4.63267191712180E-23
      3.67998163909585E-09   3.68508096821458E-09  -1.20403364917093E-18  -5.17242368834895E-02  -5.17242368788951E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.59440418694630E-09   0.00000000000000E+00  -4.59440418694630E-09
      4.47967639449010E-18  -5.49830479484492E-01  -5.50117046283774E-01   0.00000000000000E+00   1.75268609975043E-10
     -1.80243859386026E-22   7.34054608756604E-10   9.09323218731467E-10  -3.27564274531917E-18
      2.99449456442336E-09
      0.00000000000000E+00  -4.48532958626678E-12   0.00000000000000E+00   5.32848657365261E-12  -4.56306350341740E-23
      4.48002283310722E-09   4.48535131968083E-09  -1.16693629308118E-18  -7.24161654817128E-02  -7.24161654759348E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.77804878672176E-09   0.00000000000000E+00  -5.77804878672176E-09
      4.43169683159535E-18  -5.58949322326389E-01  -5.59356695255025E-01   0.00000000000000E+00   2.28628555100910E-10
     -1.77689982767199E-22   1.06406891194028E-09   1.29269746704101E-09  -3.26476053851417E-18
      3.00009960622023E-09
      0.00000000000000E+00  -5.18059424692775E-12   0.00000000000000E+00   6.69872503340934E-12  -4.50939965539808E-23
      5.17386876886105E-09   5.18056749389442E-09  -1.13828154487058E-18  -8.80300064678232E-02  -8.80300064610682E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.75499642949855E-09   0.00000000000000E+00  -6.75499642949855E-09
      4.39383479427027E-18  -5.65160841589078E-01  -5.65656992344055E-01   0.00000000000000E+00   2.65450567907246E-10
     -1.75660952850582E-22   1.30897836769660E-09   1.57442893560367E-09  -3.25555324939969E-18
      3.00388300943312E-09
      0.00000000000000E+00  -5.65892163830455E-12   0.00000000000000E+00   6.82768054821371E-12  -4.47066281458099E-23
      5.65205701731044E-09   5.65888469785861E-09  -1.11733386031907E-18  -9.92400637459741E-02  -9.92400637385820E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.39204339864783E-09   0.00000000000000E+00  -7.39204339864783E-09
      4.36586771352600E-18  -5.69364195494247E-01  -5.69910366047108E-01   0.00000000000000E+00   2.85335215310164E-10
     -1.74172949301177E-22   1.44782348547871E-09   1.73315870078870E-09  -3.24853385320694E-18
      3.00899060377053E-09
      0.00000000000000E+00  -6.16461876136920E-12   0.00000000000000E+00   5.48345317398128E-12  -4.41566881577321E-23
      6.15917575781519E-09   6.16465921098913E-09  -1.08705395957997E-18  -1.15133092857348E-01  -1.15133092849363E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.98545014627779E-09   0.00000000000000E+00  -7.98545014627779E-09
      4.32508127357726E-18  -5.75002760967896E-01  -5.75576555849075E-01   0.00000000000000E+00   3.00731056394729E-10
     -1.72030417873232E-22   1.52005987889427E-09   1.82079093528883E-09  -3.23802731399729E-18
      3.01588585612602E-09
      0.00000000000000E+00  -6.75802760846703E-12   0.00000000000000E+00   4.80028928221935E-12  -4.33160316148828E-23
      6.75321738034682E-09   6.75801766962900E-09  -1.04399940141270E-18  -1.37135794617834E-01  -1.37135794609369E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.46484934267860E-09   0.00000000000000E+00  -8.46484934267860E-09
      4.26671400120826E-18  -5.82405553272716E-01  -5.82943469419342E-01   0.00000000000000E+00   3.04684941026774E-10
     -1.69053137853359E-22   1.40214673202314E-09   1.70683167304975E-09  -3.22271459979556E-18
      3.02519444680594E-09
      0.00000000000000E+00  -7.74388901765262E-12   0.00000000000000E+00   5.70444987319279E-12  -4.14720110969071E-23
      7.73818585982822E-09   7.74389030970137E-09  -9.84112064308066E-19  -1.66671111982421E-01  -1.66671111973622E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.79941431410135E-09   0.00000000000000E+00  -8.79941431410135E-09
      4.18480385513530E-18  -5.91627397703382E-01  -5.91960175395248E-01   0.00000000000000E+00   2.96426439262068E-10
     -1.65060816621665E-22   7.59097565138172E-10   1.05552400440008E-09  -3.20069179082723E-18
      3.03776104422382E-09
      0.00000000000000E+00  -1.04008654203292E-11   0.00000000000000E+00   1.08026478458324E-11  -3.38198721168778E-23
      1.03900711904461E-08   1.04008738382919E-08  -9.03515107814493E-19  -2.04677506404250E-01  -2.04677506395195E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.05442685915141E-09   0.00000000000000E+00  -9.05442685915141E-09
      4.07102051794665E-18  -6.01036317592112E-01  -6.00612523993783E-01   0.00000000000000E+00   2.83590408333032E-10
     -1.59747527248385E-22  -1.63003738747336E-09  -1.34644697914049E-09  -3.16750541013215E-18
      3.05472595073797E-09
      0.00000000000000E+00  -1.90906633864821E-11   0.00000000000000E+00   2.55161526261465E-11   4.02841808839069E-24
      1.90651387963130E-08   1.90906549489391E-08  -8.03425539383986E-19  -2.49629892818204E-01  -2.49629892808779E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.42516919189924E-09   0.00000000000000E+00  -9.42516919189924E-09
      3.91112340372606E-18  -6.00831720438096E-01  -5.97787484537918E-01   0.00000000000000E+00   2.88032174316684E-10
     -1.52036140214539E-22  -9.95351793135638E-09  -9.66548575703985E-09  -3.10769786434207E-18
      3.07472595073797E-09
      0.00000000000000E+00  -3.75064516439633E-11   0.00000000000000E+00   4.56420195075625E-11   9.21066338723675E-23
      3.74607925203032E-08   3.75064345398108E-08  -7.10887487434620E-19  -2.90078211974309E-01  -2.90078211964247E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00621598069184E-08   0.00000000000000E+00  -1.00621598069184E-08
      3.70988020758770E-18  -5.68596898947775E-01  -5.59951994466990E-01   0.00000000000000E+00   3.14875820330979E-10
     -1.40699453414083E-22  -2.77591505532234E-08  -2.74442747328925E-08  -2.99899272015308E-18
      3.09472595073797E-09
      0.00000000000000E+00  -5.66141063068288E-11   0.00000000000000E+00   4.74576988617704E-11   1.82639351016443E-22
      5.65666464930607E-08   5.66141041919227E-08  -6.48721587569347E-19  -3.17854855277208E-01  -3.17854855266479E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07291571041100E-08   0.00000000000000E+00  -1.07291571041100E-08
      3.49529706550550E-18  -4.99457288245043E-01  -4.85002489663139E-01   0.00000000000000E+00   3.10051461696740E-10
     -1.26089536753396E-22  -4.61949985495093E-08  -4.58849470878127E-08  -2.84657547793615E-18
      3.11472595073797E-09
      0.00000000000000E+00  -6.59245910070302E-11   0.00000000000000E+00   2.32421945039598E-11   2.25818657779786E-22
      6.59013001984078E-08   6.59245423929119E-08  -6.13705382529238E-19  -3.34996076399643E-01  -3.34996076388338E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13049443966120E-08   0.00000000000000E+00  -1.13049443966120E-08
      3.26919817757326E-18  -3.97404119422685E-01  -3.80196746431377E-01   0.00000000000000E+00   2.68780362125501E-10
     -1.09662279875123E-22  -5.48883783584253E-08  -5.46195979962999E-08  -2.65549279504402E-18
      3.13472595073797E-09
      0.00000000000000E+00  -6.09393505161428E-11   0.00000000000000E+00  -1.22909206737427E-11   2.04603663910340E-22
      6.09516022159086E-08   6.09393112952351E-08  -6.01274067377346E-19  -3.43428713415610E-01  -3.43428713403801E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18097597228011E-08   0.00000000000000E+00  -1.18097597228011E-08
      3.03300298311724E-18  -2.72905824306861E-01  -2.57427466199577E-01   0.00000000000000E+00   2.10783876867360E-10
     -9.31398369839171E-23  -4.93403354493012E-08  -4.91295515724340E-08  -2.43172891573989E-18
      3.15472595073797E-09
      0.00000000000000E+00  -5.24709902113972E-11   0.00000000000000E+00  -2.09989724222897E-11   1.62270564759895E-22
      5.24919829058524E-08   5.24709839334303E-08  -5.94179052127361E-19  -3.49880211024057E-01  -3.49880211012149E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19083114228863E-08   0.00000000000000E+00  -1.19083114228863E-08
      2.79483675465951E-18  -1.59834329057220E-01  -1.47054680826477E-01   0.00000000000000E+00   1.24016759587485E-10
     -7.91989746274249E-23  -4.06866892701313E-08  -4.05626725105439E-08  -2.20065770253215E-18
      3.17472595073797E-09
      0.00000000000000E+00  -4.58499949508438E-11   0.00000000000000E+00  -1.64154398232110E-11   1.28518719577768E-22
      4.58664497387862E-08   4.58500342989631E-08  -5.80171978348250E-19  -3.58895857610072E-01  -3.58895857598396E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16752804937134E-08   0.00000000000000E+00  -1.16752804937134E-08
      2.56133114478524E-18  -7.45851745946543E-02  -6.38179560206592E-02   0.00000000000000E+00   6.51792810228085E-11
     -5.28137948559080E-23  -3.42399330862726E-08  -3.41747538052498E-08  -1.98115916643699E-18
      3.17722595073797E-09
      0.00000000000000E+00  -4.39072032246930E-11   0.00000000000000E+00  -3.80725433195409E-11   1.23696502811023E-22
      4.39452145186379E-08   4.39071419753185E-08  -5.78314148792409E-19  -3.60003291777540E-01  -3.60003291765867E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16732386041879E-08   0.00000000000000E+00  -1.16732386041879E-08
      2.53214804827477E-18  -6.49579944096559E-02  -5.48022553489413E-02   0.00000000000000E+00   7.19296855943075E-11
     -4.24127944878243E-23  -3.23058330567248E-08  -3.22339033711305E-08  -1.95383389948236E-18
      3.18060095073797E-09
      0.00000000000000E+00  -4.16873159263871E-11   0.00000000000000E+00  -3.26432043010049E-11   1.18810967372525E-22
      4.17199897184277E-08   4.16873465141268E-08  -5.74244280659207E-19  -3.62056364902094E-01  -3.62056364890607E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14875960212297E-08   0.00000000000000E+00  -1.14875960212297E-08
      2.49337741170312E-18  -5.42472654443858E-02  -4.47323984607688E-02   0.00000000000000E+00   5.76563642416486E-11
     -2.37126828496634E-23  -3.02574068571388E-08  -3.01997504928972E-08  -1.91913313104391E-18
      3.18515720073797E-09
      0.00000000000000E+00  -3.90753434449423E-11   0.00000000000000E+00  -2.84012303520167E-11   1.16201085941763E-22
      3.91037164987412E-08   3.90753152683893E-08  -5.65901079312893E-19  -3.65808889426513E-01  -3.65808889415325E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11881937631894E-08   0.00000000000000E+00  -1.11881937631894E-08
      2.44240120386959E-18  -4.34285979806958E-02  -3.46423431342545E-02   0.00000000000000E+00   4.67806586645617E-11
      5.96053874514075E-24  -2.79339021638645E-08  -2.78871215051999E-08  -1.87650012455670E-18
      3.18823266948797E-09
      0.00000000000000E+00  -3.73827367829447E-11   0.00000000000000E+00  -2.72205007493263E-11   1.16128390335628E-22
      3.74099453248054E-08   3.73827248240562E-08  -5.59023880237041E-19  -3.68758295462600E-01  -3.68758295451613E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09874452108181E-08   0.00000000000000E+00  -1.09874452108181E-08
      2.40860965948138E-18  -3.76971657734663E-02  -2.93809300718215E-02   0.00000000000000E+00   4.17507080793134E-11
      2.68342671900443E-23  -2.64370303213178E-08  -2.63952796132384E-08  -1.84958577924434E-18
      3.19238455230047E-09
      0.00000000000000E+00  -3.56421871681249E-11   0.00000000000000E+00  -2.07727042745965E-11   1.18549389269360E-22
      3.56629240639037E-08   3.56421513596292E-08  -5.48100833267188E-19  -3.73307964996201E-01  -3.73307964985442E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07586659647479E-08   0.00000000000000E+00  -1.07586659647479E-08
      2.36394093917692E-18  -3.21123380587605E-02  -2.42724067173741E-02   0.00000000000000E+00   3.25702143094665E-11
      5.29238368783346E-23  -2.49160556091909E-08  -2.48834853948813E-08  -1.81584010590973E-18
      3.19798959409734E-09
      0.00000000000000E+00  -3.40645701171112E-11   0.00000000000000E+00  -1.39284125026518E-11   1.24344229921525E-22
      3.40784791041065E-08   3.40645506916040E-08  -5.31669452283903E-19  -3.80032161587994E-01  -3.80032161577450E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05440396604250E-08   0.00000000000000E+00  -1.05440396604250E-08
      2.30484115617233E-18  -2.70925308458431E-02  -1.96820162844158E-02   0.00000000000000E+00   2.37604216855523E-11
      8.39348190923834E-23  -2.35442714528643E-08  -2.35205110311786E-08  -1.77317170388842E-18
      3.20555640052312E-09
      0.00000000000000E+00  -3.27802133120012E-11   0.00000000000000E+00  -8.37234268454276E-12   1.33130887073602E-22
      3.27886164133616E-08   3.27802440706772E-08  -5.08307911592858E-19  -3.89509339171598E-01  -3.89509339161228E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03692974390903E-08   0.00000000000000E+00  -1.03692974390903E-08
      2.22637868967938E-18  -2.28429734068678E-02  -1.57820356986665E-02   0.00000000000000E+00   1.66956883103313E-11
      1.18646236461059E-22  -2.24276423198976E-08  -2.24109466315871E-08  -1.71807077808652E-18
      3.21577158919793E-09
      0.00000000000000E+00  -3.17527462368606E-11   0.00000000000000E+00  -4.93385863209502E-12   1.42000462460702E-22
      3.17577085010125E-08   3.17527746423806E-08  -4.76706288997785E-19  -4.02313012870979E-01  -4.02313012860747E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02320003353215E-08   0.00000000000000E+00  -1.02320003353215E-08
      2.12185687573341E-18  -1.93345876041409E-02  -1.25541047271327E-02   0.00000000000000E+00   1.19386818479362E-11
      1.52872847736228E-22  -2.15327129889072E-08  -2.15207743070591E-08  -1.64515058673562E-18
      3.22956209390892E-09
      0.00000000000000E+00  -3.07926013540931E-11   0.00000000000000E+00  -3.39698198571077E-12   1.44144884427126E-22
      3.07959637103991E-08   3.07925667284135E-08  -4.35646256416804E-19  -4.19048516212464E-01  -4.19048516202358E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01052137079108E-08   0.00000000000000E+00  -1.01052137079108E-08
      1.98250087848894E-18  -1.64217979209626E-02  -9.90389043806402E-03   0.00000000000000E+00   9.14654330117468E-12
      1.76129885808076E-22  -2.06964995638040E-08  -2.06873530205027E-08  -1.54685462207213E-18
      3.24817927526875E-09
      0.00000000000000E+00  -2.96328778573736E-11   0.00000000000000E+00  -3.03644960915389E-12   1.29462021454723E-22
      2.96359070566352E-08   2.96328706070261E-08  -3.83913625413268E-19  -4.40408099402857E-01  -4.40408099392903E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.95400965353248E-09   0.00000000000000E+00  -9.95400965353248E-09
      1.79718527551161E-18  -1.39366561722929E-02  -7.73648402211638E-03   0.00000000000000E+00   7.61948943224882E-12
      1.71121658063058E-22  -1.96864804429260E-08  -1.96788609534936E-08  -1.41327165009834E-18
      3.26817927526875E-09
      0.00000000000000E+00  -2.84332018999689E-11   0.00000000000000E+00  -2.92765215509161E-12   9.99749883546613E-23
      2.84361776659291E-08   2.84332500137741E-08  -3.32446512249191E-19  -4.62007861215759E-01  -4.62007861205954E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.80533886716803E-09   0.00000000000000E+00  -9.80533886716803E-09
      1.60107849816825E-18  -1.21484780207161E-02  -6.27942022650399E-03   0.00000000000000E+00   6.62834910370383E-12
      1.35935628540465E-22  -1.86345394957100E-08  -1.86279111466062E-08  -1.26863198591906E-18
      3.28817927526875E-09
      0.00000000000000E+00  -2.74444014591927E-11   0.00000000000000E+00  -2.41232112215088E-12   6.76115056867081E-23
      2.74468236365193E-08   2.74444113153972E-08  -2.84419553608149E-19  -4.82512291882255E-01  -4.82512291872579E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67607101208296E-09   0.00000000000000E+00  -9.67607101208296E-09
      1.40755707792659E-18  -1.09313410142845E-02  -5.33310172543900E-03   0.00000000000000E+00   5.52349239984311E-12
      9.06479910342466E-23  -1.77738637957142E-08  -1.77683403033142E-08  -1.12313752431844E-18
      3.30817927526875E-09
      0.00000000000000E+00  -2.66043894926927E-11   0.00000000000000E+00  -2.04791511541242E-12   4.07985290880744E-23
      2.66064374194017E-08   2.66043895042864E-08  -2.39541408065386E-19  -5.02013672601492E-01  -5.02013672591972E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.51974058797175E-09   0.00000000000000E+00  -9.51974058797175E-09
      1.21716226616715E-18  -1.00635259855042E-02  -4.68069229811195E-03   0.00000000000000E+00   4.61793315592717E-12
      5.12510297105664E-23  -1.70892668494706E-08  -1.70846489163146E-08  -9.77620858101767E-19
      3.32817927526875E-09
      0.00000000000000E+00  -2.65008804738598E-11   0.00000000000000E+00  -2.33364498820967E-13   2.29205414266956E-23
      2.65011065426373E-08   2.65008731781385E-08  -1.95315331849446E-19  -5.21646848501035E-01  -5.21646848491178E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.85668250504471E-09   0.00000000000000E+00  -9.85668250504471E-09
      1.02002861606626E-18  -9.51486473467903E-03  -4.27080224928383E-03   0.00000000000000E+00   3.77656654346342E-12
      2.45151476866929E-23  -1.66479672396373E-08  -1.66441906730938E-08  -8.24713284216815E-19
      3.34817927526875E-09
      0.00000000000000E+00  -2.74218994985768E-11   0.00000000000000E+00   2.29637441535731E-12   1.29374241136728E-23
      2.74196041107347E-08   2.74219004851501E-08  -1.49361551299824E-19  -5.42583871693384E-01  -5.42583871682580E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08040997028066E-08   0.00000000000000E+00  -1.08040997028066E-08
      8.03946622010128E-19  -9.30699720749112E-03  -4.07124645201492E-03   0.00000000000000E+00   2.68767756330339E-12
      9.53673633799699E-24  -1.66204884599068E-08  -1.66178007823434E-08  -6.54585070710303E-19
      3.35317927526875E-09
      0.00000000000000E+00  -2.77667764867911E-11   0.00000000000000E+00   3.42409221943867E-12   1.08109826855654E-23
      2.77633668944007E-08   2.77667909866201E-08  -1.37895187965464E-19  -5.47902758933196E-01  -5.47902758922008E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11872332262284E-08   0.00000000000000E+00  -1.11872332262284E-08
      7.48010455878986E-19  -9.26271847543840E-03  -4.03901646643709E-03   0.00000000000000E+00   2.90340641264098E-12
      6.31032048044816E-24  -1.65824611668044E-08  -1.65795577603917E-08  -6.10115267913522E-19
      3.35655427526875E-09
      0.00000000000000E+00  -2.80210945641188E-11   0.00000000000000E+00   3.74526447106100E-12   9.61594357776945E-24
      2.80173300152659E-08   2.80210752797370E-08  -1.30103763474062E-19  -5.51537813856507E-01  -5.51537813845113E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13936493839191E-08   0.00000000000000E+00  -1.13936493839191E-08
      7.09556889208259E-19  -9.26475823411755E-03  -4.02597371472871E-03   0.00000000000000E+00   1.82842706478000E-12
      4.52074341213251E-24  -1.66292543228824E-08  -1.66274258958176E-08  -5.79453125734196E-19
      3.36111052526875E-09
      0.00000000000000E+00  -2.83903104076930E-11   0.00000000000000E+00   4.02827901106011E-12   8.40481474535863E-24
      2.83862519961760E-08   2.83902802751871E-08  -1.19497247030217E-19  -5.56513093460598E-01  -5.56513093448983E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16150208107963E-08   0.00000000000000E+00  -1.16150208107963E-08
      6.56635950639068E-19  -9.30341861055592E-03  -4.01805548185781E-03   0.00000000000000E+00   9.14658139882143E-13
      2.72314768610563E-24  -1.67761741225308E-08  -1.67752594643909E-08  -5.37138703608851E-19
      3.36726146276875E-09
      0.00000000000000E+00  -2.88903131570508E-11   0.00000000000000E+00   4.04391457106676E-12   7.28122937615871E-24
      2.88862294926595E-08   2.88902734072305E-08  -1.05102098865935E-19  -5.63314560609130E-01  -5.63314560597272E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18580601446487E-08   0.00000000000000E+00  -1.18580601446487E-08
      5.83697763818093E-19  -9.37979774997365E-03  -4.01347556798936E-03   0.00000000000000E+00   4.29633018798907E-13
      1.07429960020518E-24  -1.70326428956009E-08  -1.70322132625821E-08  -4.78595664952159E-19
      3.37141334558125E-09
      0.00000000000000E+00  -2.92268322741792E-11   0.00000000000000E+00   4.03323323714098E-12   6.69022739116024E-24
      2.92228251784878E-08   2.92268584117249E-08  -9.54112759182135E-20  -5.67926087304428E-01  -5.67926087292424E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20044456043546E-08   0.00000000000000E+00  -1.20044456043546E-08
      5.33856712439782E-19  -9.43906203967885E-03  -4.01281328357167E-03   0.00000000000000E+00   1.94182972704334E-13
      2.11419015685930E-25  -1.72226069903428E-08  -1.72224128073701E-08  -4.38445436521568E-19
      3.37701838737812E-09
      0.00000000000000E+00  -2.95069587226621E-11   0.00000000000000E+00   2.50931173787979E-12   6.10354097042054E-24
      2.95044939434386E-08   2.95070032551765E-08  -8.24555755207228E-20  -5.74123439398685E-01  -5.74123439386620E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20653226431267E-08   0.00000000000000E+00  -1.20653226431267E-08
      4.66230074732275E-19  -9.49020132677191E-03  -3.99486750905886E-03   0.00000000000000E+00   4.73587682156208E-13
     -5.80210961152088E-25  -1.74421541997320E-08  -1.74416806120498E-08  -3.83774499211552E-19
      3.38458519380390E-09
      0.00000000000000E+00  -2.94975905594670E-11   0.00000000000000E+00  -2.12152553888371E-14   5.52430780831685E-24
      2.94976284233441E-08   2.94976072080887E-08  -6.55607023492681E-20  -5.82256191025278E-01  -5.82256191013394E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18841287447094E-08   0.00000000000000E+00  -1.18841287447094E-08
      3.76305172981996E-19  -9.48094763829235E-03  -3.93148500867851E-03   0.00000000000000E+00   1.17463185348944E-12
     -1.22893363344957E-24  -1.76146530952329E-08  -1.76134784633794E-08  -3.10744470632728E-19
      3.39480038247871E-09
      0.00000000000000E+00  -2.87502499328093E-11   0.00000000000000E+00  -3.57884579815197E-12   4.91091604295213E-24
      2.87537842684935E-08   2.87502054226954E-08  -4.48473009370651E-20  -5.92296845017473E-01  -5.92296845006417E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10566573290285E-08   0.00000000000000E+00  -1.10566573290285E-08
      2.63359332253308E-19  -9.35777976740050E-03  -3.78308870887541E-03   0.00000000000000E+00   1.67218826356145E-12
     -1.70811472150705E-24  -1.76952202819303E-08  -1.76935480936668E-08  -2.18512031316243E-19
      3.40859088718969E-09
      0.00000000000000E+00  -2.57623569419740E-11   0.00000000000000E+00  -1.06680201245757E-11   4.07743649819265E-24
      2.57730708203213E-08   2.57624028001967E-08  -2.50353026148354E-20  -6.01885690996584E-01  -6.01885690988520E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.06397805937627E-09   0.00000000000000E+00  -8.06397805937627E-09
      1.52153004836189E-19  -9.01449084249903E-03  -3.43826197191995E-03   0.00000000000000E+00   1.43214743249417E-12
     -2.05611623758064E-24  -1.76998568882529E-08  -1.76984247408204E-08  -1.27117702221353E-19
      3.42720806854953E-09
      0.00000000000000E+00  -1.55283734091510E-11   0.00000000000000E+00  -2.71033292440342E-11   2.37235659119896E-24
      1.55554572177580E-08   1.55283538885139E-08  -3.27673406588633E-20  -5.97487908398380E-01  -5.97487908400539E-01
      0.00000000000000E+00   0.00000000000000E+00   2.15896804703268E-09   0.00000000000000E+00   2.15896804703268E-09
      1.92346904517878E-19  -8.10332973355102E-03  -2.53059773374208E-03   0.00000000000000E+00  -3.29698076807934E-13
     -2.46230991754340E-24  -1.76869922374697E-08  -1.76873219355465E-08  -1.59579563859014E-19
      3.44720806854953E-09
      0.00000000000000E+00   2.74266754249116E-12   0.00000000000000E+00  -4.50303573666352E-11  -8.30411194907891E-25
     -2.69765752553612E-09  -2.74268788290276E-09  -1.10640989332367E-19  -5.58949206117575E-01  -5.58949206138004E-01
      0.00000000000000E+00   0.00000000000000E+00   2.04290073316061E-08   0.00000000000000E+00   2.04290073316061E-08
      6.00927051149999E-19  -6.54818045033666E-03  -9.75763324553963E-04   0.00000000000000E+00  -3.86903114010681E-12
     -3.76960677995489E-24  -1.76824504175632E-08  -1.76863194487033E-08  -4.90286061817633E-19
      3.46720806854953E-09
      0.00000000000000E+00   1.94645633116539E-11   0.00000000000000E+00  -4.13413540549452E-11  -7.93194298591946E-24
     -1.94231864355914E-08  -1.94645277896464E-08  -2.76597909193978E-19  -4.83853089994723E-01  -4.83853090031831E-01
      0.00000000000000E+00   0.00000000000000E+00   3.71077330731146E-08   0.00000000000000E+00   3.71077330731146E-08
      1.34308171261229E-18  -4.84502573660822E-03   7.13804557737464E-04   0.00000000000000E+00  -9.28154093785063E-12
     -1.19281599141630E-23  -1.76339237425303E-08  -1.76432052834682E-08  -1.06648380341831E-18
      3.48720806854953E-09
      0.00000000000000E+00   2.47049484825038E-11   0.00000000000000E+00  -1.32387169628330E-11  -2.98138206588771E-23
     -2.46916568129919E-08  -2.47048955299547E-08  -5.41171784768240E-19  -3.76720970777935E-01  -3.76720970820268E-01
      0.00000000000000E+00   0.00000000000000E+00   4.23327888621520E-08   0.00000000000000E+00   4.23327888621520E-08
      2.18973748985533E-18  -2.88898209873435E-03   2.66501475566032E-03   0.00000000000000E+00  -2.08284882775431E-11
     -5.16935839584911E-23  -1.76070648439198E-08  -1.76278933321974E-08  -1.64856570508709E-18
      3.50720806854953E-09
      0.00000000000000E+00   1.69000745593454E-11   0.00000000000000E+00   1.86848227765237E-11  -4.19377071154164E-23
     -1.69187293019659E-08  -1.69000444791894E-08  -8.39185031785592E-19  -2.51659094289941E-01  -2.51659094323904E-01
      0.00000000000000E+00   0.00000000000000E+00   3.39624724259288E-08   0.00000000000000E+00   3.39624724259288E-08
      2.86898693837391E-18  -4.61356825416930E-03   7.62250608997349E-04   0.00000000000000E+00  -4.70617442810160E-11
     -7.80696460895266E-23  -1.70153662024583E-08  -1.70624279467393E-08  -2.02980190658831E-18
      3.52720806854953E-09
      0.00000000000000E+00   1.10616883045373E-11   0.00000000000000E+00   1.36505482686193E-11  -4.51558220968835E-23
     -1.10753062569724E-08  -1.10616557087038E-08  -1.05866062964524E-18  -1.42689776458579E-01  -1.42689776483392E-01
      0.00000000000000E+00   0.00000000000000E+00   2.48126352760708E-08   0.00000000000000E+00   2.48126352760708E-08
      3.36523964389532E-18  -2.87830778609818E-02  -2.44505965873550E-02   0.00000000000000E+00  -8.94647844911550E-11
     -9.08010248177432E-23  -1.36615147828757E-08  -1.37509795673670E-08  -2.30657901425008E-18
      3.54720806854953E-09
      0.00000000000000E+00   7.01950957529685E-12   0.00000000000000E+00   9.16074264611525E-12  -4.72510480295207E-23
     -7.02859359644418E-09  -7.01943285379811E-09  -1.19763339425091E-18  -6.42410143377307E-02  -6.42410143553319E-02
      0.00000000000000E+00   0.00000000000000E+00   1.76011438986858E-08   0.00000000000000E+00   1.76011438986858E-08
      3.71726252186904E-18  -7.14797436079218E-02  -6.81457905612599E-02   0.00000000000000E+00  -1.48671177324383E-10
     -1.03698527876235E-22  -1.04330398675632E-08  -1.05817110448877E-08  -2.51962912761812E-18
      3.54970806854953E-09
      0.00000000000000E+00   5.84481538641259E-12   0.00000000000000E+00   2.20690813354780E-11  -4.74269389417111E-23
     -5.86683974278650E-09  -5.84477066145107E-09  -1.21206969188671E-18  -5.56826018617252E-02  -5.56826018772091E-02
      0.00000000000000E+00   0.00000000000000E+00   1.54839179022710E-08   0.00000000000000E+00   1.54839179022710E-08
      3.75597231662472E-18  -7.75002557580890E-02  -7.44632456198782E-02   0.00000000000000E+00  -1.78275017508363E-10
     -1.05351797125118E-22  -9.46087222331154E-09  -9.63914724082001E-09  -2.54390262473801E-18
      3.55308306854953E-09
      0.00000000000000E+00   4.55127410758178E-12   0.00000000000000E+00   1.82626264197105E-11  -4.76143083080905E-23
     -4.56949880023138E-09  -4.55123617381172E-09  -1.22718753024719E-18  -4.65565597897352E-02  -4.65565598030136E-02
      0.00000000000000E+00   0.00000000000000E+00   1.32784042796292E-08   0.00000000000000E+00   1.32784042796292E-08
      3.80078693106847E-18  -8.65011708065953E-02  -8.37514945015577E-02   0.00000000000000E+00  -1.81274125853375E-10
     -1.07470883358823E-22  -8.54589397996445E-09  -8.72716810581793E-09  -2.57359940082127E-18
      3.55763931854953E-09
      0.00000000000000E+00   3.20483026011944E-12   0.00000000000000E+00   1.41137099512549E-11  -4.77817179305329E-23
     -3.21894219665410E-09  -3.20482848670290E-09  -1.24145752091326E-18  -3.77463627330653E-02  -3.77463627440363E-02
      0.00000000000000E+00   0.00000000000000E+00   1.09709437667908E-08   0.00000000000000E+00   1.09709437667908E-08
      3.85077329360591E-18  -9.97724143598141E-02  -9.73255363403092E-02   0.00000000000000E+00  -1.79343074719645E-10
     -1.10129383415257E-22  -7.58677220536791E-09  -7.76611528008766E-09  -2.60931577269264E-18
      3.56379025604953E-09
      0.00000000000000E+00   2.00019468690552E-12   0.00000000000000E+00   9.37904665838833E-12  -4.79107159031700E-23
     -2.00955866820428E-09  -2.00017962154594E-09  -1.25331127660157E-18  -3.01729240940111E-02  -3.01729241028438E-02
      0.00000000000000E+00   0.00000000000000E+00   8.83274987791482E-09   0.00000000000000E+00   8.83274987791482E-09
      3.90510298605810E-18  -1.18851012190151E-01  -1.16698265534128E-01   0.00000000000000E+00  -1.78530080702127E-10
     -1.13462601460911E-22  -6.65404017566669E-09  -6.83257025636893E-09  -2.65179170945652E-18
      3.57209402167453E-09
      0.00000000000000E+00   1.12206715446435E-12   0.00000000000000E+00   5.06986663627447E-12  -4.79991523247046E-23
     -1.12711630941188E-09  -1.12204644277565E-09  -1.26202812178981E-18  -2.42695114251290E-02  -2.42695114322725E-02
      0.00000000000000E+00   0.00000000000000E+00   7.14349993901482E-09   0.00000000000000E+00   7.14349993901482E-09
      3.96442093529387E-18  -1.45289624296852E-01  -1.43392435144101E-01   0.00000000000000E+00  -1.81826213769353E-10
     -1.17699362169831E-22  -5.83962728246978E-09  -6.02145349623925E-09  -2.70239281350406E-18
      3.58330410526828E-09
      0.00000000000000E+00   5.96898947111716E-13   0.00000000000000E+00   2.24317237771871E-12  -4.80548466959515E-23
     -5.99142680647066E-10  -5.96899508269395E-10  -1.26792697006539E-18  -1.98565545216353E-02  -1.98565545275536E-02
      0.00000000000000E+00   0.00000000000000E+00   5.91833416428363E-09   0.00000000000000E+00   5.91833416428363E-09
      4.03076595601124E-18  -1.80390989668214E-01  -1.78714353891936E-01   0.00000000000000E+00  -1.89890726239996E-10
     -1.23158814588031E-22  -5.13154392977406E-09  -5.32143465601418E-09  -2.76283898594585E-18
      3.59843771811984E-09
      0.00000000000000E+00   3.25222214451852E-13   0.00000000000000E+00   8.58332956671845E-13  -4.80866863363464E-23
     -3.26081911532029E-10  -3.25223578575405E-10  -1.27181292920104E-18  -1.64955188267797E-02  -1.64955188316868E-02
      0.00000000000000E+00   0.00000000000000E+00   4.90709669731488E-09   0.00000000000000E+00   4.90709669731488E-09
      4.10502805765358E-18  -2.24209433724847E-01  -2.22765809532857E-01   0.00000000000000E+00  -1.97590754683007E-10
     -1.30066024109309E-22  -4.38428236405632E-09  -4.58187311873946E-09  -2.83321512845255E-18
      3.61843771811984E-09
      0.00000000000000E+00   2.04170850812332E-13   0.00000000000000E+00   2.89347582981211E-13  -4.81038793335158E-23
     -2.04498652812781E-10  -2.04209305229848E-10  -1.27457567244003E-18  -1.38327267088475E-02  -1.38327267126293E-02
      0.00000000000000E+00   0.00000000000000E+00   3.78186584591262E-09   0.00000000000000E+00   3.78186584591262E-09
      4.18066537457184E-18  -2.71384919664944E-01  -2.70257692814317E-01   0.00000000000000E+00  -1.87004270445468E-10
     -1.37789044557587E-22  -3.39065227023712E-09  -3.57765654068272E-09  -2.90608970213181E-18
      3.63843771811984E-09
      0.00000000000000E+00   1.59993532215512E-13   0.00000000000000E+00   1.06196495614021E-13  -4.81119115626078E-23
     -1.60131642220200E-10  -1.60025445724634E-10  -1.27648833627449E-18  -1.20708407764259E-02  -1.20708407791284E-02
      0.00000000000000E+00   0.00000000000000E+00   2.70253407419388E-09   0.00000000000000E+00   2.70253407419388E-09
      4.23471605605572E-18  -3.05308324214682E-01  -3.04507242416044E-01   0.00000000000000E+00  -1.53053099569444E-10
     -1.43558494499144E-22  -2.38945552889969E-09  -2.54250862846928E-09  -2.95822771978123E-18
      3.65843771811984E-09
      0.00000000000000E+00   1.38226329497328E-13   0.00000000000000E+00   5.38810613235707E-14  -4.81145659189758E-23
     -1.38302598103903E-10  -1.38248717042627E-10  -1.27798846653193E-18  -1.08765589577757E-02  -1.08765589596151E-02
      0.00000000000000E+00   0.00000000000000E+00   1.83933214026448E-09   0.00000000000000E+00   1.83933214026448E-09
      4.27150269886100E-18  -3.27589641833616E-01  -3.27053673515307E-01   0.00000000000000E+00  -1.08596145997286E-10
     -1.47420505175770E-22  -1.59248727722443E-09  -1.70108342322187E-09  -2.99351423232908E-18
      3.67843771811984E-09
      0.00000000000000E+00   1.30603216309103E-13   0.00000000000000E+00   1.97306106132288E-14  -4.81160322233557E-23
     -1.30647089250702E-10  -1.30627358640137E-10  -1.27935087188918E-18  -1.00227565157311E-02  -1.00227565168843E-02
      0.00000000000000E+00   0.00000000000000E+00   1.15324596942541E-09   0.00000000000000E+00   1.15324596942541E-09
      4.29456761824951E-18  -3.39970410513394E-01  -3.39648213984424E-01   0.00000000000000E+00  -6.18191406900730E-11
     -1.49553058360532E-22  -9.60799470095102E-10  -1.02261861078532E-09  -3.01521674636033E-18
      3.69843771811984E-09
      0.00000000000000E+00   1.15081455721031E-13   0.00000000000000E+00   4.13962970970992E-14  -4.81119503125417E-23
     -1.15112347336355E-10  -1.15070951039306E-10  -1.28041250096687E-18  -9.49861560020951E-03  -9.49861560094062E-03
      0.00000000000000E+00   0.00000000000000E+00   7.31109600775015E-10   0.00000000000000E+00   7.31109600775015E-10
      4.30918981026501E-18  -3.46490853447650E-01  -3.46296763760211E-01   0.00000000000000E+00  -3.08468756940712E-11
     -1.50603635647039E-22  -5.85191774041398E-10  -6.16038649735620E-10  -3.02877730929814E-18
      3.71843771811984E-09
      0.00000000000000E+00   8.55074503402074E-14   0.00000000000000E+00   8.05800095252654E-14  -4.80970012975521E-23
     -8.55904569971856E-11  -8.55098769877085E-11  -1.28089458582393E-18  -9.29954279348158E-03  -9.29954279419950E-03
      0.00000000000000E+00   0.00000000000000E+00   7.17916175590748E-10   0.00000000000000E+00   7.17916175590748E-10
      4.32354813377683E-18  -3.53754215083273E-01  -3.53554967677857E-01   0.00000000000000E+00  -3.42171323829713E-11
     -1.51735525684492E-22  -5.98189166219954E-10  -6.32406298603077E-10  -3.04265354795290E-18
      3.72843771811984E-09
      0.00000000000000E+00   6.97101555405128E-14   0.00000000000000E+00   8.82681606530966E-14  -4.80867900033760E-23
     -6.97784356587954E-11  -6.96901674981904E-11  -1.28098079785675E-18  -9.26869065767672E-03  -9.26869065847739E-03
      0.00000000000000E+00   0.00000000000000E+00   8.00671043648845E-10   0.00000000000000E+00   8.00671043648845E-10
      4.33155484421332E-18  -3.58267817009622E-01  -3.58037509681828E-01   0.00000000000000E+00  -4.39911991120521E-11
     -1.52449793613518E-22  -6.86989677038292E-10  -7.30980876150497E-10  -3.05057404635656E-18
      3.73518771811984E-09
      0.00000000000000E+00   4.10545975317645E-14   0.00000000000000E+00   2.23584806680227E-13  -4.80753800304387E-23
     -4.12374566318235E-11  -4.10138718251914E-11  -1.28084742808839E-18  -9.32756961526045E-03  -9.32756961627668E-03
      0.00000000000000E+00   0.00000000000000E+00   1.01623282359789E-09   0.00000000000000E+00   1.01623282359789E-09
      4.33841441577260E-18  -3.62755365075367E-01  -3.62448100727048E-01   0.00000000000000E+00  -6.76014603804915E-11
     -1.53179423744840E-22  -9.07617491392145E-10  -9.75218951772790E-10  -3.05756698768421E-18
      3.73974396811984E-09
      0.00000000000000E+00   2.13079790321462E-14   0.00000000000000E+00   2.31892233144491E-13  -4.80661181385420E-23
     -2.15121181402763E-11  -2.12802259071799E-11  -1.28066859035792E-18  -9.39788958992679E-03  -9.39788959115499E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22819613007185E-09   0.00000000000000E+00   1.22819613007185E-09
      4.34401038439024E-18  -3.66674920923847E-01  -3.66294651164986E-01   0.00000000000000E+00  -9.00624197761082E-11
     -1.53830258225440E-22  -1.11685348438807E-09  -1.20691590416433E-09  -3.06334179403232E-18
      3.74281943686984E-09
      0.00000000000000E+00   1.38685553183365E-14   0.00000000000000E+00   1.39964684533720E-13  -4.80598652689842E-23
     -1.40085073504498E-11  -1.38685426659641E-11  -1.28052563302643E-18  -9.44783743780257E-03  -9.44783743918453E-03
      0.00000000000000E+00   0.00000000000000E+00   1.38196007203154E-09   0.00000000000000E+00   1.38196007203154E-09
      4.34826055940552E-18  -3.69720480673555E-01  -3.69289426085142E-01   0.00000000000000E+00  -1.05798072679091E-10
     -1.54343938713456E-22  -1.26229345668577E-09  -1.36809152936501E-09  -3.06773492637909E-18
      3.74697131968234E-09
      0.00000000000000E+00   1.70831211206000E-14   0.00000000000000E+00  -1.70892622497254E-14  -4.80525273252241E-23
     -1.70457894473939E-11  -1.70628787096916E-11  -1.28034698758987E-18  -9.49108557945271E-03  -9.49108558100887E-03
      0.00000000000000E+00   0.00000000000000E+00   1.55615716641496E-09   0.00000000000000E+00   1.55615716641496E-09
      4.35472154159831E-18  -3.74362199398193E-01  -3.73877263911066E-01   0.00000000000000E+00  -1.22304696200131E-10
     -1.55142596482924E-22  -1.41678959150515E-09  -1.53909428770543E-09  -3.07437455400844E-18
      3.75257636147921E-09
      0.00000000000000E+00   2.85637132715408E-14   0.00000000000000E+00  -8.35159206945181E-14  -4.80442651559586E-23
     -2.84380583609684E-11  -2.85215742817109E-11  -1.28017209543223E-18  -9.49368185828226E-03  -9.49368185998332E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70106118910025E-09   0.00000000000000E+00   1.70106118910025E-09
      4.36425606066225E-18  -3.81151722784886E-01  -3.80624740336872E-01   0.00000000000000E+00  -1.36235615210893E-10
     -1.56335273569155E-22  -1.53630399960728E-09  -1.67253961481833E-09  -3.08408396523003E-18
      3.76014316790499E-09
      0.00000000000000E+00   4.21567343782548E-14   0.00000000000000E+00  -7.49631194417276E-14  -4.80349817530127E-23
     -4.20820501856324E-11  -4.21570133051222E-11  -1.28004291963214E-18  -9.42182858781308E-03  -9.42182858959612E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78303829388963E-09   0.00000000000000E+00   1.78303829388963E-09
      4.37774796628188E-18  -3.90652601960567E-01  -3.90104085775536E-01   0.00000000000000E+00  -1.45755480197285E-10
     -1.58038022470967E-22  -1.59512580038699E-09  -1.74088128058443E-09  -3.09770504664973E-18
      3.77035835657980E-09
      0.00000000000000E+00   5.73111160174967E-14   0.00000000000000E+00  -6.22899583025529E-14  -4.80252674257877E-23
     -5.72396013606759E-11  -5.73018913190265E-11  -1.28002985923628E-18  -9.22619604071529E-03  -9.22619604251615E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80085743543924E-09   0.00000000000000E+00   1.80085743543924E-09
      4.39614406476131E-18  -4.03438226644767E-01  -4.02888867498499E-01   0.00000000000000E+00  -1.51021729896243E-10
     -1.60380784592400E-22  -1.59253381422361E-09  -1.74355554412001E-09  -3.11611420552503E-18
      3.78414886129078E-09
      0.00000000000000E+00   8.25684187495665E-14   0.00000000000000E+00  -8.44113563890957E-14  -4.80190246679110E-23
     -8.25194291378266E-11  -8.26038404942637E-11  -1.28037225881879E-18  -8.75647344306786E-03  -8.75647344485160E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78373766073804E-09   0.00000000000000E+00   1.78373766073804E-09
      4.42074270737488E-18  -4.20123368115397E-01  -4.19587374975335E-01   0.00000000000000E+00  -1.53924783086320E-10
     -1.63535786151528E-22  -1.54720903715725E-09  -1.70113382024374E-09  -3.14037044855610E-18
      3.80276604265062E-09
      0.00000000000000E+00   1.28307097878915E-13   0.00000000000000E+00  -1.23429934190464E-13  -4.80268637646892E-23
     -1.28164586756225E-10  -1.28288016690463E-10  -1.28170216427487E-18  -7.62662437743375E-03  -7.62662437920114E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76738657280548E-09   0.00000000000000E+00   1.76738657280548E-09
      4.45364646373373E-18  -4.41414451612187E-01  -4.40898004204838E-01   0.00000000000000E+00  -1.57017420981255E-10
     -1.67765182120644E-22  -1.48208113513357E-09  -1.63909855611499E-09  -3.17194429945887E-18
      3.82276604265062E-09
      0.00000000000000E+00   1.67524800666529E-13   0.00000000000000E+00  -1.06750443348164E-13  -4.80489412976447E-23
     -1.67457477228805E-10  -1.67564227672201E-10  -1.28393275100704E-18  -5.96217060747766E-03  -5.96217060921655E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73889326179299E-09   0.00000000000000E+00   1.73889326179299E-09
      4.48842432896960E-18  -4.62956508873109E-01  -4.62461413251984E-01   0.00000000000000E+00  -1.60612943151670E-10
     -1.72277190153961E-22  -1.41071609096899E-09  -1.57132903412083E-09  -3.20449157796256E-18
      3.84276604265062E-09
      0.00000000000000E+00   1.71565969103660E-13   0.00000000000000E+00  -2.09422340906726E-14  -4.80705452879934E-23
     -1.71511287567287E-10  -1.71532229801425E-10  -1.28625757108587E-18  -4.27027752876392E-03  -4.27027753043095E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66702571136667E-09   0.00000000000000E+00   1.66702571136667E-09
      4.52176484319693E-18  -4.83414635653345E-01  -4.82943433240232E-01   0.00000000000000E+00  -1.62588996737178E-10
     -1.76715713804457E-22  -1.33290448482791E-09  -1.49549348156527E-09  -3.23550727211106E-18
      3.86276604265062E-09
      0.00000000000000E+00   2.25386985107271E-13   0.00000000000000E+00  -1.53285977691526E-13  -4.81146168169775E-23
     -2.25259770317486E-10  -2.25413056295226E-10  -1.28967110062714E-18  -1.94270711136235E-03  -1.94270711304790E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68554704811865E-09   0.00000000000000E+00   1.68554704811865E-09
      4.55547578415930E-18  -5.02869369004107E-01  -5.02409305860100E-01   0.00000000000000E+00  -1.69321741601742E-10
     -1.81212971118209E-22  -1.29081225022157E-09  -1.46013399182350E-09  -3.26580468353216E-18
      3.88276604265062E-09
      0.00000000000000E+00  -6.80661347444981E-13   0.00000000000000E+00   2.36337032170669E-12  -4.77803185299154E-23
      6.78282656962830E-10   6.80646027284489E-10  -1.27502711398546E-18  -1.05315482264552E-02  -1.05315482266338E-02
      0.00000000000000E+00   0.00000000000000E+00   1.78631461890112E-10   0.00000000000000E+00   1.78631461890112E-10
      4.55904841339710E-18  -5.22598379583232E-01  -5.22327647110640E-01   0.00000000000000E+00  -8.75964272198634E-11
     -1.83490469597124E-22  -7.71681061954439E-10  -8.59277489174485E-10  -3.28402129941164E-18
      3.90276604265062E-09
      0.00000000000000E+00  -2.57955128921060E-12   0.00000000000000E+00   5.09044395935413E-12  -4.67310590095406E-23
      2.57444678720076E-09   2.57953723116007E-09  -1.22277208127718E-18  -4.09941717168265E-02  -4.09941717139628E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.86369643674464E-09   0.00000000000000E+00  -2.86369643674464E-09
      4.50177448466221E-18  -5.43588713250756E-01  -5.43678286862037E-01   0.00000000000000E+00   8.50761395125284E-11
     -1.81248179031268E-22   1.99083066072063E-10   2.84159205584411E-10  -3.27900240338503E-18
      3.90526604265062E-09
      0.00000000000000E+00  -3.11757775977229E-12   0.00000000000000E+00   1.09505574073280E-11  -4.65569012598655E-23
      3.10666728036335E-09   3.11761783777063E-09  -1.21490691287859E-18  -4.55062460331264E-02  -4.55062460294384E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.68801873023793E-09   0.00000000000000E+00  -3.68801873023793E-09
      4.49255443783662E-18  -5.46231286518136E-01  -5.46411057288798E-01   0.00000000000000E+00   1.28462381923625E-10
     -1.80825646693637E-22   4.41938510544769E-10   5.70400892468213E-10  -3.27764752495803E-18
      3.90864104265062E-09
      0.00000000000000E+00  -3.56036123784977E-12   0.00000000000000E+00   7.02707600732785E-12  -4.63180284612879E-23
      3.55334119987238E-09   3.56036827587967E-09  -1.20282322914084E-18  -5.23702798125623E-02  -5.23702798081806E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.38167535792866E-09   0.00000000000000E+00  -4.38167535792866E-09
      4.47776628350361E-18  -5.49851784658326E-01  -5.50110617345449E-01   0.00000000000000E+00   1.62681920130780E-10
     -1.80096880429406E-22   6.58625161918585E-10   8.21307082049186E-10  -3.27494305436277E-18
      3.91319729265062E-09
      0.00000000000000E+00  -4.08810109784422E-12   0.00000000000000E+00   6.26355084409946E-12  -4.59593514580018E-23
      4.08187151236477E-09   4.08813506320883E-09  -1.18418262707464E-18  -6.28371094062557E-02  -6.28371094010722E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.18357142805824E-09   0.00000000000000E+00  -5.18357142805824E-09
      4.45414863618451E-18  -5.54809080881071E-01  -5.55154293712829E-01   0.00000000000000E+00   2.00604346547322E-10
     -1.78874083451323E-22   8.94832018301932E-10   1.09543636484907E-09  -3.26996600910987E-18
      3.91934823015062E-09
      0.00000000000000E+00  -4.78814168483999E-12   0.00000000000000E+00   6.19594282471066E-12  -4.54093143204458E-23
      4.78190926849338E-09   4.78810521131804E-09  -1.15495371797378E-18  -7.89622143247883E-02  -7.89622143185819E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.20636488652303E-09   0.00000000000000E+00  -6.20636488652303E-09
      4.41597367366532E-18  -5.61594673461105E-01  -5.62041612391978E-01   0.00000000000000E+00   2.44855712091236E-10
     -1.76836662946955E-22   1.17340396311376E-09   1.41825967520482E-09  -3.26101995569154E-18
      3.92350011296312E-09
      0.00000000000000E+00  -5.32938272120395E-12   0.00000000000000E+00   7.01342197383409E-12  -4.50014199795015E-23
      5.32235774489278E-09   5.32937116686657E-09  -1.13315845860504E-18  -9.07690134751381E-02  -9.07690134681793E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.95884106641511E-09   0.00000000000000E+00  -6.95884106641511E-09
      4.38708138104675E-18  -5.66204327400015E-01  -5.66717822060222E-01   0.00000000000000E+00   2.71892902870872E-10
     -1.75293033006587E-22   1.35757699667746E-09   1.62946989954815E-09  -3.25392292244172E-18
      3.92630263386156E-09
      0.00000000000000E+00  -5.69161836475043E-12   0.00000000000000E+00   6.96875247977090E-12  -4.47125877069468E-23
      5.68461501505604E-09   5.69158376753577E-09  -1.11754828274100E-18  -9.91104858073010E-02  -9.91104857998608E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.44017747562768E-09   0.00000000000000E+00  -7.44017747562768E-09
      4.36623012818322E-18  -5.69320946961554E-01  -5.69871980535438E-01   0.00000000000000E+00   2.86583590129089E-10
     -1.74185806163505E-22   1.46201011796323E-09   1.74859370809214E-09  -3.24868184544222E-18
      3.93008603707445E-09
      0.00000000000000E+00  -6.08434646104982E-12   0.00000000000000E+00   5.72667850448934E-12  -4.43084490612512E-23
      6.07861594576991E-09   6.08434262427435E-09  -1.09528590203279E-18  -1.10835679556558E-01  -1.10835679548641E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.91717368075170E-09   0.00000000000000E+00  -7.91717368075170E-09
      4.33627626784245E-18  -5.73514135258721E-01  -5.74091719652656E-01   0.00000000000000E+00   2.99671776325842E-10
     -1.72608681018188E-22   1.53315928015221E-09   1.83283105647788E-09  -3.24099036580967E-18
      3.93519363141185E-09
      0.00000000000000E+00  -6.53071188387840E-12   0.00000000000000E+00   4.88715868409423E-12  -4.37237166095812E-23
      6.52581856623015E-09   6.53070572491420E-09  -1.06379533800361E-18  -1.27095173629630E-01  -1.27095173621288E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.34222785750890E-09   0.00000000000000E+00  -8.34222785750890E-09
      4.29366755207612E-18  -5.79086021332814E-01  -5.79656908480343E-01   0.00000000000000E+00   3.05838101641129E-10
     -1.70409334604775E-22   1.50568403095372E-09   1.81152213259468E-09  -3.22987221407251E-18
      3.94208888376734E-09
      0.00000000000000E+00  -7.13789744155736E-12   0.00000000000000E+00   4.86696986495022E-12  -4.27348698517546E-23
      7.13302655714900E-09   7.13789352701390E-09  -1.01982647441838E-18  -1.49196380528367E-01  -1.49196380519693E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.67361563543365E-09   0.00000000000000E+00  -8.67361563543365E-09
      4.23386078343525E-18  -5.86303471204947E-01  -5.86787497198536E-01   0.00000000000000E+00   3.02608185313003E-10
     -1.67424783067780E-22   1.23311392310667E-09   1.53572210841951E-09  -3.21403430901687E-18
      3.95139747444726E-09
      0.00000000000000E+00  -8.34492097793867E-12   0.00000000000000E+00   6.83958382875113E-12  -4.01159883676464E-23
      8.33804960272833E-09   8.34488918655705E-09  -9.59538801686146E-19  -1.78456782323136E-01  -1.78456782314221E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.91512035956486E-09   0.00000000000000E+00  -8.91512035956486E-09
      4.15087357714588E-18  -5.95026095567562E-01  -5.95206018158104E-01   0.00000000000000E+00   2.91335166812854E-10
     -1.63463155165706E-22   2.78896006195141E-10   5.70231173007831E-10  -3.19133477545973E-18
      3.96396407186514E-09
      0.00000000000000E+00  -1.17645760783865E-11   0.00000000000000E+00   1.37602704380295E-11  -2.89028903673772E-23
      1.17507964659963E-08   1.17645567364343E-08  -8.79641242261824E-19  -2.15594912386310E-01  -2.15594912377166E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.14446305514318E-09   0.00000000000000E+00  -9.14446305514318E-09
      4.03595879132916E-18  -6.02908591446506E-01  -6.02083617754875E-01   0.00000000000000E+00   2.80720428386869E-10
     -1.58139847104217E-22  -2.90081410967784E-09  -2.62009368129113E-09  -3.15631754906733E-18
      3.98092897837929E-09
      0.00000000000000E+00  -2.21343061328023E-11   0.00000000000000E+00   3.03793595294900E-11   1.86563871945936E-23
      2.21038750113934E-08   2.21342543709229E-08  -7.82961025456981E-19  -2.58599963923247E-01  -2.58599963913701E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.54620231044296E-09   0.00000000000000E+00  -9.54620231044296E-09
      3.87400836156737E-18  -5.98239520336312E-01  -5.94274662960381E-01   0.00000000000000E+00   2.91866382735820E-10
     -1.50171782691731E-22  -1.28799184432156E-08  -1.25880520604800E-08  -3.09104733611039E-18
      4.00092897837929E-09
      0.00000000000000E+00  -4.15959304128656E-11   0.00000000000000E+00   4.82397844194284E-11   1.11691841256568E-22
      4.15476463489271E-08   4.15958861333467E-08  -6.96395315545978E-19  -2.96432818043828E-01  -2.96432818033628E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02002574755018E-08   0.00000000000000E+00  -1.02002574755018E-08
      3.67000321205733E-18  -5.58697569198046E-01  -5.48807833113306E-01   0.00000000000000E+00   3.18473060074279E-10
     -1.38236517503018E-22  -3.17141017179189E-08  -3.13956286578448E-08  -2.97360789651135E-18
      4.02092897837929E-09
      0.00000000000000E+00  -5.95355037079258E-11   0.00000000000000E+00   4.45901371541288E-11   1.96394210271683E-22
      5.94908866249647E-08   5.95354767621190E-08  -6.39828121167729E-19  -3.21986953155455E-01  -3.21986953144607E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08473006976697E-08   0.00000000000000E+00  -1.08473006976697E-08
      3.45305719810394E-18  -4.82700196828193E-01  -4.67362130313325E-01   0.00000000000000E+00   3.04936005452495E-10
     -1.23018342735971E-22  -4.89931120699019E-08  -4.86881760644495E-08  -2.81322907693621E-18
      4.04092897837929E-09
      0.00000000000000E+00  -6.60821047313411E-11   0.00000000000000E+00   1.63811137381493E-11   2.26878624624955E-22
      6.60657322041722E-08   6.60821133179106E-08  -6.09723578500130E-19  -3.37225169450421E-01  -3.37225169439009E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14122450535982E-08   0.00000000000000E+00  -1.14122450535982E-08
      3.22481229703197E-18  -3.74848450472242E-01  -3.57625097091332E-01   0.00000000000000E+00   2.59775167045869E-10
     -1.06580641708449E-22  -5.49296434313581E-08  -5.46698682643123E-08  -2.61508871853184E-18
      4.06092897837929E-09
      0.00000000000000E+00  -5.92070669276717E-11   0.00000000000000E+00  -1.69955934026995E-11   1.96778683605520E-22
      5.92240374599587E-08   5.92070418665562E-08  -6.00012296199274E-19  -3.44618720037010E-01  -3.44618720025139E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18704591071487E-08   0.00000000000000E+00  -1.18704591071487E-08
      2.98740311488900E-18  -2.49629515775573E-01  -2.34715955532426E-01   0.00000000000000E+00   1.95790095496000E-10
     -8.98976182724545E-23  -4.75323728549034E-08  -4.73365827594075E-08  -2.38739081868973E-18
      4.08092897837929E-09
      0.00000000000000E+00  -5.11743262115014E-11   0.00000000000000E+00  -1.99257465953667E-11   1.54919557138782E-22
      5.11942690628644E-08   5.11743433162692E-08  -5.92374908032906E-19  -3.51293042404293E-01  -3.51293042392407E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18856379513948E-08   0.00000000000000E+00  -1.18856379513948E-08
      2.74969035586110E-18  -1.41000787837106E-01  -1.28622474860148E-01   0.00000000000000E+00   1.09545954026529E-10
     -7.73190313709589E-23  -3.93982513189007E-08  -3.92887053648743E-08  -2.15731544782820E-18
      4.10092897837929E-09
      0.00000000000000E+00  -4.44129921924949E-11   0.00000000000000E+00  -1.67524406678521E-11   1.25062552648019E-22
      4.44297574035715E-08   4.44130049629038E-08  -5.74883176256847E-19  -3.61508634119778E-01  -3.61508634108201E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15768498609013E-08   0.00000000000000E+00  -1.15768498609013E-08
      2.51815335864308E-18  -6.32686387395756E-02  -5.29231467882355E-02   0.00000000000000E+00   5.82495561894051E-11
     -3.75865716438511E-23  -3.28944046581920E-08  -3.28361551020026E-08  -1.94327018238623E-18
      4.10342897837929E-09
      0.00000000000000E+00  -4.23240754894469E-11   0.00000000000000E+00  -4.09013809470169E-11   1.21029196196211E-22
      4.23649914292291E-08   4.23240900482822E-08  -5.72235646199001E-19  -3.62876802780209E-01  -3.62876802768680E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15284039565283E-08   0.00000000000000E+00  -1.15284039565283E-08
      2.48933234875176E-18  -5.48206768599817E-02  -4.51180550773505E-02   0.00000000000000E+00   6.85689777263663E-11
     -2.35295528895766E-23  -3.08642550694795E-08  -3.07956860917531E-08  -1.91709670255275E-18
      4.10680397837929E-09
      0.00000000000000E+00  -3.99796467274876E-11   0.00000000000000E+00  -3.44714124839604E-11   1.17633623020602E-22
      4.00140706817255E-08   3.99795992692416E-08  -5.66845548346237E-19  -3.65365287123428E-01  -3.65365287112125E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13028302071320E-08   0.00000000000000E+00  -1.13028302071320E-08
      2.45118529680269E-18  -4.58529371746500E-02  -3.68178967793191E-02   0.00000000000000E+00   5.41954418592830E-11
     -9.05337483443421E-25  -2.87309645039691E-08  -2.86767690621098E-08  -1.88433974845645E-18
      4.11136022837929E-09
      0.00000000000000E+00  -3.74660399595920E-11   0.00000000000000E+00  -2.73471615534964E-11   1.17144940978100E-22
      3.74934240267445E-08   3.74660768651912E-08  -5.56798723657039E-19  -3.69685574258616E-01  -3.69685574247621E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09943415681215E-08   0.00000000000000E+00  -1.09943415681215E-08
      2.40109232803293E-18  -3.72337848111324E-02  -2.88934598146074E-02   0.00000000000000E+00   4.19125228932373E-11
      2.98333705143431E-23  -2.65136478199629E-08  -2.64717352970696E-08  -1.84429360437590E-18
      4.11751116587929E-09
      0.00000000000000E+00  -3.51251931423837E-11   0.00000000000000E+00  -1.88488943469202E-11   1.21377666042680E-22
      3.51440536710000E-08   3.51252047766532E-08  -5.40069086764818E-19  -3.76612137073398E-01  -3.76612137062715E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06832950416407E-08   0.00000000000000E+00  -1.06832950416407E-08
      2.33538004793774E-18  -2.98437205352456E-02  -2.21429103981494E-02   0.00000000000000E+00   2.99128686191689E-11
      6.68568384490009E-23  -2.44718226036318E-08  -2.44419097350125E-08  -1.79531096117292E-18
      4.12581493150429E-09
      0.00000000000000E+00  -3.32789302350380E-11   0.00000000000000E+00  -1.09880351773084E-11   1.30329086076629E-22
      3.32898683076616E-08   3.32788802724844E-08  -5.14981794578816E-19  -3.86820852258663E-01  -3.86820852248231E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04320043700624E-08   0.00000000000000E+00  -1.04320043700624E-08
      2.24875512864977E-18  -2.40779659345760E-02  -1.68796846484815E-02   0.00000000000000E+00   1.97957086307585E-11
      1.08013136182543E-22  -2.28666716110528E-08  -2.28468759024219E-08  -1.73377333407095E-18
      4.13702501509804E-09
      0.00000000000000E+00  -3.19411197928732E-11   0.00000000000000E+00  -5.86748878231066E-12   1.40428957452463E-22
      3.19469408212590E-08   3.19410733324768E-08  -4.80357171714062E-19  -4.00850190088131E-01  -4.00850190077879E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02518271904900E-08   0.00000000000000E+00  -1.02518271904900E-08
      2.13383128885569E-18  -1.97492780495052E-02  -1.29157165090972E-02   0.00000000000000E+00   1.30571343551816E-11
      1.48130210739581E-22  -2.17023032763421E-08  -2.16892461419868E-08  -1.65347411714163E-18
      4.15215862794960E-09
      0.00000000000000E+00  -3.08255736147506E-11   0.00000000000000E+00  -3.60055388238964E-12   1.43076659036313E-22
      3.08291996213048E-08   3.08255990674226E-08  -4.35272461072993E-19  -4.19220616126055E-01  -4.19220616115951E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01043773724203E-08   0.00000000000000E+00  -1.01043773724203E-08
      1.98091555359540E-18  -1.64339493146597E-02  -9.90537099069975E-03   0.00000000000000E+00   9.38775223961268E-12
      1.74657619856267E-22  -2.07306094472421E-08  -2.07212216950023E-08  -1.54564309252240E-18
      4.17215862794960E-09
      0.00000000000000E+00  -2.95664741123726E-11   0.00000000000000E+00  -3.06997729216100E-12   1.26736904537066E-22
      2.95695458781432E-08   2.95664759008512E-08  -3.79897382047020E-19  -4.42094886450264E-01  -4.42094886440323E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94165718544687E-09   0.00000000000000E+00  -9.94165718544687E-09
      1.78208240988646E-18  -1.37952343722978E-02  -7.61208870618634E-03   0.00000000000000E+00   7.61042345000347E-12
      1.67994116966000E-22  -1.96324291388546E-08  -1.96248187154044E-08  -1.40218502783944E-18
      4.19215862794960E-09
      0.00000000000000E+00  -2.83611956259982E-11   0.00000000000000E+00  -2.94202456952385E-12   9.68600185352292E-23
      2.83641631511667E-08   2.83612211265972E-08  -3.28692739023590E-19  -4.63605849335150E-01  -4.63605849325355E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.79493940031850E-09   0.00000000000000E+00  -9.79493940031850E-09
      1.58618362188009E-18  -1.20460730846283E-02  -6.19643235903666E-03   0.00000000000000E+00   6.59360299858655E-12
      1.31637613379969E-22  -1.85728753292774E-08  -1.85662817262786E-08  -1.25749088285650E-18
      4.21215862794960E-09
      0.00000000000000E+00  -2.73847942247450E-11   0.00000000000000E+00  -2.38218989758557E-12   6.49109356920541E-23
      2.73871232800092E-08   2.73847410901117E-08  -2.80890376297899E-19  -4.84037321110878E-01  -4.84037321101212E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66612254498092E-09   0.00000000000000E+00  -9.66612254498092E-09
      1.39286117098047E-18  -1.08595559499223E-02  -5.27698208371229E-03   0.00000000000000E+00   5.45547860302623E-12
      8.66878663089324E-23  -1.77240740237340E-08  -1.77186185451308E-08  -1.11197079468257E-18
      4.23215862794961E-09
      0.00000000000000E+00  -2.65513032345867E-11   0.00000000000000E+00  -2.03195600317016E-12   3.88965068568175E-23
      2.65532973378834E-08   2.65512653818803E-08  -2.36231261490001E-19  -5.03468601999783E-01  -5.03468601990275E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.50787803299872E-09   0.00000000000000E+00  -9.50787803299872E-09
      1.20270361032050E-18  -1.00103057637049E-02  -4.64047203060665E-03   0.00000000000000E+00   4.56663377974623E-12
      4.84071625154273E-23  -1.70479539826614E-08  -1.70433873488817E-08  -9.66472348830496E-19
      4.25215862794961E-09
      0.00000000000000E+00  -2.65692129583422E-11   0.00000000000000E+00   6.61835079437470E-14   2.18218345619109E-23
      2.65691862158688E-08   2.65692523993767E-08  -1.91812529056458E-19  -5.23224772400853E-01  -5.23224772390917E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.93593447156737E-09   0.00000000000000E+00  -9.93593447156737E-09
      1.00398492088915E-18  -9.49321509075047E-03  -4.25257802188293E-03   0.00000000000000E+00   3.69901207820298E-12
      2.28495318198951E-23  -1.66370169398875E-08  -1.66333179278093E-08  -8.12172391832691E-19
      4.27215862794961E-09
      0.00000000000000E+00  -2.74875684856802E-11   0.00000000000000E+00   2.29031304004034E-12   1.23758867670455E-23
      2.74852525616935E-08   2.74875428747335E-08  -1.45821673756618E-19  -5.44219258036833E-01  -5.44219258025972E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08610352928534E-08   0.00000000000000E+00  -1.08610352928534E-08
      7.86764215032081E-19  -9.29688307586518E-03  -4.05838889159919E-03   0.00000000000000E+00   2.63020319011175E-12
      8.70640627903066E-24  -1.66291377850703E-08  -1.66265075818801E-08  -6.40942541275463E-19
      4.27465862794961E-09
      0.00000000000000E+00  -2.76749317495836E-11   0.00000000000000E+00   3.70305241840480E-12   1.12350639414167E-23
      2.76712559076366E-08   2.76749589600550E-08  -1.40129358315527E-19  -5.46862105413483E-01  -5.46862105402363E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11193924179188E-08   0.00000000000000E+00  -1.11193924179188E-08
      7.58965733987284E-19  -9.25638820881208E-03  -4.04024551706299E-03   0.00000000000000E+00   3.88794860552916E-12
      6.95028570484313E-24  -1.65594544907420E-08  -1.65555665421365E-08  -6.18836375671758E-19
      4.27803362794961E-09
      0.00000000000000E+00  -2.79260352611090E-11   0.00000000000000E+00   3.70254479364616E-12   9.95245190630365E-24
      2.79223054084938E-08   2.79260079532875E-08  -1.32358797730932E-19  -5.50482885920809E-01  -5.50482885909476E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13335335381141E-08   0.00000000000000E+00  -1.13335335381141E-08
      7.20715058296149E-19  -9.25367005741785E-03  -4.02589783288427E-03   0.00000000000000E+00   2.00032363397043E-12
      5.02827927067579E-24  -1.65944747388067E-08  -1.65924744151727E-08  -5.88356260565218E-19
      4.28258987794961E-09
      0.00000000000000E+00  -2.82893730415019E-11   0.00000000000000E+00   3.96488316865913E-12   8.65418374445375E-24
      2.82853891726137E-08   2.82893540557823E-08  -1.21775328698507E-19  -5.55440667492012E-01  -5.55440667480454E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15580754064181E-08   0.00000000000000E+00  -1.15580754064181E-08
      6.68053577225657E-19  -9.28808234972504E-03  -4.01657636873042E-03   0.00000000000000E+00   1.01421255235706E-12
      3.09992638331607E-24  -1.67322928619167E-08  -1.67312786493643E-08  -5.46278248527149E-19
      4.28874081544961E-09
      0.00000000000000E+00  -2.87918555987643E-11   0.00000000000000E+00   4.06302433146839E-12   7.45092734731254E-24
      2.87877488290020E-08   2.87918118533335E-08  -1.07396411504677E-19  -5.62225565691116E-01  -5.62225565679305E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18111160989468E-08   0.00000000000000E+00  -1.18111160989468E-08
      5.95404140295791E-19  -9.36154715418064E-03  -4.01145667669794E-03   0.00000000000000E+00   4.92950474291882E-13
      1.32908360797701E-24  -1.69811887048608E-08  -1.69806957543865E-08  -4.88007728791114E-19
      4.29289269826211E-09
      0.00000000000000E+00  -2.91444475449040E-11   0.00000000000000E+00   4.22213474692806E-12   6.82079200652228E-24
      2.91402090473454E-08   2.91444311820923E-08  -9.77031210070528E-20  -5.66832908035633E-01  -5.66832908023660E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19722729635576E-08   0.00000000000000E+00  -1.19722729635576E-08
      5.45696665951838E-19  -9.42262947765252E-03  -4.01221449724653E-03   0.00000000000000E+00   1.85457019231717E-13
      4.02059118077318E-25  -1.71723436755539E-08  -1.71721582185347E-08  -4.47993544944785E-19
      4.29849774005898E-09
      0.00000000000000E+00  -2.94626895593281E-11   0.00000000000000E+00   2.84464205418982E-12   6.20089287071352E-24
      2.94598847230196E-08   2.94627293650738E-08  -8.47150879344803E-20  -5.73039398568106E-01  -5.73039398556047E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20594310875763E-08   0.00000000000000E+00  -1.20594310875763E-08
      4.78103050659439E-19  -9.48151336752956E-03  -3.99827271804835E-03   0.00000000000000E+00   3.79940008578365E-13
     -4.50628507708404E-25  -1.74036782175061E-08  -1.74032982774975E-08  -3.93387962724959E-19
      4.30606454648476E-09
      0.00000000000000E+00  -2.95132041647922E-11   0.00000000000000E+00   3.69747773782650E-13   5.59755078953128E-24
      2.95128264124570E-08   2.95131961602308E-08  -6.77205122673178E-20  -5.81212761163454E-01  -5.81212761151534E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19200029096515E-08   0.00000000000000E+00  -1.19200029096515E-08
      3.87906696047357E-19  -9.48387132557043E-03  -3.94080001327402E-03   0.00000000000000E+00   1.07385219432634E-12
     -1.15025676790940E-24  -1.75942671027733E-08  -1.75931932505790E-08  -3.20186183780038E-19
      4.31627973515957E-09
      0.00000000000000E+00  -2.88600043937723E-11   0.00000000000000E+00  -3.12282428353237E-12   4.97214448907235E-24
      2.88631493685167E-08   2.88600265442332E-08  -4.67359020196348E-20  -5.91378652569976E-01  -5.91378652558803E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11721266126497E-08   0.00000000000000E+00  -1.11721266126497E-08
      2.73781314800334E-19  -9.37311909388481E-03  -3.80020769034638E-03   0.00000000000000E+00   1.63087788738378E-12
     -1.66500963600355E-24  -1.76895308094709E-08  -1.76878999315835E-08  -2.27045412780698E-19
      4.33007023987055E-09
      0.00000000000000E+00  -2.60875791564259E-11   0.00000000000000E+00  -9.89695000124553E-12   4.14894784826703E-24
      2.60974876164557E-08   2.60875906664545E-08  -2.60744331480812E-20  -6.01389549334059E-01  -6.01389549325670E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.38881830040080E-09   0.00000000000000E+00  -8.38881830040080E-09
      1.58095276509048E-19  -9.04765179902490E-03  -3.47131350585591E-03   0.00000000000000E+00   1.47239093312607E-12
     -2.03182279831896E-24  -1.77002447569869E-08  -1.76987723660537E-08  -1.32020843360968E-19
      4.34868742123038E-09
      0.00000000000000E+00  -1.63055635754011E-11   0.00000000000000E+00  -2.59062342665290E-11   2.49486380593116E-24
      1.63315049017884E-08   1.63055986675219E-08  -3.11962724791891E-20  -5.98306559804028E-01  -5.98306559805410E-01
      0.00000000000000E+00   0.00000000000000E+00   1.38171196201875E-09   0.00000000000000E+00   1.38171196201875E-09
      1.83818858693000E-19  -8.16989975922146E-03  -2.59717132596878E-03   0.00000000000000E+00  -1.92386119245375E-13
     -2.43347621499831E-24  -1.76871182434214E-08  -1.76873106295407E-08  -1.52622586213810E-19
      4.36868742123039E-09
      0.00000000000000E+00   1.73963116744776E-12   0.00000000000000E+00  -4.44734274381064E-11  -6.17215473902186E-25
     -1.69517001144737E-09  -1.73964343888548E-09  -1.04955277997072E-19  -5.61684464390233E-01  -5.61684464409660E-01
      0.00000000000000E+00   0.00000000000000E+00   1.94268433151813E-08   0.00000000000000E+00   1.94268433151813E-08
      5.72355724996625E-19  -6.63720703154280E-03  -1.06451250156174E-03   0.00000000000000E+00  -3.65288524437799E-12
     -3.64262159258014E-24  -1.76835469910514E-08  -1.76871998762958E-08  -4.67400446999553E-19
      4.38868742123039E-09
      0.00000000000000E+00   1.88038322721830E-11   0.00000000000000E+00  -4.21739513600725E-11  -7.33725723636076E-24
     -1.87616467267737E-08  -1.88038206781338E-08  -2.66081469013745E-19  -4.88371156086416E-01  -4.88371156122866E-01
      0.00000000000000E+00   0.00000000000000E+00   3.64504045100204E-08   0.00000000000000E+00   3.64504045100204E-08
      1.30136381519703E-18  -4.93198375023383E-03   6.27911303604007E-04   0.00000000000000E+00  -8.92765609660889E-12
     -1.10523453001869E-23  -1.76376561757899E-08  -1.76465838318866E-08  -1.03528234618329E-18
      4.40868742123039E-09
      0.00000000000000E+00   2.48023957486810E-11   0.00000000000000E+00  -1.50982525242524E-11  -2.85029796783172E-23
     -2.47873210327367E-08  -2.48024192852610E-08  -5.25925639673906E-19  -3.82741486814921E-01  -3.82741486857348E-01
      0.00000000000000E+00   0.00000000000000E+00   4.24261248414462E-08   0.00000000000000E+00   4.24261248414462E-08
      2.14988631202595E-18  -3.02364496768692E-03   2.52903313564769E-03   0.00000000000000E+00  -1.99408963554447E-11
     -4.91073591859633E-23  -1.76037646598296E-08  -1.76237055561851E-08  -1.62396067235205E-18
      4.42868742123039E-09
      0.00000000000000E+00   1.73170496662675E-11   0.00000000000000E+00   1.79075465512631E-11  -4.17324337779745E-23
     -1.73349896002913E-08  -1.73170820537401E-08  -8.25870076885093E-19  -2.57747824871986E-01  -2.57747824906480E-01
      0.00000000000000E+00   0.00000000000000E+00   3.44946850467705E-08   0.00000000000000E+00   3.44946850467705E-08
      2.83978001296137E-18  -3.95240065988088E-03   1.45970767672167E-03   0.00000000000000E+00  -4.53958004296001E-11
     -7.74700255504433E-23  -1.71322071926007E-08  -1.71776029930303E-08  -2.01390993607627E-18
      4.44868742123039E-09
      0.00000000000000E+00   1.12768805238146E-11   0.00000000000000E+00   1.41558425160302E-11  -4.50188920153094E-23
     -1.12910814841148E-08  -1.12769256415988E-08  -1.04947872037095E-18  -1.47593820784916E-01  -1.47593820810106E-01
      0.00000000000000E+00   0.00000000000000E+00   2.51904520730226E-08   0.00000000000000E+00   2.51904520730226E-08
      3.34358905442182E-18  -2.70882178341736E-02  -2.27045232222724E-02   0.00000000000000E+00  -8.66639041252889E-11
     -9.01311207120477E-23  -1.38268625272984E-08  -1.39135264314238E-08  -2.29411033405087E-18
      4.45868742123039E-09
      0.00000000000000E+00   8.70945273991535E-12   0.00000000000000E+00   1.17645160226252E-11  -4.63023020911620E-23
     -8.72122586798518E-09  -8.70946135196260E-09  -1.13602813629198E-18  -1.00138157877725E-01  -1.00138157898323E-01
      0.00000000000000E+00   0.00000000000000E+00   2.05980848242647E-08   0.00000000000000E+00   2.05980848242647E-08
      3.54956990266446E-18  -4.50631451403919E-02  -4.13174127767339E-02   0.00000000000000E+00  -1.34988793011294E-10
     -9.68917888540522E-23  -1.17536346792908E-08  -1.18886234723022E-08  -2.41354176637248E-18
      4.46206242123039E-09
      0.00000000000000E+00   7.68639421216071E-12   0.00000000000000E+00   1.39684282922000E-11  -4.66785052106644E-23
     -7.70029158359746E-09  -7.68632315530531E-09  -1.16176696443022E-18  -8.54557753910585E-02  -8.54557754098115E-02
      0.00000000000000E+00   0.00000000000000E+00   1.87529992083389E-08   0.00000000000000E+00   1.87529992083389E-08
      3.61286127499261E-18  -5.19716984733642E-02  -4.84849211078187E-02   0.00000000000000E+00  -1.58362643357776E-10
     -9.91968525693358E-23  -1.09083134096755E-08  -1.10666760530333E-08  -2.45109431056239E-18
      4.46661867123039E-09
      0.00000000000000E+00   6.44446967564053E-12   0.00000000000000E+00   1.25899345445233E-11  -4.71041878644672E-23
     -6.45701493534458E-09  -6.44442500080010E-09  -1.19082408584961E-18  -6.84970431637267E-02  -6.84970431803325E-02
      0.00000000000000E+00   0.00000000000000E+00   1.66057606808465E-08   0.00000000000000E+00   1.66057606808465E-08
      3.68852127209471E-18  -6.24904796638283E-02  -5.92889454121809E-02   0.00000000000000E+00  -1.68320996301016E-10
     -1.02208348388634E-22  -9.99301468374506E-09  -1.01613356800462E-08  -2.49769718624510E-18
      4.47276960873039E-09
      0.00000000000000E+00   4.80880675071169E-12   0.00000000000000E+00   1.24130429852644E-11  -4.75088538017562E-23
     -4.82123210677499E-09  -4.80881906378977E-09  -1.21996432551832E-18  -5.10366276325467E-02  -5.10366276463447E-02
      0.00000000000000E+00   0.00000000000000E+00   1.37980058550193E-08   0.00000000000000E+00   1.37980058550193E-08
      3.77339194373357E-18  -7.86577773652569E-02  -7.58255511901704E-02   0.00000000000000E+00  -1.73236524918489E-10
     -1.06030317250000E-22  -8.81595026631106E-09  -8.98918679122965E-09  -2.55342761821524E-18
      4.47692149154289E-09
      0.00000000000000E+00   3.63383702761580E-12   0.00000000000000E+00   1.33828907391814E-11  -4.76930898427116E-23
     -3.64720197736744E-09  -3.63381908662830E-09  -1.23475029378214E-18  -4.19808434750952E-02  -4.19808434868547E-02
      0.00000000000000E+00   0.00000000000000E+00   1.17594412054285E-08   0.00000000000000E+00   1.17594412054285E-08
      3.82221576555899E-18  -9.04825526499659E-02  -8.79224053433388E-02   0.00000000000000E+00  -1.76807281170098E-10
     -1.08493732359999E-22  -7.94881483763031E-09  -8.12562211880052E-09  -2.58746547177685E-18
      4.47972401244132E-09
      0.00000000000000E+00   2.88842514043951E-12   0.00000000000000E+00   1.26702881855899E-11  -4.77839545318835E-23
     -2.90113578906574E-09  -2.88846550088019E-09  -1.24264073215749E-18  -3.70697252970797E-02  -3.70697253075328E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04531029873483E-08   0.00000000000000E+00   1.04531029873483E-08
      3.85151080513456E-18  -9.88324874462297E-02  -9.64490867685886E-02   0.00000000000000E+00  -1.78260300094010E-10
     -1.10099401832734E-22  -7.38637718637442E-09  -7.56463748646854E-09  -2.60887007297707E-18
      4.48350741565421E-09
      0.00000000000000E+00   2.12611382161704E-12   0.00000000000000E+00   9.63897026797103E-12  -4.78702601957421E-23
     -2.13571160525831E-09  -2.12607263499038E-09  -1.25040771392549E-18  -3.21259613131109E-02  -3.21259613222106E-02
      0.00000000000000E+00   0.00000000000000E+00   9.09970097896521E-09   0.00000000000000E+00   9.09970097896521E-09
      3.88593864305472E-18  -1.10565068949609E-01  -1.08367877105982E-01   0.00000000000000E+00  -1.77810401854472E-10
     -1.12168334498116E-22  -6.79581794212008E-09  -6.97362834397466E-09  -2.63553092912923E-18
      4.48861500999162E-09
      0.00000000000000E+00   1.44545247417206E-12   0.00000000000000E+00   6.37748439016045E-12  -4.79453305521461E-23
     -1.45182248114783E-09  -1.44544499675772E-09  -1.25741793068574E-18  -2.75047055083424E-02  -2.75047055161760E-02
      0.00000000000000E+00   0.00000000000000E+00   7.83361882269759E-09   0.00000000000000E+00   7.83361882269759E-09
      3.92594959019490E-18  -1.26831110535792E-01  -1.24818377407580E-01   0.00000000000000E+00  -1.78958239716675E-10
     -1.14838192035644E-22  -6.20921558622339E-09  -6.38817382594018E-09  -2.66853165950915E-18
      4.49551026234711E-09
      0.00000000000000E+00   9.18447372075268E-13   0.00000000000000E+00   3.65296640274722E-12  -4.80057295621803E-23
     -9.22125459123528E-10  -9.18472492720829E-10  -1.26325335518687E-18  -2.34370434623518E-02  -2.34370434691071E-02
      0.00000000000000E+00   0.00000000000000E+00   6.75534772192880E-09   0.00000000000000E+00   6.75534772192880E-09
      3.97252941748670E-18  -1.48939490936917E-01  -1.47100454743132E-01   0.00000000000000E+00  -1.83089994465106E-10
     -1.18308391713338E-22  -5.65378523474289E-09  -5.83687522920811E-09  -2.70927606229984E-18
      4.50481885302702E-09
      0.00000000000000E+00   5.60344741703121E-13   0.00000000000000E+00   1.83431442297046E-12  -4.80506928993214E-23
     -5.62153692796888E-10  -5.60319378373965E-10  -1.26780999673013E-18  -1.99732031133255E-02  -1.99732031191890E-02
      0.00000000000000E+00   0.00000000000000E+00   5.86354384043527E-09   0.00000000000000E+00   5.86354384043527E-09
      4.02711074703105E-18  -1.78210765174404E-01  -1.76539865199852E-01   0.00000000000000E+00  -1.90421289379598E-10
     -1.22839267434497E-22  -5.11280317268136E-09  -5.30322446206108E-09  -2.75930075030093E-18
      4.51738545044491E-09
      0.00000000000000E+00   3.40560285565509E-13   0.00000000000000E+00   8.32469176233284E-13  -4.80808630043213E-23
     -3.41360897004992E-10  -3.40528427828806E-10  -1.27122335245542E-18  -1.70430054291658E-02  -1.70430054342093E-02
      0.00000000000000E+00   0.00000000000000E+00   5.04349518213467E-09   0.00000000000000E+00   5.04349518213467E-09
      4.09049032056399E-18  -2.15369998453116E-01  -2.13888220094456E-01   0.00000000000000E+00  -1.98013213886218E-10
     -1.28665989247120E-22  -4.50495354041954E-09  -4.70296675430589E-09  -2.81926696810857E-18
      4.53435035695906E-09
      0.00000000000000E+00   2.21437661407347E-13   0.00000000000000E+00   3.34494055820118E-13  -4.80993489077587E-23
     -2.21730806503481E-10  -2.21396312447709E-10  -1.27384735887592E-18  -1.45231890785747E-02  -1.45231890826680E-02
      0.00000000000000E+00   0.00000000000000E+00   4.09326242748078E-09   0.00000000000000E+00   4.09326242748078E-09
      4.15993213498407E-18  -2.58417292938430E-01  -2.57197368397388E-01   0.00000000000000E+00  -1.93995755639607E-10
     -1.35638833308640E-22  -3.67787035939334E-09  -3.87186611503308E-09  -2.88608477610815E-18
      4.55435035695906E-09
      0.00000000000000E+00   1.68810626987434E-13   0.00000000000000E+00   1.25691998854152E-13  -4.81098337814854E-23
     -1.68915402148324E-10  -1.68789710149518E-10  -1.27592622191470E-18  -1.25488561726561E-02  -1.25488561756642E-02
      0.00000000000000E+00   0.00000000000000E+00   3.00817182612631E-09   0.00000000000000E+00   3.00817182612631E-09
      4.22009557150660E-18  -2.96304126006186E-01  -2.95409507313883E-01   0.00000000000000E+00  -1.65247974124198E-10
     -1.42017067816380E-22  -2.67413414185250E-09  -2.83938211597684E-09  -2.94416934959190E-18
      4.57435035695906E-09
      0.00000000000000E+00   1.43553324255364E-13   0.00000000000000E+00   6.17626674208608E-14  -4.81140217745853E-23
     -1.43591790838434E-10  -1.43530028171062E-10  -1.27752578865594E-18  -1.12060680959892E-02  -1.12060680980688E-02
      0.00000000000000E+00   0.00000000000000E+00   2.07954396881958E-09   0.00000000000000E+00   2.07954396881958E-09
      4.26168645088299E-18  -3.21903947796854E-01  -3.21293957884399E-01   0.00000000000000E+00  -1.22544389798191E-10
     -1.46439416838519E-22  -1.81346955085017E-09  -1.93601394064851E-09  -2.98416066222704E-18
      4.59435035695906E-09
      0.00000000000000E+00   1.31889042630008E-13   0.00000000000000E+00   2.95785077444580E-14  -4.81155580763767E-23
     -1.31924516892293E-10  -1.31894938384597E-10  -1.27890973787784E-18  -1.02654813844367E-02  -1.02654813857868E-02
      0.00000000000000E+00   0.00000000000000E+00   1.35008023097822E-09   0.00000000000000E+00   1.35008023097822E-09
      4.28868805550255E-18  -3.37182380279668E-01  -3.36798564000715E-01   0.00000000000000E+00  -7.62533316604233E-11
     -1.49086450610556E-22  -1.14193196093309E-09  -1.21818529259366E-09  -3.00977831762471E-18
      4.61435035695906E-09
      0.00000000000000E+00   1.24082239967369E-13   0.00000000000000E+00   2.09537149245789E-14  -4.81150394491998E-23
     -1.24104779526079E-10  -1.24083825811202E-10  -1.28014829206575E-18  -9.61274620775492E-03  -9.61274620856361E-03
      0.00000000000000E+00   0.00000000000000E+00   8.08687246645739E-10   0.00000000000000E+00   8.08687246645739E-10
      4.30486180043547E-18  -3.44593605433678E-01  -3.44377912126788E-01   0.00000000000000E+00  -3.59033615355767E-11
     -1.50315588337389E-22  -6.48700059298766E-10  -6.84603420834493E-10  -3.02471350836971E-18
      4.63435035695906E-09
      0.00000000000000E+00   9.25794951051870E-14   0.00000000000000E+00   8.41568875433449E-14  -4.81023129330353E-23
     -9.26971040048578E-11  -9.26129471173625E-11  -1.28076847237628E-18  -9.34883027773319E-03  -9.34883027842685E-03
      0.00000000000000E+00   0.00000000000000E+00   6.93665412666736E-10   0.00000000000000E+00   6.93665412666736E-10
      4.31873510868880E-18  -3.51260511294840E-01  -3.51071143175269E-01   0.00000000000000E+00  -3.10107767673824E-11
     -1.51350565949655E-22  -5.70041688781868E-10  -6.01052465549401E-10  -3.03796663631253E-18
      4.64435035695906E-09
      0.00000000000000E+00   8.01804555821709E-14   0.00000000000000E+00   6.99407322505235E-14  -4.80940800365265E-23
     -8.02658154809116E-11  -8.01958747487092E-11  -1.28095734799347E-18  -9.28006448677121E-03  -9.28006448747834E-03
      0.00000000000000E+00   0.00000000000000E+00   7.07132878101937E-10   0.00000000000000E+00   7.07132878101937E-10
      4.32580643746982E-18  -3.54890434939192E-01  -3.54692910659636E-01   0.00000000000000E+00  -3.41909757315847E-11
     -1.51911511605447E-22  -5.92746027621490E-10  -6.26937003353227E-10  -3.04484908947636E-18
      4.65110035695906E-09
      0.00000000000000E+00   6.10767502430053E-14   0.00000000000000E+00   1.51168364308986E-13  -4.80856001387451E-23
     -6.11879151247756E-11  -6.10367467605148E-11  -1.28095714018642E-18  -9.28946054757198E-03  -9.28946054839924E-03
      0.00000000000000E+00   0.00000000000000E+00   8.27255772943189E-10   0.00000000000000E+00   8.27255772943189E-10
      4.33139041393719E-18  -3.58178489786963E-01  -3.57937079075167E-01   0.00000000000000E+00  -4.76917024839030E-11
     -1.52431611222679E-22  -7.18527323698823E-10  -7.66219026182879E-10  -3.05043327375077E-18
      4.66021285695906E-09
      0.00000000000000E+00   3.50846896132752E-14   0.00000000000000E+00   1.56480275783363E-13  -4.80701203771790E-23
     -3.52421454148531E-11  -3.50856651391178E-11  -1.28072441991835E-18  -9.37265076695903E-03  -9.37265076811068E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15165533270814E-09   0.00000000000000E+00   1.15165533270814E-09
      4.34188487315649E-18  -3.65265030976472E-01  -3.64913228805152E-01   0.00000000000000E+00  -8.05611008804885E-11
     -1.53603815802081E-22  -1.03600856668832E-09  -1.11656966756896E-09  -3.06116045323815E-18
      4.66328832570906E-09
      0.00000000000000E+00   2.06650658716935E-14   0.00000000000000E+00   2.47577947091337E-13  -4.80637612043138E-23
     -2.09505587818401E-11  -2.07029808347968E-11  -1.28060216140718E-18  -9.41720114603623E-03  -9.41720114732435E-03
      0.00000000000000E+00   0.00000000000000E+00   1.28811964087624E-09   0.00000000000000E+00   1.28811964087624E-09
      4.34584644485827E-18  -3.68055244575648E-01  -3.67655911625571E-01   0.00000000000000E+00  -9.59936912919874E-11
     -1.54070893191457E-22  -1.17142296874898E-09  -1.26741666004112E-09  -3.06524428345109E-18
      4.66744020852156E-09
      0.00000000000000E+00   1.53380711136570E-14   0.00000000000000E+00   8.47843132986715E-14  -4.80557555310844E-23
     -1.54384219625134E-11  -1.53536376492628E-11  -1.28041595325298E-18  -9.47209855886821E-03  -9.47209856034645E-03
      0.00000000000000E+00   0.00000000000000E+00   1.47823537723459E-09   0.00000000000000E+00   1.47823537723459E-09
      4.35198390491384E-18  -3.72462335694899E-01  -3.72001413896206E-01   0.00000000000000E+00  -1.14926780434325E-10
     -1.54822510013461E-22  -1.34795495915139E-09  -1.46288173958587E-09  -3.07156795166086E-18
      4.67304525031843E-09
      0.00000000000000E+00   2.43388553599946E-14   0.00000000000000E+00  -5.98165323204058E-14  -4.80469054764429E-23
     -2.42318272313911E-11  -2.42916437637596E-11  -1.28021670104676E-18  -9.49442470536474E-03  -9.49442470701928E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65454069426589E-09   0.00000000000000E+00   1.65454069426589E-09
      4.36125767465983E-18  -3.79088165678901E-01  -3.78574508524080E-01   0.00000000000000E+00  -1.31730469438262E-10
     -1.55978399576814E-22  -1.49851858106353E-09  -1.63024905050195E-09  -3.08104097361307E-18
      4.68061205674421E-09
      0.00000000000000E+00   3.83911001527462E-14   0.00000000000000E+00  -7.69261884562705E-14  -4.80371004532266E-23
     -3.82933588283748E-11  -3.83702850168791E-11  -1.28005799734619E-18  -9.44270432931140E-03  -9.44270433107612E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76472307091808E-09   0.00000000000000E+00   1.76472307091808E-09
      4.37461099253257E-18  -3.88521299271505E-01  -3.87977360941642E-01   0.00000000000000E+00  -1.43559575922926E-10
     -1.57660323184733E-22  -1.58279320997835E-09  -1.72635278590143E-09  -3.09455299518639E-18
      4.69082724541902E-09
      0.00000000000000E+00   5.38210160036107E-14   0.00000000000000E+00  -6.30681883284419E-14  -4.80267227985936E-23
     -5.37548563645124E-11  -5.38179245528888E-11  -1.28000822141186E-18  -9.26916679916902E-03  -9.26916680096716E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79813536293841E-09   0.00000000000000E+00   1.79813536293841E-09
      4.39297928452783E-18  -4.01327616919731E-01  -4.00778017850733E-01   0.00000000000000E+00  -1.50132048366544E-10
     -1.59996345462334E-22  -1.59418539001886E-09  -1.74431743838557E-09  -3.11297106311597E-18
      4.70461775013001E-09
      0.00000000000000E+00   7.77006476775676E-14   0.00000000000000E+00  -7.85835932940992E-14  -4.80191550350358E-23
     -7.76609222740712E-11  -7.77395058674134E-11  -1.28028218730646E-18  -8.83905518898125E-03  -8.83905519076557E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78432266694602E-09   0.00000000000000E+00   1.78432266694602E-09
      4.41758599467227E-18  -4.18097999136939E-01  -4.17560289131902E-01   0.00000000000000E+00  -1.53471163573538E-10
     -1.63151204879266E-22  -1.55311199750487E-09  -1.70658316107857E-09  -3.13730380736581E-18
      4.72323493148984E-09
      0.00000000000000E+00   1.22520879434841E-13   0.00000000000000E+00  -1.19898338339993E-13  -4.80249869979080E-23
     -1.22375426927209E-10  -1.22495325265597E-10  -1.28150278933032E-18  -7.77243222942250E-03  -7.77243223118934E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76684124029879E-09   0.00000000000000E+00   1.76684124029879E-09
      4.45047959847694E-18  -4.39510747955496E-01  -4.38992647331334E-01   0.00000000000000E+00  -1.56578244957133E-10
     -1.67380140640124E-22  -1.48776767007588E-09  -1.64434591503318E-09  -3.16897680914661E-18
      4.74323493148984E-09
      0.00000000000000E+00   1.65320526973548E-13   0.00000000000000E+00  -1.15049569620759E-13  -4.80464667913269E-23
     -1.65211506506286E-10  -1.65326556075955E-10  -1.28368728950099E-18  -6.13308107113463E-03  -6.13308107287732E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74268504284093E-09   0.00000000000000E+00   1.74268504284093E-09
      4.48533329933376E-18  -4.61158168008542E-01  -4.60661172732577E-01   0.00000000000000E+00  -1.60339395894813E-10
     -1.71895729606786E-22  -1.41701909087003E-09  -1.57735848676501E-09  -3.20164600983277E-18
      4.76323493148984E-09
      0.00000000000000E+00   1.71474124366452E-13   0.00000000000000E+00  -2.63149416364347E-14  -4.80681599867891E-23
     -1.71461228709754E-10  -1.71487543651438E-10  -1.28600999067620E-18  -4.44027080305946E-03  -4.44027080473265E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67319204187072E-09   0.00000000000000E+00   1.67319204187072E-09
      4.51879714017117E-18  -4.81702276129527E-01  -4.81229116840485E-01   0.00000000000000E+00  -1.62432159949578E-10
     -1.76340416608383E-22  -1.33927233826951E-09  -1.50170449821926E-09  -3.23278714949497E-18
      4.78323493148984E-09
      0.00000000000000E+00   2.16753579809763E-13   0.00000000000000E+00  -1.30602456455294E-13  -4.81086166534429E-23
     -2.16642540741290E-10  -2.16773143197794E-10  -1.28925000874094E-18  -2.21605341665096E-03  -2.21605341832819E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67722314521022E-09   0.00000000000000E+00   1.67722314521022E-09
      4.55234160307538E-18  -5.01243987797691E-01  -5.00783825303854E-01   0.00000000000000E+00  -1.68368733869399E-10
     -1.80822656847128E-22  -1.29208126814286E-09  -1.46045000201244E-09  -3.26309159433444E-18
      4.80323493148984E-09
      0.00000000000000E+00  -4.96145270395060E-13   0.00000000000000E+00   1.85752062777815E-12  -4.78511745874685E-23
      4.94327015245458E-10   4.96184535873188E-10  -1.27828207967991E-18  -8.59416103216397E-03  -8.59416103264145E-03
      0.00000000000000E+00   0.00000000000000E+00   4.77476260349696E-10   0.00000000000000E+00   4.77476260349696E-10
      4.56189112828237E-18  -5.20819109163346E-01  -5.20512334007316E-01   0.00000000000000E+00  -1.04601006337377E-10
     -1.83545808548522E-22  -8.69059789885301E-10  -9.73660796222862E-10  -3.28360904860246E-18
      4.82323493148984E-09
      0.00000000000000E+00  -2.41661872540444E-12   0.00000000000000E+00   5.12348513817607E-12  -4.68548340174279E-23
      2.41148783390426E-09   2.41661131904239E-09  -1.22921953562276E-18  -3.72908641192226E-02  -3.72908641166148E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.60782199482720E-09   0.00000000000000E+00  -2.60782199482720E-09
      4.50973468838583E-18  -5.41725103958234E-01  -5.41785388652884E-01   0.00000000000000E+00   7.12169868102676E-11
     -1.81671867015123E-22   1.19993688974797E-10   1.91210675784883E-10  -3.28051515276307E-18
      4.84323493148984E-09
      0.00000000000000E+00  -4.25461560640147E-12   0.00000000000000E+00   5.08182183065426E-12  -4.52830404547032E-23
      4.24957977205336E-09   4.25466159388397E-09  -1.14518538011406E-18  -8.41794303065865E-02  -8.41794303012189E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.36763631967123E-09   0.00000000000000E+00  -5.36763631967123E-09
      4.40238196199240E-18  -5.63301901467324E-01  -5.63652649780756E-01   0.00000000000000E+00   2.07602897123933E-10
     -1.76075252177216E-22   9.05371828663478E-10   1.11297472578724E-09  -3.25719658187834E-18
      4.84573493148984E-09
      0.00000000000000E+00  -4.88531341680556E-12   0.00000000000000E+00   1.28239883825129E-11  -4.50362709700642E-23
      4.87249101548924E-09   4.88531500387171E-09  -1.13317075013889E-18  -9.06852504021369E-02  -9.06852503958892E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.24766421615050E-09   0.00000000000000E+00  -6.24766421615050E-09
      4.38676280145203E-18  -5.66018272186671E-01  -5.66447597058020E-01   0.00000000000000E+00   2.37055762925207E-10
     -1.75265927460216E-22   1.12529344935249E-09   1.36234921227752E-09  -3.25359205131314E-18
      4.84910993148984E-09
      0.00000000000000E+00  -5.45015855063184E-12   0.00000000000000E+00   8.87623376080133E-12  -4.46981424206061E-23
      5.44127765486253E-09   5.45015388862329E-09  -1.11520875046977E-18  -1.00282964991597E-01  -1.00282964984553E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.04366963145813E-09   0.00000000000000E+00  -7.04366963145813E-09
      4.36299041644586E-18  -5.69731064800571E-01  -5.70233234527976E-01   0.00000000000000E+00   2.67899189117933E-10
     -1.74021249693126E-22   1.32561655371717E-09   1.59351574283493E-09  -3.24778166597609E-18
      4.85366618148984E-09
      0.00000000000000E+00  -6.01831009499761E-12   0.00000000000000E+00   6.74632169020719E-12  -4.42148139096145E-23
      6.01153403671148E-09   6.01828035840164E-09  -1.08882461598466E-18  -1.14143555432414E-01  -1.14143555424649E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.76506312137387E-09   0.00000000000000E+00  -7.76506312137387E-09
      4.32761084759910E-18  -5.74743414270150E-01  -5.75293888318968E-01   0.00000000000000E+00   2.91184110288888E-10
     -1.72175040008035E-22   1.45559865268353E-09   1.74678276297225E-09  -3.23878623161444E-18
      4.85981711898984E-09
      0.00000000000000E+00  -6.62154632897664E-12   0.00000000000000E+00   5.40097825081067E-12  -4.34894435267000E-23
      6.61618196764630E-09   6.62158294589706E-09  -1.05090407802293E-18  -1.33598310461117E-01  -1.33598310452777E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.33923263135024E-09   0.00000000000000E+00  -8.33923263135024E-09
      4.27631674888570E-18  -5.81376135355856E-01  -5.81917453903705E-01   0.00000000000000E+00   3.01740249068215E-10
     -1.69554998472652E-22   1.41590943638508E-09   1.71764968545313E-09  -3.22541267086278E-18
      4.86812088461484E-09
      0.00000000000000E+00  -7.46908956392770E-12   0.00000000000000E+00   5.53264345574608E-12  -4.20644833463697E-23
      7.46360053296760E-09   7.46913317642331E-09  -9.97754450025929E-19  -1.60008369778947E-01  -1.60008369770217E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.72980223961584E-09   0.00000000000000E+00  -8.72980223961584E-09
      4.20382651713533E-18  -5.89796935394310E-01  -5.90194327160970E-01   0.00000000000000E+00   2.98064809373799E-10
     -1.65994384874229E-22   9.62604253818966E-10   1.26066906319260E-09  -3.20607206710940E-18
      4.87933096820859E-09
      0.00000000000000E+00  -9.43429140595715E-12   0.00000000000000E+00   9.04864049616182E-12  -3.70363159503932E-23
      9.42523359991911E-09   9.43428224041524E-09  -9.25455465584334E-19  -1.94489547529838E-01  -1.94489547520844E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.99435506204078E-09   0.00000000000000E+00  -8.99435506204078E-09
      4.10299904501798E-18  -5.99165477992230E-01  -5.99027221981566E-01   0.00000000000000E+00   2.86001256494999E-10
     -1.61258938371983E-22  -7.25928434869262E-10  -4.39927178374424E-10  -3.17754357943365E-18
      4.89446458106015E-09
      0.00000000000000E+00  -1.56148911516005E-11   0.00000000000000E+00   2.04262191672223E-11  -1.25729329801719E-23
      1.55944695636428E-08   1.56148957828100E-08  -8.32778317138967E-19  -2.36636205635288E-01  -2.36636205625988E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.29920260912876E-09   0.00000000000000E+00  -9.29920260912876E-09
      3.96226851290319E-18  -6.03535962105876E-01  -6.01546907966462E-01   0.00000000000000E+00   2.82917699368189E-10
     -1.54639717039664E-22  -6.59861087304936E-09  -6.31569317368132E-09  -3.12949019576422E-18
      4.91446458106015E-09
      0.00000000000000E+00  -3.20759478670938E-11   0.00000000000000E+00   4.07950236823028E-11   6.61830301580244E-23
      3.20351227989419E-08   3.20759178226243E-08  -7.32435921041816E-19  -2.80654267788621E-01  -2.80654267778745E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.87557089648806E-09   0.00000000000000E+00  -9.87557089648806E-09
      3.76475709497343E-18  -5.80851449810713E-01  -5.73858545043598E-01   0.00000000000000E+00   3.09932115591941E-10
     -1.44011140354045E-22  -2.25102790417280E-08  -2.22003469261363E-08  -3.03232117393161E-18
      4.93446458106015E-09
      0.00000000000000E+00  -5.21307973047806E-11   0.00000000000000E+00   4.97397236062350E-11   1.61587381394078E-22
      5.20809625609621E-08   5.21307022845685E-08  -6.62405824713577E-19  -3.11594287784684E-01  -3.11594287774122E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05619197383907E-08   0.00000000000000E+00  -1.05619197383907E-08
      3.55351870020562E-18  -5.21271425060497E-01  -5.08176548445738E-01   0.00000000000000E+00   3.15964043034017E-10
     -1.30290990784403E-22  -4.18847465892116E-08  -4.15687825461777E-08  -2.89111287549204E-18
      4.95446458106015E-09
      0.00000000000000E+00  -6.48628658449112E-11   0.00000000000000E+00   3.17252961271312E-11   2.20855594112866E-22
      6.48310836472232E-08   6.48628089433505E-08  -6.20516294931162E-19  -3.31404453179002E-01  -3.31404453167845E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11572118227912E-08   0.00000000000000E+00  -1.11572118227912E-08
      3.33037446374979E-18  -4.27466172198070E-01  -4.10546962869946E-01   0.00000000000000E+00   2.81562035934142E-10
     -1.14014800051018E-22  -5.39871591564934E-08  -5.37055971205593E-08  -2.70985816881863E-18
      4.97446458106015E-09
      0.00000000000000E+00  -6.32796462649278E-11   0.00000000000000E+00  -3.82728227348390E-12   2.14991088988050E-22
      6.32834657412002E-08   6.32796384589270E-08  -6.03121511154520E-19  -3.41741663213113E-01  -3.41741663201416E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16973537089905E-08   0.00000000000000E+00  -1.16973537089905E-08
      3.09642738956998E-18  -3.06404192773479E-01  -2.90153230941983E-01   0.00000000000000E+00   2.29245495733274E-10
     -9.76735889087571E-23  -5.18115302456697E-08  -5.15822847499365E-08  -2.49330587841546E-18
      4.99446458106015E-09
      0.00000000000000E+00  -5.44628270272169E-11   0.00000000000000E+00  -2.18497069437136E-11   1.73259122299226E-22
      5.44846584004332E-08   5.44628086934897E-08  -5.96342592574169E-19  -3.48048391028938E-01  -3.48048391017011E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19263361110640E-08   0.00000000000000E+00  -1.19263361110640E-08
      2.85790066734870E-18  -1.87602560634988E-01  -1.74201117281899E-01   0.00000000000000E+00   1.46775874196622E-10
     -8.20362223676594E-23  -4.26832484566221E-08  -4.25364725824256E-08  -2.26155807477453E-18
      5.01446458106015E-09
      0.00000000000000E+00  -4.76732048291505E-11   0.00000000000000E+00  -1.68438624693129E-11   1.35706124979983E-22
      4.76900093439257E-08   4.76731654814566E-08  -5.85540158153085E-19  -3.55927649620753E-01  -3.55927649608980E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17729033571515E-08   0.00000000000000E+00  -1.17729033571515E-08
      2.62244260020567E-18  -9.34470530821948E-02  -8.21362207572833E-02   0.00000000000000E+00   7.68927163375139E-11
     -6.64584852628577E-23  -3.59771548406426E-08  -3.59002621243052E-08  -2.03690244205259E-18
      5.02446458106015E-09
      0.00000000000000E+00  -4.28416205836113E-11   0.00000000000000E+00  -2.38913519050723E-11   1.21443679455853E-22
      4.28654705019153E-08   4.28415791500104E-08  -5.75235434064662E-19  -3.61503675436507E-01  -3.61503675424978E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15288165149573E-08   0.00000000000000E+00  -1.15288165149573E-08
      2.50715443505610E-18  -5.84811012071334E-02  -4.86155685217554E-02   0.00000000000000E+00   5.60384483719069E-11
     -3.10505534143278E-23  -3.13688010834251E-08  -3.13127626350532E-08  -1.93191900099144E-18
      5.02783958106015E-09
      0.00000000000000E+00  -4.05731474193226E-11   0.00000000000000E+00  -3.31289865034885E-11   1.17865280280260E-22
      4.06062970731772E-08   4.05731680866738E-08  -5.70285228494014E-19  -3.63850411663816E-01  -3.63850411652460E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13565855294092E-08   0.00000000000000E+00  -1.13565855294092E-08
      2.46882595889434E-18  -4.89035623854725E-02  -3.96984498826451E-02   0.00000000000000E+00   5.54398222851684E-11
     -1.02107855375328E-23  -2.92720223795493E-08  -2.92165825572641E-08  -1.89854073040033E-18
      5.03239583106015E-09
      0.00000000000000E+00  -3.80387837408181E-11   0.00000000000000E+00  -2.75623382066150E-11   1.16779687322471E-22
      3.80663070886781E-08   3.80387447504716E-08  -5.60836380493315E-19  -3.67973713166117E-01  -3.67973713155054E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10620787400614E-08   0.00000000000000E+00  -1.10620787400614E-08
      2.41842436263494E-18  -3.95011898481094E-02  -3.10017821101161E-02   0.00000000000000E+00   4.36316585861883E-11
      2.05221673418217E-23  -2.70202976689967E-08  -2.69766660104105E-08  -1.85758798214162E-18
      5.03854676856015E-09
      0.00000000000000E+00  -3.55685276888845E-11   0.00000000000000E+00  -1.98861551359285E-11   1.20413886961197E-22
      3.55884061911203E-08   3.55685200359845E-08  -5.44653160240192E-19  -3.74719123027054E-01  -3.74719123016314E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07403228775085E-08   0.00000000000000E+00  -1.07403228775085E-08
      2.35236130788556E-18  -3.13234801203643E-02  -2.35009667045831E-02   0.00000000000000E+00   3.17695152530920E-11
      5.86355313961026E-23  -2.48599666737293E-08  -2.48281971584761E-08  -1.80770814764537E-18
      5.04685053418515E-09
      0.00000000000000E+00  -3.35569442545652E-11   0.00000000000000E+00  -1.19737456286056E-11   1.29230967921022E-22
      3.35689415961781E-08   3.35569678505497E-08  -5.19865932411488E-19  -3.84829882396788E-01  -3.84829882386320E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04685024875880E-08   0.00000000000000E+00  -1.04685024875880E-08
      2.26543331678390E-18  -2.49469226803425E-02  -1.76725266279964E-02   0.00000000000000E+00   2.11831160824606E-11
      1.01618542961497E-22  -2.31096484790442E-08  -2.30884653629616E-08  -1.74556738437241E-18
      5.05806061777890E-09
      0.00000000000000E+00  -3.21012970145631E-11   0.00000000000000E+00  -6.38956196718504E-12   1.39960204088221E-22
      3.21076283752548E-08   3.21012388132878E-08  -4.85242961392856E-19  -3.98861934965491E-01  -3.98861934955219E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02725089579816E-08   0.00000000000000E+00  -1.02725089579816E-08
      2.15027763264738E-18  -2.02374382534731E-02  -1.33599313237025E-02   0.00000000000000E+00   1.37940792389282E-11
      1.44245383878577E-22  -2.18425239345450E-08  -2.18287298553060E-08  -1.66503467125453E-18
      5.07319423063047E-09
      0.00000000000000E+00  -3.09361546783484E-11   0.00000000000000E+00  -3.76324203596920E-12   1.43946389701751E-22
      3.09399038977003E-08   3.09361406556645E-08  -4.39927433171206E-19  -4.17311066733047E-01  -4.17311066722929E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01184138232796E-08   0.00000000000000E+00  -1.01184138232796E-08
      1.99714947517397E-18  -1.67145140529502E-02  -1.01555309697155E-02   0.00000000000000E+00   9.68732126913153E-12
      1.73964327553005E-22  -2.08274141536542E-08  -2.08177268323849E-08  -1.55722204200276E-18
      5.09319423063047E-09
      0.00000000000000E+00  -2.96664930311916E-11   0.00000000000000E+00  -3.09590139485685E-12   1.29023111537534E-22
      2.96695302762208E-08   2.96664343748260E-08  -3.84200385379181E-19  -4.40301852814246E-01  -4.40301852804292E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.95430921629053E-09   0.00000000000000E+00  -9.95430921629053E-09
      1.79806329084816E-18  -1.39669269797007E-02  -7.75627444720827E-03   0.00000000000000E+00   7.72570670372845E-12
      1.70415167169339E-22  -1.97198508652395E-08  -1.97121251585356E-08  -1.41386290546898E-18
      5.11319423063047E-09
      0.00000000000000E+00  -2.84456009394919E-11   0.00000000000000E+00  -2.98009956761695E-12   9.96697904416555E-23
      2.84485775689831E-08   2.84455974694155E-08  -3.32697476845887E-19  -4.61908849421617E-01  -4.61908849411811E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.80612309721946E-09   0.00000000000000E+00  -9.80612309721946E-09
      1.60194082890377E-18  -1.21600689009450E-02  -6.28736794688055E-03   0.00000000000000E+00   6.68732680210540E-12
      1.35459099099853E-22  -1.86461616989983E-08  -1.86394743721960E-08  -1.26924335205789E-18
      5.13319423063047E-09
      0.00000000000000E+00  -2.74515653486949E-11   0.00000000000000E+00  -2.42531859508065E-12   6.74393386358805E-23
      2.74539550125793E-08   2.74515296939843E-08  -2.84641378394172E-19  -4.82420383411350E-01  -4.82420383401673E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67655564272953E-09   0.00000000000000E+00  -9.67655564272953E-09
      1.40840971604918E-18  -1.09379081012039E-02  -5.33757875320990E-03   0.00000000000000E+00   5.53888874550490E-12
      9.03799456679942E-23  -1.77805129400004E-08  -1.77749740512548E-08  -1.12376833765501E-18
      5.15319423063047E-09
      0.00000000000000E+00  -2.66104512453483E-11   0.00000000000000E+00  -2.05056794016090E-12   4.07230327120322E-23
      2.66124864795961E-08   2.66104359116560E-08  -2.39736097707915E-19  -5.01929936240530E-01  -5.01929936231008E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.52145652362927E-09   0.00000000000000E+00  -9.52145652362927E-09
      1.21798058557660E-18  -1.00678381574487E-02  -4.68364009274981E-03   0.00000000000000E+00   4.62620573852214E-12
      5.11313837029593E-23  -1.70936055937653E-08  -1.70889793880267E-08  -9.78244487868680E-19
      5.17319423063047E-09
      0.00000000000000E+00  -2.65088709659968E-11   0.00000000000000E+00  -2.28514127183355E-13   2.28969430599055E-23
      2.65091079489648E-08   2.65088794348376E-08  -1.95474806801425E-19  -5.21576219706615E-01  -5.21576219696753E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.86145776256425E-09   0.00000000000000E+00  -9.86145776256425E-09
      1.02075143032531E-18  -9.51818600782824E-03  -4.27310554845653E-03   0.00000000000000E+00   3.78202370629440E-12
      2.44746812156679E-23  -1.66512036959797E-08  -1.66474216722734E-08  -8.25276623523886E-19
      5.18319423063047E-09
      0.00000000000000E+00  -2.70851048472368E-11   0.00000000000000E+00   2.85939330271165E-12   1.62607337320777E-23
      2.70822723905838E-08   2.70851317838866E-08  -1.72694889778295E-19  -5.31898692517054E-01  -5.31898692506496E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05574837892481E-08   0.00000000000000E+00  -1.05574837892481E-08
      9.15176592432830E-19  -9.37837017194680E-03  -4.17102507575355E-03   0.00000000000000E+00   3.22895384521531E-12
      1.43686011539365E-23  -1.65308769484835E-08  -1.65276479946383E-08  -7.42481702654535E-19
      5.18994423063047E-09
      0.00000000000000E+00  -2.75030902462683E-11   0.00000000000000E+00   3.08549631903107E-12   1.28494546508292E-23
      2.75000285003231E-08   2.75031139966421E-08  -1.57119124001766E-19  -5.39031553769719E-01  -5.39031553758768E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09509392584409E-08   0.00000000000000E+00  -1.09509392584409E-08
      8.41257752438354E-19  -9.33537344143856E-03  -4.12029966067580E-03   0.00000000000000E+00   2.43024843690399E-12
      9.21903377326955E-24  -1.65546049866382E-08  -1.65521747382013E-08  -6.84138628436588E-19
      5.19450048063047E-09
      0.00000000000000E+00  -2.77788999921025E-11   0.00000000000000E+00   3.01921706109128E-12   1.09917728902834E-23
      2.77759101579986E-08   2.77789293750597E-08  -1.46554382308330E-19  -5.43904825714340E-01  -5.43904825703153E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11875085061019E-08   0.00000000000000E+00  -1.11875085061019E-08
      7.90284666807427E-19  -9.31734214963746E-03  -4.08990256210982E-03   0.00000000000000E+00   2.15461132041300E-12
      6.44408820718873E-24  -1.65935754802777E-08  -1.65914208689572E-08  -6.43730284499096E-19
      5.20065141813047E-09
      0.00000000000000E+00  -2.81273589250679E-11   0.00000000000000E+00   2.82811207463613E-12   9.17155265374191E-24
      2.81245760203332E-08   2.81274041324079E-08  -1.32209081158700E-19  -5.50567100191046E-01  -5.50567100179617E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14292148684609E-08   0.00000000000000E+00  -1.14292148684609E-08
      7.19984280477453E-19  -9.31452038162961E-03  -4.05344059051730E-03   0.00000000000000E+00   1.70266952265527E-12
      3.78004543759139E-24  -1.66998919334696E-08  -1.66981892639470E-08  -5.87775199318752E-19
      5.20895518375547E-09
      0.00000000000000E+00  -2.86460980008160E-11   0.00000000000000E+00   3.11225992816937E-12   7.57379491743127E-24
      2.86430316026977E-08   2.86461438626259E-08  -1.12761719463854E-19  -5.59690690011861E-01  -5.59690690000141E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17207117452710E-08   0.00000000000000E+00  -1.17207117452710E-08
      6.22658237186538E-19  -9.35281863615550E-03  -4.02014053500645E-03   0.00000000000000E+00   1.17137582087343E-12
      1.48459682662587E-24  -1.69266034931758E-08  -1.69254321173549E-08  -5.09896517722683E-19
      5.21456022555234E-09
      0.00000000000000E+00  -2.90769416630565E-11   0.00000000000000E+00   3.81937137926879E-12   6.77944712419834E-24
      2.90731857980633E-08   2.90770051694426E-08  -9.96593481406990E-20  -5.65901846425681E-01  -5.65901846413747E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19345515148349E-08   0.00000000000000E+00  -1.19345515148349E-08
      5.55764577118930E-19  -9.41412824947502E-03  -4.01307250195665E-03   0.00000000000000E+00   5.65757685550463E-13
      3.35257285621723E-25  -1.71430194122929E-08  -1.71424536546073E-08  -4.56105228978230E-19
      5.21834362876523E-09
      0.00000000000000E+00  -2.93518329615186E-11   0.00000000000000E+00   3.61876526969128E-12   6.34522146308207E-24
      2.93481979117171E-08   2.93518166769868E-08  -9.08554240483458E-20  -5.70101861792728E-01  -5.70101861780685E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20438369451403E-08   0.00000000000000E+00  -1.20438369451403E-08
      5.10197885725155E-19  -9.46261081445487E-03  -4.00940236276425E-03   0.00000000000000E+00   2.79298545608212E-13
     -2.83240909140681E-25  -1.73082590303925E-08  -1.73079797318469E-08  -4.19342461676810E-19
      5.22345122310264E-09
      0.00000000000000E+00  -2.95550853649589E-11   0.00000000000000E+00   2.00742407457933E-12   5.89235159827334E-24
      2.95530385766855E-08   2.95550460007601E-08  -7.91119562590878E-20  -5.75729574652959E-01  -5.75729574640897E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20622309491822E-08   0.00000000000000E+00  -1.20622309491822E-08
      4.48588903232673E-19  -9.49933062954058E-03  -3.98788580162720E-03   0.00000000000000E+00   5.97535708796872E-13
     -8.66665096424785E-25  -1.74934125872868E-08  -1.74928150515780E-08  -3.69476946973586E-19
      5.23034647545813E-09
      0.00000000000000E+00  -2.94868447252137E-11   0.00000000000000E+00  -4.47968913147642E-13   5.41745248850361E-24
      2.94872920784000E-08   2.94868441094868E-08  -6.38068261856445E-20  -5.83104745276037E-01  -5.83104745264184E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18528504338259E-08   0.00000000000000E+00  -1.18528504338259E-08
      3.66860508359527E-19  -9.48036251341796E-03  -3.92443611463966E-03   0.00000000000000E+00   1.26671780920745E-12
     -1.36398461432290E-24  -1.76352603934701E-08  -1.76339936756609E-08  -3.03053682173882E-19
      5.23965506613804E-09
      0.00000000000000E+00  -2.87654043144485E-11   0.00000000000000E+00  -3.79259340448563E-12   4.88460890092274E-24
      2.87692218550551E-08   2.87654292616506E-08  -4.49356272188950E-20  -5.92254524921853E-01  -5.92254524910787E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10662144433328E-08   0.00000000000000E+00  -1.10662144433328E-08
      2.63849647730370E-19  -9.36170726528769E-03  -3.78523081474474E-03   0.00000000000000E+00   1.71180054321481E-12
     -1.75203912219221E-24  -1.77009266188612E-08  -1.76992148183180E-08  -2.18914020511475E-19
      5.25222166355593E-09
      0.00000000000000E+00  -2.61608712567175E-11   0.00000000000000E+00  -1.02032060574164E-11   4.14582824764180E-24
      2.61711173508002E-08   2.61609141447428E-08  -2.59736391390325E-20  -6.01443626582024E-01  -6.01443626573565E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.45883408272832E-09   0.00000000000000E+00  -8.45883408272832E-09
      1.57550885188028E-19  -9.05525803901465E-03  -3.47787760929306E-03   0.00000000000000E+00   1.51015288568973E-12
     -2.05114477886451E-24  -1.77035902149003E-08  -1.77020800620146E-08  -1.31577246048995E-19
      5.26918657007008E-09
      0.00000000000000E+00  -1.75839504725926E-11   0.00000000000000E+00  -2.49261194231253E-11   2.68425357164198E-24
      1.76088527427085E-08   1.75839266232853E-08  -2.67564171294345E-20  -6.00572237865305E-01  -6.00572237865411E-01
      0.00000000000000E+00   0.00000000000000E+00   1.06206978571586E-10   0.00000000000000E+00   1.06206978571586E-10
      1.59352676650644E-19  -8.27507519489746E-03  -2.70145713129806E-03   0.00000000000000E+00   3.68728436020538E-14
     -2.38569826596082E-24  -1.76901704747006E-08  -1.76901336018570E-08  -1.32596259521211E-19
      5.28918657007008E-09
      0.00000000000000E+00   4.87695554571967E-14   0.00000000000000E+00  -4.34592745070392E-11  -2.62751945366642E-25
     -5.31853302431126E-12  -4.87778075313507E-11  -9.35169959588046E-20  -5.67197625043310E-01  -5.67197625061048E-01
      0.00000000000000E+00   0.00000000000000E+00   1.77377723607924E-08   0.00000000000000E+00   1.77377723607924E-08
      5.14108123866493E-19  -6.78195377730858E-03  -1.20869368197662E-03   0.00000000000000E+00  -3.27744373603091E-12
     -3.41860824489715E-24  -1.76857171095251E-08  -1.76889945532611E-08  -4.20591127907690E-19
      5.30918657007008E-09
      0.00000000000000E+00   1.76711111282026E-11   0.00000000000000E+00  -4.35305771980834E-11  -6.33478279669960E-24
     -1.76275746172171E-08  -1.76711051944152E-08  -2.46228388096559E-19  -4.96968807170206E-01  -4.96968807205529E-01
      0.00000000000000E+00   0.00000000000000E+00   3.53237163521693E-08   0.00000000000000E+00   3.53237163521693E-08
      1.22058245090988E-18  -5.07328591296601E-03   4.88508745632543E-04   0.00000000000000E+00  -8.31454203871171E-12
     -9.57438936689528E-24  -1.76442966157153E-08  -1.76526111577540E-08  -9.74354062813321E-19
      5.32918657007008E-09
      0.00000000000000E+00   2.49945349389191E-11   0.00000000000000E+00  -1.83465956978038E-11  -2.59530051400952E-23
     -2.49762075269281E-08  -2.49945541226259E-08  -4.97407589122266E-19  -3.93990121178725E-01  -3.93990121221338E-01
      0.00000000000000E+00   0.00000000000000E+00   4.26131460821785E-08   0.00000000000000E+00   4.26131460821785E-08
      2.07284537255345E-18  -3.23416822763734E-03   2.31689987759672E-03   0.00000000000000E+00  -1.84061924986229E-11
     -4.40837016787599E-23  -1.76001857670540E-08  -1.76185919595527E-08  -1.57543778343118E-18
      5.34918657007008E-09
      0.00000000000000E+00   1.81834210723461E-11   0.00000000000000E+00   1.62706584959136E-11  -4.13239535912709E-23
     -1.81996449575282E-08  -1.81833742990323E-08  -8.00331282783084E-19  -2.69265580171978E-01  -2.69265580207527E-01
      0.00000000000000E+00   0.00000000000000E+00   3.55482951001949E-08   0.00000000000000E+00   3.55482951001949E-08
      2.78381127455735E-18  -2.87235629328407E-03   2.59877123672056E-03   0.00000000000000E+00  -4.24012187823948E-11
     -7.63183882140545E-23  -1.73225195823801E-08  -1.73649208011626E-08  -1.98347999177426E-18
      5.36918657007008E-09
      0.00000000000000E+00   1.17022135018226E-11   0.00000000000000E+00   1.52573426036840E-11  -4.47603010075542E-23
     -1.17175002268990E-08  -1.17022428842953E-08  -1.03196511534270E-18  -1.56861691746887E-01  -1.56861691772816E-01
      0.00000000000000E+00   0.00000000000000E+00   2.59290461539542E-08   0.00000000000000E+00   2.59290461539542E-08
      3.30239219763643E-18  -2.39888878174720E-02  -1.95064895751561E-02   0.00000000000000E+00  -8.16756922438855E-11
     -8.88830479995997E-23  -1.41451275774149E-08  -1.42268032696589E-08  -2.27042708229373E-18
      5.38918657007008E-09
      0.00000000000000E+00   7.63918601723604E-12   0.00000000000000E+00   9.19563423601729E-12  -4.70430433972600E-23
     -7.64841737648289E-09  -7.63922174224692E-09  -1.18335339054172E-18  -7.27106093589398E-02  -7.27106093776409E-02
      0.00000000000000E+00   0.00000000000000E+00   1.87010462251918E-08   0.00000000000000E+00   1.87010462251918E-08
      3.67641312214027E-18  -6.40630877926016E-02  -6.05778681047810E-02   0.00000000000000E+00  -1.41298881813592E-10
     -1.01919382759430E-22  -1.09205256011312E-08  -1.10618244829449E-08  -2.49305973159855E-18
      5.39168657007008E-09
      0.00000000000000E+00   6.51197555748806E-12   0.00000000000000E+00   2.10944410977260E-11  -4.72496772362787E-23
     -6.53307457346805E-09  -6.51198013237037E-09  -1.19946219878207E-18  -6.32604022717093E-02  -6.32604022883573E-02
      0.00000000000000E+00   0.00000000000000E+00   1.66479554851178E-08   0.00000000000000E+00   1.66479554851178E-08
      3.71803301085306E-18  -6.97628984636975E-02  -6.65693540998048E-02   0.00000000000000E+00  -1.73788388951586E-10
     -1.03603400213469E-22  -9.96218696379603E-09  -1.01359753527477E-08  -2.51857081207099E-18
      5.39506157007008E-09
      0.00000000000000E+00   5.24865119719853E-12   0.00000000000000E+00   1.77339448594867E-11  -4.74793940888111E-23
     -5.26634325760813E-09  -5.24860931274869E-09  -1.21693716051767E-18  -5.28211939083456E-02  -5.28211939228352E-02
      0.00000000000000E+00   0.00000000000000E+00   1.44896341774029E-08   0.00000000000000E+00   1.44896341774029E-08
      3.76693552620180E-18  -7.83312563607895E-02  -7.54196802539971E-02   0.00000000000000E+00  -1.79249467060752E-10
     -1.05780199862400E-22  -9.06177539759324E-09  -9.24102486465409E-09  -2.54999836568413E-18
      5.39961782007008E-09
      0.00000000000000E+00   3.83506884683749E-12   0.00000000000000E+00   1.47405782149692E-11  -4.76930204601458E-23
     -3.84979596148804E-09  -3.83505538327311E-09  -1.23408042917915E-18  -4.23618813346449E-02  -4.23618813467250E-02
      0.00000000000000E+00   0.00000000000000E+00   1.20801292559911E-08   0.00000000000000E+00   1.20801292559911E-08
      3.82197561512441E-18  -9.11133638086799E-02  -8.85155813602525E-02   0.00000000000000E+00  -1.78438642864868E-10
     -1.08520711378400E-22  -8.06663522985324E-09  -8.24507387271822E-09  -2.58789518594526E-18
      5.40269328882008E-09
      0.00000000000000E+00   2.95960481177534E-12   0.00000000000000E+00   1.35863593110535E-11  -4.77936724365445E-23
     -2.97320042456329E-09  -2.95961406525229E-09  -1.24295821713367E-18  -3.68471694033069E-02  -3.68471694138643E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05573955255838E-08   0.00000000000000E+00   1.05573955255838E-08
      3.85444455514473E-18  -1.00220313343353E-01  -9.78264703288345E-02   0.00000000000000E+00  -1.79370923747525E-10
     -1.10293174171886E-22  -7.41841053658343E-09  -7.59778146033107E-09  -2.61148633801106E-18
      5.40684517163258E-09
      0.00000000000000E+00   2.09874408992919E-12   0.00000000000000E+00   9.93471905399275E-12  -4.78850428291660E-23
     -2.10865782207898E-09  -2.09872310302503E-09  -1.25136823187639E-18  -3.14909168719813E-02  -3.14909168810148E-02
      0.00000000000000E+00   0.00000000000000E+00   9.03356980316306E-09   0.00000000000000E+00   9.03356980316306E-09
      3.89195087834600E-18  -1.13086983353844E-01  -1.10902010693434E-01   0.00000000000000E+00  -1.78558346644828E-10
     -1.12561737659510E-22  -6.75628835349335E-09  -6.93484670013829E-09  -2.64058264646962E-18
      5.41245021342945E-09
      0.00000000000000E+00   1.36931318702702E-12   0.00000000000000E+00   6.23718090374954E-12  -4.79608438231527E-23
     -1.37553921034331E-09  -1.36930202943961E-09  -1.25863508594343E-18  -2.66754937575139E-02  -2.66754937651859E-02
      0.00000000000000E+00   0.00000000000000E+00   7.67205824330477E-09   0.00000000000000E+00   7.67205824330477E-09
      3.93495308546778E-18  -1.30943662428614E-01  -1.28957841958922E-01   0.00000000000000E+00  -1.79841087207689E-10
     -1.15477372587992E-22  -6.12291512665718E-09  -6.30275621386498E-09  -2.67631799952436E-18
      5.42001701985523E-09
      0.00000000000000E+00   8.38175071755889E-13   0.00000000000000E+00   3.35876612930202E-12  -4.80191850264566E-23
     -8.41517035437762E-10  -8.38158269308508E-10  -1.26443315939403E-18  -2.25800626469750E-02  -2.25800626535391E-02
      0.00000000000000E+00   0.00000000000000E+00   6.56409307696151E-09   0.00000000000000E+00   6.56409307696151E-09
      3.98462230714196E-18  -1.55136475399270E-01  -1.53332393187426E-01   0.00000000000000E+00  -1.84582519150560E-10
     -1.19260885884813E-22  -5.54135228850217E-09  -5.72593480765285E-09  -2.72018914774794E-18
      5.43023220853004E-09
      0.00000000000000E+00   4.98257699350833E-13   0.00000000000000E+00   1.58750226142350E-12  -4.80607391377482E-23
     -4.99863551720310E-10  -4.98276049458935E-10  -1.26880431522950E-18  -1.91729927757484E-02  -1.91729927814146E-02
      0.00000000000000E+00   0.00000000000000E+00   5.66614920641892E-09   0.00000000000000E+00   5.66614920641892E-09
      4.04250309034513E-18  -1.86919515954759E-01  -1.85291260922695E-01   0.00000000000000E+00  -1.92482154256038E-10
     -1.24187792264989E-22  -4.97539100270395E-09  -5.16787315696011E-09  -2.77369877511563E-18
      5.44402271324103E-09
      0.00000000000000E+00   3.01158893303480E-13   0.00000000000000E+00   6.81022318425788E-13  -4.80873476760820E-23
     -3.01839234957480E-10  -3.01158212639103E-10  -1.27201510301504E-18  -1.63211628969250E-02  -1.63211629017395E-02
      0.00000000000000E+00   0.00000000000000E+00   4.81457877022356E-09   0.00000000000000E+00   4.81457877022356E-09
      4.10889856155731E-18  -2.26548464083842E-01  -2.25126405768510E-01   0.00000000000000E+00  -1.98754188464245E-10
     -1.30445821729255E-22  -4.31466636911995E-09  -4.51342055758433E-09  -2.83688345854227E-18
      5.46263989460086E-09
      0.00000000000000E+00   2.01415508696106E-13   0.00000000000000E+00   2.55506103722964E-13  -4.81034303934836E-23
     -2.01644301498351E-10  -2.01388795394677E-10  -1.27453348944792E-18  -1.38719906280458E-02  -1.38719906318293E-02
      0.00000000000000E+00   0.00000000000000E+00   3.78348145470851E-09   0.00000000000000E+00   3.78348145470851E-09
      4.17933632197118E-18  -2.70582332528496E-01  -2.69453707192608E-01   0.00000000000000E+00  -1.87945679147043E-10
     -1.37656963204217E-22  -3.39414698016667E-09  -3.58209265931385E-09  -2.90480283252325E-18
      5.48263989460086E-09
      0.00000000000000E+00   1.59809842741097E-13   0.00000000000000E+00   9.95748657430330E-14  -4.81116955210667E-23
     -1.59980688153759E-10  -1.59881113288064E-10  -1.27644263166545E-18  -1.21052767177728E-02  -1.21052767204927E-02
      0.00000000000000E+00   0.00000000000000E+00   2.71996590711353E-09   0.00000000000000E+00   2.71996590711353E-09
      4.23373564011345E-18  -3.04753908989207E-01  -3.03947289384108E-01   0.00000000000000E+00  -1.53847923927653E-10
     -1.43464441993269E-22  -2.40623686989774E-09  -2.56008479382554E-09  -2.95729300844800E-18
      5.50263989460086E-09
      0.00000000000000E+00   1.38593708446158E-13   0.00000000000000E+00   5.26992839155247E-14  -4.81145275886780E-23
     -1.38613734798697E-10  -1.38561035514829E-10  -1.27794856208913E-18  -1.09016481711076E-02  -1.09016481729626E-02
      0.00000000000000E+00   0.00000000000000E+00   1.85501187514884E-09   0.00000000000000E+00   1.85501187514884E-09
      4.27083587761642E-18  -3.27254719394345E-01  -3.26713909119462E-01   0.00000000000000E+00  -1.09558771154619E-10
     -1.47364383250906E-22  -1.60689206847927E-09  -1.71645083963403E-09  -2.99288731552730E-18
      5.52263989460086E-09
      0.00000000000000E+00   1.30695061046311E-13   0.00000000000000E+00   2.02432574615884E-14  -4.81160214297327E-23
     -1.30747707188537E-10  -1.30727463931123E-10  -1.27931268718605E-18  -1.00416572031499E-02  -1.00416572043168E-02
      0.00000000000000E+00   0.00000000000000E+00   1.16693617608639E-09   0.00000000000000E+00   1.16693617608639E-09
      4.29417460113816E-18  -3.39837711336262E-01  -3.39511232791319E-01   0.00000000000000E+00  -6.28530741442878E-11
     -1.49533364088889E-22  -9.73355638010725E-10  -1.03620871215516E-09  -3.01486191395210E-18
      5.54263989460086E-09
      0.00000000000000E+00   1.16091747830314E-13   0.00000000000000E+00   3.90146917234849E-14  -4.81123458005092E-23
     -1.16111825703256E-10  -1.16072811011580E-10  -1.28039404719191E-18  -9.50554826735110E-03  -9.50554826808448E-03
      0.00000000000000E+00   0.00000000000000E+00   7.33387454511660E-10   0.00000000000000E+00   7.33387454511660E-10
      4.30884235022839E-18  -3.46361468162904E-01  -3.46166976445509E-01   0.00000000000000E+00  -3.09018070687263E-11
     -1.50586562967302E-22  -5.86412836431281E-10  -6.17314643500158E-10  -3.02844830303647E-18
      5.56263989460086E-09
      0.00000000000000E+00   8.60585187634526E-14   0.00000000000000E+00   8.16716718970704E-14  -4.80975370901879E-23
     -8.61150666237571E-11  -8.60333949519081E-11  -1.28088621913029E-18  -9.30280204139505E-03  -9.30280204210857E-03
      0.00000000000000E+00   0.00000000000000E+00   7.13519423993411E-10   0.00000000000000E+00   7.13519423993411E-10
      4.32311273870825E-18  -3.53541260743920E-01  -3.53343563658099E-01   0.00000000000000E+00  -3.37571888226240E-11
     -1.51704067412853E-22  -5.93728840218659E-10  -6.27486029041435E-10  -3.04222651957796E-18
      5.57263989460086E-09
      0.00000000000000E+00   7.08122923870031E-14   0.00000000000000E+00   8.50884380796556E-14  -4.80875574504506E-23
     -7.09106398783667E-11  -7.08255514403351E-11  -1.28098354399308E-18  -9.26807421168890E-03  -9.26807421247785E-03
      0.00000000000000E+00   0.00000000000000E+00   7.88949636209302E-10   0.00000000000000E+00   7.88949636209302E-10
      4.33100223507035E-18  -3.57946853340641E-01  -3.57720597042408E-01   0.00000000000000E+00  -4.27903781274042E-11
     -1.52399486119820E-22  -6.75333706641547E-10  -7.18124084769104E-10  -3.05001869107727E-18
      5.57938989460086E-09
      0.00000000000000E+00   4.27996475387075E-14   0.00000000000000E+00   2.18612175738404E-13  -4.80763942378611E-23
     -4.30100776035325E-11  -4.27914654278421E-11  -1.28086197270122E-18  -9.32297732518290E-03  -9.32297732617931E-03
      0.00000000000000E+00   0.00000000000000E+00   9.96407769989659E-10   0.00000000000000E+00   9.96407769989659E-10
      4.33772798751778E-18  -3.62312070366107E-01  -3.62011612778445E-01   0.00000000000000E+00  -6.55433842149454E-11
     -1.53107494018280E-22  -8.88072920346715E-10  -9.53616304561814E-10  -3.05686601481656E-18
      5.58394614460086E-09
      0.00000000000000E+00   2.24101158786365E-14   0.00000000000000E+00   2.38304426484607E-13  -4.80671796642282E-23
     -2.26748360875777E-11  -2.24365316611412E-11  -1.28068825142770E-18  -9.39252790602235E-03  -9.39252790722832E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20596638296156E-09   0.00000000000000E+00   1.20596638296156E-09
      4.34322267185015E-18  -3.66145392764582E-01  -3.65772491696709E-01   0.00000000000000E+00  -8.78068442137144E-11
     -1.53742474443310E-22  -1.09572300708618E-09  -1.18352985130005E-09  -3.06253442042244E-18
      5.58702161335086E-09
      0.00000000000000E+00   1.41440895299591E-14   0.00000000000000E+00   1.54049875579691E-13  -4.80608806993927E-23
     -1.42906612036037E-11  -1.41366113280720E-11  -1.28054600983983E-18  -9.44348247371358E-03  -9.44348247507440E-03
      0.00000000000000E+00   0.00000000000000E+00   1.36081907904005E-09   0.00000000000000E+00   1.36081907904005E-09
      4.34740782840214E-18  -3.69139809642172E-01  -3.68715500815201E-01   0.00000000000000E+00  -1.03701023335032E-10
     -1.54246313294345E-22  -1.24298144437689E-09  -1.34668246771208E-09  -3.06686181856231E-18
      5.59117349616336E-09
      0.00000000000000E+00   1.65320526973548E-14   0.00000000000000E+00  -7.02524213041760E-15  -4.80534445365537E-23
     -1.64906123043724E-11  -1.64976375465509E-11  -1.28036486406156E-18  -9.48967264473187E-03  -9.48967264627139E-03
      0.00000000000000E+00   0.00000000000000E+00   1.53952310654339E-09   0.00000000000000E+00   1.53952310654339E-09
      4.35379974792764E-18  -3.73732081287863E-01  -3.73252208912212E-01   0.00000000000000E+00  -1.20654822568592E-10
     -1.55034800270710E-22  -1.40237064642810E-09  -1.52302546899684E-09  -3.07343488386608E-18
      5.59677853796023E-09
      0.00000000000000E+00   2.75534211622580E-14   0.00000000000000E+00  -7.99819242546453E-14  -4.80450581384409E-23
     -2.75026125410834E-11  -2.75825944653861E-11  -1.28018449721344E-18  -9.49663404727328E-03  -9.49663404896441E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69112268009415E-09   0.00000000000000E+00   1.69112268009415E-09
      4.36327856123321E-18  -3.80486154187437E-01  -3.79962007410233E-01   0.00000000000000E+00  -1.35169787237675E-10
     -1.56219205710175E-22  -1.52837029839056E-09  -1.66354008562840E-09  -3.08309406401977E-18
      5.60434534438601E-09
      0.00000000000000E+00   4.12382870061795E-14   0.00000000000000E+00  -7.46533176248302E-14  -4.80356345950060E-23
     -4.11282555690894E-11  -4.12029088867622E-11  -1.28004781888506E-18  -9.42975690258875E-03  -9.42975690436801E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77925368473288E-09   0.00000000000000E+00   1.77925368473288E-09
      4.37674182944794E-18  -3.89973956321343E-01  -3.89426332033562E-01   0.00000000000000E+00  -1.45204035934326E-10
     -1.57917170080059E-22  -1.59284673991173E-09  -1.73805077584621E-09  -3.09669401056289E-18
      5.61456053306082E-09
      0.00000000000000E+00   5.62089791710064E-14   0.00000000000000E+00  -6.15873201904214E-14  -4.80257089842308E-23
     -5.61827096034895E-11  -5.62442969237279E-11  -1.28002359114462E-18  -9.24070072740035E-03  -9.24070072920090E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80054694389246E-09   0.00000000000000E+00   1.80054694389246E-09
      4.39513475619765E-18  -4.02769409641370E-01  -4.02219815139410E-01   0.00000000000000E+00  -1.50780650214997E-10
     -1.60258493559568E-22  -1.59352199675359E-09  -1.74430264696875E-09  -3.11511116505303E-18
      5.62835103777181E-09
      0.00000000000000E+00   8.10070582170386E-14   0.00000000000000E+00  -8.21655201250610E-14  -4.80190268267215E-23
     -8.09175272722364E-11  -8.09996927924095E-11  -1.28034343295329E-18  -8.78396213784080E-03  -8.78396213962472E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78392824859205E-09   0.00000000000000E+00   1.78392824859205E-09
      4.41973602711392E-18  -4.19482568750607E-01  -4.18946010161724E-01   0.00000000000000E+00  -1.53785082574847E-10
     -1.63413577964014E-22  -1.54914347322461E-09  -1.70292855579962E-09  -3.13939259416063E-18
      5.64696821913164E-09
      0.00000000000000E+00   1.26378358397557E-13   0.00000000000000E+00  -1.22348971201120E-13  -4.80262186978135E-23
     -1.26283950267883E-10  -1.26406299239132E-10  -1.28163783572880E-18  -7.67457891199353E-03  -7.67457891376069E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76715268145157E-09   0.00000000000000E+00   1.76715268145157E-09
      4.45263542907502E-18  -4.40812339938925E-01  -4.40295373373669E-01   0.00000000000000E+00  -1.56875075022176E-10
     -1.67642792909564E-22  -1.48387130719007E-09  -1.64074638221241E-09  -3.17099759334622E-18
      5.66696821913164E-09
      0.00000000000000E+00   1.66881887506076E-13   0.00000000000000E+00  -1.09573406422084E-13  -4.80481245966359E-23
     -1.66774670003164E-10  -1.66884243409634E-10  -1.28385439027408E-18  -6.01765153161822E-03  -6.01765153335836E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74013832317664E-09   0.00000000000000E+00   1.74013832317664E-09
      4.48743819553855E-18  -4.62387595899228E-01  -4.61891893768218E-01   0.00000000000000E+00  -1.60527073803640E-10
     -1.72156001772595E-22  -1.41272700596322E-09  -1.57325407976703E-09  -3.20358380526447E-18
      5.68696821913164E-09
      0.00000000000000E+00   1.71474124366452E-13   0.00000000000000E+00  -2.24960788822118E-14  -4.80697448811858E-23
     -1.71465094193000E-10  -1.71487590271930E-10  -1.28617792060131E-18  -4.32577250066776E-03  -4.32577250233669E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66892922157260E-09   0.00000000000000E+00   1.66892922157260E-09
      4.52081677997000E-18  -4.82872895955289E-01  -4.82401079748824E-01   0.00000000000000E+00  -1.62535683915285E-10
     -1.76596412666319E-22  -1.33490594738522E-09  -1.49744163130068E-09  -3.23463885936869E-18
      5.70696821913164E-09
      0.00000000000000E+00   2.22907177202667E-13   0.00000000000000E+00  -1.46784982345012E-13  -4.81127710363430E-23
     -2.22759990926789E-10  -2.22906775909183E-10  -1.28954107799057E-18  -2.02809792847329E-03  -2.02809793015657E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68327946699012E-09   0.00000000000000E+00   1.68327946699012E-09
      4.55448236930981E-18  -5.02354796437415E-01  -5.01894658150938E-01   0.00000000000000E+00  -1.69038268976497E-10
     -1.81089435571129E-22  -1.29133442210423E-09  -1.46037269108091E-09  -3.26494129131923E-18
      5.72696821913164E-09
      0.00000000000000E+00  -6.19125373515938E-13   0.00000000000000E+00   2.19562400672909E-12  -4.78041237881239E-23
      6.16862244640022E-10   6.19057868646703E-10  -1.27612434124423E-18  -9.87942382800338E-03  -9.87942382828168E-03
      0.00000000000000E+00   0.00000000000000E+00   2.78294743346116E-10   0.00000000000000E+00   2.78294743346116E-10
      4.56004826417672E-18  -5.22031369887676E-01  -5.21748639826758E-01   0.00000000000000E+00  -9.32757778912544E-11
     -1.83515608081441E-22  -8.04076834101353E-10  -8.97352611992791E-10  -3.28392392293249E-18
      5.74696821913164E-09
      0.00000000000000E+00  -2.52628134163023E-12   0.00000000000000E+00   5.10464434438938E-12  -4.67720330612540E-23
      2.52116616211059E-09   2.52627080645493E-09  -1.22491190428615E-18  -3.97674736741339E-02  -3.97674736713536E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.78023748089818E-09   0.00000000000000E+00  -2.78023748089818E-09
      4.50444351455876E-18  -5.42993897451028E-01  -5.43073957165525E-01   0.00000000000000E+00   8.05869371180698E-11
     -1.81392845826911E-22   1.73379737325370E-10   2.53966674443259E-10  -3.27953161027261E-18
      5.76696821913164E-09
      0.00000000000000E+00  -4.38705571745472E-12   0.00000000000000E+00   5.14009608937215E-12  -4.51244447564632E-23
      4.38194586599732E-09   4.38708596208664E-09  -1.13850197869559E-18  -8.77912984355651E-02  -8.77912984300141E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.55104254312471E-09   0.00000000000000E+00  -5.55104254312471E-09
      4.39342266369627E-18  -5.64603612391824E-01  -5.64970425734747E-01   0.00000000000000E+00   2.15239577695359E-10
     -1.75576813827085E-22   9.48717003342838E-10   1.16395658103802E-09  -3.25492068500068E-18
      5.78696821913164E-09
      0.00000000000000E+00  -6.55881637346390E-12   0.00000000000000E+00   5.89472387411432E-12  -4.28047611170069E-23
      6.55292959757320E-09   6.55882432144727E-09  -1.02192758787797E-18  -1.48042366809952E-01  -1.48042366802087E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.86565190037070E-09   0.00000000000000E+00  -7.86565190037070E-09
      4.23610962568885E-18  -5.85443903378577E-01  -5.85855811343958E-01   0.00000000000000E+00   2.87853223805123E-10
     -1.67480259023552E-22   1.01897435511840E-09   1.30682757892335E-09  -3.21418203781089E-18
      5.80696821913164E-09
      0.00000000000000E+00  -1.05970457790044E-11   0.00000000000000E+00   1.03530773525422E-11  -3.25605575405209E-23
      1.05867203666527E-08   1.05970734440053E-08  -8.96638216326364E-19  -2.07787362104022E-01  -2.07787362095164E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.85867048135298E-09   0.00000000000000E+00  -8.85867048135298E-09
      4.05893621606180E-18  -5.99885584362610E-01  -5.99338328894366E-01   0.00000000000000E+00   2.87116078267190E-10
     -1.58988689531497E-22  -2.02551904091919E-09  -1.73840296265216E-09  -3.16229799973543E-18
      5.82696821913164E-09
      0.00000000000000E+00  -2.20435635324413E-11   0.00000000000000E+00   2.84665362626343E-11   1.83096149350592E-23
      2.20150805983213E-08   2.20435471345840E-08  -7.82854750928727E-19  -2.58658184498654E-01  -2.58658184489164E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.48936997883462E-09   0.00000000000000E+00  -9.48936997883462E-09
      3.86914881648510E-18  -5.94567162060453E-01  -5.90612961653765E-01   0.00000000000000E+00   2.93959614840859E-10
     -1.49565340941678E-22  -1.28481367705900E-08  -1.25541771557493E-08  -3.08629406555637E-18
      5.84696821913164E-09
      0.00000000000000E+00  -4.14450295096337E-11   0.00000000000000E+00   4.80859567488474E-11   1.10708634441349E-22
      4.13969039725681E-08   4.14449899293170E-08  -6.96332009708862E-19  -2.96490489455172E-01  -2.96490489444976E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01957634148526E-08   0.00000000000000E+00  -1.01957634148526E-08
      3.66523354818805E-18  -5.55184934373211E-01  -5.45341290361095E-01   0.00000000000000E+00   3.13723893151739E-10
     -1.37689626780441E-22  -3.15629504076161E-08  -3.12492265144645E-08  -2.96890153847918E-18
      5.86696821913164E-09
      0.00000000000000E+00  -5.92821040779702E-11   0.00000000000000E+00   4.43347153693058E-11   1.95639027362161E-22
      5.92377712461451E-08   5.92821059615146E-08  -6.39861758884509E-19  -3.22018773656822E-01  -3.22018773645973E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08488779099772E-08   0.00000000000000E+00  -1.08488779099772E-08
      3.44825598998851E-18  -4.79262261546341E-01  -4.64004484518479E-01   0.00000000000000E+00   3.00668957663182E-10
     -1.22535485043185E-22  -4.87338970092005E-08  -4.84332280515374E-08  -2.80839423110400E-18
      5.88696821913164E-09
      0.00000000000000E+00  -6.56635682638864E-11   0.00000000000000E+00   1.59698724027326E-11   2.25494657962349E-22
      6.56476185778563E-08   6.56635884502592E-08  -6.09958786189866E-19  -3.37188342783170E-01  -3.37188342771753E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14173705645717E-08   0.00000000000000E+00  -1.14173705645717E-08
      3.21990857869707E-18  -3.71376359348212E-01  -3.54286456689626E-01   0.00000000000000E+00   2.56717442791022E-10
     -1.06196063210058E-22  -5.45029353284785E-08  -5.42462178856875E-08  -2.60994979250721E-18
      5.90696821913164E-09
      0.00000000000000E+00  -5.88242580629907E-11   0.00000000000000E+00  -1.69030507025117E-11   1.94746889700943E-22
      5.88411864865022E-08   5.88242834357999E-08  -6.00201765590861E-19  -3.44607619294486E-01  -3.44607619282616E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18697090579160E-08   0.00000000000000E+00  -1.18697090579160E-08
      2.98251439753875E-18  -2.46708067119322E-01  -2.31914851959179E-01   0.00000000000000E+00   1.92737855606728E-10
     -8.95569391553348E-23  -4.71473122334905E-08  -4.69545743778839E-08  -2.38231263194789E-18
      5.92696821913164E-09
      0.00000000000000E+00  -5.09685021554193E-11   0.00000000000000E+00  -1.94860404192517E-11   1.54005683719313E-22
      5.09880022488968E-08   5.09685162084777E-08  -5.92304953323792E-19  -3.51386597857713E-01  -3.51386597845835E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18785011060066E-08   0.00000000000000E+00  -1.18785011060066E-08
      2.74494437541862E-18  -1.38876788090475E-01  -1.26561070235012E-01   0.00000000000000E+00   1.07539587511052E-10
     -7.70831584655721E-23  -3.91975546899819E-08  -3.90900151024710E-08  -2.15263942209483E-18
      5.94696821913164E-09
      0.00000000000000E+00  -4.42238838785846E-11   0.00000000000000E+00  -1.67089423927026E-11   1.24765462881854E-22
      4.42405693998352E-08   4.42238604574426E-08  -5.74289004955411E-19  -3.61786307404416E-01  -3.61786307392853E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15627617142958E-08   0.00000000000000E+00  -1.15627617142958E-08
      2.51368914113271E-18  -6.21266853987268E-02  -5.18363456891913E-02   0.00000000000000E+00   5.74216379966057E-11
     -3.56436973079040E-23  -3.27185203811434E-08  -3.26610987431469E-08  -1.93940013617730E-18
      5.96696821913164E-09
      0.00000000000000E+00  -3.64374707476049E-11   0.00000000000000E+00  -1.92271700475157E-11   1.27633546669422E-22
      3.64566605011427E-08   3.64374333310953E-08  -5.27553120189320E-19  -3.81754408692769E-01  -3.81754408681987E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07810289614955E-08   0.00000000000000E+00  -1.07810289614955E-08
      2.29806856190280E-18  -2.96093417853956E-02  -2.15258853012384E-02   0.00000000000000E+00   3.40414791309778E-11
      7.66084096922466E-23  -2.56904458487309E-08  -2.56564043695999E-08  -1.77051544171348E-18
      5.96946821913164E-09
      0.00000000000000E+00  -3.49025614993927E-11   0.00000000000000E+00  -3.01166755257164E-11   1.27855988677679E-22
      3.49326186861635E-08   3.49025020106379E-08  -5.20935954280481E-19  -3.84459079829015E-01  -3.84459079818353E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06625902794664E-08   0.00000000000000E+00  -1.06625902794664E-08
      2.27141208620413E-18  -2.66337071603678E-02  -1.89965373519348E-02   0.00000000000000E+00   3.97052279205622E-11
      9.16652772397456E-23  -2.42796169590930E-08  -2.42399117311723E-08  -1.75047613192365E-18
      5.97284321913164E-09
      0.00000000000000E+00  -3.35561176519304E-11   0.00000000000000E+00  -1.98340653101071E-11   1.30271747395331E-22
      3.35759433650504E-08   3.35561092997404E-08  -5.11101571081141E-19  -3.88442974630847E-01  -3.88442974620348E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04992103736329E-08   0.00000000000000E+00  -1.04992103736329E-08
      2.23597725119312E-18  -2.39419774660323E-02  -1.66775268409698E-02   0.00000000000000E+00   2.74358724236255E-11
      1.09135270360399E-22  -2.30843347985312E-08  -2.30568989261075E-08  -1.72487568011198E-18
      5.97739946913164E-09
      0.00000000000000E+00  -3.25261707688851E-11   0.00000000000000E+00  -1.11128839666669E-11   1.33917017536007E-22
      3.25374016988789E-08   3.25262888149123E-08  -4.97178808657671E-19  -3.94069968888665E-01  -3.94069968878307E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03574960408264E-08   0.00000000000000E+00  -1.03574960408264E-08
      2.18878590985711E-18  -2.15665490895020E-02  -1.45819399122399E-02   0.00000000000000E+00   1.81789792123517E-11
      1.28051324437964E-22  -2.21869717532984E-08  -2.21687927740859E-08  -1.69160710119944E-18
      5.98355040663164E-09
      0.00000000000000E+00  -3.17550423552908E-11   0.00000000000000E+00  -6.09962669273682E-12   1.38445762752334E-22
      3.17612330375653E-08   3.17551334108727E-08  -4.78196434628923E-19  -4.01748397719103E-01  -4.01748397708854E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02492582677575E-08   0.00000000000000E+00  -1.02492582677575E-08
      2.12574336283077E-18  -1.94333627684484E-02  -1.26576042819577E-02   0.00000000000000E+00   1.27341505066751E-11
      1.47746143996241E-22  -2.15186092936220E-08  -2.15058751431152E-08  -1.64754692820185E-18
      5.99185417225664E-09
      0.00000000000000E+00  -3.10961482105640E-11   0.00000000000000E+00  -3.88371822188700E-12   1.42090590323110E-22
      3.11001183896574E-08   3.10962346714357E-08  -4.53030905005195E-19  -4.11967461971284E-01  -4.11967461961125E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01587568772737E-08   0.00000000000000E+00  -1.01587568772737E-08
      2.04138742668053E-18  -1.74436671717385E-02  -1.08469566198891E-02   0.00000000000000E+00   9.89535194583390E-12
      1.65802532311288E-22  -2.09473731461079E-08  -2.09374777941619E-08  -1.58835652167534E-18
      6.00306425585039E-09
      0.00000000000000E+00  -3.03753507129593E-11   0.00000000000000E+00  -3.13432196140942E-12   1.39705577340208E-22
      3.03784813528363E-08   3.03753470308750E-08  -4.20401350261145E-19  -4.25318057733021E-01  -4.25318057722959E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00619083239722E-08   0.00000000000000E+00  -1.00619083239722E-08
      1.92859259325616E-18  -1.55337247252696E-02  -9.13362281224053E-03   0.00000000000000E+00   8.35487727510879E-12
      1.75459019368257E-22  -2.03217935841780E-08  -2.03134387069028E-08  -1.50819124299501E-18
      6.01819786870196E-09
      0.00000000000000E+00  -2.94363301197495E-11   0.00000000000000E+00  -3.02494358356563E-12   1.25309027971664E-22
      2.94394001247338E-08   2.94363751811504E-08  -3.78866345258314E-19  -4.42511988205962E-01  -4.42511988196023E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.93871634859230E-09   0.00000000000000E+00  -9.93871634859230E-09
      1.77818390779506E-18  -1.36863114487987E-02  -7.54322942014649E-03   0.00000000000000E+00   7.41117851152999E-12
      1.66354294809979E-22  -1.95050700110698E-08  -1.94976588325581E-08  -1.39931756253675E-18
      6.03819786870196E-09
      0.00000000000000E+00  -2.82995678073320E-11   0.00000000000000E+00  -2.77317174370109E-12   9.60442347910769E-23
      2.83023484537132E-08   2.82995752819696E-08  -3.27722781990292E-19  -4.64010705877750E-01  -4.64010705867959E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.79060257629614E-09   0.00000000000000E+00  -9.79060257629614E-09
      1.58237185626914E-18  -1.19955462470013E-02  -6.16396160674367E-03   0.00000000000000E+00   6.40921170782125E-12
      1.30354713357585E-22  -1.85153819173814E-08  -1.85089727056734E-08  -1.25464907427885E-18
      6.05819786870196E-09
      0.00000000000000E+00  -2.73448417640597E-11   0.00000000000000E+00  -2.32811714312909E-12   6.43875419883508E-23
      2.73472101357020E-08   2.73448820185589E-08  -2.79983683826022E-19  -4.84425129426727E-01  -4.84425129417063E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66320914001906E-09   0.00000000000000E+00  -9.66320914001906E-09
      1.38910767346876E-18  -1.08279856087786E-02  -5.25705205817999E-03   0.00000000000000E+00   5.39658701715711E-12
      8.57996728165728E-23  -1.76870694655571E-08  -1.76816728785398E-08  -1.10912398964274E-18
      6.07819786870196E-09
      0.00000000000000E+00  -2.65157593212874E-11   0.00000000000000E+00  -2.02121135043543E-12   3.86633199565763E-23
      2.65177617844532E-08   2.65157405731028E-08  -2.35413239134354E-19  -5.03826087411183E-01  -5.03826087401684E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.49886514507031E-09   0.00000000000000E+00  -9.49886514507031E-09
      1.19913037056735E-18  -9.98797051046301E-03  -4.62648977646813E-03   0.00000000000000E+00   4.53184669883921E-12
      4.80147170829238E-23  -1.70214072747314E-08  -1.70168754280325E-08  -9.63717131433002E-19
      6.09819786870196E-09
      0.00000000000000E+00  -2.65576405214540E-11   0.00000000000000E+00   1.25025144900294E-13   2.16147766833311E-23
      2.65574798700416E-08   2.65576048951865E-08  -1.91022969424783E-19  -5.23579079450692E-01  -5.23579079440753E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.93893362614669E-09   0.00000000000000E+00  -9.93893362614669E-09
      1.00035169804442E-18  -9.48056687629977E-03  -4.24454444844847E-03   0.00000000000000E+00   3.66493000869745E-12
      2.25335080130625E-23  -1.66223361990485E-08  -1.66186712690398E-08  -8.09328728619637E-19
      6.11819786870196E-09
      0.00000000000000E+00  -2.74936302383359E-11   0.00000000000000E+00   2.33422298657216E-12   1.22652418046547E-23
      2.74913244171460E-08   2.74936586401326E-08  -1.45035156891755E-19  -5.44582528086474E-01  -5.44582528075604E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08708985778015E-08   0.00000000000000E+00  -1.08708985778015E-08
      7.82933726488391E-19  -9.29157315303485E-03  -4.05425966063821E-03   0.00000000000000E+00   2.60050569241831E-12
      8.54279403221558E-24  -1.66253605680235E-08  -1.66227600623311E-08  -6.37898569596636E-19
      6.12319786870196E-09
      0.00000000000000E+00  -2.78522839371313E-11   0.00000000000000E+00   3.55891572046518E-12   1.02882499650471E-23
      2.78487313243156E-08   2.78522902400361E-08  -1.33562168773424E-19  -5.49918416538482E-01  -5.49918416527229E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12533618971883E-08   0.00000000000000E+00  -1.12533618971883E-08
      7.26666917002449E-19  -9.25528103679196E-03  -4.02547569837703E-03   0.00000000000000E+00   2.75033167515578E-12
      5.54814517127198E-24  -1.66016786745230E-08  -1.65989283428479E-08  -5.93104748229025E-19
      6.12994786870196E-09
      0.00000000000000E+00  -2.83612874707354E-11   0.00000000000000E+00   3.75177328152192E-12   8.45377059224461E-24
      2.83575356857905E-08   2.83612874590720E-08  -1.17879789225089E-19  -5.57268918657084E-01  -5.57268918645502E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15817348201675E-08   0.00000000000000E+00  -1.15817348201675E-08
      6.48490206966319E-19  -9.29395570534680E-03  -4.00723995363935E-03   0.00000000000000E+00   1.19565812548548E-12
      2.83083967178898E-24  -1.67807482970300E-08  -1.67795526389045E-08  -5.30610417741229E-19
      6.13906036870196E-09
      0.00000000000000E+00  -2.90240390944249E-11   0.00000000000000E+00   3.62171886123293E-12   6.95478001471772E-24
      2.90204539778149E-08   2.90240756966761E-08  -9.66372575936326E-20  -5.67331726764636E-01  -5.67331726752747E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18895154273746E-08   0.00000000000000E+00  -1.18895154273746E-08
      5.40146997634367E-19  -9.39147980393359E-03  -3.99291085862915E-03   0.00000000000000E+00   5.47511831485571E-13
      6.60278712060895E-25  -1.71351077811332E-08  -1.71345602693017E-08  -4.43509740040735E-19
      6.14213583745196E-09
      0.00000000000000E+00  -2.92745915375271E-11   0.00000000000000E+00   4.04476009275810E-12   6.52662047378703E-24
      2.92705230258776E-08   2.92745677859703E-08  -8.95233427626432E-20  -5.70731778535681E-01  -5.70731778523678E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20027457518900E-08   0.00000000000000E+00  -1.20027457518900E-08
      5.03232928160235E-19  -9.43497430952180E-03  -3.99315793433385E-03   0.00000000000000E+00   2.17626859170046E-13
      2.94132900404834E-26  -1.72720396609391E-08  -1.72718220340800E-08  -4.13709585397591E-19
      6.14628772026446E-09
      0.00000000000000E+00  -2.94997948331599E-11   0.00000000000000E+00   2.72262916920735E-12   6.07377572544569E-24
      2.94970984543423E-08   2.94998210835115E-08  -7.99848281737134E-20  -5.75307130022007E-01  -5.75307130009955E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20522229520638E-08   0.00000000000000E+00  -1.20522229520638E-08
      4.53193510833142E-19  -9.48054462618358E-03  -3.98334618378061E-03   0.00000000000000E+00   2.91711492106913E-13
     -5.92153558106884E-25  -1.74478898429401E-08  -1.74475981314480E-08  -3.73208682659430E-19
      6.15189276206133E-09
      0.00000000000000E+00  -2.95378185543638E-11   0.00000000000000E+00   3.79871718353408E-13   5.60578505529884E-24
      2.95374689745645E-08   2.95378488462828E-08  -6.74145617309883E-20  -5.81361883408864E-01  -5.81361883396926E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19387025473843E-08   0.00000000000000E+00  -1.19387025473843E-08
      3.86276584054596E-19  -9.48714062433485E-03  -3.94219363275784E-03   0.00000000000000E+00   9.67704781728876E-13
     -1.14323206593159E-24  -1.76001140036800E-08  -1.75991462988983E-08  -3.18862022323606E-19
      6.15945956848711E-09
      0.00000000000000E+00  -2.91459170606993E-11   0.00000000000000E+00  -2.51973714144533E-12   5.11020258935831E-24
      2.91484386845863E-08   2.91459189474449E-08  -5.14235388803222E-20  -5.89104739513760E-01  -5.89104739502300E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14600693570280E-08   0.00000000000000E+00  -1.14600693570280E-08
      2.99560457603938E-19  -9.41740748420230E-03  -3.84514232640606E-03   0.00000000000000E+00   1.58444151070976E-12
     -1.58616837937901E-24  -1.76874340319277E-08  -1.76858495904170E-08  -2.48136918723616E-19
      6.16967475716192E-09
      0.00000000000000E+00  -2.76976173996738E-11   0.00000000000000E+00  -6.96827204360546E-12   4.51607725392059E-24
      2.77046279250041E-08   2.76976596529605E-08  -3.30237840782002E-20  -5.98047368866792E-01  -5.98047368856802E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.99084256240636E-09   0.00000000000000E+00  -9.99084256240636E-09
      1.97502115808687E-19  -9.22186606071902E-03  -3.64299372592264E-03   0.00000000000000E+00   1.71526870843364E-12
     -1.91854411214845E-24  -1.77085323592625E-08  -1.77068170905541E-08  -1.64478331730487E-19
      6.18346526187290E-09
      0.00000000000000E+00  -2.30353030048082E-11   0.00000000000000E+00  -1.66610268762462E-11   3.55500777748534E-24
      2.30519271990242E-08   2.30352661721479E-08  -2.01638476785796E-20  -6.04147586096676E-01  -6.04147586091336E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.34059194221772E-09   0.00000000000000E+00  -5.34059194221772E-09
      1.23852657470078E-19  -8.75057829925366E-03  -3.17553037260520E-03   0.00000000000000E+00   9.95963112552251E-13
     -2.19396384566134E-24  -1.76956701930428E-08  -1.76946742299303E-08  -1.03688809791499E-19
      6.20208244323274E-09
      0.00000000000000E+00  -9.83335678912385E-12   0.00000000000000E+00  -3.49603534176438E-11   1.47165637051068E-24
      9.86832522092794E-09   9.83336486751030E-09  -4.71545331734732E-20  -5.90104599699852E-01  -5.90104599707709E-01
      0.00000000000000E+00   0.00000000000000E+00   7.85651326727969E-09   0.00000000000000E+00   7.85651326727969E-09
      2.70118789822947E-19  -7.61798936569714E-03  -2.04445166601817E-03   0.00000000000000E+00  -1.35677959530138E-12
     -2.68882906408043E-24  -1.76885213551947E-08  -1.76898781347900E-08  -2.22964256649473E-19
      6.22208244323274E-09
      0.00000000000000E+00   9.22369142354029E-12   0.00000000000000E+00  -4.68424633858259E-11  -2.44180823369037E-24
     -9.17664733290004E-09  -9.22348979628586E-09  -1.53191347569659E-19  -5.38836297147961E-01  -5.38836297174862E-01
      0.00000000000000E+00   0.00000000000000E+00   2.69016785684214E-08   0.00000000000000E+00   2.69016785684214E-08
      8.08152361191374E-19  -5.95254761983573E-03  -3.82737511284890E-04   0.00000000000000E+00  -5.53843945473366E-12
     -4.95630993274397E-24  -1.76726503326809E-08  -1.76781887721356E-08  -6.54961013621716E-19
      6.24208244323274E-09
      0.00000000000000E+00   2.30491715601265E-11   0.00000000000000E+00  -3.42735119425056E-11  -1.30128994477406E-23
     -2.30149527739937E-08  -2.30492262859362E-08  -3.51816605675119E-19  -4.52318556533153E-01  -4.52318556573825E-01
      0.00000000000000E+00   0.00000000000000E+00   4.06724146355280E-08   0.00000000000000E+00   4.06724146355280E-08
      1.62160065390193E-18  -4.26062347899240E-03   1.29189773704289E-03   0.00000000000000E+00  -1.19797831865385E-11
     -2.01163225395473E-23  -1.76112085664052E-08  -1.76231883495917E-08  -1.26978404822681E-18
      6.26208244323274E-09
      0.00000000000000E+00   2.30976655813721E-11   0.00000000000000E+00  -5.08728692880861E-13  -3.67166885023566E-23
     -2.30971201663066E-08  -2.30976288949995E-08  -6.42955100777078E-19  -3.36066581528623E-01  -3.36066581569386E-01
      0.00000000000000E+00   0.00000000000000E+00   4.07636019961389E-08   0.00000000000000E+00   4.07636019961389E-08
      2.43687269382471E-18  -1.92711323731143E-03   3.63887665028775E-03   0.00000000000000E+00  -2.77295986065392E-11
     -6.57333050655759E-23  -1.76382435025327E-08  -1.76659731011393E-08  -1.79391759304763E-18
      6.28208244323274E-09
      0.00000000000000E+00   1.45538089026419E-11   0.00000000000000E+00   2.04311659314461E-11  -4.31383037593115E-23
     -1.45742386649970E-08  -1.45538074990656E-08  -9.20418294339770E-19  -2.13244099786372E-01  -2.13244099816989E-01
      0.00000000000000E+00   0.00000000000000E+00   3.06171467444002E-08   0.00000000000000E+00   3.06171467444002E-08
      3.04921562871272E-18  -1.05800562786212E-02  -5.51902152851657E-03   0.00000000000000E+00  -5.87649737582301E-11
     -8.20784005784390E-23  -1.60045742715763E-08  -1.60633392453346E-08  -2.12879733437295E-18
      6.30208244323274E-09
      0.00000000000000E+00   9.74123651770470E-12   0.00000000000000E+00   1.10720939551056E-11  -4.59910791644173E-23
     -9.75229964548827E-09  -9.74122755153321E-09  -1.11389952167608E-18  -1.12484402356507E-01  -1.12484402378965E-01
      0.00000000000000E+00   0.00000000000000E+00   2.24582445972041E-08   0.00000000000000E+00   2.24582445972041E-08
      3.49838052065680E-18  -4.10953071695345E-02  -3.70885936279604E-02   0.00000000000000E+00  -1.09444405526820E-10
     -9.51837172238701E-23  -1.26075726401439E-08  -1.27170170456708E-08  -2.38448099898072E-18
      6.30458244323274E-09
      0.00000000000000E+00   8.75317083482613E-12   0.00000000000000E+00   1.83532898127848E-11  -4.62944197116072E-23
     -8.77148138313720E-09  -8.75312809332446E-09  -1.13565444828681E-18  -1.00334777914362E-01  -1.00334777934963E-01
      0.00000000000000E+00   0.00000000000000E+00   2.06006275210086E-08   0.00000000000000E+00   2.06006275210086E-08
      3.54988208945932E-18  -4.56137623961321E-02  -4.18809753814678E-02   0.00000000000000E+00  -1.46054377844526E-10
     -9.69242342531890E-23  -1.17014450498402E-08  -1.18474994276848E-08  -2.41422764117251E-18
      6.30795744323274E-09
      0.00000000000000E+00   7.74747096240371E-12   0.00000000000000E+00   1.38005068513787E-11  -4.66792082733606E-23
     -7.76130422760503E-09  -7.74750372075370E-09  -1.16160044542957E-18  -8.55329121391976E-02  -8.55329121580299E-02
      0.00000000000000E+00   0.00000000000000E+00   1.88322009161885E-08   0.00000000000000E+00   1.88322009161885E-08
      3.61344076755146E-18  -5.24867875090527E-02  -4.89943312795432E-02   0.00000000000000E+00  -1.60599305890279E-10
     -9.92459746857451E-23  -1.09240978895449E-08  -1.10846971954352E-08  -2.45184032212189E-18
      6.31251369323274E-09
      0.00000000000000E+00   6.48322815474211E-12   0.00000000000000E+00   1.28220839238052E-11  -4.71070134159505E-23
     -6.49609464672482E-09  -6.48327256280106E-09  -1.19083467538591E-18  -6.84762593862486E-02  -6.84762594029090E-02
      0.00000000000000E+00   0.00000000000000E+00   1.66604261950808E-08   0.00000000000000E+00   1.66604261950808E-08
      3.68934983440279E-18  -6.29668203567949E-02  -5.97603022731459E-02   0.00000000000000E+00  -1.69023755852697E-10
     -1.02264912267194E-22  -1.00081298764267E-08  -1.01771536322795E-08  -2.49851515901689E-18
      6.31866463073274E-09
      0.00000000000000E+00   4.82350190866489E-12   0.00000000000000E+00   1.26050672258416E-11  -4.75117599409180E-23
     -4.83607042717922E-09  -4.82346535995343E-09  -1.22006499452360E-18  -5.09651105059278E-02  -5.09651105197439E-02
      0.00000000000000E+00   0.00000000000000E+00   1.38160796582403E-08   0.00000000000000E+00   1.38160796582403E-08
      3.77433167687565E-18  -7.91096098131790E-02  -7.62763037193473E-02   0.00000000000000E+00  -1.73650087830740E-10
     -1.06091347486850E-22  -8.81896421045608E-09  -8.99261429828692E-09  -2.55426668235205E-18
      6.32281651354524E-09
      0.00000000000000E+00   3.63723528289247E-12   0.00000000000000E+00   1.35159386295022E-11  -4.76955315112387E-23
     -3.65077476828522E-09  -3.63725882965576E-09  -1.23486524303927E-18  -4.19014016529931E-02  -4.19014016647531E-02
      0.00000000000000E+00   0.00000000000000E+00   1.17600799671271E-08   0.00000000000000E+00   1.17600799671271E-08
      3.82315815076479E-18  -9.09265116273373E-02  -8.83672468013244E-02   0.00000000000000E+00  -1.77116645271909E-10
     -1.08556099612446E-22  -7.94570449219899E-09  -8.12282113747101E-09  -2.58829290772553E-18
      6.32561903444368E-09
      0.00000000000000E+00   2.88713931411860E-12   0.00000000000000E+00   1.27551294739698E-11  -4.77860147075656E-23
     -2.89988925249416E-09  -2.88713412302024E-09  -1.24275195760732E-18  -3.69927131607317E-02  -3.69927131711779E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04462136735808E-08   0.00000000000000E+00   1.04462136735808E-08
      3.85243388289455E-18  -9.92734956332042E-02  -9.68918460640855E-02   0.00000000000000E+00  -1.78514297047756E-10
     -1.10162098721119E-22  -7.38056525351322E-09  -7.55907955056109E-09  -2.60968192528723E-18
      6.32940243765657E-09
      0.00000000000000E+00   2.12198080844270E-12   0.00000000000000E+00   9.67615495906885E-12  -4.78718385168787E-23
     -2.13165654242884E-09  -2.12198038746982E-09  -1.25050348433590E-18  -3.20583918210915E-02  -3.20583918301799E-02
      0.00000000000000E+00   0.00000000000000E+00   9.08839563024863E-09   0.00000000000000E+00   9.08839563024863E-09
      3.88681894812205E-18  -1.11003688773245E-01  -1.08808769526372E-01   0.00000000000000E+00  -1.78019035591991E-10
     -1.12230911953782E-22  -6.78839620718676E-09  -6.96641524277886E-09  -2.63631546378615E-18
      6.33451003199397E-09
      0.00000000000000E+00   1.44086023731168E-12   0.00000000000000E+00   6.38324652032945E-12  -4.79464105511448E-23
     -1.44724665973417E-09  -1.44086341321389E-09  -1.25749036492587E-18  -2.74514051743369E-02  -2.74514051821584E-02
      0.00000000000000E+00   0.00000000000000E+00   7.82152737451646E-09   0.00000000000000E+00   7.82152737451646E-09
      3.92676813704997E-18  -1.27266158696398E-01  -1.25255791660722E-01   0.00000000000000E+00  -1.79141994014646E-10
     -1.14900282516956E-22  -6.20152196728787E-09  -6.38066396130263E-09  -2.66927777212410E-18
      6.34140528434946E-09
      0.00000000000000E+00   9.14957272061382E-13   0.00000000000000E+00   3.64620096814500E-12  -4.80063857513062E-23
     -9.18579320354828E-10  -9.14933119386730E-10  -1.26330150300472E-18  -2.33987866119270E-02  -2.33987866186719E-02
      0.00000000000000E+00   0.00000000000000E+00   6.74489952066481E-09   0.00000000000000E+00   6.74489952066481E-09
      3.97327592135739E-18  -1.49366754989550E-01  -1.47529895514887E-01   0.00000000000000E+00  -1.83261702840277E-10
     -1.18369756228092E-22  -5.64670469843751E-09  -5.82996640127790E-09  -2.70997441835267E-18
      6.35071387502938E-09
      0.00000000000000E+00   5.58232312747348E-13   0.00000000000000E+00   1.82710532025077E-12  -4.80510449968311E-23
     -5.60037106468293E-10  -5.58210001148090E-10  -1.26783868616409E-18  -1.99474010943963E-02  -1.99474011002514E-02
      0.00000000000000E+00   0.00000000000000E+00   5.85515890763075E-09   0.00000000000000E+00   5.85515890763075E-09
      4.02777919899439E-18  -1.78621248370540E-01  -1.76952325587087E-01   0.00000000000000E+00  -1.90571226760299E-10
     -1.22899399308124E-22  -5.10637767972220E-09  -5.29694890648262E-09  -2.75994051283030E-18
      6.36328047244726E-09
      0.00000000000000E+00   3.39549993456226E-13   0.00000000000000E+00   8.28216406594201E-13  -4.80810358690905E-23
     -3.40370797520199E-10  -3.39542581113653E-10  -1.27123987117565E-18  -1.70258192747953E-02  -1.70258192798314E-02
      0.00000000000000E+00   0.00000000000000E+00   5.03610248841314E-09   0.00000000000000E+00   5.03610248841314E-09
      4.09106587152149E-18  -2.15744361987637E-01  -2.14264602189921E-01   0.00000000000000E+00  -1.98086322272142E-10
     -1.28722787426309E-22  -4.49847358502724E-09  -4.69655990729951E-09  -2.81982600034584E-18
      6.38024537896141E-09
      0.00000000000000E+00   2.21070282458517E-13   0.00000000000000E+00   3.32594334885286E-13  -4.80994492856492E-23
     -2.21410950658689E-10  -2.21078356323852E-10  -1.27385870257788E-18  -1.45113402672280E-02  -1.45113402713136E-02
      0.00000000000000E+00   0.00000000000000E+00   4.08566327172556E-09   0.00000000000000E+00   4.08566327172556E-09
      4.16037876697460E-18  -2.58718344711553E-01  -2.57500714236354E-01   0.00000000000000E+00  -1.93889320767069E-10
     -1.35686577578632E-22  -3.67069559463442E-09  -3.86458491540163E-09  -2.88652006439673E-18
      6.40024537896141E-09
      0.00000000000000E+00   1.68718782250227E-13   0.00000000000000E+00   1.25150846944490E-13  -4.81099025692676E-23
     -1.68818758688237E-10  -1.68693607841341E-10  -1.27593580600268E-18  -1.25406243862200E-02  -1.25406243892212E-02
      0.00000000000000E+00   0.00000000000000E+00   3.00117038252674E-09   0.00000000000000E+00   3.00117038252674E-09
      4.22040217462514E-18  -2.96512472469222E-01  -2.95620029459965E-01   0.00000000000000E+00  -1.64978195349989E-10
     -1.42051171873510E-22  -2.66749857933526E-09  -2.83247677468539E-09  -2.94446636862246E-18
      6.42024537896141E-09
      0.00000000000000E+00   1.43461479518157E-13   0.00000000000000E+00   6.16649588020393E-14  -4.81140669516544E-23
     -1.43535903706264E-10  -1.43474238747510E-10  -1.27753435057777E-18  -1.12004238976437E-02  -1.12004238997178E-02
      0.00000000000000E+00   0.00000000000000E+00   2.07411663687042E-09   0.00000000000000E+00   2.07411663687042E-09
      4.26188450736255E-18  -3.22035987194219E-01  -3.21427689736865E-01   0.00000000000000E+00  -1.22234500231905E-10
     -1.46461024824401E-22  -1.80840789789081E-09  -1.93064239812286E-09  -2.98435015678477E-18
      6.44024537896141E-09
      0.00000000000000E+00   1.31889042630008E-13   0.00000000000000E+00   2.94313200379100E-14  -4.81156040971788E-23
     -1.31925698822176E-10  -1.31896267502187E-10  -1.27891836635933E-18  -1.02613631497031E-02  -1.02613631510489E-02
      0.00000000000000E+00   0.00000000000000E+00   1.34577874611452E-09   0.00000000000000E+00   1.34577874611452E-09
      4.28880008228483E-18  -3.37250506600363E-01  -3.36868046063100E-01   0.00000000000000E+00  -7.59417244353108E-11
     -1.49096920053969E-22  -1.13794075417692E-09  -1.21388247861238E-09  -3.00988171592551E-18
      6.46024537896141E-09
      0.00000000000000E+00   1.23990395230161E-13   0.00000000000000E+00   2.12238068893594E-14  -4.81150407712047E-23
     -1.24001559002600E-10  -1.23980335195758E-10  -1.28015486793703E-18  -9.61059570219789E-03  -9.61059570300425E-03
      0.00000000000000E+00   0.00000000000000E+00   8.06357304894744E-10   0.00000000000000E+00   8.06357304894744E-10
      4.30492722838273E-18  -3.44629851881924E-01  -3.44414860094812E-01   0.00000000000000E+00  -3.57310064515791E-11
     -1.50320144105747E-22  -6.46645963247277E-10  -6.82376969699006E-10  -3.02477236044570E-18
      6.48024537896141E-09
      0.00000000000000E+00   9.24876503679794E-14   0.00000000000000E+00   8.42821148972006E-14  -4.81022607771780E-23
     -9.25513519316885E-11  -9.24670698168394E-11  -1.28077215557817E-18  -9.34818121397477E-03  -9.34818121466847E-03
      0.00000000000000E+00   0.00000000000000E+00   6.93698700805976E-10   0.00000000000000E+00   6.93698700805976E-10
      4.31880120239885E-18  -3.51301962040166E-01  -3.51112537464983E-01   0.00000000000000E+00  -3.10365682895567E-11
     -1.51355847828056E-22  -5.70195062699384E-10  -6.01231630989092E-10  -3.03802904682068E-18
      6.50024537896141E-09
      0.00000000000000E+00   6.88835529056451E-14   0.00000000000000E+00   6.83959427385666E-14  -4.80822514710438E-23
     -6.89978458098754E-11  -6.89294498671849E-11  -1.28093306588194E-18  -9.25957798975624E-03  -9.25957799063376E-03
      0.00000000000000E+00   0.00000000000000E+00   8.77521581705234E-10   0.00000000000000E+00   8.77521581705234E-10
      4.33635163403296E-18  -3.61526633861987E-01  -3.61271872463681E-01   0.00000000000000E+00  -5.08610391465685E-11
     -1.53005638139218E-22  -7.57731092691413E-10  -8.08592131838135E-10  -3.05541856815101E-18
      6.50274537896141E-09
      0.00000000000000E+00   5.63008239082139E-14   0.00000000000000E+00   2.57254832568631E-13  -4.80785491026160E-23
     -5.65807133546887E-11  -5.63234585221682E-11  -1.28092190524662E-18  -9.26556145740149E-03  -9.26556145830152E-03
      0.00000000000000E+00   0.00000000000000E+00   9.00037571249896E-10   0.00000000000000E+00   9.00037571249896E-10
      4.33860172796108E-18  -3.62896822222411E-01  -3.62630993776204E-01   0.00000000000000E+00  -5.51169861469588E-11
     -1.53226291842952E-22  -7.88597126579722E-10  -8.43714112726834E-10  -3.05767982271446E-18
      6.50612037896141E-09
      0.00000000000000E+00   2.16753579809763E-14   0.00000000000000E+00   5.20235177234034E-13  -4.80704048784562E-23
     -2.22217071197518E-11  -2.17014719425658E-11  -1.28079053925217E-18  -9.32944684683446E-03  -9.32944684790080E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06633949406147E-09   0.00000000000000E+00   1.06633949406147E-09
      4.34220062375354E-18  -3.65388519863487E-01  -3.65059381751499E-01   0.00000000000000E+00  -7.57577142785597E-11
     -1.53630404310446E-22  -9.68880307839915E-10  -1.04463802211863E-09  -3.06141008450136E-18
      6.51067662896141E-09
      0.00000000000000E+00   1.04703000416580E-14   0.00000000000000E+00   1.46296866566076E-13  -4.80609025235275E-23
     -1.05824573668403E-11  -1.04361605003223E-11  -1.28056305248910E-18  -9.41827675329483E-03  -9.41827675461514E-03
      0.00000000000000E+00   0.00000000000000E+00   1.32030743545720E-09   0.00000000000000E+00   1.32030743545720E-09
      4.34821627450634E-18  -3.69712678762035E-01  -3.69299968719165E-01   0.00000000000000E+00  -1.00616274266302E-10
     -1.54353735684643E-22  -1.20925500069067E-09  -1.30987127495712E-09  -3.06765322201723E-18
      6.51682756646141E-09
      0.00000000000000E+00   1.80015684926752E-14   0.00000000000000E+00  -4.02784220724351E-14  -4.80503124592494E-23
     -1.79490631573649E-11  -1.79893415794854E-11  -1.28030479197708E-18  -9.47665946608486E-03  -9.47665946765415E-03
      0.00000000000000E+00   0.00000000000000E+00   1.56928342218749E-09   0.00000000000000E+00   1.56928342218749E-09
      4.35786883875600E-18  -3.76642500461029E-01  -3.76153721143421E-01   0.00000000000000E+00  -1.23800024896196E-10
     -1.55549377526774E-22  -1.42749405571179E-09  -1.55129408060814E-09  -3.07756404677892E-18
      6.52513133208641E-09
      0.00000000000000E+00   3.37070185551623E-14   0.00000000000000E+00  -7.72479145595263E-14  -4.80388345571192E-23
     -3.35878061154543E-11  -3.36650540300619E-11  -1.28009081969289E-18  -9.44828823898848E-03  -9.44828824072220E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73371838898296E-09   0.00000000000000E+00   1.73371838898296E-09
      4.37226522991787E-18  -3.86852715192650E-01  -3.86317063669209E-01   0.00000000000000E+00  -1.40350895560580E-10
     -1.57358900842636E-22  -1.55970243939213E-09  -1.70005333495286E-09  -3.09217441022497E-18
      6.53634141568016E-09
      0.00000000000000E+00   5.12493633617999E-14   0.00000000000000E+00  -6.54613319767862E-14  -4.80269570176152E-23
     -5.12080659122382E-11  -5.12735272442630E-11  -1.28000741151184E-18  -9.27611198200113E-03  -9.27611198379204E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79091471618517E-09   0.00000000000000E+00   1.79091471618517E-09
      4.39234153359558E-18  -4.00881609269377E-01  -4.00333483826613E-01   0.00000000000000E+00  -1.49226987010482E-10
     -1.59910780993189E-22  -1.59041420193038E-09  -1.73964118894102E-09  -3.11233412208374E-18
      6.55147502853172E-09
      0.00000000000000E+00   7.76088029403601E-14   0.00000000000000E+00  -7.89590949082700E-14  -4.80186536662781E-23
     -7.75576273291108E-11  -7.76365864240671E-11  -1.28030733037318E-18  -8.80536501427770E-03  -8.80536501605862E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78092163271187E-09   0.00000000000000E+00   1.78092163271187E-09
      4.41929331210402E-18  -4.19250185892867E-01  -4.18713515242835E-01   0.00000000000000E+00  -1.53311053470710E-10
     -1.63367422986310E-22  -1.54997399281687E-09  -1.70328504628774E-09  -3.13898598173084E-18
      6.57147502853172E-09
      0.00000000000000E+00   1.25643600499897E-13   0.00000000000000E+00  -1.20335789584556E-13  -4.80260875940266E-23
     -1.25527061972424E-10  -1.25647397762057E-10  -1.28168383302352E-18  -7.62329933250429E-03  -7.62329933426721E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76291481291181E-09   0.00000000000000E+00   1.76291481291181E-09
      4.45455160836225E-18  -4.42121980523702E-01  -4.41606110286713E-01   0.00000000000000E+00  -1.56762536913816E-10
     -1.67903745346295E-22  -1.48050487823574E-09  -1.63726741514973E-09  -3.17286777533873E-18
      6.59147502853173E-09
      0.00000000000000E+00   1.67524800666529E-13   0.00000000000000E+00  -1.13085503641425E-13  -4.80483266821097E-23
     -1.67394451617991E-10  -1.67507537121681E-10  -1.28391387685007E-18  -5.96007306566928E-03  -5.96007306740568E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73639115558473E-09   0.00000000000000E+00   1.73639115558473E-09
      4.48927943147395E-18  -4.63631013732665E-01  -4.63136688581804E-01   0.00000000000000E+00  -1.60675953998173E-10
     -1.72413121895367E-22  -1.40820766446473E-09  -1.56888361846307E-09  -3.20536555462388E-18
      6.61147502853173E-09
      0.00000000000000E+00   1.71474124366452E-13   0.00000000000000E+00  -2.10060071926127E-14  -4.80699335386221E-23
     -1.71475802147155E-10  -1.71496808154395E-10  -1.28623854745028E-18  -4.26916962848490E-03  -4.26916963014979E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66489963561033E-09   0.00000000000000E+00   1.66489963561033E-09
      4.52257742418615E-18  -4.84060997388913E-01  -4.83590453665469E-01   0.00000000000000E+00  -1.62663538300124E-10
     -1.76849627182051E-22  -1.33073928915568E-09  -1.49340282745598E-09  -3.23633887673587E-18
      6.63147502853173E-09
      0.00000000000000E+00   2.24101158786365E-13   0.00000000000000E+00  -1.49830617537634E-13  -4.81134625879886E-23
     -2.23918932221230E-10  -2.24068762838816E-10  -1.28962578047253E-18  -1.95837686613628E-03  -1.95837686781776E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68147676050168E-09   0.00000000000000E+00   1.68147676050168E-09
      4.55620695939618E-18  -5.03490958039334E-01  -5.03031753784697E-01   0.00000000000000E+00  -1.69276006081845E-10
     -1.81341860325171E-22  -1.28813199158084E-09  -1.45740799766286E-09  -3.26658117892365E-18
      6.65147502853173E-09
      0.00000000000000E+00  -7.26032647625499E-13   0.00000000000000E+00   2.47922173872041E-12  -4.77605403052211E-23
      7.23499036672422E-10   7.25978258411094E-10  -1.27407912059227E-18  -1.10885615626838E-02  -1.10885615627885E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04717419502746E-10   0.00000000000000E+00   1.04717419502746E-10
      4.55830130778624E-18  -5.23248230842309E-01  -5.22986504679486E-01   0.00000000000000E+00  -8.33763939857439E-11
     -1.83508414282644E-22  -7.47319283927978E-10  -8.30695677913905E-10  -3.28422218719397E-18
      6.67147502853173E-09
      0.00000000000000E+00  -2.61436044461225E-12   0.00000000000000E+00   5.06852661043649E-12  -4.67004854673661E-23
      2.60928180547311E-09   2.61435033208350E-09  -1.22114577291862E-18  -4.19192171546185E-02  -4.19192171517000E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.91847594801214E-09   0.00000000000000E+00  -2.91847594801214E-09
      4.49993178882600E-18  -5.44243183700440E-01  -5.44339048986373E-01   0.00000000000000E+00   8.80979757500503E-11
     -1.81186167438163E-22   2.16027640178829E-10   3.04125615928698E-10  -3.27878601590738E-18
      6.67397502853173E-09
      0.00000000000000E+00  -3.15220322569953E-12   0.00000000000000E+00   1.09477717414390E-11  -4.65249460959909E-23
      3.14126036178004E-09   3.15220813352143E-09  -1.21319685127843E-18  -4.64738175722538E-02  -4.64738175685127E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.74109180181797E-09   0.00000000000000E+00  -3.74109180181797E-09
      4.49057905932145E-18  -5.46886089272752E-01  -5.47071684016042E-01   0.00000000000000E+00   1.31133400923902E-10
     -1.80754581166844E-22   4.57750267373007E-10   5.88883668296728E-10  -3.27738220804302E-18
      6.67735002853173E-09
      0.00000000000000E+00  -3.59608884062350E-12   0.00000000000000E+00   7.04517765828365E-12  -4.62841136462329E-23
      3.58909595553113E-09   3.59614113318937E-09  -1.20099726902579E-18  -5.33948980860917E-02  -5.33948980816563E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.43539764733519E-09   0.00000000000000E+00  -4.43539764733519E-09
      4.47560959226170E-18  -5.50506962679844E-01  -5.50771451195241E-01   0.00000000000000E+00   1.65254067023466E-10
     -1.80013909668989E-22   6.74002447122455E-10   8.39256514145741E-10  -3.27461232323590E-18
      6.68190627853173E-09
      0.00000000000000E+00  -4.12713511115742E-12   0.00000000000000E+00   6.30007979865776E-12  -4.59225503442622E-23
      4.12086066456057E-09   4.12716074435919E-09  -1.18218859400891E-18  -6.39416395293136E-02  -6.39416395240730E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.24059348086110E-09   0.00000000000000E+00  -5.24059348086110E-09
      4.45173213821452E-18  -5.55464899332182E-01  -5.55815783089274E-01   0.00000000000000E+00   2.03155230561521E-10
     -1.78774875996408E-22   9.10277505940369E-10   1.11343273650171E-09  -3.26954354420561E-18
      6.68805721603173E-09
      0.00000000000000E+00  -4.82956366132059E-12   0.00000000000000E+00   6.21605030536947E-12  -4.53688481066190E-23
      4.82332334636940E-09   4.82953939667472E-09  -1.15272825016128E-18  -8.01695557767309E-02  -8.01695557704671E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.26380763844345E-09   0.00000000000000E+00  -6.26380763844345E-09
      4.41320384891844E-18  -5.62249956996290E-01  -5.62701940646903E-01   0.00000000000000E+00   2.47128668979667E-10
     -1.76717212943932E-22   1.18713957278948E-09   1.43426824176897E-09  -3.26047559875715E-18
      6.69220909884423E-09
      0.00000000000000E+00  -5.36942702662643E-12   0.00000000000000E+00   6.99652984835448E-12  -4.49589877817776E-23
      5.36238636647392E-09   5.36938289632223E-09  -1.13079048546334E-18  -9.20335607159521E-02  -9.20335607089414E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.01068925320001E-09   0.00000000000000E+00  -7.01068925320001E-09
      4.38409628870430E-18  -5.66857311203976E-01  -5.67374536104139E-01   0.00000000000000E+00   2.73613433808501E-10
     -1.75162659874745E-22   1.36769292306949E-09   1.64130635687781E-09  -3.25330580324095E-18
      6.69781414064110E-09
      0.00000000000000E+00  -5.95190634999656E-12   0.00000000000000E+00   5.73090849777869E-12  -4.43724413613133E-23
      5.94621740601390E-09   5.95194831451164E-09  -1.09847711974511E-18  -1.09153039676135E-01  -1.09153039668393E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.74206267391477E-09   0.00000000000000E+00  -7.74206267391477E-09
      4.34070170382298E-18  -5.73063579095342E-01  -5.73627703454619E-01   0.00000000000000E+00   2.95804875326097E-10
     -1.72864624666982E-22   1.49430948407721E-09   1.79011435940314E-09  -3.24222458407787E-18
      6.70538094706688E-09
      0.00000000000000E+00  -6.61300476841634E-12   0.00000000000000E+00   4.87548471412405E-12  -4.34917166378876E-23
      6.60814872091448E-09   6.61302420562856E-09  -1.05183930610994E-18  -1.33155906595070E-01  -1.33155906586725E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.34472105207613E-09   0.00000000000000E+00  -8.34472105207613E-09
      4.27755881494477E-18  -5.81236153084982E-01  -5.81781898115902E-01   0.00000000000000E+00   3.04415703389533E-10
     -1.69615867183751E-22   1.42728114305831E-09   1.73169684644767E-09  -3.22571950883483E-18
      6.71559613574169E-09
      0.00000000000000E+00  -7.67032138314939E-12   0.00000000000000E+00   5.59269781269494E-12  -4.15845138878531E-23
      7.66471832033699E-09   7.67031101814964E-09  -9.86414932284754E-19  -1.65538874588076E-01  -1.65538874579322E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.75436320294757E-09   0.00000000000000E+00  -8.75436320294757E-09
      4.18813134309890E-18  -5.91399741562517E-01  -5.91741504667168E-01   0.00000000000000E+00   2.97332054744766E-10
     -1.65233261027285E-22   7.86720130053374E-10   1.08405218479798E-09  -3.20171641081414E-18
      6.72938664045267E-09
      0.00000000000000E+00  -1.06516933976429E-11   0.00000000000000E+00   1.10353100757428E-11  -3.28937484298170E-23
      1.06406710396512E-08   1.06517063497270E-08  -8.98302419183016E-19  -2.07062657326593E-01  -2.07062657317544E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.04874600139165E-09   0.00000000000000E+00  -9.04874600139165E-09
      4.06334456873819E-18  -6.01403034520201E-01  -6.00898443834144E-01   0.00000000000000E+00   2.84313527940418E-10
     -1.59385987293060E-22  -1.88727387627547E-09  -1.60296034833521E-09  -3.16504214955517E-18
      6.74800382181251E-09
      0.00000000000000E+00  -2.08894425646915E-11   0.00000000000000E+00   2.73661534753687E-11   1.27487413651355E-23
      2.08620597371924E-08   2.08894258906677E-08  -7.90709652926553E-19  -2.55216083389717E-01  -2.55216083380240E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.47660550179431E-09   0.00000000000000E+00  -9.47660550179431E-09
      3.88691688543571E-18  -5.98296255742311E-01  -5.94701600499273E-01   0.00000000000000E+00   2.92555258795798E-10
     -1.50718167300577E-22  -1.17053756476692E-08  -1.14128203888735E-08  -3.09620723250915E-18
      6.76800382181251E-09
      0.00000000000000E+00  -3.99744115774667E-11   0.00000000000000E+00   4.73000216426768E-11   1.03831970031715E-22
      3.99271050319013E-08   3.99744050535441E-08  -7.01835569967765E-19  -2.94054265905463E-01  -2.94054265895317E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01455050021460E-08   0.00000000000000E+00  -1.01455050021460E-08
      3.68400678539278E-18  -5.61639169452042E-01  -5.52243009091899E-01   0.00000000000000E+00   3.15801022765344E-10
     -1.39038864054965E-22  -3.01447010741632E-08  -2.98289000513980E-08  -2.98217121542502E-18
      6.78800382181251E-09
      0.00000000000000E+00  -5.83823930322853E-11   0.00000000000000E+00   4.57404786153845E-11   1.90834475365346E-22
      5.83366583328330E-08   5.83823988114486E-08  -6.43152437349726E-19  -3.20449121175640E-01  -3.20449121164837E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08024647931090E-08   0.00000000000000E+00  -1.08024647931090E-08
      3.46795748953061E-18  -4.88293317410713E-01  -4.73304438071218E-01   0.00000000000000E+00   3.05763878443034E-10
     -1.24063132094545E-22  -4.78856978967825E-08  -4.75799340183396E-08  -2.82480505218088E-18
      6.80800382181251E-09
      0.00000000000000E+00  -6.59711562887944E-11   0.00000000000000E+00   1.89683926189327E-11   2.26128791568451E-22
      6.59521263290966E-08   6.59710947217157E-08  -6.11220987147367E-19  -3.36397261561384E-01  -3.36397261550012E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13722690777423E-08   0.00000000000000E+00  -1.13722690777423E-08
      3.24051210797576E-18  -3.82636395396020E-01  -3.65435472002543E-01   0.00000000000000E+00   2.62356781485719E-10
     -1.07649207961170E-22  -5.48611824254591E-08  -5.45988256439735E-08  -2.62929112082839E-18
      6.82800382181251E-09
      0.00000000000000E+00  -5.97584108851284E-11   0.00000000000000E+00  -1.53460985811513E-11   1.99233168377974E-22
      5.97737702855274E-08   5.97584241869464E-08  -6.00558285264139E-19  -3.44155808748043E-01  -3.44155808736194E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18494506884604E-08   0.00000000000000E+00  -1.18494506884604E-08
      3.00352309420655E-18  -2.57640331622120E-01  -2.42546465405722E-01   0.00000000000000E+00   2.00883736482556E-10
     -9.10350681202189E-23  -4.81098572349684E-08  -4.79089734984859E-08  -2.40296480894241E-18
      6.84800382181251E-09
      0.00000000000000E+00  -5.16017716184652E-11   0.00000000000000E+00  -2.02304045229350E-11   1.57345481944780E-22
      5.16220380532301E-08   5.16018076487074E-08  -5.93080069997599E-19  -3.50765282979935E-01  -3.50765282968042E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18931387346503E-08   0.00000000000000E+00  -1.18931387346503E-08
      2.76566031951355E-18  -1.47507128572567E-01  -1.34996515430449E-01   0.00000000000000E+00   1.14310875002055E-10
     -7.79900033552744E-23  -3.98229797890590E-08  -3.97086689140570E-08  -2.17258024951595E-18
      6.85800382181251E-09
      0.00000000000000E+00  -4.74339492887248E-11   0.00000000000000E+00  -2.06619244277187E-11   1.36323889121503E-22
      4.74546453997659E-08   4.74339834753384E-08  -5.88786544846225E-19  -3.54286308060881E-01  -3.54286308049038E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18427440676241E-08   0.00000000000000E+00  -1.18427440676241E-08
      2.64723287883731E-18  -1.00065460194463E-01  -8.88519976345282E-02   0.00000000000000E+00   7.56829561082871E-11
     -6.99413810568434E-23  -3.56669223638226E-08  -3.55912394077144E-08  -2.05844633399108E-18
      6.86137882181251E-09
      0.00000000000000E+00  -4.57010227870932E-11   0.00000000000000E+00  -2.53762375324757E-11   1.29237279868064E-22
      4.57264224674433E-08   4.57010462299109E-08  -5.87091067067852E-19  -3.55550699863861E-01  -3.55550699852053E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18085279005347E-08   0.00000000000000E+00  -1.18085279005347E-08
      2.60737909717300E-18  -8.53889725689116E-02  -7.47106903935774E-02   0.00000000000000E+00   6.81920848232771E-11
     -6.35725969787340E-23  -3.39607104141992E-08  -3.38925183293759E-08  -2.02028803010515E-18
      6.86593507181251E-09
      0.00000000000000E+00  -4.35573666206696E-11   0.00000000000000E+00  -2.33225997392296E-11   1.21748935852532E-22
      4.35806577141284E-08   4.35573351143893E-08  -5.83139910084599E-19  -3.57847375501054E-01  -3.57847375489410E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16434094403644E-08   0.00000000000000E+00  -1.16434094403644E-08
      2.55432881291034E-18  -6.84402512556176E-02  -5.83853266602105E-02   0.00000000000000E+00   5.68503922159489E-11
     -4.86859378947666E-23  -3.19707760662408E-08  -3.19139256740249E-08  -1.97118890282574E-18
      6.87208600931251E-09
      0.00000000000000E+00  -4.06221006642542E-11   0.00000000000000E+00  -2.36068797679057E-11   1.16678994168909E-22
      4.06456652582957E-08   4.06220583785279E-08  -5.73962769772455E-19  -3.62253258938429E-01  -3.62253258927087E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13418669427380E-08   0.00000000000000E+00  -1.13418669427380E-08
      2.48456569821224E-18  -5.09952545986725E-02  -4.17701019274042E-02   0.00000000000000E+00   4.76290884266686E-11
     -1.69109237365756E-23  -2.93278205242168E-08  -2.92801914357902E-08  -1.91060292843979E-18
      6.87623789212501E-09
      0.00000000000000E+00  -3.84370225213499E-11   0.00000000000000E+00  -2.59901293178773E-11   1.15721984669539E-22
      3.84630496442575E-08   3.84370595149397E-08  -5.65682416389171E-19  -3.65912568572611E-01  -3.65912568561507E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11043828314176E-08   0.00000000000000E+00  -1.11043828314176E-08
      2.43846160199106E-18  -4.19493479930900E-02  -3.33377769319587E-02   0.00000000000000E+00   4.36371177151024E-11
      1.03915401066197E-23  -2.73763138012374E-08  -2.73326766835223E-08  -1.87277918560189E-18
      6.87904041302344E-09
      0.00000000000000E+00  -3.70140720077937E-11   0.00000000000000E+00  -2.51044891618596E-11   1.16255591672558E-22
      3.70391322319367E-08   3.70140277427750E-08  -5.59152639088617E-19  -3.68695506833606E-01  -3.68695506822668E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09378389497479E-08   0.00000000000000E+00  -1.09378389497479E-08
      2.40780807975065E-18  -3.70441705603470E-02  -2.88284679931988E-02   0.00000000000000E+00   3.93642220303014E-11
      2.92660644005064E-23  -2.61155530150571E-08  -2.60761887930268E-08  -1.84865544066203E-18
      6.88282381623633E-09
      0.00000000000000E+00  -3.55154414307785E-11   0.00000000000000E+00  -1.96216163396143E-11   1.18855183180983E-22
      3.55350056921796E-08   3.55153840758401E-08  -5.49068903456301E-19  -3.72891051858006E-01  -3.72891051847264E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07419865739075E-08   0.00000000000000E+00  -1.07419865739075E-08
      2.36716681323410E-18  -3.21067782771287E-02  -2.43015316496247E-02   0.00000000000000E+00   3.14490863727911E-11
      5.30230661336670E-23  -2.48048465883055E-08  -2.47733975019327E-08  -1.81809790977780E-18
      6.88793141057374E-09
      0.00000000000000E+00  -3.41059920935918E-11   0.00000000000000E+00  -1.36524829763219E-11   1.24351919076339E-22
      3.41196200911864E-08   3.41059676082102E-08  -5.34092255256005E-19  -3.79024589518391E-01  -3.79024589507840E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05510295538094E-08   0.00000000000000E+00  -1.05510295538094E-08
      2.31327643443130E-18  -2.74914268161434E-02  -2.00700661220988E-02   0.00000000000000E+00   2.36579191224347E-11
      8.16572542972323E-23  -2.35785959735234E-08  -2.35549380544009E-08  -1.77918417917529E-18
      6.89482666292923E-09
      0.00000000000000E+00  -3.29068672046103E-11   0.00000000000000E+00  -8.57853577070292E-12   1.32663357998198E-22
      3.29154569439442E-08   3.29068784081736E-08  -5.12829169671339E-19  -3.87657355270613E-01  -3.87657355260224E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03882656262866E-08   0.00000000000000E+00  -1.03882656262866E-08
      2.24164672140215E-18  -2.34284338487301E-02  -1.63335753990082E-02   0.00000000000000E+00   1.71249307068339E-11
      1.14400324433296E-22  -2.25357377125939E-08  -2.25186127818870E-08  -1.72881755173082E-18
      6.90413525360914E-09
      0.00000000000000E+00  -3.19185259875202E-11   0.00000000000000E+00  -5.21105670560713E-12   1.41696166108094E-22
      3.19237262383549E-08   3.19185151816494E-08  -4.83923228948438E-19  -3.99366998829170E-01  -3.99366998818913E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02562198234839E-08   0.00000000000000E+00  -1.02562198234839E-08
      2.14617576914210E-18  -1.99678123155793E-02  -1.31427424524888E-02   0.00000000000000E+00   1.24634802797751E-11
      1.48111519994146E-22  -2.16747588384454E-08  -2.16622953581655E-08  -1.66225254019367E-18
      6.91670185102703E-09
      0.00000000000000E+00  -3.10077935733703E-11   0.00000000000000E+00  -3.53740229392578E-12   1.45958029050151E-22
      3.10113056707481E-08   3.10077682684543E-08  -4.46081062469727E-19  -4.14764012597448E-01  -4.14764012587312E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01358316558205E-08   0.00000000000000E+00  -1.01358316558205E-08
      2.01880285322794E-18  -1.70396306563823E-02  -1.04635687290284E-02   0.00000000000000E+00   9.55262888417335E-12
      1.74331398678052E-22  -2.08814892415182E-08  -2.08719366126338E-08  -1.57272179075821E-18
      6.93366675754118E-09
      0.00000000000000E+00  -2.99432212243979E-11   0.00000000000000E+00  -3.05770584461564E-12   1.36229998482618E-22
      2.99463262850384E-08   2.99432685791939E-08  -3.98052198289857E-19  -4.34525194532675E-01  -4.34525194522678E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.99629076602301E-09   0.00000000000000E+00  -9.99629076602301E-09
      1.84921671489413E-18  -1.45210142204566E-02  -8.23636901417766E-03   0.00000000000000E+00   7.90333874600280E-12
      1.77508637970643E-22  -1.99548811519171E-08  -1.99469778131709E-08  -1.45116451660428E-18
      6.95366675754118E-09
      0.00000000000000E+00  -2.87241660274424E-11   0.00000000000000E+00  -2.97433129184227E-12   1.09091193986553E-22
      2.87271271020878E-08   2.87241527707960E-08  -3.45582873881682E-19  -4.56452762619633E-01  -4.56452762609790E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.84240990886969E-09   0.00000000000000E+00  -9.84240990886969E-09
      1.65236851671674E-18  -1.25474146553386E-02  -6.59838406731782E-03   0.00000000000000E+00   6.86817146067637E-12
      1.48018814899527E-22  -1.88886110333871E-08  -1.88817428619262E-08  -1.30678564283506E-18
      6.97366675754118E-09
      0.00000000000000E+00  -2.76761257311673E-11   0.00000000000000E+00  -2.55716010216701E-12   7.62127927127000E-23
      2.76787274026323E-08   2.76761702425302E-08  -2.96725059152714E-19  -4.77221068812957E-01  -4.77221068803248E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70941513995949E-09   0.00000000000000E+00  -9.70941513995949E-09
      1.45818021391755E-18  -1.12050913727006E-02  -5.54433906143323E-03   0.00000000000000E+00   5.80332920897516E-12
      1.03089324937105E-22  -1.79725584317799E-08  -1.79667551025708E-08  -1.16145515476484E-18
      6.99366675754118E-09
      0.00000000000000E+00  -2.68144384066863E-11   0.00000000000000E+00  -2.10094617878377E-12   4.72358674026531E-23
      2.68165048983315E-08   2.68144039521527E-08  -2.51024061963991E-19  -4.96988082530701E-01  -4.96988082521134E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.56756394033776E-09   0.00000000000000E+00  -9.56756394033776E-09
      1.26682893511079E-18  -1.02647721716370E-02  -4.83083813876862E-03   0.00000000000000E+00   4.82012016123409E-12
      6.08200888141813E-23  -1.72516601319762E-08  -1.72468400118149E-08  -1.01580487314680E-18
      7.01366675754118E-09
      0.00000000000000E+00  -2.63401521837466E-11   0.00000000000000E+00  -1.14722610970118E-12   2.68277276739710E-23
      2.63413120403950E-08   2.63401648142853E-08  -2.07271418098636E-19  -5.16287710462792E-01  -5.16287710453164E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.62791170105054E-09   0.00000000000000E+00  -9.62791170105054E-09
      1.07427070108978E-18  -9.61235921603497E-03  -4.34685323826477E-03   0.00000000000000E+00   4.02976101047377E-12
      3.04149318890608E-23  -1.67162828742453E-08  -1.67122531132347E-08  -8.66999282991149E-19
      7.03366675754118E-09
      0.00000000000000E+00  -2.71952266871487E-11   0.00000000000000E+00   2.13159862222601E-12   1.50070587443530E-23
      2.71930639663741E-08   2.71951955649964E-08  -1.61521302003061E-19  -5.36991979579068E-01  -5.36991979568473E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05949914514613E-08   0.00000000000000E+00  -1.05949914514613E-08
      8.62370872060559E-19  -9.34867702875633E-03  -4.11847107642450E-03   0.00000000000000E+00   2.92789657764597E-12
      1.26098104291003E-23  -1.66031320101127E-08  -1.66002041135351E-08  -7.00849570057498E-19
      7.04366675754118E-09
      0.00000000000000E+00  -2.77716442578631E-11   0.00000000000000E+00   2.87204892809658E-12   1.08700426694877E-23
      2.77687225947173E-08   2.77715946436454E-08  -1.38461704894820E-19  -5.47640526006302E-01  -5.47640525995145E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11570875159501E-08   0.00000000000000E+00  -1.11570875159501E-08
      7.50799996901058E-19  -9.27999274216502E-03  -4.04527932723378E-03   0.00000000000000E+00   2.49024825821311E-12
      6.39994363197058E-24  -1.66169973759536E-08  -1.66145071276953E-08  -6.12338292006237E-19
      7.05041675754118E-09
      0.00000000000000E+00  -2.82358275597099E-11   0.00000000000000E+00   3.42128841674765E-12   8.86816018591659E-24
      2.82323935588164E-08   2.82358148472331E-08  -1.22796127477729E-19  -5.54959671668375E-01  -5.54959671656874E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15010461485457E-08   0.00000000000000E+00  -1.15010461485457E-08
      6.73167935398374E-19  -9.28951488434320E-03  -4.01690957336562E-03   0.00000000000000E+00   1.64455913249700E-12
      3.42940905037953E-24  -1.67364132578201E-08  -1.67347686986876E-08  -5.50371807920647E-19
      7.05952925754118E-09
      0.00000000000000E+00  -2.88922418965321E-11   0.00000000000000E+00   3.58568654334096E-12   7.21597680238179E-24
      2.88886485663102E-08   2.88922342528536E-08  -1.01524714221902E-19  -5.65006501569794E-01  -5.65006501557961E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18336586841278E-08   0.00000000000000E+00  -1.18336586841278E-08
      5.65333720639259E-19  -9.37281891327251E-03  -3.99819072062647E-03   0.00000000000000E+00   7.33451084694270E-13
      1.02822870878705E-24  -1.70593090198104E-08  -1.70585755687257E-08  -4.63809006417358E-19
      7.06260472629118E-09
      0.00000000000000E+00  -2.91640104739292E-11   0.00000000000000E+00   4.38078557042298E-12   6.74653146365123E-24
      2.91596153479747E-08   2.91639961335452E-08  -9.43866275270808E-20  -5.68409371100858E-01  -5.68409371088889E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19693758159745E-08   0.00000000000000E+00  -1.19693758159745E-08
      5.28522279360224E-19  -9.41736918657501E-03  -3.99987694363228E-03   0.00000000000000E+00   2.57943728500723E-13
      3.28842373576346E-25  -1.71948782612992E-08  -1.71946203175707E-08  -4.34135651833144E-19
      7.06675660910368E-09
      0.00000000000000E+00  -2.94399120645006E-11   0.00000000000000E+00   3.32357496879846E-12   6.25460195294728E-24
      2.94366385907182E-08   2.94399621656870E-08  -8.47854831214284E-20  -5.73004254472747E-01  -5.73004254460692E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20558746095189E-08   0.00000000000000E+00  -1.20558746095189E-08
      4.78467700779308E-19  -9.47219668464839E-03  -3.99500865775507E-03   0.00000000000000E+00   1.55809291365212E-13
     -3.65738324948667E-25  -1.73842433654592E-08  -1.73840875561679E-08  -3.93682217657878E-19
      7.07236165090055E-09
      0.00000000000000E+00  -2.95601368255053E-11   0.00000000000000E+00   1.10383699718461E-12   5.75377243434104E-24
      2.95590421601652E-08   2.95601459971623E-08  -7.20733339179885E-20  -5.79114705012239E-01  -5.79114705000239E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20001811314454E-08   0.00000000000000E+00  -1.20001811314454E-08
      4.11206183967485E-19  -9.49439100422303E-03  -3.96178904835903E-03   0.00000000000000E+00   7.88124948408643E-13
     -9.86462902863737E-25  -1.75607529906655E-08  -1.75599648657171E-08  -3.39132850049496E-19
      7.07992845732633E-09
      0.00000000000000E+00  -2.92902969875896E-11   0.00000000000000E+00  -1.72194346723114E-12   5.23567110097825E-24
      2.92920381073625E-08   2.92903161638952E-08  -5.57663109820467E-20  -5.86996925816177E-01  -5.86996925804557E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16198658453101E-08   0.00000000000000E+00  -1.16198658453101E-08
      3.23280908422477E-19  -9.44251349172566E-03  -3.87510036679204E-03   0.00000000000000E+00   1.47839251809777E-12
     -1.48728552803861E-24  -1.76719287111033E-08  -1.76704503185852E-08  -2.67514597440430E-19
      7.09014364600114E-09
      0.00000000000000E+00  -2.80740889774875E-11   0.00000000000000E+00  -5.84643752060931E-12   4.63986212362284E-24
      2.80799202228412E-08   2.80740737853206E-08  -3.65700979147174E-20  -5.96321870121408E-01  -5.96321870111040E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03686090917715E-08   0.00000000000000E+00  -1.03686090917715E-08
      2.17363610254736E-19  -9.26878695665783E-03  -3.69034091899588E-03   0.00000000000000E+00   1.72956308693077E-12
     -1.85990408457132E-24  -1.77071942566361E-08  -1.77054646935492E-08  -1.80793512340018E-19
      7.10393415071213E-09
      0.00000000000000E+00  -2.39593529058531E-11   0.00000000000000E+00  -1.47011439185440E-11   3.72386050875222E-24
      2.39741143961795E-08   2.39594132522610E-08  -2.13771504606557E-20  -6.03597467010638E-01  -6.03597467004375E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.26348958425642E-09   0.00000000000000E+00  -6.26348958425642E-09
      1.30986927635834E-19  -8.83832662945145E-03  -3.26288527304071E-03   0.00000000000000E+00   1.15241176311494E-12
     -2.15380122583423E-24  -1.76970760797678E-08  -1.76959236680047E-08  -1.09609777175179E-19
      7.12255133207196E-09
      0.00000000000000E+00  -1.16257068357287E-11   0.00000000000000E+00  -3.26624850271458E-11   1.75800753673021E-24
      1.16583337044137E-08   1.16256712193866E-08  -4.22784500098399E-20  -5.92592428517373E-01  -5.92592428523436E-01
      0.00000000000000E+00   0.00000000000000E+00   6.06345743015116E-09   0.00000000000000E+00   6.06345743015116E-09
      2.43871414280576E-19  -7.77112269300405E-03  -2.19782123327493E-03   0.00000000000000E+00  -1.03091437649229E-12
     -2.61343665753759E-24  -1.76880977351612E-08  -1.76891286495377E-08  -2.01592964270736E-19
      7.14255133207196E-09
      0.00000000000000E+00   7.32810789231415E-12   0.00000000000000E+00  -4.67229980284359E-11  -1.92076278217526E-24
     -7.28138235441180E-09  -7.32810535244023E-09  -1.39769056912459E-19  -5.45115550117620E-01  -5.45115550142630E-01
      0.00000000000000E+00   0.00000000000000E+00   2.50094361863407E-08   0.00000000000000E+00   2.50094361863407E-08
      7.44060138007389E-19  -6.13151714155694E-03  -5.60671874248401E-04   0.00000000000000E+00  -4.92239710589905E-12
     -4.53160091403326E-24  -1.76764084367945E-08  -1.76813308339004E-08  -6.04291081094930E-19
      7.16255133207196E-09
      0.00000000000000E+00   2.21237439880235E-11   0.00000000000000E+00  -3.66444755591272E-11  -1.12785942753123E-23
     -2.20871415068479E-08  -2.21237859824070E-08  -3.28554888765810E-19  -4.61935823530441E-01  -4.61935823570193E-01
      0.00000000000000E+00   0.00000000000000E+00   3.97525260945009E-08   0.00000000000000E+00   3.97525260945009E-08
      1.53911065989741E-18  -4.43873005333206E-03   1.11554119587090E-03   0.00000000000000E+00  -1.11052208257116E-11
     -1.72111050094280E-23  -1.76176348912681E-08  -1.76287401120938E-08  -1.21055577113160E-18
      7.18255133207196E-09
      0.00000000000000E+00   2.37268020312436E-11   0.00000000000000E+00  -4.31972114151190E-12  -3.50492925159366E-23
     -2.37224701571732E-08  -2.37267898783148E-08  -6.12842106796327E-19  -3.48220706501604E-01  -3.48220706542986E-01
      0.00000000000000E+00   0.00000000000000E+00   4.13819612124004E-08   0.00000000000000E+00   4.13819612124004E-08
      2.36674988414541E-18  -2.21347292974659E-03   3.34911519003649E-03   0.00000000000000E+00  -2.54969915365404E-11
     -6.22598861773834E-23  -1.76296743425489E-08  -1.76551713340856E-08  -1.75390777734909E-18
      7.20255133207196E-09
      0.00000000000000E+00   1.51794552524996E-11   0.00000000000000E+00   2.04598030511332E-11  -4.28035166707216E-23
     -1.51998877211859E-08  -1.51794279181349E-08  -8.97500781415965E-19  -2.24301815006060E-01  -2.24301815037629E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15681314590829E-08   0.00000000000000E+00   3.15681314590829E-08
      2.99811251332707E-18  -8.61122939622364E-03  -3.44768196813013E-03   0.00000000000000E+00  -5.51690714166850E-11
     -8.08734402530272E-23  -1.63335344695313E-08  -1.63887035409481E-08  -2.10061173191111E-18
      7.22255133207196E-09
      0.00000000000000E+00   1.01184428534160E-11   0.00000000000000E+00   1.16982700188541E-11  -4.57563502789573E-23
     -1.01301697558888E-08  -1.01184714858700E-08  -1.09848833486567E-18  -1.21032261916998E-01  -1.21032261940133E-01
      0.00000000000000E+00   0.00000000000000E+00   2.31350516008156E-08   0.00000000000000E+00   2.31350516008156E-08
      3.46081354534338E-18  -3.73242323421393E-02  -3.32231364605408E-02   0.00000000000000E+00  -1.03357242154679E-10
     -9.39018203394293E-23  -1.29132228727910E-08  -1.30165801149457E-08  -2.36232521047772E-18
      7.24255133207196E-09
      0.00000000000000E+00   5.97909239220999E-12   0.00000000000000E+00   9.45454730915029E-12  -4.75157241932885E-23
     -5.98859085249780E-09  -5.97913630518869E-09  -1.21663207754193E-18  -5.27902566199884E-02  -5.27902566357552E-02
      0.00000000000000E+00   0.00000000000000E+00   1.57667265872992E-08   0.00000000000000E+00   1.57667265872992E-08
      3.77614807708937E-18  -8.42282667220806E-02  -8.11445129563889E-02   0.00000000000000E+00  -1.58404539127257E-10
     -1.06481924479410E-22  -9.62918574298315E-09  -9.78759028211051E-09  -2.55951599954744E-18
      7.24505133207196E-09
      0.00000000000000E+00   4.77932459006807E-12   0.00000000000000E+00   2.26770866032625E-11  -4.76448308780793E-23
     -4.80196366259086E-09  -4.77928657598765E-09  -1.22840046347427E-18  -4.57063187583484E-02  -4.57063187719702E-02
      0.00000000000000E+00   0.00000000000000E+00   1.36218558201416E-08   0.00000000000000E+00   1.36218558201416E-08
      3.81020271663972E-18  -9.07357981202848E-02  -8.79497638345846E-02   0.00000000000000E+00  -1.83169255622972E-10
     -1.08075506778943E-22  -8.65939998853059E-09  -8.84256924415367E-09  -2.58180225316546E-18
      7.24842633207196E-09
      0.00000000000000E+00   3.52307227454352E-12   0.00000000000000E+00   1.78690308746889E-11  -4.77738072351022E-23
     -3.54090939382585E-09  -3.52304036295121E-09  -1.24004524921701E-18  -3.85606468425220E-02  -3.85606468539959E-02
      0.00000000000000E+00   0.00000000000000E+00   1.14738132919663E-08   0.00000000000000E+00   1.14738132919663E-08
      3.84892683650011E-18  -1.00335475080234E-01  -9.78304160328806E-02   0.00000000000000E+00  -1.83344493060601E-10
     -1.10099438613793E-22  -7.76742843595418E-09  -7.95077292901489E-09  -2.60888158728310E-18
      7.25298258207196E-09
      0.00000000000000E+00   2.35903207517532E-12   0.00000000000000E+00   1.22821479828409E-11  -4.78839940593816E-23
     -2.37129948217493E-09  -2.35901733419214E-09  -1.25046075269558E-18  -3.19948901806875E-02  -3.19948901901377E-02
      0.00000000000000E+00   0.00000000000000E+00   9.45024014397928E-09   0.00000000000000E+00   9.45024014397928E-09
      3.89198449315612E-18  -1.14197816775844E-01  -1.11963575436550E-01   0.00000000000000E+00  -1.80969932645298E-10
     -1.12640466054688E-22  -6.91025287714211E-09  -7.09122280978752E-09  -2.64152374046053E-18
      7.25913351957196E-09
      0.00000000000000E+00   1.43654353466293E-12   0.00000000000000E+00   7.21176460253387E-12  -4.79680940379753E-23
     -1.44372592777100E-09  -1.43651416316851E-09  -1.25884945438916E-18  -2.64727425849615E-02  -2.64727425927211E-02
      0.00000000000000E+00   0.00000000000000E+00   7.75961170509027E-09   0.00000000000000E+00   7.75961170509027E-09
      3.93971337977840E-18  -1.33653458247077E-01  -1.31661229328676E-01   0.00000000000000E+00  -1.81314865379520E-10
     -1.15860556025873E-22  -6.14178267654203E-09  -6.32309754192167E-09  -2.68086392538923E-18
      7.26743728519696E-09
      0.00000000000000E+00   8.21000105898082E-13   0.00000000000000E+00   3.55816177707633E-12  -4.80279002954962E-23
     -8.24574475578690E-10  -8.21016313801661E-10  -1.26507180511607E-18  -2.20715354004112E-02  -2.20715354069011E-02
      0.00000000000000E+00   0.00000000000000E+00   6.48994063066468E-09   0.00000000000000E+00   6.48994063066468E-09
      3.99360432569560E-18  -1.60062961540764E-01  -1.58276841875718E-01   0.00000000000000E+00  -1.86025369889800E-10
     -1.20006081245203E-22  -5.48289894697300E-09  -5.66892431686292E-09  -2.72853252057953E-18
      7.27864736879071E-09
      0.00000000000000E+00   4.63632233423595E-13   0.00000000000000E+00   1.52512197831778E-12  -4.80677469731065E-23
     -4.65190399950854E-10  -4.63665277972584E-10  -1.26948510443619E-18  -1.85812306341382E-02  -1.85812306396617E-02
      0.00000000000000E+00   0.00000000000000E+00   5.52348046224168E-09   0.00000000000000E+00   5.52348046224168E-09
      4.05552300340577E-18  -1.94541413092710E-01  -1.92947203906574E-01   0.00000000000000E+00  -1.94124050736607E-10
     -1.25371082415016E-22  -4.86569113353243E-09  -5.05981518426916E-09  -2.78603789896958E-18
      7.29378098164227E-09
      0.00000000000000E+00   2.75074987936543E-13   0.00000000000000E+00   5.95025268834131E-13  -4.80919560509743E-23
     -2.75657142871977E-10  -2.75062117603190E-10  -1.27262151312303E-18  -1.57315620279576E-02  -1.57315620325662E-02
      0.00000000000000E+00   0.00000000000000E+00   4.60856741256904E-09   0.00000000000000E+00   4.60856741256904E-09
      4.12526727842792E-18  -2.36681338124963E-01  -2.35315965668788E-01   0.00000000000000E+00  -1.98392903404604E-10
     -1.32075340744768E-22  -4.13511239156104E-09  -4.33350529496578E-09  -2.85264576530489E-18
      7.31378098164227E-09
      0.00000000000000E+00   1.88373556012637E-13   0.00000000000000E+00   2.06962186101657E-13  -4.81062540209548E-23
     -1.88577313838477E-10  -1.88370351652423E-10  -1.27507662279972E-18  -1.33503598896260E-02  -1.33503598931313E-02
      0.00000000000000E+00   0.00000000000000E+00   3.50529373914745E-09   0.00000000000000E+00   3.50529373914745E-09
      4.19537315321087E-18  -2.80687451296385E-01  -2.79642373273033E-01   0.00000000000000E+00  -1.80762182706411E-10
     -1.39353118147135E-22  -3.13616120478844E-09  -3.31692338749499E-09  -2.92029653041115E-18
      7.33378098164227E-09
      0.00000000000000E+00   1.53380711136570E-13   0.00000000000000E+00   8.42340337348672E-14  -4.81128446341000E-23
     -1.53531923004607E-10  -1.53447688970921E-10  -1.27686402992808E-18  -1.17477308380519E-02  -1.17477308405266E-02
      0.00000000000000E+00   0.00000000000000E+00   2.47478613416751E-09   0.00000000000000E+00   2.47478613416751E-09
      4.24486887589422E-18  -3.11616568380501E-01  -3.10885171717028E-01   0.00000000000000E+00  -1.42812938450525E-10
     -1.44647860961518E-22  -2.17852550674601E-09  -2.32133844519668E-09  -2.96800484596614E-18
      7.35378098164227E-09
      0.00000000000000E+00   1.35287297906687E-13   0.00000000000000E+00   4.53092594038841E-14  -4.81148597000419E-23
     -1.35336204155759E-10  -1.35290894896404E-10  -1.27830917912787E-18  -1.06521714792958E-02  -1.06521714809592E-02
      0.00000000000000E+00   0.00000000000000E+00   1.66340609735638E-09   0.00000000000000E+00   1.66340609735638E-09
      4.27813699784135E-18  -3.31417666352261E-01  -3.30936196864205E-01   0.00000000000000E+00  -9.75835230396243E-11
     -1.48084697259954E-22  -1.43053167942014E-09  -1.52811520245991E-09  -2.99982781871348E-18
      7.37378098164227E-09
      0.00000000000000E+00   1.29776613674235E-13   0.00000000000000E+00   1.46456787856300E-14  -4.81162685030456E-23
     -1.29756483976510E-10  -1.29741838297772E-10  -1.27965638901455E-18  -9.85970012299999E-03  -9.85970012401448E-03
      0.00000000000000E+00   0.00000000000000E+00   1.01449006614475E-09   0.00000000000000E+00   1.01449006614475E-09
      4.29842679916424E-18  -3.41747728729182E-01  -3.41468972933422E-01   0.00000000000000E+00  -5.13342853680118E-11
     -1.49849846566946E-22  -8.33413942478863E-10  -8.84748227847025E-10  -3.01877041014969E-18
      7.39378098164227E-09
      0.00000000000000E+00   1.06999118846769E-13   0.00000000000000E+00   6.04410834764343E-14  -4.81089630056556E-23
     -1.07029013200472E-10  -1.06968572117044E-10  -1.28055852789641E-18  -9.43671976036503E-03  -9.43671976106513E-03
      0.00000000000000E+00   0.00000000000000E+00   7.00105203106527E-10   0.00000000000000E+00   7.00105203106527E-10
      4.31242890322637E-18  -3.48054307867743E-01  -3.47867434153715E-01   0.00000000000000E+00  -2.94316402971451E-11
     -1.50846107122642E-22  -5.63704990692194E-10  -5.93136630989490E-10  -3.03187037532996E-18
      7.41378098164227E-09
      0.00000000000000E+00   8.09152134798311E-14   0.00000000000000E+00   7.26559118415076E-14  -4.80927405363586E-23
     -8.09750978525898E-11  -8.09024419407964E-11  -1.28095160868233E-18  -9.27286886013639E-03  -9.27286886088532E-03
      0.00000000000000E+00   0.00000000000000E+00   7.48931796772602E-10   0.00000000000000E+00   7.48931796772602E-10
      4.32740753916182E-18  -3.55937103577529E-01  -3.55726631744824E-01   0.00000000000000E+00  -3.76688346544977E-11
     -1.52084348148819E-22  -6.30360520177172E-10  -6.68029354831822E-10  -3.04645593047949E-18
      7.42378098164227E-09
      0.00000000000000E+00   5.75866502291193E-14   0.00000000000000E+00   1.26896114448536E-13  -4.80799891387162E-23
     -5.77286964349471E-11  -5.76018003205466E-11  -1.28091900452442E-18  -9.28597138910210E-03  -9.28597139001634E-03
      0.00000000000000E+00   0.00000000000000E+00   9.14242924394569E-10   0.00000000000000E+00   9.14242924394569E-10
      4.33654996840577E-18  -3.61517272283188E-01  -3.61247370809651E-01   0.00000000000000E+00  -5.59059096596777E-11
     -1.52984488867250E-22  -8.00735214414071E-10  -8.56641124073902E-10  -3.05563096388136E-18
      7.42715598164227E-09
      0.00000000000000E+00   3.33396396063322E-14   0.00000000000000E+00   3.67038862801261E-13  -4.80731755550607E-23
     -3.37223215042594E-11  -3.33552826415062E-11  -1.28082669011602E-18  -9.32892148341750E-03  -9.32892148445643E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03893247427733E-09   0.00000000000000E+00   1.03893247427733E-09
      4.34005636550646E-18  -3.63865923694216E-01  -3.63549093516297E-01   0.00000000000000E+00  -7.11577536452172E-11
     -1.53366322518061E-22  -9.34419437990438E-10  -1.00557719163581E-09  -3.05922967539043E-18
      7.43171223164227E-09
      0.00000000000000E+00   1.54299158508645E-14   0.00000000000000E+00   2.14673294275173E-13  -4.80636093542704E-23
     -1.56812840279998E-11  -1.54666107337727E-11  -1.28062170340380E-18  -9.40965702954084E-03  -9.40965703081517E-03
      0.00000000000000E+00   0.00000000000000E+00   1.27433205592162E-09   0.00000000000000E+00   1.27433205592162E-09
      4.34586254093625E-18  -3.67991719648889E-01  -3.67595081064013E-01   0.00000000000000E+00  -9.53432000357309E-11
     -1.54053626174624E-22  -1.16352224515203E-09  -1.25886544518792E-09  -3.06524083753245E-18
      7.43786316914227E-09
      0.00000000000000E+00   1.79097237554677E-14   0.00000000000000E+00   1.23788783423545E-15  -4.80526814801033E-23
     -1.78757767067633E-11  -1.78745388189772E-11  -1.28036212943722E-18  -9.47410400179235E-03  -9.47410400332320E-03
      0.00000000000000E+00   0.00000000000000E+00   1.53085349719754E-09   0.00000000000000E+00   1.53085349719754E-09
      4.35527872511917E-18  -3.74739426416444E-01  -3.74262719814148E-01   0.00000000000000E+00  -1.19640359531071E-10
     -1.55212026578694E-22  -1.39333859884728E-09  -1.51297895837851E-09  -3.07491659568195E-18
      7.44616693476727E-09
      0.00000000000000E+00   3.15945895993892E-14   0.00000000000000E+00  -6.49763333915092E-14  -4.80407524156871E-23
     -3.15185278504056E-11  -3.15835041838451E-11  -1.28013003888685E-18  -9.45964584354600E-03  -9.45964584526101E-03
      0.00000000000000E+00   0.00000000000000E+00   1.71500072351734E-09   0.00000000000000E+00   1.71500072351734E-09
      4.36951968917396E-18  -3.84851463807601E-01  -3.84321054225054E-01   0.00000000000000E+00  -1.37996539029682E-10
     -1.56996248366354E-22  -1.54542068030381E-09  -1.68341721933365E-09  -3.08938965028712E-18
      7.45737701836102E-09
      0.00000000000000E+00   4.87695554571967E-14   0.00000000000000E+00  -6.30190955705156E-14  -4.80283102353622E-23
     -4.86954814105644E-11  -4.87585005061829E-11  -1.28001735438617E-18  -9.30531240384003E-03  -9.30531240562768E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78765035095549E-09   0.00000000000000E+00   1.78765035095549E-09
      4.38955939904457E-18  -3.98883565792876E-01  -3.98335676591329E-01   0.00000000000000E+00  -1.48227281754006E-10
     -1.59538595425523E-22  -1.59066456869517E-09  -1.73889185044934E-09  -3.10954204465840E-18
      7.47251063121259E-09
      0.00000000000000E+00   7.40268581892666E-14   0.00000000000000E+00  -7.46086247188820E-14  -4.80189195367389E-23
     -7.39184756763154E-11  -7.39930843010823E-11  -1.28026083153221E-18  -8.86674864698496E-03  -8.86674864876738E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78241433194706E-09   0.00000000000000E+00   1.78241433194706E-09
      4.41653376748533E-18  -4.17331835105415E-01  -4.16793546248683E-01   0.00000000000000E+00  -1.52859199011463E-10
     -1.62994977691841E-22  -1.55556204863429E-09  -1.70842124764592E-09  -3.13627293595312E-18
      7.49251063121259E-09
      0.00000000000000E+00   1.21143208376728E-13   0.00000000000000E+00  -1.17538068444997E-13  -4.80246999773163E-23
     -1.21082190841913E-10  -1.21199728910406E-10  -1.28154700146143E-18  -7.73617614459657E-03  -7.73617614636039E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76381426163045E-09   0.00000000000000E+00   1.76381426163045E-09
      4.45181005271794E-18  -4.40321314466689E-01  -4.39803759569915E-01   0.00000000000000E+00  -1.56373259496415E-10
     -1.67532056363071E-22  -1.48624127322357E-09  -1.64261453272015E-09  -3.17026305125651E-18
      7.51251063121259E-09
      0.00000000000000E+00   1.65779750659586E-13   0.00000000000000E+00  -1.19520509714395E-13  -4.80464939224385E-23
     -1.65691229242042E-10  -1.65810749751804E-10  -1.28374192691647E-18  -6.09136924703954E-03  -6.09136924878007E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74053625580119E-09   0.00000000000000E+00   1.74053625580119E-09
      4.48662077783396E-18  -4.61927238879978E-01  -4.61431073163817E-01   0.00000000000000E+00  -1.60419755429923E-10
     -1.72045273642201E-22  -1.41430575061924E-09  -1.57472550604934E-09  -3.20287885091750E-18
      7.53251063121258E-09
      0.00000000000000E+00   1.71382279629245E-13   0.00000000000000E+00  -2.47996319694704E-14  -4.80681280355613E-23
     -1.71329369040952E-10  -1.71354168672970E-10  -1.28606266505797E-18  -4.40053931081259E-03  -4.40053931248312E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67053093983457E-09   0.00000000000000E+00   1.67053093983457E-09
      4.52003139663065E-18  -4.82437892564524E-01  -4.81965529673888E-01   0.00000000000000E+00  -1.62488577843495E-10
     -1.76487193377238E-22  -1.33668819331791E-09  -1.49917677116158E-09  -3.23396873157269E-18
      7.55251063121258E-09
      0.00000000000000E+00   2.18406785079499E-13   0.00000000000000E+00  -1.35366803399861E-13  -4.81093150432923E-23
     -2.18316946748625E-10  -2.18452313552073E-10  -1.28933684719375E-18  -2.15631311867255E-03  -2.15631312035023E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67768448973067E-09   0.00000000000000E+00   1.67768448973067E-09
      4.55358508642527E-18  -5.01946572964339E-01  -5.01486794119217E-01   0.00000000000000E+00  -1.68585664722728E-10
     -1.80971060972019E-22  -1.29064651145570E-09  -1.45923217617861E-09  -3.26424823923152E-18
      7.57251063121258E-09
      0.00000000000000E+00  -5.80183204939947E-13   0.00000000000000E+00   2.08239262694474E-12  -4.78170576112847E-23
      5.78075531313309E-10   5.80157923940205E-10  -1.27669569788505E-18  -9.54035155713711E-03  -9.54035155747871E-03
      0.00000000000000E+00   0.00000000000000E+00   3.41600492553204E-10   0.00000000000000E+00   3.41600492553204E-10
      4.56041709627634E-18  -5.21594124020538E-01  -5.21303703568888E-01   0.00000000000000E+00  -9.68616126911835E-11
     -1.83491580428957E-22  -8.24896803802064E-10  -9.21758416493431E-10  -3.28372139839128E-18
      7.59251063121258E-09
      0.00000000000000E+00  -2.48807393095190E-12   0.00000000000000E+00   5.10134472291016E-12  -4.67977493742382E-23
      2.48295109425899E-09   2.48805243898186E-09  -1.22623393943808E-18  -3.90088930036427E-02  -3.90088930009228E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.71990270856165E-09   0.00000000000000E+00  -2.71990270856165E-09
      4.50601904210510E-18  -5.42537265925671E-01  -5.42610356524270E-01   0.00000000000000E+00   7.72506103570186E-11
     -1.81456943921890E-22   1.54599659222974E-10   2.31850269579811E-10  -3.27978510266702E-18
      7.59751063121258E-09
      0.00000000000000E+00  -3.27839789462267E-12   0.00000000000000E+00   8.25431633654791E-12  -4.64562131035195E-23
      3.27023531080733E-09   3.27848962714383E-09  -1.20971631873430E-18  -4.84599990706784E-02  -4.84599990667329E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.94554557417202E-09   0.00000000000000E+00  -3.94554557417202E-09
      4.48629131423424E-18  -5.47857024638267E-01  -5.48067256673735E-01   0.00000000000000E+00   1.41480844301517E-10
     -1.80522315340297E-22   5.25575102726987E-10   6.67055947028323E-10  -3.27657499549994E-18
      7.60426063121258E-09
      0.00000000000000E+00  -4.02610590022914E-12   0.00000000000000E+00   6.04325442135647E-12  -4.59347284605767E-23
      4.02012362541791E-09   4.02616687983922E-09  -1.18253043677759E-18  -6.37494002237682E-02  -6.37494002186809E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.08729099123477E-09   0.00000000000000E+00  -5.08729099123477E-09
      4.45195210004340E-18  -5.55180000666798E-01  -5.55514410192286E-01   0.00000000000000E+00   1.96261305023924E-10
     -1.78750502482109E-22   8.64862806371618E-10   1.06112411139536E-09  -3.26942166326581E-18
      7.61337313121258E-09
      0.00000000000000E+00  -5.00884458834968E-12   0.00000000000000E+00   5.90686285404911E-12  -4.50980661335193E-23
      5.00295867809174E-09   5.00886554094574E-09  -1.13752072320655E-18  -8.83978789181877E-02  -8.83978789116919E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.49582180212965E-09   0.00000000000000E+00  -6.49582180212965E-09
      4.39275892387150E-18  -5.65224805150192E-01  -5.65693394454564E-01   0.00000000000000E+00   2.55573560166274E-10
     -1.75583930701655E-22   1.23138270101764E-09   1.48695626118374E-09  -3.25523820066495E-18
      7.61644859996258E-09
      0.00000000000000E+00  -5.49093761395199E-12   0.00000000000000E+00   8.27342877186958E-12  -4.47850587365251E-23
      5.48266851004013E-09   5.49094193881196E-09  -1.12097612598338E-18  -9.72695115807681E-02  -9.72695115736231E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.14497002649844E-09   0.00000000000000E+00  -7.14497002649844E-09
      4.37078479183532E-18  -5.68626066801015E-01  -5.69147302133418E-01   0.00000000000000E+00   2.74707223713126E-10
     -1.74421803246579E-22   1.37932086397405E-09   1.65402808768700E-09  -3.24980866585194E-18
      7.62060048277508E-09
      0.00000000000000E+00  -5.97394908692637E-12   0.00000000000000E+00   6.34504445723099E-12  -4.43468788505178E-23
      5.96758981845856E-09   5.97393486291575E-09  -1.09697448522577E-18  -1.09937175050537E-01  -1.09937175042780E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.75664583872449E-09   0.00000000000000E+00  -7.75664583872449E-09
      4.33858010729486E-18  -5.73217250364245E-01  -5.73779041606171E-01   0.00000000000000E+00   2.93675578352568E-10
     -1.72728324198041E-22   1.48903539745597E-09   1.78271097580836E-09  -3.24160562206909E-18
      7.62620552457196E-09
      0.00000000000000E+00  -6.49764777848369E-12   0.00000000000000E+00   5.18402737151847E-12  -4.37080742554145E-23
      6.49245031936528E-09   6.49763434673675E-09  -1.06264337053330E-18  -1.27669284671493E-01  -1.27669284663213E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.27969969357177E-09   0.00000000000000E+00  -8.27969969357177E-09
      4.29217204444682E-18  -5.79319693612604E-01  -5.79881300176727E-01   0.00000000000000E+00   3.03401778000007E-10
     -1.70335143900107E-22   1.47866356883508E-09   1.78206534683491E-09  -3.22952867391352E-18
      7.63377233099774E-09
      0.00000000000000E+00  -7.19640253915855E-12   0.00000000000000E+00   5.07308884118101E-12  -4.25892398268414E-23
      7.19128802044380E-09   7.19636110928494E-09  -1.01445339494424E-18  -1.51840689854743E-01  -1.51840689846078E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.66528600069851E-09   0.00000000000000E+00  -8.66528600069851E-09
      4.22660350265551E-18  -5.87183469852761E-01  -5.87646455961360E-01   0.00000000000000E+00   3.01091021186575E-10
     -1.67073213213705E-22   1.16783387022703E-09   1.46892489141344E-09  -3.21215010771126E-18
      7.64398751967254E-09
      0.00000000000000E+00  -8.64911074757000E-12   0.00000000000000E+00   7.44614326584257E-12  -3.92911026730209E-23
      8.64166514984898E-09   8.64911129311479E-09  -9.48402551131461E-19  -1.83731629601140E-01  -1.83731629592209E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.93147452529430E-09   0.00000000000000E+00  -8.93147452529430E-09
      4.13536680523541E-18  -5.96458090538386E-01  -5.96547341058933E-01   0.00000000000000E+00   2.89503047519213E-10
     -1.62739561406130E-22  -7.13981533959068E-12   2.82363232179460E-10  -3.18696425410395E-18
      7.65777802438353E-09
      0.00000000000000E+00  -1.30182567412693E-11   0.00000000000000E+00   1.59441250240792E-11  -2.38662706910905E-23
      1.30022839152054E-08   1.30182280402295E-08  -8.61765021289720E-19  -2.23677133560697E-01  -2.23677133551504E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.19290950475464E-09   0.00000000000000E+00  -9.19290950475464E-09
      4.00859194340242E-18  -6.03575634429421E-01  -6.02371029201613E-01   0.00000000000000E+00   2.80967418084335E-10
     -1.56845640073766E-22  -4.10628595355886E-09  -3.82531853547468E-09  -3.14682692211270E-18
      7.67639520574336E-09
      0.00000000000000E+00  -2.60642505931752E-11   0.00000000000000E+00   3.47826976935094E-11   3.75301330093071E-23
      2.60294607676994E-08   2.60642434653929E-08  -7.60630561957781E-19  -2.68357978686161E-01  -2.68357978676486E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67460705458455E-09   0.00000000000000E+00  -9.67460705458455E-09
      3.82847802928212E-18  -5.92149889691808E-01  -5.86987487206897E-01   0.00000000000000E+00   2.99697665743016E-10
     -1.47660051735375E-22  -1.66893340765513E-08  -1.63896364108084E-08  -3.06784746732433E-18
      7.69639520574336E-09
      0.00000000000000E+00  -4.61888101864024E-11   0.00000000000000E+00   4.98991291128693E-11   1.33558760985794E-22
      4.61389071008192E-08   4.61888062299322E-08  -6.81061831641774E-19  -3.03223344079115E-01  -3.03223344068759E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03553709135449E-08   0.00000000000000E+00  -1.03553709135449E-08
      3.62137061101122E-18  -5.44138045816506E-01  -5.32850174556890E-01   0.00000000000000E+00   3.18883015844930E-10
     -1.35001202836507E-22  -3.61523183322319E-08  -3.58334353163871E-08  -2.94030877936944E-18
      7.71639520574336E-09
      0.00000000000000E+00  -6.22557611345383E-11   0.00000000000000E+00   3.99734849354757E-11   2.08978090465214E-22
      6.22157866598084E-08   6.22557601447441E-08  -6.30802444408628E-19  -3.26298442548336E-01  -3.26298442537356E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09799135086147E-08   0.00000000000000E+00  -1.09799135086147E-08
      3.40177234083892E-18  -4.60484187952920E-01  -4.44330713661808E-01   0.00000000000000E+00   2.95730418106933E-10
     -1.19219557932400E-22  -5.15715770542363E-08  -5.12758466361295E-08  -2.77096989643029E-18
      7.73639520574336E-09
      0.00000000000000E+00  -6.53591029600434E-11   0.00000000000000E+00   7.82531869751608E-12   2.23970250143672E-22
      6.53512498786140E-08   6.53590751973117E-08  -6.06291912048863E-19  -3.39376300930052E-01  -3.39376300918515E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15365997040939E-08   0.00000000000000E+00  -1.15365997040939E-08
      3.17104034675705E-18  -3.46401505543610E-01  -3.29444961968167E-01   0.00000000000000E+00   2.47623481406262E-10
     -1.02864183121957E-22  -5.40700989746239E-08  -5.38224754932178E-08  -2.56474843470818E-18
      7.75639520574336E-09
      0.00000000000000E+00  -5.71064859429983E-11   0.00000000000000E+00  -2.04298903378909E-11   1.86782191092538E-22
      5.71269231810921E-08   5.71064932907544E-08  -5.98576165664310E-19  -3.46017412337945E-01  -3.46017412326032E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19128774961836E-08   0.00000000000000E+00  -1.19128774961836E-08
      2.93278279683337E-18  -2.22643214429833E-01  -2.08404719277617E-01   0.00000000000000E+00   1.75507623542031E-10
     -8.62404971925974E-23  -4.53691234181129E-08  -4.51936157945709E-08  -2.33420663116907E-18
      7.76639520574336E-09
      0.00000000000000E+00  -5.19464649172051E-11   0.00000000000000E+00  -2.55870136491210E-11   1.62401366246009E-22
      5.19720906835746E-08   5.19465036699257E-08  -5.96486129574969E-19  -3.48686112596221E-01  -3.48686112584228E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19927111914404E-08   0.00000000000000E+00  -1.19927111914404E-08
      2.81285568491897E-18  -1.65478180950581E-01  -1.52890374406402E-01   0.00000000000000E+00   1.17963313122576E-10
     -7.98043293274138E-23  -4.00717557916077E-08  -3.99537924784852E-08  -2.21636955534400E-18
      7.77314520574336E-09
      0.00000000000000E+00  -4.91135139980389E-11   0.00000000000000E+00  -2.08499278948808E-11   1.47016025949260E-22
      4.91344119504198E-08   4.91135620225250E-08  -5.94376118199177E-19  -3.50780950672313E-01  -3.50780950660379E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19335066236504E-08   0.00000000000000E+00  -1.19335066236504E-08
      2.73230451520933E-18  -1.30682840976873E-01  -1.18968854706587E-01   0.00000000000000E+00   8.75831395457988E-11
     -7.63725291258291E-23  -3.72676385384204E-08  -3.71800553988747E-08  -2.13792839701015E-18
      7.77770145574336E-09
      0.00000000000000E+00  -4.73099588934947E-11   0.00000000000000E+00  -1.96350286794169E-11   1.37362304913415E-22
      4.73296119560608E-08   4.73099769273815E-08  -5.92484763431136E-19  -3.52371896202828E-01  -3.52371896190955E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18731972962235E-08   0.00000000000000E+00  -1.18731972962235E-08
      2.67820726002841E-18  -1.09067708585546E-01  -9.79029230655079E-02   0.00000000000000E+00   7.33078826932482E-11
     -7.29228543395364E-23  -3.55100875138513E-08  -3.54367796311581E-08  -2.08572249659728E-18
      7.78385239324336E-09
      0.00000000000000E+00  -4.51103692821116E-11   0.00000000000000E+00  -1.77283880456664E-11   1.26702182412792E-22
      4.51281116413073E-08   4.51103832532617E-08  -5.88300282253427E-19  -3.55109154016205E-01  -3.55109154004473E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17320562232433E-08   0.00000000000000E+00  -1.17320562232433E-08
      2.60604411545276E-18  -8.35621709398002E-02  -7.30458875505467E-02   0.00000000000000E+00   5.98517055331188E-11
     -6.26622260498998E-23  -3.34381787355515E-08  -3.33783270300184E-08  -2.01774383319933E-18
      7.79215615886836E-09
      0.00000000000000E+00  -4.18206744848124E-11   0.00000000000000E+00  -1.95923194122688E-11   1.18273610034589E-22
      4.18402526974192E-08   4.18206603780070E-08  -5.77870663395950E-19  -3.60431640910952E-01  -3.60431640899511E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14409981966718E-08   0.00000000000000E+00  -1.14409981966718E-08
      2.51104074791154E-18  -5.70812113974207E-02  -4.75096622005531E-02   0.00000000000000E+00   4.86377003352398E-11
     -3.02531879811860E-23  -3.04282998816703E-08  -3.03796621813350E-08  -1.93317008451559E-18
      7.79776120066523E-09
      0.00000000000000E+00  -3.90088478552040E-11   0.00000000000000E+00  -2.47601736280339E-11   1.16253093266973E-22
      3.90336128209908E-08   3.90088526473629E-08  -5.67451663593263E-19  -3.65127596799483E-01  -3.65127596788323E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11597517405398E-08   0.00000000000000E+00  -1.11597517405398E-08
      2.44848987296307E-18  -4.38963513007153E-02  -3.51220754864505E-02   0.00000000000000E+00   4.43598376242649E-11
      4.26313011560986E-24  -2.78934607444476E-08  -2.78491009068234E-08  -1.88103820936981E-18
      7.80154460387812E-09
      0.00000000000000E+00  -3.71218058845382E-11   0.00000000000000E+00  -2.46463440224042E-11   1.16868246418106E-22
      3.71464746151505E-08   3.71218282711282E-08  -5.58754254871677E-19  -3.68848054506843E-01  -3.68848054495898E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09452275401118E-08   0.00000000000000E+00  -1.09452275401118E-08
      2.40707966392199E-18  -3.71431291006571E-02  -2.88957902313884E-02   0.00000000000000E+00   3.93494462331843E-11
      2.95393542169200E-23  -2.62159501772496E-08  -2.61766007310164E-08  -1.84832540905032E-18
      7.80665219821553E-09
      0.00000000000000E+00  -3.52367844980909E-11   0.00000000000000E+00  -1.82723449197743E-11   1.20732166821618E-22
      3.52550303263964E-08   3.52367579814768E-08  -5.44899475827880E-19  -3.74597433561282E-01  -3.74597433550583E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06998660657690E-08   0.00000000000000E+00  -1.06998660657690E-08
      2.35242908859351E-18  -3.08708711347110E-02  -2.31401369798700E-02   0.00000000000000E+00   2.98044133163446E-11
      6.08634515446744E-23  -2.45666963290240E-08  -2.45368919157076E-08  -1.80752961276563E-18
      7.81354745057102E-09
      0.00000000000000E+00  -3.36070914810805E-11   0.00000000000000E+00  -1.16810604624726E-11   1.28490680345491E-22
      3.36187862262374E-08   3.36071051657750E-08  -5.24253552426398E-19  -3.83022092182196E-01  -3.83022092171716E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04797803941281E-08   0.00000000000000E+00  -1.04797803941281E-08
      2.28016835814584E-18  -2.55337187423458E-02  -1.82470804664554E-02   0.00000000000000E+00   2.10585800029406E-11
      9.72116902710940E-23  -2.31483833516502E-08  -2.31273247716471E-08  -1.75591480571945E-18
      7.82285604125094E-09
      0.00000000000000E+00  -3.23321028391656E-11   0.00000000000000E+00  -6.74185233116531E-12   1.38544843156619E-22
      3.23388719513124E-08   3.23321300989814E-08  -4.95398530903735E-19  -3.94718736902608E-01  -3.94718736892300E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03081169808488E-08   0.00000000000000E+00  -1.03081169808488E-08
      2.18421431649043E-18  -2.12332200076633E-02  -1.42941882107234E-02   0.00000000000000E+00   1.45093913810941E-11
      1.35700567992259E-22  -2.20385225095137E-08  -2.20240131181325E-08  -1.68881578558670E-18
      7.83542263866882E-09
      0.00000000000000E+00  -3.12885629350137E-11   0.00000000000000E+00  -4.06264282483994E-12   1.45476193053030E-22
      3.12925999761954E-08   3.12885373333707E-08  -4.57130448538037E-19  -4.10261020267360E-01  -4.10261020257191E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01697226014960E-08   0.00000000000000E+00  -1.01697226014960E-08
      2.05641550670586E-18  -1.78052396483400E-02  -1.11513967631940E-02   0.00000000000000E+00   1.04392705629282E-11
      1.68332508730758E-22  -2.11292540024379E-08  -2.11188147318748E-08  -1.59928505816782E-18
      7.85238754518297E-09
      0.00000000000000E+00  -3.01934981332884E-11   0.00000000000000E+00  -3.14648806798111E-12   1.39336634284273E-22
      3.01966455370094E-08   3.01934990489416E-08  -4.08354594672025E-19  -4.30269388198776E-01  -4.30269388188750E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00260727958866E-08   0.00000000000000E+00  -1.00260727958866E-08
      1.88632411901961E-18  -1.50028890909964E-02  -8.64878925786719E-03   0.00000000000000E+00   8.24410911921910E-12
      1.78999864001346E-22  -2.01756703621744E-08  -2.01674262530550E-08  -1.47796952434759E-18
      7.87238754518297E-09
      0.00000000000000E+00  -2.89502877704473E-11   0.00000000000000E+00  -3.03285624229788E-12   1.14639293088855E-22
      2.89533149133308E-08   2.89502820570886E-08  -3.55109033089259E-19  -4.52448219336085E-01  -4.52448219326215E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.86974491747729E-09   0.00000000000000E+00  -9.86974491747729E-09
      1.68892922067007E-18  -1.28647302614284E-02  -6.85306709347674E-03   0.00000000000000E+00   7.08704141503137E-12
      1.54886173307383E-22  -1.90876241810265E-08  -1.90805371396113E-08  -1.33382018758081E-18
      7.89238754518297E-09
      0.00000000000000E+00  -2.78548555897731E-11   0.00000000000000E+00  -2.67346090837940E-12   8.20572445165169E-23
      2.78575248639697E-08   2.78548514030614E-08  -3.05621123229378E-19  -4.73415148610231E-01  -4.73415148600498E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.73294194180183E-09   0.00000000000000E+00  -9.73294194180183E-09
      1.49427038183403E-18  -1.14196806951952E-02  -5.71004506810104E-03   0.00000000000000E+00   6.02272153101286E-12
      1.11367867387299E-22  -1.81279321827907E-08  -1.81219094612596E-08  -1.18864925860465E-18
      7.91238754518297E-09
      0.00000000000000E+00  -2.69702070809902E-11   0.00000000000000E+00  -2.15695321326394E-12   5.19297977437611E-23
      2.69723617531157E-08   2.69702047999025E-08  -2.59323688726100E-19  -4.93372798574379E-01  -4.93372798564780E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.59914595179463E-09   0.00000000000000E+00  -9.59914595179463E-09
      1.30228746279814E-18  -1.04195681050853E-02  -4.94649735152588E-03   0.00000000000000E+00   4.98175212587536E-12
      6.77440920984821E-23  -1.73760406002338E-08  -1.73710588481078E-08  -1.04296377407204E-18
      7.93238754518297E-09
      0.00000000000000E+00  -2.63137927441680E-11   0.00000000000000E+00  -1.59620822339537E-12   2.98534264731042E-23
      2.63153790000350E-08   2.63137827918117E-08  -2.15619062106822E-19  -5.12570072309638E-01  -5.12570072300109E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.52930671390831E-09   0.00000000000000E+00  -9.52930671390831E-09
      1.11170132851997E-18  -9.70332650312021E-03  -4.41506596510294E-03   0.00000000000000E+00   4.19122232674334E-12
      3.49522176080897E-23  -1.67886673002301E-08  -1.67844760779033E-08  -8.96082266413148E-19
      7.95238754518297E-09
      0.00000000000000E+00  -2.70294469364891E-11   0.00000000000000E+00   1.78702106218237E-12   1.66647374436722E-23
      2.70276553263993E-08   2.70294423474615E-08  -1.70103176919662E-19  -5.33068590128709E-01  -5.33068590118277E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04323406028916E-08   0.00000000000000E+00  -1.04323406028916E-08
      9.03054516462140E-19  -9.38337647612317E-03  -4.15414849043046E-03   0.00000000000000E+00   3.13066076814200E-12
      1.50847015385621E-23  -1.66002324053381E-08  -1.65971017445699E-08  -7.32951339542478E-19
      7.97238754518297E-09
      0.00000000000000E+00  -2.79354034243041E-11   0.00000000000000E+00   2.26385213577849E-12   9.77427816323979E-24
      2.79331386455648E-08   2.79354024977006E-08  -1.23914031459735E-19  -5.54416913039397E-01  -5.54416913028180E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12161189670673E-08   0.00000000000000E+00  -1.12161189670673E-08
      6.78732137120794E-19  -9.25940902418942E-03  -3.99168288851636E-03   0.00000000000000E+00   2.25627603930977E-12
      4.90767751087240E-24  -1.67215398066726E-08  -1.67192835306333E-08  -5.54818105661057E-19
      7.97488754518296E-09
      0.00000000000000E+00  -2.81722710015623E-11   0.00000000000000E+00   4.66187819411814E-12   8.96320019369498E-24
      2.81676490718689E-08   2.81723109500630E-08  -1.18198929820943E-19  -5.57106654566407E-01  -5.57106654554942E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14643998560599E-08   0.00000000000000E+00  -1.14643998560599E-08
      6.50071137480644E-19  -9.24901404046612E-03  -3.98487083935655E-03   0.00000000000000E+00   2.67391376104588E-12
      3.65616037759102E-24  -1.67105850077643E-08  -1.67079110940033E-08  -5.31872207659701E-19
      7.97826254518297E-09
      0.00000000000000E+00  -2.85330371293135E-11   0.00000000000000E+00   5.29915952492273E-12   8.08052466264070E-24
      2.85277154427874E-08   2.85330146023123E-08  -1.10388347098872E-19  -5.60798805031099E-01  -5.60798805019404E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16949644133748E-08   0.00000000000000E+00  -1.16949644133748E-08
      6.10600632585504E-19  -9.29560130497281E-03  -3.99045419862280E-03   0.00000000000000E+00   5.89034873993266E-13
      2.31489324670964E-24  -1.68386392238116E-08  -1.68380501889376E-08  -5.00212285486633E-19
      7.98281879518297E-09
      0.00000000000000E+00  -2.89885870258628E-11   0.00000000000000E+00   4.97221461899689E-12   7.21168394466150E-24
      2.89836418182044E-08   2.89886140328234E-08  -9.97721009370155E-20  -5.65841764375223E-01  -5.65841764363315E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19079346754146E-08   0.00000000000000E+00  -1.19079346754146E-08
      5.56345105220646E-19  -9.38201129299462E-03  -4.00041844868375E-03   0.00000000000000E+00  -1.64479050247318E-13
      1.01027695646275E-24  -1.70805148783587E-08  -1.70806793574090E-08  -4.56573004283631E-19
      7.98589426393297E-09
      0.00000000000000E+00  -2.92662336664412E-11   0.00000000000000E+00   4.49627956076723E-12   6.73440653154676E-24
      2.92617828287158E-08   2.92662791082766E-08  -9.26187543105524E-20  -5.69255936454133E-01  -5.69255936442112E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20205727700363E-08   0.00000000000000E+00  -1.20205727700363E-08
      5.19376209309299E-19  -9.43851454736979E-03  -4.00492642062318E-03   0.00000000000000E+00  -2.14822353439598E-13
      3.01427560560297E-25  -1.72454915158870E-08  -1.72457063382405E-08  -4.26757454998746E-19
      7.99004614674547E-09
      0.00000000000000E+00  -2.95079690147714E-11   0.00000000000000E+00   2.92126997588415E-12   6.23552211677625E-24
      2.95050206704285E-08   2.95079419404044E-08  -8.30243774506552E-20  -5.73850622969097E-01  -5.73850622957021E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20766537772808E-08   0.00000000000000E+00  -1.20766537772808E-08
      4.69235358058893E-19  -9.48881264308549E-03  -3.99675308715130E-03   0.00000000000000E+00   1.91300180415438E-13
     -3.93354950272439E-25  -1.74314794633038E-08  -1.74312881631234E-08  -3.86210980608238E-19
      7.99565118854234E-09
      0.00000000000000E+00  -2.95752912071445E-11   0.00000000000000E+00   6.38228280659990E-13   5.72699395713326E-24
      2.95746529305758E-08   2.95752911588565E-08  -7.03573149900306E-20  -5.79942887563607E-01  -5.79942887551620E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19863653778535E-08   0.00000000000000E+00  -1.19863653778535E-08
      4.02051279123409E-19  -9.49946882301113E-03  -3.95774214237555E-03   0.00000000000000E+00   9.37009957972595E-13
     -1.01107542560809E-24  -1.75898627909609E-08  -1.75889257810029E-08  -3.31693964133378E-19
      8.00321799496812E-09
      0.00000000000000E+00  -2.92420785005556E-11   0.00000000000000E+00  -2.13665796821891E-12   5.20211824482757E-24
      2.92442076330650E-08   2.92420709750968E-08  -5.41704037159303E-20  -5.87771107758041E-01  -5.87771107746481E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15597386992278E-08   0.00000000000000E+00  -1.15597386992278E-08
      3.14580974053740E-19  -9.43607631370743E-03  -3.86491949738009E-03   0.00000000000000E+00   1.57170223141680E-12
     -1.50735527806917E-24  -1.76839039781005E-08  -1.76823322758691E-08  -2.60410570337809E-19
      8.01343318364293E-09
      0.00000000000000E+00  -2.79245657453136E-11   0.00000000000000E+00  -6.33634401875255E-12   4.59727591750817E-24
      2.79309080276696E-08   2.79245716836508E-08  -3.52928560896271E-20  -5.96942116022600E-01  -5.96942116012384E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02167058073322E-08   0.00000000000000E+00  -1.02167058073322E-08
      2.10215396596869E-19  -9.25130060907548E-03  -3.67209796994505E-03   0.00000000000000E+00   1.74295567969691E-12
     -1.87544398131034E-24  -1.77096088319985E-08  -1.77078658763188E-08  -1.74922540507243E-19
      8.02722368835391E-09
      0.00000000000000E+00  -2.35804015201348E-11   0.00000000000000E+00  -1.55225104981054E-11   3.65758856621752E-24
      2.35959173358773E-08   2.35803948253792E-08  -2.10572555784699E-20  -6.03734820613798E-01  -6.03734820607913E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.88441904878795E-09   0.00000000000000E+00  -5.88441904878795E-09
      1.29066287983141E-19  -8.80309459534230E-03  -3.22763673579813E-03   0.00000000000000E+00   1.09295147774079E-12
     -2.16786240957533E-24  -1.76970687280689E-08  -1.76959757765912E-08  -1.08009032404672E-19
      8.04584086971374E-09
      0.00000000000000E+00  -1.08741413511595E-11   0.00000000000000E+00  -3.36484729255873E-11   1.63931851953546E-24
      1.09077975613180E-08   1.08741490883924E-08  -4.45152268289489E-20  -5.91454310601689E-01  -5.91454310608505E-01
      0.00000000000000E+00   0.00000000000000E+00   6.81558731105014E-09   0.00000000000000E+00   6.81558731105014E-09
      2.55953313026729E-19  -7.70762668249022E-03  -2.13413371411886E-03   0.00000000000000E+00  -1.16703258973791E-12
     -2.64509162610513E-24  -1.76885693668529E-08  -1.76897363994426E-08  -2.11438086197781E-19
      8.06584086971374E-09
      0.00000000000000E+00   8.13597420079155E-12   0.00000000000000E+00  -4.67392050501930E-11  -2.13996067487871E-24
     -8.08907014376691E-09  -8.13580934881711E-09  -1.45644529867764E-19  -5.42361641742539E-01  -5.42361641768355E-01
      0.00000000000000E+00   0.00000000000000E+00   2.58160918696397E-08   0.00000000000000E+00   2.58160918696397E-08
      7.72275150419522E-19  -6.05618126898676E-03  -4.85705968811361E-04   0.00000000000000E+00  -5.24908982878070E-12
     -4.70993296364391E-24  -1.76750334309938E-08  -1.76802825208226E-08  -6.26630620551759E-19
      8.08584086971374E-09
      0.00000000000000E+00   2.25251973343576E-11   0.00000000000000E+00  -3.56514612024056E-11  -1.20088026598866E-23
     -2.24895272696747E-08  -2.25251787308771E-08  -3.38648924035234E-19  -4.57749965466782E-01  -4.57749965506933E-01
      0.00000000000000E+00   0.00000000000000E+00   4.01515473762413E-08   0.00000000000000E+00   4.01515473762413E-08
      1.57530609794435E-18  -4.36419040592179E-03   1.18933331943151E-03   0.00000000000000E+00  -1.14754649045489E-11
     -1.84292560596373E-23  -1.76148931804595E-08  -1.76263686453641E-08  -1.23665717390911E-18
      8.10584086971374E-09
      0.00000000000000E+00   2.34582480196488E-11   0.00000000000000E+00  -2.67737942029477E-12  -3.58168540485546E-23
     -2.34555620907360E-08  -2.34582394701564E-08  -6.26003026483421E-19  -3.42926268385679E-01  -3.42926268426798E-01
      0.00000000000000E+00   0.00000000000000E+00   4.11183680692034E-08   0.00000000000000E+00   4.11183680692034E-08
      2.39767345932842E-18  -2.09043012091047E-03   3.47371921583269E-03   0.00000000000000E+00  -2.64489229382077E-11
     -6.38527355335099E-23  -1.76336796761087E-08  -1.76601285990470E-08  -1.77167043284500E-18
      8.12584086971374E-09
      0.00000000000000E+00   1.48991451145422E-11   0.00000000000000E+00   2.04799183522885E-11  -4.29510463253292E-23
     -1.49196115597026E-08  -1.48991316413503E-08  -9.07591497057132E-19  -2.19453994905855E-01  -2.19453994937003E-01
      0.00000000000000E+00   0.00000000000000E+00   3.11472312655656E-08   0.00000000000000E+00   3.11472312655656E-08
      3.02061808463973E-18  -9.46351713718476E-03  -4.34426993956470E-03   0.00000000000000E+00  -5.67224069620366E-11
     -8.13974819809018E-23  -1.61913772172532E-08  -1.62480996242153E-08  -2.11302658758260E-18
      8.14584086971374E-09
      0.00000000000000E+00   9.95321417117967E-12   0.00000000000000E+00   1.14085816961165E-11  -4.58598968120853E-23
     -9.96457567855617E-09  -9.95316709686010E-09  -1.10529509183557E-18  -1.17268040027740E-01  -1.17268040050578E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28385556956025E-08   0.00000000000000E+00   2.28385556956025E-08
      3.47738919855178E-18  -3.89689116127051E-02  -3.49091498230058E-02   0.00000000000000E+00  -1.06007248837715E-10
     -9.44634012573292E-23  -1.27793813499046E-08  -1.28853885987424E-08  -2.37209410671621E-18
      8.16584086971374E-09
      0.00000000000000E+00   5.78695320197185E-12   0.00000000000000E+00   9.53404459966617E-12  -4.75551610403794E-23
     -5.79647114326342E-09  -5.78693709866380E-09  -1.21959182020094E-18  -5.09854537644180E-02  -5.09854537798471E-02
      0.00000000000000E+00   0.00000000000000E+00   1.54290737909185E-08   0.00000000000000E+00   1.54290737909185E-08
      3.78597067437015E-18  -8.66250866046602E-02  -8.35871600749405E-02   0.00000000000000E+00  -1.59863914036532E-10
     -1.06971916610716E-22  -9.48227277821798E-09  -9.64213669225462E-09  -2.56637885416921E-18
      8.17584086971374E-09
      0.00000000000000E+00   2.94591994593142E-12   0.00000000000000E+00   1.35321748660827E-11  -4.78787565773019E-23
     -2.95941008059238E-09  -2.94587790572635E-09  -1.24832186294425E-18  -3.32107254955349E-02  -3.32107255059763E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04414309330426E-08   0.00000000000000E+00   1.04414309330426E-08
      3.89038498370057E-18  -1.15807669184193E-01  -1.13446043579675E-01   0.00000000000000E+00  -1.78897771195319E-10
     -1.12692554012422E-22  -7.31665525612083E-09  -7.49555302731626E-09  -2.64206312075633E-18
      8.18934086971374E-09
      0.00000000000000E+00   1.19921673371868E-12   0.00000000000000E+00   6.22357522554835E-12  -4.80253021065868E-23
     -1.20546041420323E-09  -1.19923683897773E-09  -1.26354336219151E-18  -2.30317050137818E-02  -2.30317050209672E-02
      0.00000000000000E+00   0.00000000000000E+00   7.18538000116553E-09   0.00000000000000E+00   7.18538000116553E-09
      3.98738761371631E-18  -1.57989778437201E-01  -1.56103719218188E-01   0.00000000000000E+00  -1.83320602136731E-10
     -1.19591593812290E-22  -5.80282256005095E-09  -5.98614316218780E-09  -2.72384425152480E-18
      8.20756586971374E-09
      0.00000000000000E+00   4.62530096577105E-13   0.00000000000000E+00   1.94886156469283E-12  -4.80823946384550E-23
     -4.64486327811852E-10  -4.62537466247208E-10  -1.27071472855946E-18  -1.74275679493654E-02  -1.74275679547162E-02
      0.00000000000000E+00   0.00000000000000E+00   5.35073364961620E-09   0.00000000000000E+00   5.35073364961620E-09
      4.08490473448056E-18  -2.12251127297138E-01  -2.10710994579244E-01   0.00000000000000E+00  -1.93694672203016E-10
     -1.28138154057003E-22  -4.69450151116583E-09  -4.88819618336897E-09  -2.81419000592111E-18
      8.22756586971374E-09
      0.00000000000000E+00   2.33744856193156E-13   0.00000000000000E+00   5.51886110747284E-13  -4.81021238897393E-23
     -2.34298830657973E-10  -2.33746944547274E-10  -1.27405919051476E-18  -1.43299272253805E-02  -1.43299272294404E-02
      0.00000000000000E+00   0.00000000000000E+00   4.05997277876490E-09   0.00000000000000E+00   4.05997277876490E-09
      4.16610419005587E-18  -2.62187644941996E-01  -2.60982102131818E-01   0.00000000000000E+00  -1.91425860503510E-10
     -1.36251986033908E-22  -3.63479997371399E-09  -3.82622583421764E-09  -2.89204499954111E-18
      8.24756586971374E-09
      0.00000000000000E+00   1.68167713826981E-13   0.00000000000000E+00   1.58073027303539E-13  -4.81110221565416E-23
     -1.68357729783267E-10  -1.68199656756011E-10  -1.27612908038011E-18  -1.23929195271584E-02  -1.23929195300841E-02
      0.00000000000000E+00   0.00000000000000E+00   2.92569279335091E-09   0.00000000000000E+00   2.92569279335091E-09
      4.22461804592288E-18  -2.98960078387283E-01  -2.98091260692346E-01   0.00000000000000E+00  -1.62033690498999E-10
     -1.42463887713866E-22  -2.59545944609576E-09  -2.75749313659490E-09  -2.94848896554277E-18
      8.26756586971374E-09
      0.00000000000000E+00   1.41808274248421E-13   0.00000000000000E+00   6.49715502994436E-14  -4.81143070783515E-23
     -1.41834009676540E-10  -1.41769038126289E-10  -1.27769541355698E-18  -1.10957196031925E-02  -1.10957196052020E-02
      0.00000000000000E+00   0.00000000000000E+00   2.00956233015781E-09   0.00000000000000E+00   2.00956233015781E-09
      4.26480929252604E-18  -3.23601865393185E-01  -3.23013370313108E-01   0.00000000000000E+00  -1.18592895820006E-10
     -1.46724438066676E-22  -1.74920039621146E-09  -1.86779329203161E-09  -2.98711387896906E-18
      8.28756586971374E-09
      0.00000000000000E+00   1.31337974206763E-13   0.00000000000000E+00   2.67390003240145E-14  -4.81156620116555E-23
     -1.31335872406118E-10  -1.31309133405842E-10  -1.27906891956468E-18  -1.01834004075444E-02  -1.01834004088350E-02
      0.00000000000000E+00   0.00000000000000E+00   1.29062355657280E-09   0.00000000000000E+00   1.29062355657280E-09
      4.29062176365749E-18  -3.38011248430527E-01  -3.37645981341094E-01   0.00000000000000E+00  -7.19480775681429E-11
     -1.49217005489183E-22  -1.08736634559857E-09  -1.15931442316686E-09  -3.01155284409282E-18
      8.30756586971374E-09
      0.00000000000000E+00   1.21326897851143E-13   0.00000000000000E+00   2.67307906214420E-14  -4.81140375802332E-23
     -1.21347297866416E-10  -1.21320567075843E-10  -1.28025330654006E-18  -9.57079225385435E-03  -9.57079225463694E-03
      0.00000000000000E+00   0.00000000000000E+00   7.82589309906324E-10   0.00000000000000E+00   7.82589309906324E-10
      4.30627354985562E-18  -3.45113561724179E-01  -3.44905220783133E-01   0.00000000000000E+00  -3.41608257852549E-11
     -1.50384894398473E-22  -6.27107917045059E-10  -6.61268742830464E-10  -3.02602024331556E-18
      8.32756586971374E-09
      0.00000000000000E+00   9.00078424633762E-14   0.00000000000000E+00   8.41533573164295E-14  -4.81004532107714E-23
     -9.00994556757612E-11  -9.00153023184929E-11  -1.28082286346421E-18  -9.33080538979935E-03  -9.33080539050180E-03
      0.00000000000000E+00   0.00000000000000E+00   7.02445761402314E-10   0.00000000000000E+00   7.02445761402314E-10
      4.32032246508367E-18  -3.51996528249461E-01  -3.51803575029284E-01   0.00000000000000E+00  -3.21495440399765E-11
     -1.51454554757223E-22  -5.80280915043767E-10  -6.12430459083896E-10  -3.03949960161946E-18
      8.34756586971374E-09
      0.00000000000000E+00   6.54852976289666E-14   0.00000000000000E+00   7.12686908860820E-14  -4.80792505258372E-23
     -6.55961579039550E-11  -6.55248892131170E-11  -1.28091766556595E-18  -9.26139043221911E-03  -9.26139043313957E-03
      0.00000000000000E+00   0.00000000000000E+00   9.20455056294435E-10   0.00000000000000E+00   9.20455056294435E-10
      4.33873156620956E-18  -3.62985102012976E-01  -3.62715740076937E-01   0.00000000000000E+00  -5.51901025964675E-11
     -1.53239947102638E-22  -7.99740064484631E-10  -8.54930167081252E-10  -3.05781390064360E-18
      8.35006586971374E-09
      0.00000000000000E+00   4.88614001944042E-14   0.00000000000000E+00   3.37733490040341E-13  -4.80749513197621E-23
     -4.91595821226027E-11  -4.88218486326105E-11  -1.28088801637894E-18  -9.27499530950568E-03  -9.27499531046533E-03
      0.00000000000000E+00   0.00000000000000E+00   9.59653033356123E-10   0.00000000000000E+00   9.59653033356123E-10
      4.34113069879295E-18  -3.64502866528648E-01  -3.64215890105832E-01   0.00000000000000E+00  -6.18039285743590E-11
     -1.53486179501229E-22  -8.49027256149432E-10  -9.10831184723945E-10  -3.06024268241400E-18
      8.35344086971374E-09
      0.00000000000000E+00   1.60728290113172E-14   0.00000000000000E+00   4.95364598202809E-13  -4.80666265882216E-23
     -1.65673820644522E-11  -1.60720174662974E-11  -1.28073804223022E-18  -9.34426574597188E-03  -9.34426574711031E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13842735232568E-09   0.00000000000000E+00   1.13842735232568E-09
      4.34497289110704E-18  -3.67212240699515E-01  -3.66858614660890E-01   0.00000000000000E+00  -8.33358567860304E-11
     -1.53929660506627E-22  -1.03901947807333E-09  -1.12235533485952E-09  -3.06423484887683E-18
      8.35799711971374E-09
      0.00000000000000E+00   9.09262898354515E-15   0.00000000000000E+00   9.99116110526427E-14  -4.80573124920834E-23
     -9.22974097381995E-12  -9.12982936281537E-12  -1.28050517643771E-18  -9.42929658173283E-03  -9.42929658312154E-03
      0.00000000000000E+00   0.00000000000000E+00   1.38870901777940E-09   0.00000000000000E+00   1.38870901777940E-09
      4.35130019656930E-18  -3.71784922268811E-01  -3.71350248019848E-01   0.00000000000000E+00  -1.07513707339057E-10
     -1.54700776137333E-22  -1.27206548107735E-09  -1.37957918841656E-09  -3.07079502013159E-18
      8.36414805721374E-09
      0.00000000000000E+00   2.00221527112408E-14   0.00000000000000E+00  -6.79233999451845E-14  -4.80471860719277E-23
     -1.99890803039646E-11  -2.00570037039579E-11  -1.28026044630478E-18  -9.47350640818112E-03  -9.47350640979715E-03
      0.00000000000000E+00   0.00000000000000E+00   1.61602726469797E-09   0.00000000000000E+00   1.61602726469797E-09
      4.36124027927275E-18  -3.78917338736105E-01  -3.78414482413971E-01   0.00000000000000E+00  -1.28619304585944E-10
     -1.55939446046842E-22  -1.46735095640776E-09  -1.59597026099386E-09  -3.08097983296798E-18
      8.37245182283874E-09
      0.00000000000000E+00   3.67378948830107E-14   0.00000000000000E+00  -8.42379325415455E-14  -4.80362767979371E-23
     -3.66977304921849E-11  -3.67819684247745E-11  -1.28007345769953E-18  -9.42574900164066E-03  -9.42574900339441E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75375717293480E-09   0.00000000000000E+00   1.75375717293480E-09
      4.37580306779997E-18  -3.89222077070398E-01  -3.88681093549822E-01   0.00000000000000E+00  -1.42864109482213E-10
     -1.57775365265501E-22  -1.57411109502769E-09  -1.71697520451006E-09  -3.09572961010044E-18
      8.38366190643249E-09
      0.00000000000000E+00   5.47394633756859E-14   0.00000000000000E+00  -6.77914577288001E-14  -4.80251715494857E-23
     -5.46906204508275E-11  -5.47584119086044E-11  -1.28003053746156E-18  -9.22910942780407E-03  -9.22910942959795E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79388087670682E-09   0.00000000000000E+00   1.79388087670682E-09
      4.39591262238508E-18  -4.03231524945449E-01  -4.02683562786791E-01   0.00000000000000E+00  -1.50247346198785E-10
     -1.60335993759659E-22  -1.58887511859910E-09  -1.73912246479805E-09  -3.11588208492351E-18
      8.39879551928405E-09
      0.00000000000000E+00   8.29357976983967E-14   0.00000000000000E+00  -8.58088272050006E-14  -4.80184576252243E-23
     -8.28379943065288E-11  -8.29238031337818E-11  -1.28041216959843E-18  -8.71115598509043E-03  -8.71115598687064E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78021116422502E-09   0.00000000000000E+00   1.78021116422502E-09
      4.42285364893849E-18  -4.21498002615265E-01  -4.20963221587007E-01   0.00000000000000E+00  -1.53818244866970E-10
     -1.63792833773947E-22  -1.54346911622409E-09  -1.69728736109123E-09  -3.14244147934006E-18
      8.41879551928405E-09
      0.00000000000000E+00   1.31705353155593E-13   0.00000000000000E+00  -1.23378122855941E-13  -4.80281335296318E-23
     -1.31588995066820E-10  -1.31712373189724E-10  -1.28191176720057E-18  -7.45811596171504E-03  -7.45811596347819E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76314603351388E-09   0.00000000000000E+00   1.76314603351388E-09
      4.45811656960877E-18  -4.44228617968145E-01  -4.43714585694800E-01   0.00000000000000E+00  -1.57241394516964E-10
     -1.68329421332175E-22  -1.47419226580708E-09  -1.63143366032421E-09  -3.17620480240820E-18
      8.43879551928405E-09
      0.00000000000000E+00   1.69361695410679E-13   0.00000000000000E+00  -1.03114002390110E-13  -4.80507990311233E-23
     -1.69261562821100E-10  -1.69364676823538E-10  -1.28418052145436E-18  -5.77454835563857E-03  -5.77454835736996E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73138489614145E-09   0.00000000000000E+00   1.73138489614145E-09
      4.49274426753160E-18  -4.65624766758008E-01  -4.65132604013021E-01   0.00000000000000E+00  -1.60945923810011E-10
     -1.72833887041891E-22  -1.40107429550772E-09  -1.56202021931790E-09  -3.20856374607724E-18
      8.45879551928405E-09
      0.00000000000000E+00   1.72025192789698E-13   0.00000000000000E+00  -1.79356462498190E-14  -4.80725614441805E-23
     -1.72043600772968E-10  -1.72061536419266E-10  -1.28651790991674E-18  -4.07838668368171E-03  -4.07838668534070E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65899376505416E-09   0.00000000000000E+00   1.65899376505416E-09
      4.52592414283268E-18  -4.85960262682311E-01  -4.85491757606188E-01   0.00000000000000E+00  -1.62882810095237E-10
     -1.77264805584987E-22  -1.32404941853951E-09  -1.48693222863493E-09  -3.23940623291594E-18
      8.47879551928405E-09
      0.00000000000000E+00   2.27132035114214E-13   0.00000000000000E+00  -1.56446974848252E-13  -4.81173496754722E-23
     -2.26939221680340E-10  -2.27095668655237E-10  -1.28996685743906E-18  -1.73224248131080E-03  -1.73224248299108E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68027620742365E-09   0.00000000000000E+00   1.68027620742365E-09
      4.55952966698115E-18  -5.05303089362188E-01  -5.04845216938654E-01   0.00000000000000E+00  -1.69754902729817E-10
     -1.81758440814706E-22  -1.28342563603835E-09  -1.45318053876835E-09  -3.26956280954210E-18
      8.49879551928405E-09
      0.00000000000000E+00  -9.34428356349377E-13   0.00000000000000E+00   3.03422156604834E-12  -4.76781661348335E-23
      9.31376548589479E-10   9.34410770155480E-10  -1.27026847756708E-18  -1.33506150286044E-02  -1.33506150283720E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.32329022829248E-10   0.00000000000000E+00  -2.32329022829248E-10
      4.55488308652457E-18  -5.25232698156703E-01  -5.25011499060003E-01   0.00000000000000E+00  -6.40970203709384E-11
     -1.83421368577327E-22  -6.37984726955132E-10  -7.02081747326254E-10  -3.28461460895749E-18
      8.51879551928405E-09
      0.00000000000000E+00  -2.79061049531349E-12   0.00000000000000E+00   5.00998334054349E-12  -4.65618614656343E-23
      2.78561566316004E-09   2.79062564650053E-09  -1.21389616307875E-18  -4.60577271120476E-02  -4.60577271088542E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.19334292720835E-09   0.00000000000000E+00  -3.19334292720835E-09
      4.49101622798040E-18  -5.46311165786156E-01  -5.46438098388230E-01   0.00000000000000E+00   1.02724114763004E-10
     -1.80708206000244E-22   2.99993165944921E-10   4.02717280707743E-10  -3.27712006490165E-18
      8.52004551928405E-09
      0.00000000000000E+00  -3.15587701518783E-12   0.00000000000000E+00   1.44837037723229E-11  -4.64662741062658E-23
      3.14143572199411E-09   3.15591942576638E-09  -1.20991977934345E-18  -4.83335065939308E-02  -4.83335065901956E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.73520503522791E-09   0.00000000000000E+00  -3.73520503522791E-09
      4.48634722168637E-18  -5.47628483017365E-01  -5.47811053988731E-01   0.00000000000000E+00   1.30587909628388E-10
     -1.80493412389658E-22   4.48697699833901E-10   5.79285609462109E-10  -3.27642744234292E-18
      8.52173301928405E-09
      0.00000000000000E+00  -3.44564716107757E-12   0.00000000000000E+00   9.10484356995947E-12  -4.63467149427892E-23
      3.43655157921567E-09   3.44565642278558E-09  -1.20406991004846E-18  -5.16558377879066E-02  -5.16558377837136E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.19303870974081E-09   0.00000000000000E+00  -4.19303870974081E-09
      4.47927146886368E-18  -5.49425931261947E-01  -5.49661469844573E-01   0.00000000000000E+00   1.52872058532043E-10
     -1.80151714450164E-22   5.94510228423241E-10   7.47382286955103E-10  -3.27520155881522E-18
      8.52401114428405E-09
      0.00000000000000E+00  -3.75323518598558E-12   0.00000000000000E+00   7.20912928241829E-12  -4.61781350071849E-23
      3.74600717754707E-09   3.75321630682944E-09  -1.19548790543942E-18  -5.64993751804693E-02  -5.64993751757988E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.67049537915172E-09   0.00000000000000E+00  -4.67049537915172E-09
      4.46863149657805E-18  -5.51878597207541E-01  -5.52167671033505E-01   0.00000000000000E+00   1.75769258097597E-10
     -1.79618211060989E-22   7.41509814224165E-10   9.17279072321583E-10  -3.27314359113863E-18
      8.52708661303405E-09
      0.00000000000000E+00  -4.13925861646882E-12   0.00000000000000E+00   6.73880816134678E-12  -4.59318704747793E-23
      4.13247692497651E-09   4.13921573313781E-09  -1.18275325199502E-18  -6.36294418939958E-02  -6.36294418887403E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.25549708157001E-09   0.00000000000000E+00  -5.25549708157001E-09
      4.45246837953796E-18  -5.55226526382104E-01  -5.55578307394408E-01   0.00000000000000E+00   2.03128072726017E-10
     -1.78781399413178E-22   9.13153275706450E-10   1.11628134843229E-09  -3.26971512754295E-18
      8.53123849584655E-09
      0.00000000000000E+00  -4.64569049743112E-12   0.00000000000000E+00   6.59197403850626E-12  -4.55670518636772E-23
      4.63910846589069E-09   4.64570043992915E-09  -1.16355936425764E-18  -7.42500102813664E-02  -7.42500102753630E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.00346973684747E-09   0.00000000000000E+00  -6.00346973684747E-09
      4.42754267672219E-18  -5.59798380959940E-01  -5.60226257576100E-01   0.00000000000000E+00   2.36067652687471E-10
     -1.77458787605655E-22   1.12170164423104E-09   1.35776929691834E-09  -3.26398331246455E-18
      8.53684353764342E-09
      0.00000000000000E+00  -5.28492986839550E-12   0.00000000000000E+00   6.22560795502227E-12  -4.50257424903197E-23
      5.27866670425787E-09   5.28489231221284E-09  -1.13436882131116E-18  -9.01131874203522E-02  -9.01131874134504E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.90182204077926E-09   0.00000000000000E+00  -6.90182204077926E-09
      4.38885767570902E-18  -5.66022271436393E-01  -5.66531815018963E-01   0.00000000000000E+00   2.71128007405285E-10
     -1.75384609383549E-22   1.34580172116116E-09   1.61692972856627E-09  -3.25448885439786E-18
      8.54062694085631E-09
      0.00000000000000E+00  -5.74580675970287E-12   0.00000000000000E+00   6.59864318751407E-12  -4.46349204651600E-23
      5.73921614347426E-09   5.74581478666172E-09  -1.11314101040908E-18  -1.01441156578230E-01  -1.01441156570725E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.50526359461170E-09   0.00000000000000E+00  -7.50526359461170E-09
      4.36046223731158E-18  -5.70225800767925E-01  -5.70780256514376E-01   0.00000000000000E+00   2.88946807604567E-10
     -1.73876225967955E-22   1.47050200034561E-09   1.75944880795001E-09  -3.24732122690250E-18
      8.54573453519372E-09
      0.00000000000000E+00  -6.23699241428873E-12   0.00000000000000E+00   5.33965765841271E-12  -4.40803146568877E-23
      6.23169050202290E-09   6.23703015968127E-09  -1.08260090805320E-18  -1.17423116436912E-01  -1.17423116428849E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.06285934769227E-09   0.00000000000000E+00  -8.06285934769227E-09
      4.31928042256404E-18  -5.75853752457496E-01  -5.76429137015335E-01   0.00000000000000E+00   3.02308804754973E-10
     -1.71720046413923E-22   1.52352038325665E-09   1.82582918801145E-09  -3.23667951451083E-18
      8.55262978754921E-09
      0.00000000000000E+00  -6.82810514295637E-12   0.00000000000000E+00   4.77832107087032E-12  -4.32200475890321E-23
      6.82332744711895E-09   6.82810576818978E-09  -1.03934834206635E-18  -1.39459667604752E-01  -1.39459667596242E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.50976949730776E-09   0.00000000000000E+00  -8.50976949730776E-09
      4.26060341439302E-18  -5.83224337251326E-01  -5.83754327398905E-01   0.00000000000000E+00   3.04603928306794E-10
     -1.68739924342981E-22   1.37705980081134E-09   1.68166372911796E-09  -3.22125507232667E-18
      8.56193837822912E-09
      0.00000000000000E+00  -7.84868386280641E-12   0.00000000000000E+00   5.88179447291651E-12  -4.12574197876605E-23
      7.84284821243562E-09   7.84873000690849E-09  -9.79365991269504E-19  -1.68953314819949E-01  -1.68953314811126E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.82322396685398E-09   0.00000000000000E+00  -8.82322396685398E-09
      4.17847163400835E-18  -5.92358775809760E-01  -5.92666031285123E-01   0.00000000000000E+00   2.95545629231886E-10
     -1.64753928637527E-22   6.78948330713708E-10   9.74493959945429E-10  -3.19910564273885E-18
      8.57450497564701E-09
      0.00000000000000E+00  -1.06396617370687E-11   0.00000000000000E+00   1.13214584830419E-11  -3.29989545245455E-23
      1.06283275943531E-08   1.06396490528361E-08  -8.98877687674191E-19  -2.06804151875147E-01  -2.06804151866076E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.07145006290523E-09   0.00000000000000E+00  -9.07145006290523E-09
      4.06447437307136E-18  -6.01497969277925E-01  -6.01004327394240E-01   0.00000000000000E+00   2.82992375090429E-10
     -1.59441550378578E-22  -1.85119136502119E-09  -1.56819898993092E-09  -3.16559668539717E-18
      8.59146988216116E-09
      0.00000000000000E+00  -1.96487120097550E-11   0.00000000000000E+00   2.64398689913761E-11   6.75852354273204E-24
      1.96222564529308E-08   1.96486963219222E-08  -7.99407068351965E-19  -2.51391947784359E-01  -2.51391947774911E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.44778975227794E-09   0.00000000000000E+00  -9.44778975227794E-09
      3.90419350315866E-18  -6.00473149487078E-01  -5.97260254881368E-01   0.00000000000000E+00   2.88710076160257E-10
     -1.51685613242144E-22  -1.04896166458044E-08  -1.02009065696443E-08  -3.10478643480669E-18
      8.61146988216116E-09
      0.00000000000000E+00  -3.82965000734224E-11   0.00000000000000E+00   4.62172393014920E-11   9.60143577401564E-23
      3.82502623767970E-08   3.82964796160986E-08  -7.08014173411928E-19  -2.91332648462492E-01  -2.91332648452403E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00889339699276E-08   0.00000000000000E+00  -1.00889339699276E-08
      3.70241482376010E-18  -5.66837414581294E-01  -5.57952052309395E-01   0.00000000000000E+00   3.15680699754762E-10
     -1.40237330965768E-22  -2.85232263459257E-08  -2.82075456461711E-08  -2.99440065034818E-18
      8.63146988216116E-09
      0.00000000000000E+00  -5.72105460302545E-11   0.00000000000000E+00   4.69834757761460E-11   1.85662788444865E-22
      5.71635730780032E-08   5.72105565537795E-08  -6.46941703773506E-19  -3.18673413807302E-01  -3.18673413796549E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07523132871661E-08   0.00000000000000E+00  -1.07523132871661E-08
      3.48736855801678E-18  -4.96360033698247E-01  -4.81724598627212E-01   0.00000000000000E+00   3.09188666037618E-10
     -1.25504733386581E-22  -4.67674319326509E-08  -4.64582432666135E-08  -2.84042685424328E-18
      8.65146988216116E-09
      0.00000000000000E+00  -6.60051388415612E-11   0.00000000000000E+00   2.19620505126259E-11   2.26490266246968E-22
      6.59831426146583E-08   6.60051046651712E-08  -6.12878992184602E-19  -3.35444701802887E-01  -3.35444701791561E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13257116035016E-08   0.00000000000000E+00  -1.13257116035016E-08
      3.26085432594675E-18  -3.93170284388597E-01  -3.75944045092593E-01   0.00000000000000E+00   2.67073157271457E-10
     -1.09069214099975E-22  -5.49464662189409E-08  -5.46793930616696E-08  -2.64797533376215E-18
      8.67146988216115E-09
      0.00000000000000E+00  -6.06112811148375E-11   0.00000000000000E+00  -1.33078610233147E-11   2.03357430556763E-22
      6.06245656685821E-08   6.06112578075590E-08  -6.01037343495502E-19  -3.43651445834381E-01  -3.43651445822558E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18230967233707E-08   0.00000000000000E+00  -1.18230967233707E-08
      3.02439239147934E-18  -2.68405227061627E-01  -2.53034408261926E-01   0.00000000000000E+00   2.08032886217820E-10
     -9.25067474952315E-23  -4.89961939704060E-08  -4.87881610841882E-08  -2.42335504798384E-18
      8.69146988216115E-09
      0.00000000000000E+00  -5.22165802893324E-11   0.00000000000000E+00  -2.08178140002740E-11   1.61003149939021E-22
      5.22374419487866E-08   5.22166241347865E-08  -5.93859722415585E-19  -3.50137617447925E-01  -3.50137617436020E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19047066311665E-08   0.00000000000000E+00  -1.19047066311665E-08
      2.78629825885601E-18  -1.56165281524243E-01  -1.43464627769415E-01   0.00000000000000E+00   1.21115657548078E-10
     -7.88264453670304E-23  -4.04330331611680E-08  -4.03119175036200E-08  -2.19243853644042E-18
      8.71146988216115E-09
      0.00000000000000E+00  -4.55844718155769E-11   0.00000000000000E+00  -1.64412972498155E-11   1.27865295856531E-22
      4.56009337233235E-08   4.55844924260738E-08  -5.79272670492180E-19  -3.59354711007698E-01  -3.59354710996040E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16585799771722E-08   0.00000000000000E+00  -1.16585799771722E-08
      2.55312665931256E-18  -7.22781058730729E-02  -6.15892845633215E-02   0.00000000000000E+00   6.37621405190705E-11
     -5.02247939161579E-23  -3.39896745894206E-08  -3.39259124489016E-08  -1.97385398882038E-18
      8.71396988216115E-09
      0.00000000000000E+00  -4.36113713261476E-11   0.00000000000000E+00  -3.86591958842906E-11   1.23174798315756E-22
      4.36499582034245E-08   4.36112990075404E-08  -5.77275838050814E-19  -3.60508087772750E-01  -3.60508087761102E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16478956978848E-08   0.00000000000000E+00  -1.16478956978848E-08
      2.52400692006785E-18  -6.28700154719378E-02  -5.27994984465498E-02   0.00000000000000E+00   7.12822148179603E-11
     -3.91009668571576E-23  -3.20346855244728E-08  -3.19634033096549E-08  -1.94673108201704E-18
      8.71734488216115E-09
      0.00000000000000E+00  -4.13588791461330E-11   0.00000000000000E+00  -3.31205163123587E-11   1.18559304813797E-22
      4.13920038369430E-08   4.13588833206308E-08  -5.72957937669067E-19  -3.62642879756056E-01  -3.62642879744603E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14535669923660E-08   0.00000000000000E+00  -1.14535669923660E-08
      2.48535113146862E-18  -5.24946832654531E-02  -4.30725797572017E-02   0.00000000000000E+00   5.70404239363932E-11
     -1.95268106320548E-23  -2.99623567522017E-08  -2.99053163282653E-08  -1.91239319379955E-18
      8.72190113216115E-09
      0.00000000000000E+00  -3.87531521068183E-11   0.00000000000000E+00  -2.83353592629691E-11   1.16365126724534E-22
      3.87815162583219E-08   3.87531808990591E-08  -5.64271180166638E-19  -3.66509737233901E-01  -3.66509737222750E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11503262588951E-08   0.00000000000000E+00  -1.11503262588951E-08
      2.43454745745152E-18  -4.21187673685091E-02  -3.34220732254750E-02   0.00000000000000E+00   4.58918969620149E-11
      1.06522644862196E-23  -2.76487465371259E-08  -2.76028546401639E-08  -1.87027627728489E-18
      8.72497660091115E-09
      0.00000000000000E+00  -3.70924155686318E-11   0.00000000000000E+00  -2.67128202861919E-11   1.16558059936897E-22
      3.71191206807685E-08   3.70924078604824E-08  -5.57189820186761E-19  -3.69527771738405E-01  -3.69527771727454E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09511548078303E-08   0.00000000000000E+00  -1.09511548078303E-08
      2.40086752306363E-18  -3.66539164185845E-02  -2.84177140478510E-02   0.00000000000000E+00   4.06516296612371E-11
      3.14110643444177E-23  -2.61819046823132E-08  -2.61412530526519E-08  -1.84367770287687E-18
      8.72912848372365E-09
      0.00000000000000E+00  -3.54093607593038E-11   0.00000000000000E+00  -2.00872454997187E-11   1.19245244463108E-22
      3.54294574027784E-08   3.54093701572788E-08  -5.46067589182470E-19  -3.74144650616881E-01  -3.74144650606152E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07285522392953E-08   0.00000000000000E+00  -1.07285522392953E-08
      2.35632383141829E-18  -3.13498212378901E-02  -2.35737421019185E-02   0.00000000000000E+00   3.15033807702447E-11
      5.71672722474147E-23  -2.47123212987538E-08  -2.46808179179835E-08  -1.81025624223582E-18
      8.73473352552053E-09
      0.00000000000000E+00  -3.39017293980423E-11   0.00000000000000E+00  -1.33091881418118E-11   1.25204524288444E-22
      3.39150691491271E-08   3.39017599609854E-08  -5.29490627783526E-19  -3.80917706304860E-01  -3.80917706294337E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05228411455371E-08   0.00000000000000E+00  -1.05228411455371E-08
      2.29734286697568E-18  -2.65807493570863E-02  -1.92148446386633E-02   0.00000000000000E+00   2.29175559036157E-11
      8.76501073180670E-23  -2.34018363713522E-08  -2.33789188154485E-08  -1.76785223919215E-18
      8.74230033194631E-09
      0.00000000000000E+00  -3.26778982747520E-11   0.00000000000000E+00  -7.97576509838226E-12   1.33942286656311E-22
      3.26858514610145E-08   3.26778756959162E-08  -5.06071245375831E-19  -3.90413555693560E-01  -3.90413555683204E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03562926524970E-08   0.00000000000000E+00  -1.03562926524970E-08
      2.21897880518550E-18  -2.25201828048186E-02  -1.54873997971269E-02   0.00000000000000E+00   1.61663086528250E-11
      1.21630538840716E-22  -2.23377493520722E-08  -2.23215830434192E-08  -1.71290755980966E-18
      8.75251552062111E-09
      0.00000000000000E+00  -3.16877201629176E-11   0.00000000000000E+00  -4.75251706853743E-12   1.42475961356581E-22
      3.16924457229389E-08   3.16876932058705E-08  -4.74504133276990E-19  -4.03204810108154E-01  -4.03204810097930E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02240738749555E-08   0.00000000000000E+00  -1.02240738749555E-08
      2.11453796152768E-18  -1.91360592722469E-02  -1.23735834970969E-02   0.00000000000000E+00   1.16691901761030E-11
      1.54851982382620E-22  -2.14752885210912E-08  -2.14636193309150E-08  -1.64003382825069E-18
      8.76630602533210E-09
      0.00000000000000E+00  -3.07419949038917E-11   0.00000000000000E+00  -3.34463836334059E-12   1.44014976421769E-22
      3.07453851150448E-08   3.07420404766816E-08  -4.33554571740944E-19  -4.19903375348579E-01  -4.19903375338480E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00992025105495E-08   0.00000000000000E+00  -1.00992025105495E-08
      1.97526486172874E-18  -1.62980685306632E-02  -9.79418591468403E-03   0.00000000000000E+00   9.03183096095083E-12
      1.76788589987242E-22  -2.06518697970931E-08  -2.06428379661320E-08  -1.54171028998780E-18
      8.78492320669193E-09
      0.00000000000000E+00  -2.95850267492885E-11   0.00000000000000E+00  -3.02960505643180E-12   1.28663193774793E-22
      2.95880060555373E-08   2.95849764504810E-08  -3.81979044098815E-19  -4.41211600080987E-01  -4.41211600071039E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94835466020313E-09   0.00000000000000E+00  -9.94835466020313E-09
      1.79005453878782E-18  -1.38570955330382E-02  -7.67023132041342E-03   0.00000000000000E+00   7.57075149022292E-12
      1.70390963006855E-22  -1.96441925417682E-08  -1.96366217902778E-08  -1.40807549468900E-18
      8.80492320669193E-09
      0.00000000000000E+00  -2.83924228366488E-11   0.00000000000000E+00  -2.91052233585641E-12   9.88594874109832E-23
      2.83952849572222E-08   2.83923744348865E-08  -3.30651678528263E-19  -4.62766822303551E-01  -4.62766822293750E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.80036374672730E-09   0.00000000000000E+00  -9.80036374672730E-09
      1.59404726385327E-18  -1.20953255614132E-02  -6.23757865617853E-03   0.00000000000000E+00   6.58530388385126E-12
      1.34455091479110E-22  -1.85985959920432E-08  -1.85920106881592E-08  -1.26339558532501E-18
      8.82492320669193E-09
      0.00000000000000E+00  -2.74121639564329E-11   0.00000000000000E+00  -2.39115729194878E-12   6.65575866847399E-23
      2.74145537463933E-08   2.74121625891014E-08  -2.82741360434671E-19  -4.83234775929912E-01  -4.83234775920241E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67146195624397E-09   0.00000000000000E+00  -9.67146195624397E-09
      1.40061802472839E-18  -1.08948213141958E-02  -5.30529025063329E-03   0.00000000000000E+00   5.48387507935752E-12
      8.91228002066583E-23  -1.77461845079369E-08  -1.77407006328574E-08  -1.11787666429372E-18
      8.84492320669193E-09
      0.00000000000000E+00  -2.65755502452095E-11   0.00000000000000E+00  -2.03964278589512E-12   4.00167685839358E-23
      2.65775653323880E-08   2.65755256896022E-08  -2.37976884641135E-19  -5.02699912283101E-01  -5.02699912273588E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.51326695347451E-09   0.00000000000000E+00  -9.51326695347451E-09
      1.21035268565890E-18  -1.00366429502227E-02  -4.66086357627366E-03   0.00000000000000E+00   4.58986245035583E-12
      5.00911151931497E-23  -1.70668485985781E-08  -1.70622587361277E-08  -9.72375801017768E-19
      8.86492320669193E-09
      0.00000000000000E+00  -2.65299034108173E-11   0.00000000000000E+00  -9.06690535005127E-14   2.24538566823505E-23
      2.65299815281611E-08   2.65298908591076E-08  -1.93667097449157E-19  -5.22388445311502E-01  -5.22388445301609E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.89293905008961E-09   0.00000000000000E+00  -9.89293905008961E-09
      1.01249390465711E-18  -9.50342953198292E-03  -4.26164766931840E-03   0.00000000000000E+00   3.73750633947791E-12
      2.38108338066340E-23  -1.66406893153577E-08  -1.66369518090182E-08  -8.18826807207954E-19
      8.88492320669193E-09
      0.00000000000000E+00  -2.74526674855414E-11   0.00000000000000E+00   2.30103571259438E-12   1.26921626079840E-23
      2.74503751756702E-08   2.74526762113828E-08  -1.47693531063424E-19  -5.43353934051069E-01  -5.43353934040238E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08315885385093E-08   0.00000000000000E+00  -1.08315885385093E-08
      7.95862133886924E-19  -9.30185858913028E-03  -4.06507214787690E-03   0.00000000000000E+00   2.65746456190987E-12
      9.17529283853830E-24  -1.66237451374354E-08  -1.66210876728735E-08  -6.48168602823500E-19
      8.90492320669193E-09
      0.00000000000000E+00  -2.84451417158059E-11   0.00000000000000E+00   2.47795173243463E-12   7.90961004326641E-24
      2.84426638666439E-08   2.84451418183764E-08  -1.01560541205289E-19  -5.64962228634965E-01  -5.64962228623442E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15229295555336E-08   0.00000000000000E+00  -1.15229295555336E-08
      5.65403542776252E-19  -9.27698260857255E-03  -3.94531862732662E-03   0.00000000000000E+00   1.74890199533866E-12
      2.22653027754820E-24  -1.69239611648381E-08  -1.69222122628427E-08  -4.63843001570964E-19
      8.92492320669193E-09
      0.00000000000000E+00  -2.88945380149623E-11   0.00000000000000E+00   1.13710842901284E-12   5.71375688930893E-24
      2.88933569684527E-08   2.88944940768817E-08  -5.82469796701724E-20  -5.85767590393306E-01  -5.85767590381867E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14390265941370E-08   0.00000000000000E+00  -1.14390265941370E-08
      3.36623010893512E-19  -9.33342630710390E-03  -3.83374760897112E-03   0.00000000000000E+00   9.25441684764349E-13
     -6.83357662965341E-25  -1.74563929244295E-08  -1.74554674827447E-08  -2.78376031223340E-19
      8.94492320669193E-09
      0.00000000000000E+00  -2.58402412791260E-11   0.00000000000000E+00  -7.51124831527765E-12   4.27497210361996E-24
      2.58477533055268E-08   2.58402420572116E-08  -2.87047092075840E-20  -6.00074308202536E-01  -6.00074308194344E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.19202333123696E-09   0.00000000000000E+00  -8.19202333123696E-09
      1.72782544268773E-19  -9.01476405722367E-03  -3.45435359099289E-03   0.00000000000000E+00   1.01853127157697E-12
     -1.81836593228002E-24  -1.76492372572462E-08  -1.76482187259746E-08  -1.44077835061189E-19
      8.96492320669193E-09
      0.00000000000000E+00  -1.50014601517914E-11   0.00000000000000E+00  -2.67172603662837E-11   2.34030530525012E-24
      1.50281463862395E-08   1.50014291258732E-08  -3.89065879937871E-20  -5.94436943570748E-01  -5.94436943573423E-01
      0.00000000000000E+00   0.00000000000000E+00   2.67526601407086E-09   0.00000000000000E+00   2.67526601407086E-09
      2.26287864550190E-19  -8.06733206619739E-03  -2.49794794246919E-03   0.00000000000000E+00  -5.24571271207433E-13
     -2.45237585131680E-24  -1.76761705686729E-08  -1.76766951399441E-08  -1.87381276556403E-19
      8.98492320669193E-09
      0.00000000000000E+00   3.33616823432620E-12   0.00000000000000E+00  -4.51929288500659E-11  -9.95512019909978E-25
     -3.29098507575311E-09  -3.33617800460318E-09  -1.19766288474601E-19  -5.54635449403164E-01  -5.54635449424184E-01
      0.00000000000000E+00   0.00000000000000E+00   2.10197905478165E-08   0.00000000000000E+00   2.10197905478165E-08
      6.46683675506520E-19  -6.50338393607464E-03  -9.31819883180203E-04   0.00000000000000E+00  -4.06536402334839E-12
     -3.94688950644041E-24  -1.76795471791900E-08  -1.76836125432133E-08  -5.26917387031920E-19
      9.00492320669193E-09
      0.00000000000000E+00   1.97257697442721E-11   0.00000000000000E+00  -4.05295603176791E-11  -8.59042132399625E-24
     -1.96852423441924E-08  -1.97257719045101E-08  -2.89613073387760E-19  -4.78327905139909E-01  -4.78327905177274E-01
      0.00000000000000E+00   0.00000000000000E+00   3.73652704856725E-08   0.00000000000000E+00   3.73652704856725E-08
      1.39398908521997E-18  -4.80403312693194E-03   7.53628532420341E-04   0.00000000000000E+00  -9.62882319179989E-12
     -1.30655410601255E-23  -1.76298697579705E-08  -1.76394985811623E-08  -1.10437601183221E-18
      9.02492320669193E-09
      0.00000000000000E+00   2.43079955282929E-11   0.00000000000000E+00  -1.16258997863544E-11  -3.11348983322808E-23
     -2.42963792652059E-08  -2.43080051649923E-08  -5.57879740029241E-19  -3.70123229236088E-01  -3.70123229278025E-01
      0.00000000000000E+00   0.00000000000000E+00   4.19373022128390E-08   0.00000000000000E+00   4.19373022128390E-08
      2.23273512947675E-18  -2.81585412292145E-03   2.73858422188495E-03   0.00000000000000E+00  -2.17634736124879E-11
     -5.44218271285920E-23  -1.76075335742342E-08  -1.76292970478468E-08  -1.67485538944751E-18
      9.04492320669193E-09
      0.00000000000000E+00   1.64072356994898E-11   0.00000000000000E+00   1.89073608595786E-11  -4.21236665667796E-23
     -1.64261815535243E-08  -1.64072741926648E-08  -8.52594074465080E-19  -2.45462647304655E-01  -2.45462647337971E-01
      0.00000000000000E+00   0.00000000000000E+00   3.33166324123080E-08   0.00000000000000E+00   3.33166324123080E-08
      2.89906777772291E-18  -5.59379115032027E-03  -2.66200028641334E-04   0.00000000000000E+00  -4.87662271139413E-11
     -7.86909572610766E-23  -1.68605919925292E-08  -1.69093582196432E-08  -2.04647370325783E-18
      9.06492320669193E-09
      0.00000000000000E+00   1.08299640325627E-11   0.00000000000000E+00   1.29993843899242E-11  -4.52877750984580E-23
     -1.08429699368361E-08  -1.08299705524462E-08  -1.06759334097873E-18  -1.37875229567532E-01  -1.37875229591936E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44033502542019E-08   0.00000000000000E+00   2.44033502542019E-08
      3.38713478280695E-18  -3.08633866972696E-02  -2.65868614177394E-02   0.00000000000000E+00  -9.24685182071007E-11
     -9.15044045778489E-23  -1.34809111835485E-08  -1.35733797017557E-08  -2.31954144182822E-18
      9.07492320669192E-09
      0.00000000000000E+00   8.30900968569053E-12   0.00000000000000E+00   1.15297633639100E-11  -4.65164177314545E-23
     -8.32049990257067E-09  -8.30897013920681E-09  -1.15009689999650E-18  -9.21030407484889E-02  -9.21030407683610E-02
      0.00000000000000E+00   0.00000000000000E+00   1.98719939206515E-08   0.00000000000000E+00   1.98719939206515E-08
      3.58585472201346E-18  -4.97544282017381E-02  -4.61112808474123E-02   0.00000000000000E+00  -1.41755793818552E-10
     -9.82478468893633E-23  -1.14212679876261E-08  -1.15630237814448E-08  -2.43575782201696E-18
      9.08842320669193E-09
      0.00000000000000E+00   5.27427587887943E-12   0.00000000000000E+00   1.03655526215161E-11  -4.75396532217080E-23
     -5.28459908882985E-09  -5.27423353620838E-09  -1.22033355918107E-18  -5.06538150077436E-02  -5.06538150223090E-02
      0.00000000000000E+00   0.00000000000000E+00   1.45654025965682E-08   0.00000000000000E+00   1.45654025965682E-08
      3.78248765706713E-18  -8.36378773408899E-02  -8.07105177977255E-02   0.00000000000000E+00  -1.67081993194406E-10
     -1.06660612612610E-22  -9.12408706716539E-09  -9.29116906035991E-09  -2.56215409788607E-18
      9.10664820669192E-09
      0.00000000000000E+00   2.09497845570369E-12   0.00000000000000E+00   8.28475928361737E-12  -4.79754811530917E-23
     -2.10324102466477E-09  -2.09495626538120E-09  -1.25719458871345E-18  -2.73057643641297E-02  -2.73057643730241E-02
      0.00000000000000E+00   0.00000000000000E+00   8.89443217964677E-09   0.00000000000000E+00   8.89443217964677E-09
      3.94458868354120E-18  -1.38740679791739E-01  -1.36598372813179E-01   0.00000000000000E+00  -1.76001512080112E-10
     -1.16434021863603E-22  -6.62347440218538E-09  -6.79947591426561E-09  -2.68739409482775E-18
      9.12664820669192E-09
      0.00000000000000E+00   6.70650271089360E-13   0.00000000000000E+00   3.43274458160960E-12  -4.80749337871528E-23
     -6.74094442857567E-10  -6.70661698276006E-10  -1.26921406094013E-18  -1.86209238220675E-02  -1.86209238279586E-02
      0.00000000000000E+00   0.00000000000000E+00   5.89103254955971E-09   0.00000000000000E+00   5.89103254955971E-09
      4.06240933453239E-18  -1.99336771716117E-01  -1.97691985402434E-01   0.00000000000000E+00  -1.89850362757104E-10
     -1.26069046332219E-22  -5.03052048852647E-09  -5.22037085128370E-09  -2.79319527359226E-18
      9.14664820669192E-09
      0.00000000000000E+00   2.77279261629523E-13   0.00000000000000E+00   9.52457430730241E-13  -4.80993260955044E-23
     -2.78271829656280E-10  -2.77319372225598E-10  -1.27341986809551E-18  -1.49224500505562E-02  -1.49224500549193E-02
      0.00000000000000E+00   0.00000000000000E+00   4.36314755624690E-09   0.00000000000000E+00   4.36314755624690E-09
      4.14967228565733E-18  -2.51917854510594E-01  -2.50630519944804E-01   0.00000000000000E+00  -1.94436086994510E-10
     -1.34555202297894E-22  -3.89139209702671E-09  -4.08582818402136E-09  -2.87625241756182E-18
      9.16664820669192E-09
      0.00000000000000E+00   1.79280927029092E-13   0.00000000000000E+00   2.37216056969243E-13  -4.81095316227643E-23
     -1.79487940432081E-10  -1.79250724375160E-10  -1.27570371068368E-18  -1.27702235607586E-02  -1.27702235639293E-02
      0.00000000000000E+00   0.00000000000000E+00   3.17070003457411E-09   0.00000000000000E+00   3.17070003457411E-09
      4.21308628634881E-18  -2.91717206223031E-01  -2.90774675487336E-01   0.00000000000000E+00  -1.70688778505851E-10
     -1.41226694075058E-22  -2.82076053169286E-09  -2.99144931019886E-09  -2.93738257566514E-18
      9.18664820669192E-09
      0.00000000000000E+00   1.46492355846005E-13   0.00000000000000E+00   8.00951495505205E-14  -4.81137781865637E-23
     -1.46552294233328E-10  -1.46472199083826E-10  -1.27735931176055E-18  -1.13502396888326E-02  -1.13502396910304E-02
      0.00000000000000E+00   0.00000000000000E+00   2.19783141280975E-09   0.00000000000000E+00   2.19783141280975E-09
      4.25704291460501E-18  -3.18923614032280E-01  -3.18277281415134E-01   0.00000000000000E+00  -1.28913964950826E-10
     -1.45913613435578E-22  -1.92244524877496E-09  -2.05135921372593E-09  -2.97968360284446E-18
      9.20664820669192E-09
      0.00000000000000E+00   1.32531955790461E-13   0.00000000000000E+00   3.51906726860164E-14  -4.81151921685501E-23
     -1.32592873186505E-10  -1.32557682513867E-10  -1.27875482746132E-18  -1.03679969054822E-02  -1.03679969069243E-02
      0.00000000000000E+00   0.00000000000000E+00   1.44209708003056E-09   0.00000000000000E+00   1.44209708003056E-09
      4.28588485620562E-18  -3.35544851079434E-01  -3.35132250738025E-01   0.00000000000000E+00  -8.27071295566698E-11
     -1.48795250872664E-22  -1.22683226795993E-09  -1.30953939751675E-09  -3.00713002874430E-18
      9.22664820669192E-09
      0.00000000000000E+00   1.26194668923142E-13   0.00000000000000E+00   1.70576911831840E-14  -4.81154240402129E-23
     -1.26228859098297E-10  -1.26211801407161E-10  -1.28003478790172E-18  -9.67180244992084E-03  -9.67180245078271E-03
      0.00000000000000E+00   0.00000000000000E+00   8.61870980931398E-10   0.00000000000000E+00   8.61870980931398E-10
      4.30312227582425E-18  -3.43690429292910E-01  -3.43458649102049E-01   0.00000000000000E+00  -3.98370594443328E-11
     -1.50160562799573E-22  -6.95822120079724E-10  -7.35659179524207E-10  -3.02308748792252E-18
      9.24664820669192E-09
      0.00000000000000E+00   9.59777503818655E-14   0.00000000000000E+00   8.05276149720154E-14  -4.81039064957064E-23
     -9.60788342247036E-11  -9.59983066097797E-11  -1.28072136862122E-18  -9.37096671038064E-03  -9.37096671107565E-03
      0.00000000000000E+00   0.00000000000000E+00   6.95007313024466E-10   0.00000000000000E+00   6.95007313024466E-10
      4.31702242208474E-18  -3.50268675393551E-01  -3.50079951190388E-01   0.00000000000000E+00  -3.05916009560522E-11
     -1.51185320479271E-22  -5.68417405458480E-10  -5.99009006414683E-10  -3.03630105346352E-18
      9.26664820669192E-09
      0.00000000000000E+00   7.31084108171913E-14   0.00000000000000E+00   6.62483753249666E-14  -4.80853183300026E-23
     -7.31352066530908E-11  -7.30689582778139E-11  -1.28096299158270E-18  -9.25636911006251E-03  -9.25636911089445E-03
      0.00000000000000E+00   0.00000000000000E+00   8.31932167339109E-10   0.00000000000000E+00   8.31932167339109E-10
      4.33366106543152E-18  -3.59665411256710E-01  -3.59426318819184E-01   0.00000000000000E+00  -4.61750379103570E-11
     -1.52688944047415E-22  -7.12688171150744E-10  -7.58863209061253E-10  -3.05269807384882E-18
      9.27664820669192E-09
      0.00000000000000E+00   3.84829448899537E-14   0.00000000000000E+00   1.85233205788003E-13  -4.80685788028483E-23
     -3.86934231580105E-11  -3.85081899522706E-11  -1.28074293331529E-18  -9.33290367149658E-03  -9.33290367262122E-03
      0.00000000000000E+00   0.00000000000000E+00   1.12463683982471E-09   0.00000000000000E+00   1.12463683982471E-09
      4.34490743382976E-18  -3.67174147762413E-01  -3.66831937299602E-01   0.00000000000000E+00  -7.79821919871363E-11
     -1.53931086478507E-22  -1.00814645788523E-09  -1.08612864987252E-09  -3.06416450051448E-18
      9.28002320669192E-09
      0.00000000000000E+00   1.72668105950150E-14   0.00000000000000E+00   3.27815615648128E-13  -4.80610546040367E-23
     -1.75528010913588E-11  -1.72249854757587E-11  -1.28059746118527E-18  -9.38873428224333E-03  -9.38873428352677E-03
      0.00000000000000E+00   0.00000000000000E+00   1.28343320763775E-09   0.00000000000000E+00   1.28343320763775E-09
      4.34923902090554E-18  -3.70247143979817E-01  -3.69848191654899E-01   0.00000000000000E+00  -9.67242458388906E-11
     -1.54445210462722E-22  -1.16948397632221E-09  -1.26620822216126E-09  -3.06864155972027E-18
      9.28457945669192E-09
      0.00000000000000E+00   1.29501079462613E-14   0.00000000000000E+00   6.89721074001301E-14  -4.80522127115250E-23
     -1.29989196958166E-11  -1.29299475884645E-11  -1.28038278944752E-18  -9.45255935394527E-03  -9.45255935544484E-03
      0.00000000000000E+00   0.00000000000000E+00   1.49957602666959E-09   0.00000000000000E+00   1.49957602666959E-09
      4.35607146417705E-18  -3.75179898286708E-01  -3.74711488491126E-01   0.00000000000000E+00  -1.18101106571141E-10
     -1.55289273225213E-22  -1.36854497251014E-09  -1.48664607908143E-09  -3.07568867472954E-18
      9.29073039419192E-09
      0.00000000000000E+00   2.56246816809000E-14   0.00000000000000E+00  -8.33516695150110E-14  -4.80428625524326E-23
     -2.55435824342911E-11  -2.56269341038542E-11  -1.28017354617356E-18  -9.46775756219610E-03  -9.46775756387707E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68096763935381E-09   0.00000000000000E+00   1.68096763935381E-09
      4.36641099106624E-18  -3.82569717758095E-01  -3.82048154404760E-01   0.00000000000000E+00  -1.35308456596156E-10
     -1.56586155370184E-22  -1.52003224865338E-09  -1.65534070524969E-09  -3.08623744489269E-18
      9.29903415981692E-09
      0.00000000000000E+00   4.22485791154623E-14   0.00000000000000E+00  -8.47305896843908E-14  -4.80328142772446E-23
     -4.21524686831565E-11  -4.22371992728889E-11  -1.28003349792738E-18  -9.38855818845033E-03  -9.38855819022762E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77729121439240E-09   0.00000000000000E+00   1.77729121439240E-09
      4.38116920075793E-18  -3.92967183611605E-01  -3.92420503474581E-01   0.00000000000000E+00  -1.46121572927241E-10
     -1.58453829342275E-22  -1.58893244219216E-09  -1.73505401511956E-09  -3.10113570283055E-18
      9.31024424341067E-09
      0.00000000000000E+00   6.04338370825526E-14   0.00000000000000E+00  -7.00537233173670E-14  -4.80229443222668E-23
     -6.04073652477731E-11  -6.04774189711385E-11  -1.28005678325211E-18  -9.15304587654444E-03  -9.15304587833949E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79504080542891E-09   0.00000000000000E+00   1.79504080542891E-09
      4.40129175824098E-18  -4.06913638103729E-01  -4.06367112199352E-01   0.00000000000000E+00  -1.51545071377981E-10
     -1.61022509145662E-22  -1.58301831507953E-09  -1.73456338645767E-09  -3.12123497498887E-18
      9.32537785626223E-09
      0.00000000000000E+00   9.12936687842816E-14   0.00000000000000E+00  -9.59530678575887E-14  -4.80187062075653E-23
     -9.11833197314884E-11  -9.12792727993940E-11  -1.28056733333498E-18  -8.56123429402092E-03  -8.56123429579899E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77806374166300E-09   0.00000000000000E+00   1.77806374166300E-09
      4.42820028653271E-18  -4.25007366641073E-01  -4.24475894661254E-01   0.00000000000000E+00  -1.54533010523135E-10
     -1.64477535982442E-22  -1.53225145834030E-09  -1.68678446886360E-09  -3.14763295319773E-18
      9.34537785626223E-09
      0.00000000000000E+00   1.40155068978686E-13   0.00000000000000E+00  -1.25925424788650E-13  -4.80313668516435E-23
     -1.40021151356444E-10  -1.40147076781281E-10  -1.28223822297164E-18  -7.21040594692854E-03  -7.21040594869017E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76163421544414E-09   0.00000000000000E+00   1.76163421544414E-09
      4.46343297084159E-18  -4.47516282612597E-01  -4.47005383838731E-01   0.00000000000000E+00  -1.57921512319426E-10
     -1.69012129827838E-22  -1.46356562634327E-09  -1.62148713866287E-09  -3.18119474786995E-18
      9.36537785626223E-09
      0.00000000000000E+00   1.71198590154830E-13   0.00000000000000E+00  -8.72317149600324E-14  -4.80543625533107E-23
     -1.71098834668371E-10  -1.71186066383379E-10  -1.28454571802687E-18  -5.50839957281752E-03  -5.50839957453932E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72180118975337E-09   0.00000000000000E+00   1.72180118975337E-09
      4.49786899463666E-18  -4.68737258412339E-01  -4.68248689018272E-01   0.00000000000000E+00  -1.61300747601034E-10
     -1.73506832756490E-22  -1.38931437576884E-09  -1.55061512337005E-09  -3.21332327660979E-18
      9.38537785626223E-09
      0.00000000000000E+00   1.74321311219886E-13   0.00000000000000E+00  -1.94719533889934E-14  -4.80770075507821E-23
     -1.74323982840713E-10  -1.74343454794150E-10  -1.28693076690483E-18  -3.78734818830289E-03  -3.78734818995487E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65198495098502E-09   0.00000000000000E+00   1.65198495098502E-09
      4.53090869365636E-18  -4.88922854503098E-01  -4.88457276564843E-01   0.00000000000000E+00  -1.63356661757122E-10
     -1.77932231697045E-22  -1.31428483443356E-09  -1.47764149619086E-09  -3.24397792675152E-18
      9.40537785626223E-09
      0.00000000000000E+00   2.10967361365689E-13   0.00000000000000E+00  -1.08268927695510E-13  -4.81149984388022E-23
     -2.10822565009558E-10  -2.10930833937302E-10  -1.29005908070740E-18  -1.63897749355815E-03  -1.63897749520311E-03
      0.00000000000000E+00   0.00000000000000E+00   1.64496622211713E-09   0.00000000000000E+00   1.64496622211713E-09
      4.56380801809870E-18  -5.08156147721918E-01  -5.07704307601183E-01   0.00000000000000E+00  -1.68639580828802E-10
     -1.82378993011958E-22  -1.26539580735077E-09  -1.43403538817975E-09  -3.27374893739130E-18
      9.42537785626223E-09
      0.00000000000000E+00  -1.23567909439006E-12   0.00000000000000E+00   3.78489882004673E-12  -4.75526546453411E-23
      1.23190310077141E-09   1.23568799959141E-09  -1.26436387982594E-18  -1.68349457526343E-02  -1.68349457519150E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.19212485760314E-10   0.00000000000000E+00  -7.19212485760314E-10
      4.54942376838350E-18  -5.28318988571070E-01  -5.28156275271928E-01   0.00000000000000E+00  -3.61111816632992E-11
     -1.83312205368984E-22  -4.80364332167644E-10  -5.16475513831126E-10  -3.28505988855756E-18
      9.44537785626223E-09
      0.00000000000000E+00  -3.04731653580853E-12   0.00000000000000E+00   4.93116613828604E-12  -4.63550996898139E-23
      3.04238481517043E-09   3.04731598130867E-09  -1.20300990987264E-18  -5.22231049073582E-02  -5.22231049037677E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.59046099150461E-09   0.00000000000000E+00  -3.59046099150461E-09
      4.47761454855340E-18  -5.49502681639299E-01  -5.49673865746296E-01   0.00000000000000E+00   1.23566429802937E-10
     -1.80039700094872E-22   4.19578580393173E-10   5.43145010195930E-10  -3.27460463868076E-18
      9.45537785626223E-09
      0.00000000000000E+00  -4.33672480146500E-12   0.00000000000000E+00   6.89851925991524E-12  -4.55262211992872E-23
      4.32985429621286E-09   4.33675281547273E-09  -1.15992115127003E-18  -7.62030377915770E-02  -7.62030377860567E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.52031835218407E-09   0.00000000000000E+00  -5.52031835218407E-09
      4.42241136503156E-18  -5.60365255085647E-01  -5.60738241508001E-01   0.00000000000000E+00   2.14306786885196E-10
     -1.77154266082897E-22   9.69258749826294E-10   1.18356553671131E-09  -3.26249021376153E-18
      9.46887785626223E-09
      0.00000000000000E+00  -5.74507200180521E-12   0.00000000000000E+00   5.71342683086479E-12  -4.41743712617000E-23
      5.73933481363037E-09   5.74504824046119E-09  -1.08561980307101E-18  -1.15789205268166E-01  -1.15789205260811E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.35462904953210E-09   0.00000000000000E+00  -7.35462904953210E-09
      4.32312387286288E-18  -5.75105342333232E-01  -5.75612584667705E-01   0.00000000000000E+00   2.81743786980127E-10
     -1.71897265682644E-22   1.32783702209097E-09   1.60958080907092E-09  -3.23750406979187E-18
      9.47343410626223E-09
      0.00000000000000E+00  -6.41076265708537E-12   0.00000000000000E+00   7.72702350806088E-12  -4.36429794373946E-23
      6.40305400488314E-09   6.41078102839116E-09  -1.05824406188267E-18  -1.29869921363778E-01  -1.29869921355690E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.08835764941470E-09   0.00000000000000E+00  -8.08835764941470E-09
      4.28627129332274E-18  -5.80019698578299E-01  -5.80548383610275E-01   0.00000000000000E+00   2.91960910873548E-10
     -1.70022391845109E-22   1.38561571015038E-09   1.67757662102376E-09  -3.22802723144007E-18
      9.47958504376223E-09
      0.00000000000000E+00  -7.08196399659797E-12   0.00000000000000E+00   5.91080468364543E-12  -4.27509666315490E-23
      7.07604756396418E-09   7.08195836864778E-09  -1.01939504494868E-18  -1.49371534069295E-01  -1.49371534060722E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.57376657743775E-09   0.00000000000000E+00  -8.57376657743775E-09
      4.23353459096533E-18  -5.86440036563496E-01  -5.86910225507753E-01   0.00000000000000E+00   2.97353887509009E-10
     -1.67407379217353E-22   1.19445432128097E-09   1.49180820878981E-09  -3.21413954601665E-18
      9.48788880938723E-09
      0.00000000000000E+00  -8.17445714568150E-12   0.00000000000000E+00   6.94106391785016E-12  -4.05485001738816E-23
      8.16748916770777E-09   8.17443023162558E-09  -9.65724905296033E-19  -1.75480502097084E-01  -1.75480502088207E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.87772225430055E-09   0.00000000000000E+00  -8.87772225430055E-09
      4.15981606608177E-18  -5.94337095364061E-01  -5.94558927516639E-01   0.00000000000000E+00   2.90801918667046E-10
     -1.63888176940836E-22   4.12490104008112E-10   7.03292022674994E-10  -3.19409116078573E-18
      9.49909889298098E-09
      0.00000000000000E+00  -1.09184105144936E-11   0.00000000000000E+00   1.24280616565534E-11  -3.21137558397579E-23
      1.09059532607051E-08   1.09183813223616E-08  -8.93938708118838E-19  -2.09055944024454E-01  -2.09055944015347E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.10744096609782E-09   0.00000000000000E+00  -9.10744096609782E-09
      4.05772089152667E-18  -6.02210715197641E-01  -6.01640613103055E-01   0.00000000000000E+00   2.80713572013676E-10
     -1.59169102308295E-22  -2.09165392827743E-09  -1.81094035626392E-09  -3.16378218340783E-18
      9.51423250583254E-09
      0.00000000000000E+00  -1.89738368807541E-11   0.00000000000000E+00   2.65011957841420E-11   3.38509380729710E-24
      1.89473059635319E-08   1.89738071593160E-08  -8.04496421898664E-19  -2.49136273249582E-01  -2.49136273240139E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.44287535411342E-09   0.00000000000000E+00  -9.44287535411342E-09
      3.91481607171196E-18  -6.02165397028748E-01  -5.99163548703315E-01   0.00000000000000E+00   2.85536940246600E-10
     -1.52336615623259E-22  -9.81646874544909E-09  -9.53093180520264E-09  -3.11031964981328E-18
      9.53423250583254E-09
      0.00000000000000E+00  -3.73486623854408E-11   0.00000000000000E+00   4.55437144866245E-11   9.15650680253838E-23
      3.73031499981040E-08   3.73486937125907E-08  -7.11662764564035E-19  -2.89716569847768E-01  -2.89716569837711E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00570825658931E-08   0.00000000000000E+00  -1.00570825658931E-08
      3.71367442039409E-18  -5.70233171308516E-01  -5.61636370778728E-01   0.00000000000000E+00   3.16293446166962E-10
     -1.41005745479021E-22  -2.76079045928646E-08  -2.72916111466978E-08  -3.00201165583006E-18
      9.55423250583254E-09
      0.00000000000000E+00  -5.65358545907280E-11   0.00000000000000E+00   4.76536364149481E-11   1.82675762400875E-22
      5.64881639757290E-08   5.65358176121441E-08  -6.49193818056474E-19  -3.17612378419835E-01  -3.17612378409111E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07231042057667E-08   0.00000000000000E+00  -1.07231042057667E-08
      3.49921233627876E-18  -5.01403080002873E-01  -4.86971054607756E-01   0.00000000000000E+00   3.11794331942678E-10
     -1.26411066732546E-22  -4.61245077383197E-08  -4.58127134063772E-08  -2.85001851822228E-18
      9.57423250583254E-09
      0.00000000000000E+00  -6.60294776969212E-11   0.00000000000000E+00   2.36973644767342E-11   2.26736220698991E-22
      6.60057864996999E-08   6.60294838641768E-08  -6.13874096452313E-19  -3.34869353648170E-01  -3.34869353636872E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12983919416095E-08   0.00000000000000E+00  -1.12983919416095E-08
      3.27324449744657E-18  -3.99652732860385E-01  -3.82410248615148E-01   0.00000000000000E+00   2.70320125334505E-10
     -1.09954454470735E-22  -5.50014120479017E-08  -5.47310919225673E-08  -2.65937040099425E-18
      9.59423250583254E-09
      0.00000000000000E+00  -6.11662070170454E-11   0.00000000000000E+00  -1.19874276478680E-11   2.06016348721323E-22
      6.11782203349445E-08   6.11662329072969E-08  -6.01269559160877E-19  -3.43366399166242E-01  -3.43366399154436E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18058984337227E-08   0.00000000000000E+00  -1.18058984337227E-08
      3.03712652877211E-18  -2.75116852364650E-01  -2.59565793475018E-01   0.00000000000000E+00   2.12461003122902E-10
     -9.34233171971398E-23  -4.95727954766969E-08  -4.93603344735741E-08  -2.43585696961124E-18
      9.61423250583254E-09
      0.00000000000000E+00  -5.26149109146014E-11   0.00000000000000E+00  -2.12046008457951E-11   1.63364990563333E-22
      5.26361009260643E-08   5.26148963252186E-08  -5.94284630049313E-19  -3.49773412702084E-01  -3.49773412690172E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19117788201918E-08   0.00000000000000E+00  -1.19117788201918E-08
      2.79889095236828E-18  -1.61558046176228E-01  -1.48734153329090E-01   0.00000000000000E+00   1.25552255057476E-10
     -7.93481452289130E-23  -4.08286697600843E-08  -4.07031175050269E-08  -2.20460632231896E-18
      9.63423250583254E-09
      0.00000000000000E+00  -4.59784857381972E-11   0.00000000000000E+00  -1.64549702904648E-11   1.29182683288518E-22
      4.59949127220642E-08   4.59784577517738E-08  -5.80560773873376E-19  -3.58689105120827E-01  -3.58689105109144E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16835053170364E-08   0.00000000000000E+00  -1.16835053170364E-08
      2.56522084602755E-18  -7.56647138530332E-02  -6.48596267546745E-02   0.00000000000000E+00   6.58855900945435E-11
     -5.38895918901920E-23  -3.43608380248320E-08  -3.42949524347375E-08  -1.98466007215417E-18
      9.64423250583254E-09
      0.00000000000000E+00  -4.06696762381277E-11   0.00000000000000E+00  -2.62257585238987E-11   1.19731427614859E-22
      4.06959150863473E-08   4.06696893278235E-08  -5.65918047738218E-19  -3.65706841410707E-01  -3.65706841399391E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13157482016217E-08   0.00000000000000E+00  -1.13157482016217E-08
      2.45206336401133E-18  -4.70989788895755E-02  -3.78505856767414E-02   0.00000000000000E+00   5.07562459578855E-11
     -2.59483069909225E-24  -2.94046973721596E-08  -2.93539411262017E-08  -1.88614531627311E-18
      9.65098250583254E-09
      0.00000000000000E+00  -3.71004060607688E-11   0.00000000000000E+00  -2.61362396841944E-11   1.19814368863043E-22
      3.71265792027797E-08   3.71004429630956E-08  -5.50605181810297E-19  -3.72252049466307E-01  -3.72252049455376E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09303701970864E-08   0.00000000000000E+00  -1.09303701970864E-08
      2.37828336518100E-18  -3.50128162097544E-02  -2.67675310945627E-02   0.00000000000000E+00   4.05611426077222E-11
      4.17764522141670E-23  -2.62106339086170E-08  -2.61700727660093E-08  -1.82767818337070E-18
      9.66009500583254E-09
      0.00000000000000E+00  -3.42126238334898E-11   0.00000000000000E+00  -1.56829907484659E-11   1.27484797734246E-22
      3.42282685462503E-08   3.42125855555019E-08  -5.24553478411067E-19  -3.82939810563969E-01  -3.82939810553416E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05525060437078E-08   0.00000000000000E+00  -1.05525060437078E-08
      2.28212365385771E-18  -2.63107446735738E-02  -1.88562556886701E-02   0.00000000000000E+00   2.55158700558493E-11
      9.21940616799684E-23  -2.36855953818501E-08  -2.36600795117942E-08  -1.75757017544665E-18
      9.67239688083254E-09
      0.00000000000000E+00  -3.22916911547943E-11   0.00000000000000E+00  -7.69811940134264E-12   1.38839542455046E-22
      3.22993921447743E-08   3.22916940253731E-08  -4.86831625812616E-19  -3.98236737379956E-01  -3.98236737369662E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02930512495381E-08   0.00000000000000E+00  -1.02930512495381E-08
      2.15549982401730E-18  -2.05343728095930E-02  -1.36033329441471E-02   0.00000000000000E+00   1.52101099154119E-11
      1.41008635273484E-22  -2.20138528857506E-08  -2.19986427758350E-08  -1.66866819820468E-18
      9.68900441208254E-09
      0.00000000000000E+00  -3.09288989441090E-11   0.00000000000000E+00  -4.01681945271395E-12   1.42693779011652E-22
      3.09328835547868E-08   3.09288667353343E-08  -4.37234864897541E-19  -4.18432399382880E-01  -4.18432399372768E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01120719208784E-08   0.00000000000000E+00  -1.01120719208784E-08
      1.98756327358906E-18  -1.65960443333191E-02  -1.00373545923559E-02   0.00000000000000E+00   9.90442570910354E-12
      1.73155322645397E-22  -2.08266992401650E-08  -2.08167948144557E-08  -1.55032840869152E-18
      9.70900441208254E-09
      0.00000000000000E+00  -2.96224075573320E-11   0.00000000000000E+00  -3.18752210334674E-12   1.27010941365621E-22
      2.96255996089364E-08   2.96224120868332E-08  -3.81701478563453E-19  -4.41353349962255E-01  -4.41353349952308E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94750028028787E-09   0.00000000000000E+00  -9.94750028028787E-09
      1.78861326798331E-18  -1.38760605431009E-02  -7.67713244116775E-03   0.00000000000000E+00   7.76756168335271E-12
      1.67981262920016E-22  -1.96826793682288E-08  -1.96749118065453E-08  -1.40691178941985E-18
      9.72900441208254E-09
      0.00000000000000E+00  -2.84040871182741E-11   0.00000000000000E+00  -2.97437254065520E-12   9.75266716024286E-23
      2.84070623899875E-08   2.84040880174470E-08  -3.30354131371597E-19  -4.62907545737290E-01  -4.62907545727490E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.79945011412292E-09   0.00000000000000E+00  -9.79945011412292E-09
      1.59262426570085E-18  -1.20979291235612E-02  -6.23620377652743E-03   0.00000000000000E+00   6.64908405878776E-12
      1.32458360470784E-22  -1.86112869873829E-08  -1.86046379033240E-08  -1.26227013432925E-18
      9.74900441208254E-09
      0.00000000000000E+00  -2.74179501748769E-11   0.00000000000000E+00  -2.40589429084132E-12   6.56413393556948E-23
      2.74203753854440E-08   2.74179694911532E-08  -2.82434802375938E-19  -4.83374368276984E-01  -4.83374368267314E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67027095249465E-09   0.00000000000000E+00  -9.67027095249465E-09
      1.39921884665096E-18  -1.08949376553588E-02  -5.30320175178609E-03   0.00000000000000E+00   5.49665035429688E-12
      8.77236531255527E-23  -1.77531951890129E-08  -1.77476985386585E-08  -1.11678404427502E-18
      9.76900441208254E-09
      0.00000000000000E+00  -2.65805098610187E-11   0.00000000000000E+00  -2.04266422765262E-12   3.94768061307148E-23
      2.65825270876075E-08   2.65804844233799E-08  -2.37665802388968E-19  -5.02840001002852E-01  -5.02840000993338E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.51382153966352E-09   0.00000000000000E+00  -9.51382153966352E-09
      1.20894241585768E-18  -1.00362539386146E-02  -4.65908667170327E-03   0.00000000000000E+00   4.59595904309533E-12
      4.92579838357569E-23  -1.70712588427595E-08  -1.70666628837164E-08  -9.71276613468717E-19
      9.78900441208254E-09
      0.00000000000000E+00  -2.65395471082241E-11   0.00000000000000E+00  -7.91604537258251E-14   2.21798327609096E-23
      2.65395992655231E-08   2.65395201050694E-08  -1.93337606708439E-19  -5.22538134612911E-01  -5.22538134603012E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.89890640710318E-09   0.00000000000000E+00  -9.89890640710318E-09
      1.01096428771562E-18  -9.50363215476078E-03  -4.26069652640448E-03   0.00000000000000E+00   3.73921465828770E-12
      2.33871903102699E-23  -1.66443529126246E-08  -1.66406136979663E-08  -8.17626681007183E-19
      9.80900441208254E-09
      0.00000000000000E+00  -2.74563412750297E-11   0.00000000000000E+00   2.28639967665510E-12   1.25701113606291E-23
      2.74540754302402E-08   2.74563618299169E-08  -1.47373565206489E-19  -5.43502003208422E-01  -5.43502003197588E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08331844514657E-08   0.00000000000000E+00  -1.08331844514657E-08
      7.94300598686307E-19  -9.30122969880774E-03  -4.06378484165462E-03   0.00000000000000E+00   2.65982894863904E-12
      8.99096386646386E-24  -1.66258372073998E-08  -1.66231773784512E-08  -6.46927033479818E-19
      9.81400441208254E-09
      0.00000000000000E+00  -2.78025040895648E-11   0.00000000000000E+00   3.43588424531837E-12   1.05282254850992E-23
      2.77990347797574E-08   2.78024706640027E-08  -1.35908656465682E-19  -5.48826228983469E-01  -5.48826228972256E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12131869574169E-08   0.00000000000000E+00  -1.12131869574169E-08
      7.38234663899223E-19  -9.25924508180705E-03  -4.03247861668214E-03   0.00000000000000E+00   2.85461476617853E-12
      5.89691417493399E-24  -1.65921383213521E-08  -1.65892837065859E-08  -6.02326007433540E-19
      9.82075441208254E-09
      0.00000000000000E+00  -2.82854237178020E-11   0.00000000000000E+00   3.56098240970027E-12   8.62289957883666E-24
      2.82817867195904E-08   2.82853477020001E-08  -1.20245056514496E-19  -5.56156360367071E-01  -5.56156360355536E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15350696298004E-08   0.00000000000000E+00  -1.15350696298004E-08
      6.60372943898070E-19  -9.28722154689385E-03  -4.00972947047756E-03   0.00000000000000E+00   1.34277853196914E-12
      3.07812527017864E-24  -1.67516208507315E-08  -1.67502780721996E-08  -5.40127887383573E-19
      9.82986691208254E-09
      0.00000000000000E+00  -2.89435831046312E-11   0.00000000000000E+00   3.59594816110188E-12   7.06250007915784E-24
      2.89399535888880E-08   2.89435495370491E-08  -9.90055587502982E-20  -5.66203301425513E-01  -5.66203301413660E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18529609703890E-08   0.00000000000000E+00  -1.18529609703890E-08
      5.52362837055400E-19  -9.37802698690374E-03  -3.99331231088621E-03   0.00000000000000E+00   6.32949291407697E-13
      8.15750673358423E-25  -1.70912215159517E-08  -1.70905885666603E-08  -4.53357278305103E-19
      9.83294238083254E-09
      0.00000000000000E+00  -2.92058916740958E-11   0.00000000000000E+00   4.23230468141941E-12   6.61827612680785E-24
      2.92016883500623E-08   2.92059206547437E-08  -9.18847241426903E-20  -5.69602510669048E-01  -5.69602510657070E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19782128617702E-08   0.00000000000000E+00  -1.19782128617702E-08
      5.15524217718178E-19  -9.42239228310156E-03  -3.99447506257422E-03   0.00000000000000E+00   2.28317659085500E-13
      1.57117542217351E-25  -1.72279361106325E-08  -1.72277077929734E-08  -4.23639493575488E-19
      9.83709426364504E-09
      0.00000000000000E+00  -2.94594749935258E-11   0.00000000000000E+00   3.05819199435767E-12   6.15076963404937E-24
      2.94564361340770E-08   2.94594943260713E-08  -8.23204565406810E-20  -5.74185320725667E-01  -5.74185320713619E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20477773484492E-08   0.00000000000000E+00  -1.20477773484492E-08
      4.65503258016325E-19  -9.47345354317167E-03  -3.98756023091566E-03   0.00000000000000E+00   2.05662032555146E-13
     -4.94672906679919E-25  -1.74119226396546E-08  -1.74117169776220E-08  -3.83182801475643E-19
      9.84269930544191E-09
      0.00000000000000E+00  -2.95424107912242E-11   0.00000000000000E+00   7.75708382003258E-13   5.67095686974881E-24
      2.95416624670520E-08   2.95424381754340E-08  -6.96846973313948E-20  -5.80265770938248E-01  -5.80265770926284E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19650485496869E-08   0.00000000000000E+00  -1.19650485496869E-08
      3.98438660793691E-19  -9.48900987296207E-03  -3.95091781494321E-03   0.00000000000000E+00   8.59374525224036E-13
     -1.07503006033941E-24  -1.75782490002724E-08  -1.75773896257472E-08  -3.28753963462297E-19
      9.85026611186769E-09
      0.00000000000000E+00  -2.92148006136050E-11   0.00000000000000E+00  -2.09937448613442E-12   5.16780333974069E-24
      2.92169320129090E-08   2.92148326384229E-08  -5.35409231058030E-20  -5.88076299476672E-01  -5.88076299465135E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15371026151108E-08   0.00000000000000E+00  -1.15371026151108E-08
      3.11139638590773E-19  -9.42922387015501E-03  -3.85951702867117E-03   0.00000000000000E+00   1.51905699106538E-12
     -1.54258239676981E-24  -1.76792490803029E-08  -1.76777300233119E-08  -2.57598715484970E-19
      9.86048130054250E-09
      0.00000000000000E+00  -2.78839703714679E-11   0.00000000000000E+00  -6.40043001991030E-12   4.57520685650346E-24
      2.78904019425870E-08   2.78840015125671E-08  -3.47494477043947E-20  -5.97207467622698E-01  -5.97207467612521E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01772251270413E-08   0.00000000000000E+00  -1.01772251270413E-08
      2.07177363732083E-19  -9.24517212201376E-03  -3.66631271013927E-03   0.00000000000000E+00   1.71649839095615E-12
     -1.89221835069167E-24  -1.77084928839169E-08  -1.77067763855259E-08  -1.72427916027689E-19
      9.87427180525348E-09
      0.00000000000000E+00  -2.34913121250435E-11   0.00000000000000E+00  -1.56957696387580E-11   3.63739442117737E-24
      2.35070647365536E-08   2.34913689669148E-08  -2.07426143932353E-20  -6.03885980922142E-01  -6.03885980916347E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.79499375906420E-09   0.00000000000000E+00  -5.79499375906420E-09
      1.27261474997572E-19  -8.79420529911127E-03  -3.21862155805870E-03   0.00000000000000E+00   1.07107848473817E-12
     -2.17538841644725E-24  -1.76974462863353E-08  -1.76963752078506E-08  -1.06518860604336E-19
      9.89288898661331E-09
      0.00000000000000E+00  -1.07044122768000E-11   0.00000000000000E+00  -3.38620705297667E-11   1.61120104161175E-24
      1.07382808440401E-08   1.07044187735103E-08  -4.47745820625806E-20  -5.91317795874053E-01  -5.91317795881039E-01
      0.00000000000000E+00   0.00000000000000E+00   6.98628670651556E-09   0.00000000000000E+00   6.98628670651556E-09
      2.57326441644552E-19  -7.69298940961510E-03  -2.11919108933311E-03   0.00000000000000E+00  -1.19859695752627E-12
     -2.65210575510773E-24  -1.76895068830684E-08  -1.76907054800260E-08  -2.12551859581972E-19
      9.91288898661331E-09
      0.00000000000000E+00   8.31589804098110E-12   0.00000000000000E+00  -4.67630336803193E-11  -2.18661743112802E-24
     -8.26903340302928E-09  -8.31579643670961E-09  -1.46690343372341E-19  -5.41870502712031E-01  -5.41870502738028E-01
      0.00000000000000E+00   0.00000000000000E+00   2.59966513581251E-08   0.00000000000000E+00   2.59966513581251E-08
      7.77259468807056E-19  -6.03926926977370E-03  -4.68614317241316E-04   0.00000000000000E+00  -5.29383698063565E-12
     -4.74439069647017E-24  -1.76755610844349E-08  -1.76808549214155E-08  -6.30569125434715E-19
      9.93288898661331E-09
      0.00000000000000E+00   2.26175931399883E-11   0.00000000000000E+00  -3.54374697635298E-11  -1.21560834880158E-23
     -2.25821660096874E-08  -2.26176034794510E-08  -3.40577812180244E-19  -4.56951486684396E-01  -4.56951486724640E-01
      0.00000000000000E+00   0.00000000000000E+00   4.02442378422579E-08   0.00000000000000E+00   4.02442378422579E-08
      1.58214422565221E-18  -4.34752389700774E-03   1.20608348335644E-03   0.00000000000000E+00  -1.15511348521947E-11
     -1.86708591882542E-23  -1.76150832279547E-08  -1.76266343628069E-08  -1.24156641347197E-18
      9.95288898661331E-09
      0.00000000000000E+00   2.34111316694614E-11   0.00000000000000E+00  -2.33519972137846E-12  -3.59594641291822E-23
     -2.34087851987681E-08  -2.34111203984895E-08  -6.28552622675895E-19  -3.41897357375772E-01  -3.41897357416845E-01
      0.00000000000000E+00   0.00000000000000E+00   4.10729934361702E-08   0.00000000000000E+00   4.10729934361702E-08
      2.40360409437562E-18  -2.06366810572838E-03   3.50103072244450E-03   0.00000000000000E+00  -2.66398730957847E-11
     -6.41475586571521E-23  -1.76352331645848E-08  -1.76618730376806E-08  -1.77505147169972E-18
      9.97288898661331E-09
      0.00000000000000E+00   1.48468854590711E-11   0.00000000000000E+00   2.04909592988234E-11  -4.29796360237207E-23
     -1.48673698223812E-08  -1.48468788630824E-08  -9.09544197838265E-19  -2.18512157462780E-01  -2.18512157493848E-01
      0.00000000000000E+00   0.00000000000000E+00   3.10679984073777E-08   0.00000000000000E+00   3.10679984073777E-08
      3.02496406252317E-18  -9.62806695835803E-03  -4.51732042041559E-03   0.00000000000000E+00  -5.70289680047607E-11
     -8.14998077751847E-23  -1.61640905762905E-08  -1.62211195442953E-08  -2.11541986468490E-18
      9.99288898661331E-09
      0.00000000000000E+00   9.92106851315704E-12   0.00000000000000E+00   1.13577743283339E-11  -4.58799041485100E-23
     -9.93241219550144E-09  -9.92105442117315E-09  -1.10660875225445E-18  -1.16539603856797E-01  -1.16539603879578E-01
      0.00000000000000E+00   0.00000000000000E+00   2.27811682112355E-08   0.00000000000000E+00   2.27811682112355E-08
      3.48058742674788E-18  -3.92886520740281E-02  -3.52368535353559E-02   0.00000000000000E+00  -1.06525045767371E-10
     -9.45724656843589E-23  -1.27535887442948E-08  -1.28601137900623E-08  -2.37397867449343E-18
      9.99466673995998E-09
      0.00000000000000E+00   9.14112300479072E-12   0.00000000000000E+00   2.03845597883005E-11  -4.60992061110344E-23
     -9.16150379841205E-09  -9.14111923862379E-09  -1.12277826238875E-18  -1.07588319541597E-01  -1.07588319562893E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12956447824288E-08   0.00000000000000E+00   2.12956447824288E-08
      3.51844583052939E-18  -4.23413201011087E-02  -3.85117999780136E-02   0.00000000000000E+00  -1.39426576693839E-10
     -9.58124291833640E-23  -1.20150989671118E-08  -1.21545255438057E-08  -2.39566756814064E-18
      9.99706670697799E-09
      0.00000000000000E+00   8.38046489123799E-12   0.00000000000000E+00   1.47550477103092E-11  -4.63950862697207E-23
     -8.39525431308788E-09  -8.38049926537762E-09  -1.14276351925641E-18  -9.63280955541152E-02  -9.63280955740504E-02
      0.00000000000000E+00   0.00000000000000E+00   1.99351962905472E-08   0.00000000000000E+00   1.99351962905472E-08
      3.56628964412421E-18  -4.69002951869803E-02  -4.32597567001191E-02   0.00000000000000E+00  -1.54272895536473E-10
     -9.74885880083959E-23  -1.14004241296325E-08  -1.15546970251691E-08  -2.42352612486780E-18
      1.00000000000000E-08
      0.00000000000000E+00   7.54201428527047E-12   0.00000000000000E+00   1.31731581032756E-11  -4.67216949092353E-23
     -7.55520998369632E-09  -7.54203682559309E-09  -1.16470857914323E-18  -8.37558393438272E-02  -8.37558393623105E-02
      0.00000000000000E+00   0.00000000000000E+00   1.84833305885927E-08   0.00000000000000E+00   1.84833305885927E-08
      3.62050666876325E-18  -5.30108319606459E-02  -4.95635561885066E-02   0.00000000000000E+00  -1.62706709007338E-10
     -9.94960393678560E-23  -1.07785870539917E-08  -1.09412937629991E-08  -2.45579808962001E-18
}
